/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.BlueToothListener;
import com.ea.game.InquiryListener;
import com.ea.game.MainFrame;
import com.ea.game.ServiceListener;
import com.ea.sdk.SDKMIDlet;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

class BlueToothConnection
implements Runnable {
    private static final String SERVICE_ID = "f1fa12f1fa12f1fa12f1fa12f1fa12f1";
    private static final int CONNECTION_METHOD = 10390323;
    public static final int PACKET_SIZE = 32;
    private static final int MAX_SEND_RETRIES = 20;
    private static final int MAX_TIME_SEARCH_DEVS = 20000;
    private static final int SLEEP_TIME = 2;
    public static final int ERROR_NO_CONNECTABLE_DEVICES_FOUND = 1;
    public static final int ERROR_DEVICE_ENUMERATION_ERROR = 2;
    public static final int ERROR_DURING_CONNECTION = 3;
    public static final int ERROR_COLLECTING_PACKET = 4;
    public static final int ERROR_NO_JSR82_SUPPORT = 5;
    private static final int STATE_CLIENT_SEARCH_DEVS = 1;
    private static final int STATE_CLIENT_SEARCH_SERVS = 2;
    private static final int STATE_CLIENT_CONNECTING = 3;
    private static final int STATE_CLIENT_CONNECTED = 4;
    private BlueToothListener m_callBackInst;
    private static SDKMIDlet m_Parent;
    private Thread m_runThread;
    public static LocalDevice m_localDevice;
    public static DiscoveryAgent m_discAgent;
    public static InquiryListener m_inqListener;
    public static ServiceListener m_servListener;
    public static L2CAPConnection m_con;
    private static int m_state;
    L2CAPConnectionNotifier m_notifier;
    private static boolean m_requestMakeThisDeviceDiscoverable;
    private static boolean m_requestScanForNewDevices;
    private static boolean m_requestConnectToDevice;
    private static boolean m_requestThreadKill;
    private static int m_requestConnectToDeviceId;
    public static String[] m_deviceNames;
    public static boolean m_fullConnection;
    private static boolean m_waitingConnection;
    private static byte[] m_buffer;
    public static int m_numenumeratedDevices;
    private static int m_connectTime;
    private static int m_transID;
    private static boolean m_searchForDevs;
    private static int m_timePacketLastReceived;
    private static final int TIME_CHECK_CONNECTION = 5000;
    public static boolean m_checkingData;

    public BlueToothConnection(SDKMIDlet sDKMIDlet, BlueToothListener blueToothListener) {
        m_Parent = sDKMIDlet;
        this.m_callBackInst = blueToothListener;
        m_fullConnection = false;
        m_waitingConnection = false;
        m_requestScanForNewDevices = false;
        m_requestThreadKill = false;
        m_deviceNames = null;
        m_connectTime = 0;
        m_buffer = new byte[1024];
        m_state = -1;
        m_searchForDevs = false;
        this.m_runThread = new Thread(this);
        this.m_runThread.start();
    }

    public void cancelThread() {
        m_requestThreadKill = true;
    }

    public void run() {
        while (this.m_runThread != null) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (m_requestScanForNewDevices) {
                m_requestScanForNewDevices = false;
                this._SearchForDevices();
            }
            if (m_requestConnectToDevice) {
                m_requestConnectToDevice = false;
                this._ConnectToDevice(m_requestConnectToDeviceId);
            }
            if (m_requestMakeThisDeviceDiscoverable) {
                m_requestMakeThisDeviceDiscoverable = false;
                this._MakeThisDeviceDiscoverable();
            }
            if (m_fullConnection && MainFrame.m_bluetoothSafeToProcessData) {
                this.checkforReceivedData();
            }
            if (!m_requestThreadKill) continue;
            this.m_runThread = null;
        }
    }

    public void SearchForDevices() {
        m_requestScanForNewDevices = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _SearchForDevices() {
        block21: {
            MainFrame.m_bluetoothServs = 0;
            MainFrame.m_bluetoothDevs = 0;
            MainFrame.m_bluetoothServsSearched = 0;
            m_numenumeratedDevices = 0;
            m_connectTime = (int)System.currentTimeMillis();
            m_searchForDevs = true;
            try {
                int n2;
                m_localDevice = LocalDevice.getLocalDevice();
                m_discAgent = m_localDevice.getDiscoveryAgent();
                if (m_localDevice.getDiscoverable() != 0) {
                    m_localDevice.setDiscoverable(0);
                }
                m_inqListener = new InquiryListener();
                for (n2 = 0; n2 < 10 && m_searchForDevs; ++n2) {
                    m_state = 1;
                    InquiryListener inquiryListener = m_inqListener;
                    synchronized (inquiryListener) {
                        m_discAgent.startInquiry(10390323, (DiscoveryListener)m_inqListener);
                        try {
                            m_inqListener.wait(0L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    UUID[] uUIDArray = new UUID[]{new UUID(SERVICE_ID, false)};
                    if (m_inqListener == null) {
                        return;
                    }
                    m_servListener = new ServiceListener();
                    BlueToothConnection.m_servListener.m_servsFound = 0;
                    m_state = 2;
                    int n3 = BlueToothConnection.m_inqListener.cached_devices.size();
                    for (int i2 = 0; m_searchForDevs && i2 < n3; ++i2) {
                        ServiceListener serviceListener = m_servListener;
                        synchronized (serviceListener) {
                            RemoteDevice remoteDevice = (RemoteDevice)BlueToothConnection.m_inqListener.cached_devices.elementAt(i2);
                            ++MainFrame.m_bluetoothServsSearched;
                            m_transID = m_discAgent.searchServices(null, uUIDArray, remoteDevice, (DiscoveryListener)m_servListener);
                            try {
                                m_servListener.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (m_servListener == null || BlueToothConnection.m_servListener.m_servsFound != 0) break;
                }
                m_state = -1;
                if (!m_searchForDevs) break block21;
                m_numenumeratedDevices = BlueToothConnection.m_servListener.m_servsFound;
                m_deviceNames = null;
                m_deviceNames = new String[m_numenumeratedDevices];
                for (n2 = 0; n2 < m_numenumeratedDevices; ++n2) {
                    try {
                        BlueToothConnection.m_deviceNames[n2] = BlueToothConnection.m_servListener.m_foundServs[n2].getHostDevice().getFriendlyName(false);
                    }
                    catch (IOException iOException) {
                        BlueToothConnection.m_deviceNames[n2] = BlueToothConnection.m_servListener.m_foundServs[n2].getHostDevice().getBluetoothAddress();
                    }
                    this.m_callBackInst.bluetoothOnNotifyNewDeviceFound();
                }
                m_state = -1;
                if (m_numenumeratedDevices == 0) {
                    this.m_callBackInst.bluetoothOnError(null, 1);
                } else {
                    this.m_callBackInst.bluetoothOnCompletedDeviceEnumeration();
                }
                m_searchForDevs = false;
            }
            catch (Exception exception) {
                this.m_callBackInst.bluetoothOnError(exception, 2);
            }
        }
    }

    public void ConnectToDevice(int n2) {
        m_requestConnectToDevice = true;
        m_requestConnectToDeviceId = n2;
    }

    private void _ConnectToDevice(int n2) {
        m_timePacketLastReceived = m_connectTime = (int)System.currentTimeMillis();
        try {
            String string = BlueToothConnection.m_servListener.m_foundServs[n2].getConnectionURL(0, false);
            m_con = (L2CAPConnection)Connector.open((String)string);
            this.m_callBackInst.bluetoothOnNewConnection();
            m_fullConnection = true;
        }
        catch (Exception exception) {
            this.m_callBackInst.bluetoothOnError(exception, 3);
            m_fullConnection = false;
        }
    }

    public void MakeThisDeviceDiscoverable() {
        m_requestMakeThisDeviceDiscoverable = true;
    }

    private void _MakeThisDeviceDiscoverable() {
        m_connectTime = (int)System.currentTimeMillis();
        try {
            int n2;
            m_localDevice = LocalDevice.getLocalDevice();
            if (!m_localDevice.setDiscoverable(10390323) && (n2 = m_localDevice.getDiscoverable()) != 10390323) {
                m_fullConnection = false;
                m_waitingConnection = false;
                this.m_callBackInst.bluetoothOnError(null, 1);
                return;
            }
            UUID[] uUIDArray = new UUID[]{new UUID(SERVICE_ID, false)};
            String string = "btl2cap://localhost:" + uUIDArray[0].toString() + ";name=FIFA10;master=false;authenticate=false;authorize=false;encrypt=false;ReceiveMTU=48;TransmitMTU=48";
            m_waitingConnection = true;
            this.m_notifier = (L2CAPConnectionNotifier)Connector.open((String)string);
            if (m_waitingConnection) {
                m_con = this.m_notifier.acceptAndOpen();
                if (m_localDevice.getDiscoverable() != 0) {
                    m_localDevice.setDiscoverable(0);
                }
                m_fullConnection = true;
                this.m_callBackInst.bluetoothOnNewConnection();
            }
        }
        catch (Exception exception) {
            m_fullConnection = false;
            m_waitingConnection = false;
            this.m_callBackInst.bluetoothOnError(exception, 3);
        }
    }

    public void closeBluetoothConnection() {
        m_fullConnection = false;
        m_searchForDevs = false;
        if (m_state == 1) {
            m_discAgent.cancelInquiry((DiscoveryListener)m_inqListener);
            m_inqListener.inquiryCompleted(7);
            BlueToothConnection.m_inqListener.cached_devices.removeAllElements();
        } else if (m_state == 2) {
            m_discAgent.cancelServiceSearch(m_transID);
        }
        if (m_discAgent != null) {
            if (m_state == 1) {
                m_discAgent.cancelInquiry((DiscoveryListener)m_inqListener);
            }
            m_discAgent = null;
        }
        try {
            if (m_localDevice != null) {
                m_localDevice.setDiscoverable(0);
                m_localDevice = null;
            }
        }
        catch (BluetoothStateException bluetoothStateException) {
            // empty catch block
        }
        if (m_inqListener != null) {
            m_inqListener = null;
        }
        if (m_servListener != null) {
            m_servListener = null;
        }
        if (this.m_notifier != null) {
            try {
                this.m_notifier.close();
                this.m_notifier = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m_con != null) {
            try {
                m_con.close();
                m_con = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        m_waitingConnection = false;
        m_requestScanForNewDevices = false;
        m_requestThreadKill = false;
        m_connectTime = 0;
        m_numenumeratedDevices = 0;
        m_state = -1;
    }

    private void checkforReceivedData() {
        m_checkingData = true;
        byte[] byArray = m_buffer;
        int n2 = (int)System.currentTimeMillis();
        try {
            if (m_con != null && m_con.ready()) {
                m_timePacketLastReceived = n2;
                int n3 = m_con.receive(byArray);
                if (n3 >= 32) {
                    this.m_callBackInst.bluetoothOnNewPacketArrived(byArray);
                }
            } else if (m_con != null && !m_con.ready()) {
                if (n2 - m_timePacketLastReceived > 5000) {
                    m_timePacketLastReceived = n2;
                    MainFrame.bluetoothSendData(MainFrame.m_bluetoothDataToSend, 6);
                }
            } else if (m_con == null) {
                this.m_callBackInst.bluetoothOnError(null, 4);
            }
        }
        catch (Exception exception) {
            this.m_callBackInst.bluetoothOnError(exception, 4);
        }
        m_checkingData = false;
    }

    public int sendPacket(byte[] byArray) {
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            try {
                m_con.send(byArray);
                bl = true;
            }
            catch (Exception exception) {
                if (++n2 == 20) {
                    this.m_callBackInst.bluetoothOnError(exception, 4);
                    return 0;
                }
                bl = false;
            }
        }
        return 0;
    }

    public int GetConnectingTime() {
        return (int)System.currentTimeMillis() - m_connectTime;
    }

    public String[] getEnumeratedDeviceNames() {
        return m_deviceNames;
    }

    public int getNumEnumeratedDevices() {
        return m_numenumeratedDevices;
    }

    static {
        m_checkingData = false;
    }
}

