/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameLogic;
import com.ea.game.MainFrame;
import com.ea.game.XMLMenuSystem;

public class MicroGame {
    public int m_state;
    public static final int STATE_FINISHED = 0;
    public static final int STATE_WAITING_INPUT = 1;
    public static final int STATE_WAITING_TIMED_OUT = 2;
    public static final int STATE_PAUSED = 3;
    public static final int STATE_DELAY_INPUT_WHILST_OFFSCREEN = 4;
    public static final int RESULT_PENDING = 0;
    public static final int RESULT_BAD = 1;
    public static final int RESULT_GOOD = 2;
    public static final int RESULT_DODGY = 3;
    public int m_type;
    public static final int TYPE_TACKLE = 0;
    public static final int TYPE_SHOOT = 1;
    public static final int TYPE_PASS = 2;
    private long m_timerLastFrame;
    private long m_cumulativeDuration;
    private long m_currentFrameDuration;
    private long m_maximumDuration;
    public static final int TOTAL_MARKER_RANGE = 100;
    public int m_markerAccelleration = 1;
    public int m_markerPosition;
    private boolean m_markerPositionIncreasing;
    private static final int MOTION_CONTROL_SENSITIVITY = 2;
    public int m_stat;
    public int[] m_zonePositions;
    public int m_numZones;
    public static final int ZONE_START = 0;
    public static final int ZONE_END = 1;
    public static final int ZONE_COLOUR = 2;
    public static final int ZONE_STORAGE = 3;
    public static final int MICROGAME_MAX_NUM_AIM_ZONES = 6;
    public static final int ZONE_COLOUR_RED = 0;
    public static final int ZONE_COLOUR_GREEN = 1;
    public static final int ZONE_COLOUR_ORANGE = 2;
    public static final int ZONE_COLOUR_YELLOW = 3;
    public static final int MICROGAME_OFF_SCREEN_PLAYER_DIST = 3840;
    public static final int MICROGAME_MIN_TACKLE_AIM_ZONE_WIDTH = 1;
    public static final int MICROGAME_MAX_TACKLE_AIM_ZONE_WIDTH = 75;
    public static final int MICROGAME_TACKLE_AIM_ZONE_RANGE = 74;
    public static final int MICROGAME_MAX_TACKLE_DISTANCE = 1024;
    public static final int MICROGAME_MIN_SHOOT_AIM_ZONE_WIDTH = 1;
    public static final int MICROGAME_MAX_SHOOT_AIM_ZONE_WIDTH = 46;
    public static final int MICROGAME_SHOOT_AIM_ZONE_RANGE = 45;
    public static final int MICROGAME_CURVE_OFFSET = 3500;
    public static final int FLAG_OVER_BAR = 1024;
    public int[] m_playerUsingMicroGame;

    public MicroGame() {
        this.setState(0);
        this.m_type = -1;
        this.m_zonePositions = new int[18];
    }

    public void init(int[] nArray, int n2, int n3, int n4, int n5) {
        if (GameLogic.m_gameMode == 5 && !GameLogic.m_freeKickChallengeUpdateTime) {
            return;
        }
        this.m_playerUsingMicroGame = nArray;
        this.m_numZones = n2;
        this.m_maximumDuration = n3;
        this.m_type = n4;
        this.m_stat = n5;
        this.setState(1);
        this.m_timerLastFrame = System.currentTimeMillis();
        this.m_currentFrameDuration = 0L;
        this.m_cumulativeDuration = 0L;
        this.m_markerAccelleration = 1;
        if (this.m_type == 1) {
            this.m_markerPosition = 0;
            this.m_markerPositionIncreasing = true;
        } else {
            int n6 = DDMath.getPositiveRandom() % 100;
            if (n6 < 50) {
                this.m_markerPosition = n6 % 25;
            } else {
                this.m_markerPosition = 75 + n6 % 25;
                this.m_markerPositionIncreasing = false;
            }
        }
    }

    public void updateTimeAllowed(int n2) {
        this.m_maximumDuration = n2;
        this.m_timerLastFrame = System.currentTimeMillis();
        this.m_currentFrameDuration = 0L;
        this.m_cumulativeDuration = 0L;
    }

    public void update() {
        if (GameLogic.m_matchState == 4 || GameLogic.m_gameMode == 5 && !GameLogic.m_freeKickChallengeUpdateTime) {
            this.setState(0);
            return;
        }
        if (this.m_playerUsingMicroGame != null) {
            DDDebug.msg("player whom instantiated it:   team " + this.m_playerUsingMicroGame[12] + "  playerid :" + this.m_playerUsingMicroGame[9]);
        }
        for (int i2 = 0; i2 < this.m_numZones * 2; ++i2) {
            this.m_zonePositions[i2] = DDMath.max(this.m_zonePositions[i2], 0);
            this.m_zonePositions[i2] = DDMath.min(this.m_zonePositions[i2], 100);
        }
        if (this.m_state == 1) {
            if (XMLMenuSystem.m_menuMatchType == 4) {
                this.m_currentFrameDuration = 5L;
                this.m_cumulativeDuration += this.m_currentFrameDuration;
            } else {
                this.m_currentFrameDuration = System.currentTimeMillis() - this.m_timerLastFrame;
                this.m_cumulativeDuration += this.m_currentFrameDuration;
                this.m_timerLastFrame = System.currentTimeMillis();
            }
            if (this.m_cumulativeDuration >= this.m_maximumDuration) {
                this.cancelMicroGame();
                return;
            }
            this.updateMarker();
        }
        if (this.m_state == 4 && this.m_playerUsingMicroGame != null && DDMath.calcHorizontalDist(GameAI.m_ballStorage, this.m_playerUsingMicroGame) <= 3840) {
            this.m_timerLastFrame = System.currentTimeMillis();
            this.setState(1);
        }
    }

    private void updateMarker() {
        if (this.m_markerPositionIncreasing) {
            for (int i2 = 0; i2 < this.m_markerAccelleration; ++i2) {
                this.m_markerPosition += MainFrame.m_inGameFrameRate == 24 ? 5 : 8;
            }
            if (this.m_type == 1 && this.m_markerPosition == 40) {
                ++this.m_markerAccelleration;
            }
            if (this.m_markerPosition > 100) {
                this.m_markerPosition = 100;
                boolean bl = this.m_markerPositionIncreasing = !this.m_markerPositionIncreasing;
                if (this.m_type == 1) {
                    this.cancelMicroGame();
                }
            }
        } else {
            this.m_markerPosition -= MainFrame.m_inGameFrameRate == 24 ? 5 : 8;
            if (this.m_markerPosition < 0) {
                this.m_markerPosition = 0;
                this.m_markerPositionIncreasing = !this.m_markerPositionIncreasing;
            }
        }
    }

    public void setAIResult(int n2) {
        this.m_markerPosition = n2 == 2 ? this.m_zonePositions[1] + this.m_zonePositions[2] >> 1 : this.m_zonePositions[2] + 5;
    }

    public void setMark() {
        if (this.m_state == 1) {
            this.setState(0);
        }
    }

    public void cancelMicroGame() {
        this.setState(2);
        if (this.m_playerUsingMicroGame != null) {
            GameLogic.m_controller[this.m_playerUsingMicroGame[12]].m_joystick &= 0xFFFFFE6F;
        }
        this.m_playerUsingMicroGame = null;
        GameLogic.m_lockPassTargetsPlayer = null;
    }

    public void setState(int n2) {
        this.m_state = n2;
    }

    public int getResult() {
        if (this.m_state == 0) {
            if (this.m_type == 0) {
                if (this.getMarkerZone() == 1) {
                    return 2;
                }
                if (this.getMarkerZone() == 2) {
                    return 3;
                }
                return 1;
            }
            int n2 = this.m_zonePositions[3];
            int n3 = this.m_zonePositions[4];
            if (this.getMarkerZone() == 2) {
                return 2;
            }
            if (this.m_markerPosition < n2 && n2 - this.m_markerPosition < 10 || this.m_markerPosition > n3 && this.m_markerPosition - n3 < 10) {
                return 3;
            }
            return 1;
        }
        if (this.m_state == 1 || this.m_state == 3 || this.m_state == 4) {
            return 0;
        }
        return 1;
    }

    public boolean inProgress() {
        return this.m_state == 1 || this.m_state == 4;
    }

    public int getMarkerZone() {
        for (int i2 = 0; i2 < this.m_numZones; ++i2) {
            if (this.m_markerPosition < this.m_zonePositions[i2 * 3 + 0] || this.m_markerPosition > this.m_zonePositions[i2 * 3 + 1]) continue;
            return this.m_zonePositions[i2 * 3 + 2];
        }
        return 0;
    }

    public int getDistToGreenZone() {
        int n2 = 100;
        for (int i2 = 0; i2 < this.m_numZones; ++i2) {
            if (this.m_zonePositions[i2 * 3 + 2] != 1) continue;
            if (this.m_markerPosition < this.m_zonePositions[i2 * 3 + 0]) {
                if (DDMath.abs(n2) <= this.m_zonePositions[i2 * 3 + 0] - this.m_markerPosition) continue;
                n2 = this.m_markerPosition - this.m_zonePositions[i2 * 3 + 0];
                continue;
            }
            if (this.m_markerPosition <= this.m_zonePositions[i2 * 3 + 1] || DDMath.abs(n2) <= this.m_markerPosition - this.m_zonePositions[i2 * 3 + 1]) continue;
            n2 = this.m_markerPosition - this.m_zonePositions[i2 * 3 + 1];
        }
        if (this.m_type == 1) {
            n2 = DDMath.abs(n2);
            if (this.m_markerPosition > this.m_zonePositions[1] && this.m_markerPosition < this.m_zonePositions[3]) {
                n2 |= 0x400;
            }
        }
        return n2;
    }

    public int getMarkerAccuracy() {
        int n2 = 100;
        for (int i2 = 0; i2 < this.m_numZones; ++i2) {
            if (this.m_markerPosition < this.m_zonePositions[i2 * 3 + 0] && this.m_zonePositions[i2 * 3 + 0] - this.m_markerPosition < n2) {
                n2 = this.m_zonePositions[i2 * 3 + 0] - this.m_markerPosition;
            }
            if (this.m_markerPosition <= this.m_zonePositions[i2 * 3 + 1] || this.m_markerPosition - this.m_zonePositions[i2 * 3 + 1] >= n2) continue;
            n2 = this.m_markerPosition - this.m_zonePositions[i2 * 3 + 1];
        }
        return n2;
    }

    public int getOrangeZone() {
        for (int i2 = 0; i2 < this.m_numZones; ++i2) {
            if (this.m_zonePositions[i2 * 3 + 2] != 2) continue;
            return this.m_zonePositions[i2 * 3 + 0] + (this.m_zonePositions[i2 * 3 + 1] - this.m_zonePositions[i2 * 3 + 0]) / 2;
        }
        return -1;
    }

    public int[] getMarkerRanges() {
        return this.m_zonePositions;
    }
}

