/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import com.appon.miniframework.Util;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NinePatchPNGBox {
    private Image leftTopImage;
    private Image topImage;
    private Image leftImage;
    private Image baseImage;
    private Image bottomImage;
    private Image rightImage;
    private Image rightTopImage;
    private Image rightBottomImage;
    private Image leftBottomImage;
    private int color;

    public NinePatchPNGBox(Image leftTopImage, Image topImage, Image leftImage, int color, Image baseBitmap, Image bottomImage, Image rightImage, Image rightTopImage, Image rightBottomImage, Image leftBottomImage) {
        this.leftTopImage = leftTopImage;
        this.topImage = topImage;
        this.leftImage = leftImage;
        this.color = color;
        this.baseImage = baseBitmap;
        this.bottomImage = bottomImage;
        this.rightImage = rightImage;
        this.rightTopImage = rightTopImage;
        this.rightBottomImage = rightBottomImage;
        this.leftBottomImage = leftBottomImage;
    }

    public NinePatchPNGBox() {
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        int i;
        int i2;
        if (this.leftImage == null || this.topImage == null || this.leftTopImage == null) {
            return;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int startX = x + Util.getImageWidth(this.leftTopImage);
        int endX = x + width - Util.getImageWidth(this.leftTopImage);
        g.setClip(startX, y, width - Util.getImageWidth(this.leftTopImage) * 2, height);
        for (i2 = startX; i2 < endX; i2 += Util.getImageWidth(this.topImage)) {
            Util.drawImage(g, this.topImage, i2, y);
        }
        startX = x + Util.getImageWidth(this.leftTopImage);
        endX = x + width - Util.getImageWidth(this.leftTopImage);
        for (i2 = startX; i2 < endX; i2 += Util.getImageWidth(this.topImage)) {
            Util.drawImage(g, this.bottomImage, i2, y + height - Util.getImageHeight(this.topImage));
        }
        int startY = y + Util.getImageHeight(this.leftTopImage);
        int endY = y + height - Util.getImageHeight(this.leftTopImage);
        g.setClip(x, startY, width, height - Util.getImageHeight(this.leftTopImage) * 2);
        for (i = startY; i < endY; i += Util.getImageHeight(this.leftImage)) {
            Util.drawImage(g, this.leftImage, x, i);
        }
        startY = y + Util.getImageHeight(this.leftTopImage);
        endY = y + height - Util.getImageHeight(this.leftTopImage);
        for (i = startY; i < endY; i += Util.getImageHeight(this.leftImage)) {
            Util.drawImage(g, this.rightImage, x + width - Util.getImageWidth(this.leftImage), i);
        }
        g.setClip(x + Util.getImageWidth(this.leftImage), y + Util.getImageHeight(this.topImage), width - Util.getImageWidth(this.leftImage) - Util.getImageWidth(this.leftImage), height - Util.getImageHeight(this.topImage) - Util.getImageHeight(this.topImage));
        if (this.color != -1) {
            g.setColor(Util.getColor(this.color));
            g.fillRect(x + Util.getImageWidth(this.leftImage), y + Util.getImageHeight(this.topImage), width - Util.getImageWidth(this.leftImage) - Util.getImageWidth(this.leftImage), height - Util.getImageHeight(this.topImage) - Util.getImageHeight(this.topImage));
        }
        if (this.baseImage != null) {
            this.fillImageRect(g, x + Util.getImageWidth(this.leftImage), y + Util.getImageHeight(this.topImage), width - Util.getImageWidth(this.leftImage) - Util.getImageWidth(this.leftImage), height - Util.getImageHeight(this.topImage) - Util.getImageHeight(this.topImage), this.baseImage);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        Util.drawImage(g, this.leftTopImage, x, y);
        Util.drawImage(g, this.rightTopImage, x + width - Util.getImageWidth(this.leftTopImage), y);
        Util.drawImage(g, this.leftBottomImage, x, y + height - Util.getImageHeight(this.leftTopImage));
        Util.drawImage(g, this.rightBottomImage, x + width - Util.getImageWidth(this.leftTopImage), y + height - Util.getImageHeight(this.leftTopImage));
    }

    private void fillImageRect(Graphics g, int x, int y, int width, int height, Image image) {
        int _maxW = x + width + Util.getImageWidth(image);
        int w = Util.getImageWidth(image);
        int _maxH = y + height + Util.getImageHeight(image);
        int h = Util.getImageHeight(image);
        for (int i = x; i <= _maxW; i += w) {
            for (int j = y; j <= _maxH; j += h) {
                Util.drawImage(g, image, i, j);
            }
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void cleanup() {
        this.baseImage = null;
        this.leftImage = null;
        this.topImage = null;
        this.leftTopImage = null;
    }
}

