/*
 * Decompiled with CFR 0.152.
 */
package com.indiagames.arjunprince;

import com.appon.gtantra.GTantra;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.FighterHero;
import com.indiagames.arjunprince.KnightTestCanvas;
import com.indiagames.arjunprince.KnightTestEngine;
import com.indiagames.arjunprince.VillainCharactor;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class FightSystem {
    FighterHero hero;
    Vector villains = new Vector();
    public static final int INSERT_FROM_LEFT = 0;
    public static final int INSERT_FROM_RIGHT = 1;
    GTantra heroTantra;
    GTantra villianTantra = Constant.enemyTantra;
    int screenWidth;

    public FightSystem(int screenWidth, int heroHeath, int heroDamage) {
        this.hero = new FighterHero(KnightTestEngine.hero.heroTantra, screenWidth, this, heroHeath, heroDamage);
        this.screenWidth = screenWidth;
    }

    public void keyPRESSED(int gameKey) {
        this.hero.keyPRESSED(gameKey);
    }

    public void pointerPress(int x, int y) {
        this.hero.pointerPress(x, y);
    }

    public void heroKilled() {
        KnightTestEngine.getInstance().setInGameStatus(3);
    }

    public void insertVillian(int enterFrom, int damage, int helth, int villainType) {
        int _x = 0;
        _x = enterFrom == 0 ? -this.villianTantra.getFrameWidth(0) : this.screenWidth + this.villianTantra.getFrameWidth(0);
        this.villains.addElement(new VillainCharactor(villainType, this.villianTantra, this.screenWidth, _x, this, damage, helth));
    }

    public int getVillanLife(int i) {
        VillainCharactor vilan = (VillainCharactor)this.villains.elementAt(i);
        return vilan.villainLife;
    }

    public FighterHero getHero() {
        return this.hero;
    }

    public void update() {
        this.hero.update();
        for (int i = 0; i < this.villains.size(); ++i) {
            ((VillainCharactor)this.villains.elementAt(i)).update();
        }
    }

    public void PAINT(Graphics g) {
        for (int i = 0; i < this.villains.size(); ++i) {
            ((VillainCharactor)this.villains.elementAt(i)).PAINT(g);
        }
        if (KnightTestEngine.getInstance().getInGameStatus() != 3) {
            this.hero.PAINT(g);
        }
        if (KnightTestCanvas.isTouchScreen) {
            g.drawImage(Constant.ELLIPSE_1.getImage(), Constant.JUMP_IMG_X, Constant.SLIDE_JUMP_IMG_Y, 0);
            g.drawImage(Constant.ELLIPSE_1.getImage(), Constant.SLIDE_IMG_X, Constant.SLIDE_JUMP_IMG_Y, 0);
            g.drawImage(Constant.ELLIPSE_1.getImage(), Constant.JUMP_IMG_X, Constant.SCREEN_HEIGHT >> 2, 0);
            g.drawImage(Constant.IMG_SWORD.getImage(), Constant.SLIDE_IMG_X, Constant.SLIDE_JUMP_IMG_Y, 0);
            g.drawImage(Constant.IMG_JUMP.getImage(), Constant.JUMP_IMG_X, Constant.SCREEN_HEIGHT >> 2, 0);
        }
    }

    public void heroAttacked(int x, int y, int width, int height, int attackId, int damage) {
        for (int i = 0; i < this.villains.size(); ++i) {
            VillainCharactor villain = (VillainCharactor)this.villains.elementAt(i);
            int[] collsionRect = villain.getCurrentBodyCollisionRect();
            if (!FightSystem.isRectCollision(x, y, width, height, collsionRect[0], collsionRect[1], collsionRect[2], collsionRect[3])) continue;
            villain.setAttackCooler(0L);
            int left = Math.max(x, collsionRect[0]);
            int right = Math.min(x + width, collsionRect[0] + collsionRect[2]);
            int bottom = Math.max(y + height, collsionRect[1] + collsionRect[3]);
            int top = Math.min(y, collsionRect[1]);
            if (villain.getLastAttackId() != attackId) {
                this.hero.successfullyHitted(left, top, right - left, bottom - top);
            }
            if (!villain.attackOccured(damage, attackId, villain.isLeftToHero())) continue;
            KnightTestEngine.score += 200;
            if (this.villains.size() == 1) {
                if (this.hero.getX() != Constant.HERO_X_POS) {
                    if (this.hero.getX() < Constant.HERO_X_POS) {
                        this.hero.setDirection(1);
                        this.hero.setState(1);
                    } else {
                        this.hero.setDirection(1);
                        this.hero.setState(1);
                    }
                } else if (this.hero.getX() == Constant.HERO_X_POS) {
                    this.hero.setDirection(1);
                }
                KnightTestEngine.getInstance().setEnemyKill(true);
                KnightTestEngine.setVillanCharacterEnter(false);
                KnightTestEngine.hero.setHeroX(this.hero.getX());
                KnightTestEngine.getInstance().setGoblineEnter(false);
            }
            this.villains.removeElementAt(i);
            --i;
        }
    }

    public void villainAttacked(int x, int y, int width, int height, int attackId, int damage, VillainCharactor c) {
        int[] collsionRect = this.hero.getCurrentBodyCollisionRect();
        if (FightSystem.isRectCollision(x, y, width, height, collsionRect[0], collsionRect[1], collsionRect[2], collsionRect[3])) {
            int left = Math.max(x, collsionRect[0]);
            int right = Math.min(x + width, collsionRect[0] + collsionRect[2]);
            int bottom = Math.max(y + height, collsionRect[1] + collsionRect[3]);
            int top = Math.min(y, collsionRect[1]);
            if (this.hero.getLastAttackId() != attackId) {
                c.successfullyHitted(left, top, right - left, bottom - top);
            }
            if (this.hero.attackOccured(damage, attackId, !c.isLeftToHero())) {
                --KnightTestEngine.totalheart;
                this.heroKilled();
            }
        }
    }

    public static boolean isRectCollision(int xPos1, int ypos1, int width1, int height1, int xPos2, int ypos2, int width2, int height2) {
        if (width1 == 0 || height1 == 0 || width2 == 0 || height2 == 0) {
            return false;
        }
        if (xPos1 > xPos2 + width2 || xPos1 + width1 < xPos2) {
            return false;
        }
        return ypos1 <= ypos2 + height2 && ypos1 + height1 >= ypos2;
    }
}

