/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gtantra;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GTantra {
    public static boolean _bDebug = false;
    private static int version_no;
    private int _nModules;
    private int _nFrames;
    private int _nAniamtion;
    private int _nImagesUsed;
    private boolean _bIsCollisionInfo = false;
    public Image[][] _module_images;
    static boolean processAlpha;
    public int[] _width;
    public int[] _height;
    int[] _modulesX;
    int[] _modulesY;
    int[] _iFramesModCnt;
    int[][] _iFrameModules;
    int[][] _iFrameModX;
    int[][] _iFrameModY;
    private int[][] _iFrameCollX;
    private int[][] _iFrameCollY;
    private int[][] _iFrameCollWidth;
    private int[][] _iFrameCollHeight;
    public int[] _iAnimFrameCnt;
    public int[][] _iAnimFrames;
    public int[][] _iAnimFrameX;
    public int[][] _iAnimFrameY;
    public int _iImageFormate;
    static final int IMAGE_1 = 1;
    static final int IMAGE_4 = 2;
    static final int IMAGE_16 = 3;
    static final int IMAGE_256 = 4;
    static final int IMAGE_24_BIT = 5;
    static final int IMAGE_RAW_PNG = 6;
    public static int _iPixelFormate;
    static final int PIXEL_8888 = 0;
    static final int PIXEL_0888 = 1;
    static final int PIXEL_4444 = 2;
    static final int PIXEL_0333 = 3;
    static final int PIXEL_0555 = 4;
    static final int PIXEL_0565 = 5;
    int[][] colors = new int[256][];
    static int _iNColors;
    static int[] modulePixels;
    byte[][] module_flag;
    byte[][] frame_flag;
    byte[][] frameTimer;
    byte[] pixel_locations;
    byte[] image_data;
    int[] module_data_off;
    int num_pal = 0;
    int crt_pal = 0;
    public static final byte FLAG_FLIP_X = 1;
    public static final byte FLAG_FLIP_Y = 2;
    int _iCharCommanHeight;
    private Image projectImage;
    private int bytesToRead;

    public void Load(byte[] file, boolean doCaching) {
        try {
            int j;
            int i;
            int offset = 0;
            version_no = file[offset++];
            if (version_no >= 3) {
                this.bytesToRead = file[offset++];
            }
            if (_bDebug) {
                System.out.println("version_no:" + version_no);
            }
            _iPixelFormate = file[offset++];
            if (_bDebug) {
                System.out.println("_iPixelFormate:" + _iPixelFormate);
            }
            this._iImageFormate = file[offset++];
            if (_bDebug) {
                System.out.println("_iImageFormate:" + this._iImageFormate);
            }
            this.num_pal = file[offset++];
            if (_bDebug) {
                System.out.println("num_pal:" + this.num_pal);
            }
            if ((file[offset++] & 0xFF) != 0) {
                this._bIsCollisionInfo = true;
                if (_bDebug) {
                    System.out.println("Collision Info present..");
                }
            } else {
                this._bIsCollisionInfo = false;
                if (_bDebug) {
                    System.out.println("Collision Info is not present..");
                }
            }
            if (this._iImageFormate != 5 && this._iImageFormate != 6) {
                _iNColors = file[offset++] & 0xFF;
                if (_bDebug) {
                    System.out.println(" Total Colors: " + _iNColors);
                }
                this.num_pal = this.num_pal == 0 ? 1 : this.num_pal;
                processAlpha = false;
                for (i = 0; i < this.num_pal; ++i) {
                    this.colors[i] = new int[_iNColors];
                    for (j = 0; j < _iNColors; ++j) {
                        if (_iPixelFormate == 0) {
                            this.colors[i][j] = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
                            if (this.colors[i][j] == 0) {
                                this.colors[i][j] = 1;
                            }
                            if (this.colors[i][j] == 0xFF00FF) {
                                this.colors[i][j] = 0;
                                processAlpha = true;
                            } else {
                                this.colors[i][j] = this.colors[i][j] * -1;
                            }
                            this.colors[i][j] = (this.colors[i][j] & 0xFFFFFF) * -1;
                            continue;
                        }
                        if (_iPixelFormate != 1) continue;
                        this.colors[i][j] = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16);
                        if (this.colors[i][j] == 0) {
                            this.colors[i][j] = 1;
                        }
                        if (this.colors[i][j] == 0xFF00FF) {
                            this.colors[i][j] = 0;
                            processAlpha = true;
                        } else {
                            this.colors[i][j] = this.colors[i][j] * -1;
                        }
                        this.colors[i][j] = (this.colors[i][j] & 0xFFFFFF) * -1;
                    }
                }
            }
            if (_bDebug) {
                System.out.println("Pixel Format:" + _iPixelFormate);
            }
            this._nModules = this.bytesToInt(file, offset, this.bytesToRead);
            offset += this.bytesToRead;
            if (_bDebug) {
                System.out.println("_nModules: " + this._nModules);
            }
            this._width = new int[this._nModules];
            this._height = new int[this._nModules];
            if (this._iImageFormate == 5) {
                this._modulesX = new int[this._nModules];
                this._modulesY = new int[this._nModules];
            }
            for (i = 0; i < this._nModules; ++i) {
                if (this._iImageFormate == 5) {
                    this._modulesX[i] = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
                    this._modulesY[i] = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
                }
                this._width[i] = this.bytesToInt(file, offset, this.bytesToRead);
                this._height[i] = this.bytesToInt(file, offset += this.bytesToRead, this.bytesToRead);
                offset += this.bytesToRead;
                if (this._height[i] > this._iCharCommanHeight) {
                    this._iCharCommanHeight = this._height[i];
                }
                if (!_bDebug) continue;
                System.out.println("Width: " + this._width[i] + " Height: " + this._height[i]);
            }
            this._nFrames = file[offset++] & 0xFF;
            if (_bDebug) {
                System.out.println("_nFrames: " + this._nFrames);
            }
            this._iFramesModCnt = new int[this._nFrames];
            this._iFrameModules = new int[this._nFrames][];
            this._iFrameModX = new int[this._nFrames][];
            this._iFrameModY = new int[this._nFrames][];
            this.module_flag = new byte[this._nFrames][];
            if (this._bIsCollisionInfo) {
                if (version_no == 1) {
                    this._iFrameCollX = new int[this._nFrames][1];
                    this._iFrameCollY = new int[this._nFrames][1];
                    this._iFrameCollWidth = new int[this._nFrames][1];
                    this._iFrameCollHeight = new int[this._nFrames][1];
                } else {
                    this._iFrameCollX = new int[this._nFrames][];
                    this._iFrameCollY = new int[this._nFrames][];
                    this._iFrameCollWidth = new int[this._nFrames][];
                    this._iFrameCollHeight = new int[this._nFrames][];
                }
            }
            for (i = 0; i < this._nFrames; ++i) {
                this._iFramesModCnt[i] = this.bytesToInt(file, offset, this.bytesToRead);
                offset += this.bytesToRead;
                this._iFrameModules[i] = new int[this._iFramesModCnt[i]];
                this._iFrameModX[i] = new int[this._iFramesModCnt[i]];
                this._iFrameModY[i] = new int[this._iFramesModCnt[i]];
                this.module_flag[i] = new byte[this._iFramesModCnt[i]];
                for (j = 0; j < this._iFramesModCnt[i]; ++j) {
                    this._iFrameModules[i][j] = this.bytesToInt(file, offset, this.bytesToRead);
                    this._iFrameModX[i][j] = this.bytesToIntWithSign(file, offset += this.bytesToRead, this.bytesToRead);
                    this._iFrameModY[i][j] = this.bytesToIntWithSign(file, offset += this.bytesToRead, this.bytesToRead);
                    offset += this.bytesToRead;
                    this.module_flag[i][j] = (byte)(file[offset++] & 0xFF);
                }
                if (this._bIsCollisionInfo) {
                    if (version_no == 1) {
                        this._iFrameCollX[i][0] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                        this._iFrameCollY[i][0] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                        this._iFrameCollWidth[i][0] = file[offset++] & 0xFF;
                        this._iFrameCollHeight[i][0] = file[offset++] & 0xFF;
                        continue;
                    }
                    int totalCollisionRectangles = file[offset++] & 0xFF;
                    this._iFrameCollX[i] = new int[totalCollisionRectangles];
                    this._iFrameCollY[i] = new int[totalCollisionRectangles];
                    this._iFrameCollWidth[i] = new int[totalCollisionRectangles];
                    this._iFrameCollHeight[i] = new int[totalCollisionRectangles];
                    for (int j2 = 0; j2 < totalCollisionRectangles; ++j2) {
                        this._iFrameCollX[i][j2] = this.bytesToIntWithSign(file, offset, this.bytesToRead);
                        this._iFrameCollY[i][j2] = this.bytesToIntWithSign(file, offset += this.bytesToRead, this.bytesToRead);
                        this._iFrameCollWidth[i][j2] = this.bytesToInt(file, offset += this.bytesToRead, this.bytesToRead);
                        this._iFrameCollHeight[i][j2] = this.bytesToInt(file, offset += this.bytesToRead, this.bytesToRead);
                        offset += this.bytesToRead;
                    }
                    continue;
                }
                this._iFrameCollX = null;
                this._iFrameCollY = null;
                this._iFrameCollWidth = null;
                this._iFrameCollHeight = null;
            }
            this._nAniamtion = file[offset++] & 0xFF;
            this._iAnimFrameCnt = new int[this._nAniamtion];
            this._iAnimFrames = new int[this._nAniamtion][];
            this._iAnimFrameX = new int[this._nAniamtion][];
            this._iAnimFrameY = new int[this._nAniamtion][];
            this.frame_flag = new byte[this._nAniamtion][];
            this.frameTimer = new byte[this._nAniamtion][];
            for (i = 0; i < this._nAniamtion; ++i) {
                this._iAnimFrameCnt[i] = this.bytesToInt(file, offset, this.bytesToRead);
                offset += this.bytesToRead;
                this._iAnimFrameX[i] = new int[this._iAnimFrameCnt[i]];
                this._iAnimFrameY[i] = new int[this._iAnimFrameCnt[i]];
                this._iAnimFrames[i] = new int[this._iAnimFrameCnt[i]];
                this.frame_flag[i] = new byte[this._iAnimFrameCnt[i]];
                this.frameTimer[i] = new byte[this._iAnimFrameCnt[i]];
                for (j = 0; j < this._iAnimFrameCnt[i]; ++j) {
                    this._iAnimFrames[i][j] = this.bytesToInt(file, offset, this.bytesToRead);
                    this._iAnimFrameX[i][j] = this.bytesToIntWithSign(file, offset += this.bytesToRead, this.bytesToRead);
                    this._iAnimFrameY[i][j] = this.bytesToIntWithSign(file, offset += this.bytesToRead, this.bytesToRead);
                    offset += this.bytesToRead;
                    this.frame_flag[i][j] = (byte)(file[offset++] & 0xFF);
                    this.frameTimer[i][j] = (byte)(file[offset++] & 0xFF);
                }
            }
            if (this._iImageFormate == 6) {
                this._module_images = new Image[1][this._nModules];
                for (i = 0; i < this._nModules; ++i) {
                    int size = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
                    this._module_images[0][i] = Image.createImage((byte[])file, (int)offset, (int)size);
                    offset += size;
                }
            } else if (this._iImageFormate != 5) {
                int x;
                this._module_images = new Image[this.num_pal][this._nModules];
                int image_data_length = 0;
                int mod_data_length = 0;
                this.module_data_off = new int[this._nModules];
                for (x = 0; x < this._nModules; ++x) {
                    mod_data_length = this._width[x] * this._height[x];
                    if (this._iImageFormate == 1) {
                        mod_data_length >>= 3;
                        if (this._width[x] * this._height[x] % 8 != 0) {
                            // empty if block
                        }
                    } else if (this._iImageFormate == 2) {
                        mod_data_length >>= 2;
                        if (this._width[x] * this._height[x] % 4 != 0) {
                            ++mod_data_length;
                        }
                    } else if (this._iImageFormate == 3) {
                        mod_data_length >>= 1;
                        if (this._width[x] * this._height[x] % 2 != 0) {
                            ++mod_data_length;
                        }
                    } else if (this._iImageFormate == 4) {
                        // empty if block
                    }
                    this.module_data_off[x] = ++mod_data_length;
                    image_data_length += mod_data_length;
                }
                this.image_data = new byte[image_data_length];
                for (x = 0; x < image_data_length; ++x) {
                    this.image_data[x] = file[offset++];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file = null;
        if (doCaching) {
            this.buildCacheImages();
        }
    }

    public void unload() {
        this._module_images = null;
        this.freeImageData();
        this._width = null;
        this._height = null;
        this._iFramesModCnt = null;
        this._iFrameModules = null;
        this._iFrameModX = null;
        this._iFrameModY = null;
        this._iFrameCollX = null;
        this._iFrameCollY = null;
        this._iFrameCollWidth = null;
        this._iFrameCollHeight = null;
        this._iAnimFrameCnt = null;
        this._iAnimFrames = null;
        this._iAnimFrameX = null;
        this._iAnimFrameY = null;
        modulePixels = null;
        this.module_flag = null;
        this.frame_flag = null;
        this.frameTimer = null;
    }

    public int getFrameId(int anim, int frameIndex) {
        return this._iAnimFrames[anim][frameIndex];
    }

    public int getFrameMinimumX(int frame) {
        return this.getSmallNumber(this._iFrameModX[frame]);
    }

    public int getFrameMinimumY(int frame) {
        return this.getSmallNumber(this._iFrameModY[frame]);
    }

    public int getFrameHeight(int frame) {
        int Y = this.getSmallNumber(this._iFrameModY[frame]);
        int temp2 = 0;
        temp2 = this._iFrameModY[frame][0] + this._height[this._iFrameModules[frame][0]];
        for (int i = 0; i < this._iFramesModCnt[frame]; ++i) {
            if (temp2 >= this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]]) continue;
            temp2 = this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]];
        }
        return temp2 - Y;
    }

    public int bytesToInt(byte[] buffer, int offset, int numOfBytes) {
        int value = 0;
        for (int i = 0; i < numOfBytes; ++i) {
            value += (buffer[offset++] & 0xFF) << 8 * i;
        }
        return value;
    }

    public int bytesToIntWithSign(byte[] buffer, int offset, int numOfBytes) {
        int value = this.bytesToInt(buffer, offset, numOfBytes);
        int signBit = 0;
        int valueWitoutSign = value;
        if (numOfBytes == 1) {
            signBit = value & 0x80;
            valueWitoutSign &= 0x7F;
        } else {
            signBit = value & 0x8000;
            valueWitoutSign &= Short.MAX_VALUE;
        }
        if (signBit > 0) {
            valueWitoutSign = -valueWitoutSign;
        }
        return valueWitoutSign;
    }

    public void buildCacheImages() {
        if (this._iImageFormate == 5 || this._iImageFormate == 6) {
            return;
        }
        for (int i = 0; i < this.num_pal; ++i) {
            this.BuildImages(i);
        }
        this.freeImageData();
    }

    private int[] RetriveImageData(int pal, int moduleId, int flags) {
        int clr;
        int j;
        int t;
        int t2;
        int i;
        int i2;
        int _iImageLength = this._width[moduleId] * this._height[moduleId];
        this.pixel_locations = new byte[_iImageLength];
        byte _bReadingByte = 0;
        boolean _iShiftCounter = false;
        boolean _ILocationCounter = false;
        int offset = 0;
        for (i2 = 0; i2 < moduleId; ++i2) {
            offset += this.module_data_off[i2];
        }
        if (this._iImageFormate == 1) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2++] = (byte)(_bReadingByte >> 0 & 1);
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 1 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 2 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 3 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 4 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 5 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 6 & 1);
                }
                if (i2 >= _iImageLength) continue;
                this.pixel_locations[i2] = (byte)(_bReadingByte >> 7 & 1);
            }
        } else if (this._iImageFormate == 2) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2++] = (byte)((_bReadingByte & 0xFF) >> 0 & 3);
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)((_bReadingByte & 0xFF) >> 2 & 3);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)((_bReadingByte & 0xFF) >> 4 & 3);
                }
                if (i2 >= _iImageLength) continue;
                this.pixel_locations[i2] = (byte)((_bReadingByte & 0xFF) >> 6 & 3);
            }
        } else if (this._iImageFormate == 3) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2++] = (byte)(_bReadingByte >> 0 & 0xF);
                if (i2 >= _iImageLength) continue;
                this.pixel_locations[i2] = (byte)(_bReadingByte >> 4 & 0xF);
            }
        } else if (this._iImageFormate == 4) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2] = (byte)(_bReadingByte & 0xFF);
            }
        }
        int[] pixels = new int[this._width[moduleId] * this._height[moduleId]];
        for (i = 0; i < pixels.length; ++i) {
            pixels[i] = this.colors[pal][this.pixel_locations[i] & 0xFF];
        }
        this.pixel_locations = null;
        if ((flags & 1) != 0) {
            t2 = this._width[moduleId] * this._height[moduleId];
            t = this._width[moduleId] >> 1;
            for (i = 0; i < t2; i += this._width[moduleId]) {
                j = 0;
                int j2 = this._width[moduleId] - 1;
                while (j < t) {
                    clr = pixels[i + j];
                    pixels[i + j] = pixels[i + j2];
                    pixels[i + j2] = clr;
                    ++j;
                    --j2;
                }
            }
        }
        if ((flags & 2) != 0) {
            i = 0;
            t = 0;
            t2 = this._width[moduleId] * (this._height[moduleId] - 1);
            while (i < this._height[moduleId] >> 1) {
                for (j = 0; j < this._width[moduleId]; ++j) {
                    clr = pixels[t + j];
                    pixels[t + j] = pixels[t2 + j];
                    pixels[t2 + j] = clr;
                }
                ++i;
                t += this._width[moduleId];
                t2 -= this._width[moduleId];
            }
        }
        return pixels;
    }

    public int getSingleModuleFrameWidth(int frame) {
        return this._width[this._iFrameModules[frame][0]];
    }

    public int getSingleModuleFrameHeight(int frame) {
        return this._height[this._iFrameModules[frame][0]];
    }

    public void BuildImages(int pal) {
        for (int x = 0; x < this._nModules; ++x) {
            this._module_images[pal][x] = Image.createRGBImage((int[])this.RetriveImageData(pal, x, 0), (int)this._width[x], (int)this._height[x], (boolean)processAlpha);
        }
    }

    public void freeImageData() {
        this.pixel_locations = null;
        this.image_data = null;
        this.module_data_off = null;
        System.gc();
    }

    private int byteToIntWithSign(byte val) {
        int j = val & 0x80;
        val = (byte)(val & 0x7F);
        int num = (j >>= 7) == 1 ? val * -1 : val;
        return num;
    }

    void DrawAnimation(Graphics g, int animation, int posX, int posY, int flags) {
        for (int animFrame = 0; animFrame < this._iAnimFrameCnt[animation]; ++animFrame) {
            this.DrawAnimationFrame(g, animation, animFrame, posX, posY, flags);
        }
    }

    public int getTotalAnimations() {
        return this._nAniamtion;
    }

    public void DrawFrame(Graphics g, int frame, int posX, int posY, int flags) {
        for (int frameModule = 0; frameModule < this._iFramesModCnt[frame]; ++frameModule) {
            this.DrawFrameModule(g, frame, frameModule, posX, posY, flags);
        }
    }

    public void DrawFrameModule(Graphics g, int frame, int frameModule, int posX, int posY, int flags) {
        int module = this._iFrameModules[frame][frameModule];
        posX = (flags & 1) != 0 ? (posX -= this._iFrameModX[frame][frameModule]) : (posX += this._iFrameModX[frame][frameModule]);
        posY = (flags & 2) != 0 ? (posY -= this._iFrameModY[frame][frameModule]) : (posY += this._iFrameModY[frame][frameModule]);
        if ((flags & 1) != 0) {
            posX -= this._width[module] & 0xFF;
        }
        if ((flags & 2) != 0) {
            posY -= this._height[module] & 0xFF;
        }
        this.DrawModule(g, module, posX, posY, flags ^ this.module_flag[frame][frameModule] & 0xF);
    }

    public void setProjectImage(Image projectImage) {
        this.projectImage = projectImage;
    }

    public void DrawModule(Graphics g, int module_id, int posX, int posY, int flag) {
        int sizeX = this._width[module_id] & 0xFF;
        int sizeY = this._height[module_id] & 0xFF;
        int x = 0;
        int y = 0;
        if (this._iImageFormate != 5) {
            Image img = this._module_images[this.crt_pal][module_id];
            if (img == null) {
                g.drawRGB(this.RetriveImageData(this.crt_pal, module_id, flag), 0, sizeX, posX, posY, sizeX, sizeY, processAlpha);
                return;
            }
            if ((flag & 1) != 0) {
                if ((flag & 2) != 0) {
                    g.drawRegion(img, x, y, sizeX, sizeY, 3, posX, posY, 0);
                } else {
                    g.drawRegion(img, x, y, sizeX, sizeY, 2, posX, posY, 0);
                }
            } else if ((flag & 2) != 0) {
                g.drawRegion(img, x, y, sizeX, sizeY, 1, posX, posY, 0);
            } else {
                g.drawRegion(img, x, y, sizeX, sizeY, 0, posX, posY, 0);
            }
        } else {
            x = this._modulesX[module_id] & 0xFFFF;
            y = this._modulesY[module_id] & 0xFFFF;
            if ((flag & 1) != 0) {
                if ((flag & 2) != 0) {
                    g.drawRegion(this.projectImage, x, y, sizeX, sizeY, 3, posX, posY, 0);
                } else {
                    g.drawRegion(this.projectImage, x, y, sizeX, sizeY, 2, posX, posY, 0);
                }
            } else if ((flag & 2) != 0) {
                g.drawRegion(this.projectImage, x, y, sizeX, sizeY, 1, posX, posY, 0);
            } else {
                g.drawRegion(this.projectImage, x, y, sizeX, sizeY, 0, posX, posY, 0);
            }
        }
    }

    public int[] getFrameRect(int frame, int posX, int posY, int[] arry) {
        int X = this.getSmallNumber(this._iFrameModX[frame]);
        int Y = this.getSmallNumber(this._iFrameModY[frame]);
        int temp1 = 0;
        int temp2 = 0;
        temp1 = this._iFrameModX[frame][0] + this._width[this._iFrameModules[frame][0]];
        temp2 = this._iFrameModY[frame][0] + this._height[this._iFrameModules[frame][0]];
        for (int i = 0; i < this._iFramesModCnt[frame]; ++i) {
            if (temp1 < this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]]) {
                temp1 = this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]];
            }
            if (temp2 >= this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]]) continue;
            temp2 = this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]];
        }
        arry[0] = X + posX;
        arry[1] = Y + posY;
        arry[2] = temp1 - X;
        arry[3] = temp2 - Y;
        return arry;
    }

    public int[] getCollisionRect(int frameId, int[] tmp, int index) {
        if (version_no == 1) {
            tmp[0] = this._iFrameCollX[frameId][0];
            tmp[1] = this._iFrameCollY[frameId][0];
            tmp[2] = this._iFrameCollWidth[frameId][0];
            tmp[3] = this._iFrameCollHeight[frameId][0];
        } else {
            tmp[0] = this._iFrameCollX[frameId][index];
            tmp[1] = this._iFrameCollY[frameId][index];
            tmp[2] = this._iFrameCollWidth[frameId][index];
            tmp[3] = this._iFrameCollHeight[frameId][index];
        }
        return tmp;
    }

    public int getFrameY(int frame) {
        return this.getSmallNumber(this._iFrameModY[frame]);
    }

    public int getFrameX(int frame) {
        return this.getSmallNumber(this._iFrameModX[frame]);
    }

    public int getFrameWidth(int frame) {
        int X = this.getSmallNumber(this._iFrameModX[frame]);
        int temp1 = 0;
        temp1 = this._iFrameModX[frame][0] + this._width[this._iFrameModules[frame][0]];
        for (int i = 0; i < this._iFramesModCnt[frame]; ++i) {
            if (temp1 >= this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]]) continue;
            temp1 = this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]];
        }
        return temp1 - X;
    }

    public void setCurrentPallete(int pal) {
        this.crt_pal = pal;
    }

    public void setCurrentPalleteTemp(int pal) {
        this.crt_pal = pal;
    }

    protected int getSmallNumber(int[] arry) {
        int temp = 0;
        boolean temp2 = false;
        if (arry.length != 0) {
            temp = arry[0];
            for (int i = 0; i < arry.length; ++i) {
                if (temp <= arry[i]) continue;
                temp = arry[i];
            }
        }
        return temp;
    }

    public void DrawAnimationFrame(Graphics g, int animation, int _aframe, int posX, int posY, int flags) {
        int frame = this._iAnimFrames[animation][_aframe];
        posX = (flags & 1) != 0 ? (posX -= this._iAnimFrameX[animation][_aframe]) : (posX += this._iAnimFrameX[animation][_aframe]);
        posY = (flags & 2) != 0 ? (posY -= this._iAnimFrameY[animation][_aframe]) : (posY += this._iAnimFrameY[animation][_aframe]);
        this.DrawFrame(g, frame, posX, posY, flags ^ this.frame_flag[animation][_aframe] & 0xF);
    }

    public static byte[] getFileByteData(String path) {
        int file_size = 0;
        byte[] buffer = new byte[file_size];
        try {
            InputStream _is = "".getClass().getResourceAsStream(path);
            file_size = _is.available();
            buffer = new byte[file_size];
            for (int i = 0; i < file_size; ++i) {
                buffer[i] = (byte)(_is.read() & 0xFF);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    static {
        processAlpha = false;
    }
}

