/*
 * Decompiled with CFR 0.152.
 */
package com.appon.leaderBoard;

import com.appon.leaderBoard.Attribute;
import com.appon.leaderBoard.Tag;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;

public class XMLParser {
    private DataInputStream inputStream;
    private boolean _bLeave;
    private boolean documentStart = false;
    private Tag tag = new Tag();
    private Vector _VUnclosedTags = new Vector();
    private StringBuffer _SCharactorBuffer = new StringBuffer();
    private static final int NEW_LINE_CHAR_VAL = 13;
    private static final int TAB_CHAR_VAL = 9;
    private static final int SPACE_CHAR_VAL = 32;
    private static final int PAR_END_CHAR_VAL = 10;
    private static final int UTF_16_IDENTIFY_CHAR = 65279;
    private static final String XML_DATA_NULL = "Passed XML data array is null";
    private static final String XML_INVALID_CHARACTOR = "Invlid charactor  ";
    private static final String XML_INVALID_TAG_NAME = "Invalid Tag name found ";
    private static final String XML_NO_OPENING_QUOTE = "A string literal was expected, but no opening quote character was found.";
    private static final String XML_NO_ENDING_QUOTE = "A string literal was expected, but no ending quote character was found.";
    private static final String XML_UNCLOSED_TAG_ERROR = "Unclosed tag found ";
    private static final String XML_UNCLOSED_COMMENT_ERROR = "No Closing comment found";
    private static final String XML_UNSUPPORTED_FORMAT = "Unsupported format.";
    private int _iFileLength;
    private int _iLocalCounter = 0;
    private static final byte ENCODING_UTF_8 = 0;
    private static final byte ENCODING_UTF_16 = 1;
    private static final byte ENCODING_UNKNOWN = 2;
    private int _iEncoding = 2;

    public XMLParser(InputStream inputStream) throws Exception {
        this.inputStream = new DataInputStream(inputStream);
        this._iFileLength = this.inputStream.available();
        this._iLocalCounter = 0;
        this.identifyEncoding();
    }

    private void identifyEncoding() throws Exception {
        byte[] buf = new byte[2];
        this.inputStream.read(buf);
        switch (buf[0] & 0xFF) {
            case 254: {
                if ((buf[1] & 0xFF) != 255) {
                    throw new Exception(XML_UNSUPPORTED_FORMAT);
                }
                this._iEncoding = 1;
                this._iLocalCounter += 2;
                this.readCharactor();
                break;
            }
            default: {
                this._iEncoding = 0;
                this._SCharactorBuffer.append(new String(buf));
                this.inputStream.read(buf);
                this._SCharactorBuffer.append(new String(buf));
                this._iLocalCounter += 4;
                this.removeSpecialCharactors();
                if (this.checkCharactor(0) == '<') break;
                throw new Exception(XML_UNSUPPORTED_FORMAT);
            }
        }
    }

    public String getCurrentEncoding() {
        if (this._iEncoding == 0) {
            return "UTF-8";
        }
        if (this._iEncoding == 1) {
            return "UTF-16";
        }
        return "UNKNOWN";
    }

    private char checkCharactor(int index) {
        if (index >= this._SCharactorBuffer.length()) {
            return ' ';
        }
        return this._SCharactorBuffer.charAt(index);
    }

    private void skipCharactors(int times) throws Exception {
        while (times > 0) {
            this.readCharactor();
            --times;
        }
    }

    private void readCharactor() throws Exception {
        try {
            if (this._iEncoding == 2) {
                throw new Exception(XML_UNSUPPORTED_FORMAT);
            }
            if (this._SCharactorBuffer.length() > 0) {
                this._SCharactorBuffer.deleteCharAt(0);
                if (this._iLocalCounter < this._iFileLength) {
                    if (this._iEncoding == 1) {
                        this._SCharactorBuffer.append(this.inputStream.readChar());
                        this._iLocalCounter += 2;
                    } else if (this._iEncoding == 0) {
                        this._SCharactorBuffer.append((char)this.inputStream.read());
                        ++this._iLocalCounter;
                    }
                }
            } else {
                for (int i = 0; i < 4 && this._iLocalCounter < this._iFileLength; ++i) {
                    char ch = ' ';
                    if (this._iEncoding == 1) {
                        ch = this.inputStream.readChar();
                        this._iLocalCounter += 2;
                    } else if (this._iEncoding == 0) {
                        ch = (char)this.inputStream.read();
                        ++this._iLocalCounter;
                    }
                    this._SCharactorBuffer.append(ch);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Tag read() throws Exception {
        if (this.inputStream == null) {
            throw new Exception(XML_DATA_NULL);
        }
        this.tag.reset();
        this.removeSpecialCharactors();
        if (!this.documentStart) {
            this.tag.set_Event(0);
            this.documentStart = true;
            return this.tag;
        }
        if (this.isEndOfXmlData()) {
            if (this._VUnclosedTags.size() > 0) {
                throw new Exception("Unclosed tag found <" + this._VUnclosedTags.elementAt(this._VUnclosedTags.size() - 1).toString() + '>');
            }
            this.tag.set_Event(1);
            return this.tag;
        }
        this._bLeave = false;
        if (this.isCommnetFound()) {
            this.removeCommentedText();
            return this.read();
        }
        if (this.isCommandLineFound()) {
            this.removeCommandLine();
            return this.read();
        }
        boolean endTag = false;
        if (this.checkForEndTag()) {
            endTag = true;
            this.tag.set_Event(3);
            this.tag.set_TagName(this.getEndTagName());
        } else {
            this.tag.set_Event(2);
            this.tag.set_TagName(this.getTagName());
        }
        while (!this._bLeave && !endTag) {
            this.removeWhiteSpace();
            Attribute attribute = new Attribute();
            attribute.set_AttributeName(this.getAttributeName());
            if (this._bLeave) {
                this.tag.add_Attribute(attribute);
                break;
            }
            if (this.isAttributeDataPresent()) {
                attribute.set_AttributeData(this.getAttributeData());
            }
            this.tag.add_Attribute(attribute);
        }
        if (!endTag && this.isTagDataTextPresent()) {
            this.tag.set_TagText(this.getTagDataText());
        }
        return this.tag;
    }

    private void removeCommandLine() throws Exception {
        while (!this.isEndOfXmlData()) {
            if (this.checkCharactor(0) == '>') {
                this.readCharactor();
                break;
            }
            this.readCharactor();
        }
    }

    private boolean isCommandLineFound() throws Exception {
        char ch = this.checkCharactor(0);
        if (ch == '<' && !this.isEndOfXmlData()) {
            if (this.checkCharactor(1) == '!' || this.checkCharactor(1) == '?') {
                this.skipCharactors(2);
                return true;
            }
            return false;
        }
        return false;
    }

    private void removeCommentedText() throws Exception {
        String miniStr = "";
        while (this._SCharactorBuffer.length() > 3) {
            miniStr = this.checkCharactor(0) == '!' && miniStr.length() == 0 || this.checkCharactor(0) == '-' && miniStr.length() == 1 || this.checkCharactor(0) == '-' && miniStr.length() == 2 ? miniStr + this.checkCharactor(0) : "";
            if (miniStr.equals("!--")) {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            if (this.checkCharactor(0) == '-' && this.checkCharactor(1) == '-' && this.checkCharactor(2) == '>') break;
            this.readCharactor();
        }
        if (this._SCharactorBuffer.length() <= 3) {
            throw new Exception(XML_UNCLOSED_COMMENT_ERROR);
        }
        if (this.checkCharactor(0) != '-' || this.checkCharactor(1) != '-' || this.checkCharactor(2) != '>') {
            throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
        }
        this.skipCharactors(3);
    }

    private boolean isCommnetFound() throws Exception {
        char ch = this.checkCharactor(0);
        if (ch == '<' && !this.isEndOfXmlData()) {
            if (this.checkCharactor(1) == '!') {
                if (this._SCharactorBuffer.length() > 3 && this.checkCharactor(2) == '-' && this.checkCharactor(3) == '-') {
                    this.skipCharactors(4);
                    return true;
                }
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            return false;
        }
        return false;
    }

    private String getTagDataText() throws Exception {
        String data = "";
        char ch = this.checkCharactor(0);
        while (ch != '<') {
            data = data + ch;
            if (ch == '>' || this.isEndOfXmlData()) {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
        return data;
    }

    private boolean isTagDataTextPresent() throws Exception {
        this.removeSpecialCharactors();
        char ch = this.checkCharactor(0);
        return ch != '<' && ch != '>' && !this.isEndOfXmlData();
    }

    private void removeWhiteSpace() throws Exception {
        char ch = this.checkCharactor(0);
        while (!(ch != ' ' && ch != '\t' || this.isEndOfXmlData())) {
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
    }

    private String getStringTillNewLine() throws Exception {
        StringBuffer string = new StringBuffer();
        char ch = this.checkCharactor(0);
        while (ch != '\r' && ch != '\n') {
            string.append(ch);
            if (this.isEndOfXmlData()) break;
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
        return string.toString();
    }

    private void removeSpecialCharactors() throws Exception {
        if (this.isEndOfXmlData()) {
            return;
        }
        char ch = this.checkCharactor(0);
        while (!(ch != '\ufeff' && ch != '\r' && ch != '\t' && ch != ' ' && ch != '\n' || this.isEndOfXmlData())) {
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
    }

    private boolean isAttributeDataPresent() throws Exception {
        char ch = this.checkCharactor(0);
        if (ch == '\r' || ch == '\n') {
            throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
        }
        if (ch == '=') {
            this.readCharactor();
            return true;
        }
        return false;
    }

    private boolean checkForEndTag() throws Exception {
        if (this.checkCharactor(0) != '<') {
            throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
        }
        if (this.checkCharactor(0) == '<' && this.checkCharactor(1) == '/') {
            this.skipCharactors(2);
            return true;
        }
        return false;
    }

    private String getEndTagName() throws Exception {
        StringBuffer name = new StringBuffer();
        char ch = this.checkCharactor(0);
        while (ch != ' ' && ch != '>' && ch != '\t') {
            if (ch == '/' || this.isEndOfXmlData() || ch == '\r' || ch == '\n') {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            name.append(ch);
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
        String tempString = name.toString();
        if (tempString.length() == 0) {
            throw new Exception(XML_INVALID_TAG_NAME + this.getStringTillNewLine());
        }
        this.removeWhiteSpace();
        ch = this.checkCharactor(0);
        if (ch != '>' || this._VUnclosedTags.size() == 0) {
            throw new Exception(XML_INVALID_TAG_NAME + this.getStringTillNewLine());
        }
        String lastTag = this._VUnclosedTags.elementAt(this._VUnclosedTags.size() - 1).toString();
        this._VUnclosedTags.removeElementAt(this._VUnclosedTags.size() - 1);
        if (!tempString.equals(lastTag)) {
            throw new Exception(XML_INVALID_TAG_NAME + this.getStringTillNewLine());
        }
        this.skipCharactors(1);
        return tempString;
    }

    private String getTagName() throws Exception {
        String tempString;
        StringBuffer name = new StringBuffer();
        if (this.checkCharactor(0) != '<') {
            throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
        }
        this.readCharactor();
        char ch = this.checkCharactor(0);
        while (ch != ' ' && ch != '>' && ch != '\t') {
            if (ch == '/' && !this.isEndOfXmlData()) {
                if (this.checkCharactor(1) != '>') continue;
                this.skipCharactors(2);
                this._bLeave = true;
                break;
            }
            if (ch == '/' || ch == '\r' || ch == '\n') {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            name.append(ch);
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
        if ((tempString = name.toString()).length() == 0) {
            throw new Exception(XML_INVALID_TAG_NAME + this.getStringTillNewLine());
        }
        this.removeWhiteSpace();
        ch = this.checkCharactor(0);
        if (ch == '>') {
            this.skipCharactors(1);
            this._bLeave = true;
            this._VUnclosedTags.addElement(tempString);
        }
        return tempString;
    }

    private String getAttributeName() throws Exception {
        StringBuffer name = new StringBuffer();
        char ch = this.checkCharactor(0);
        while (ch != '=' && ch != ' ' && ch != '>' && ch != '\t') {
            if (ch == '/' && !this.isEndOfXmlData()) {
                if (this.checkCharactor(1) != '>') continue;
                this.skipCharactors(2);
                this._bLeave = true;
                break;
            }
            if (ch == '/' || ch == '\r' || ch == '\n') {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            name.append(ch);
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
        String tempString = name.toString();
        this.removeWhiteSpace();
        ch = this.checkCharactor(0);
        if (ch == '>') {
            this.skipCharactors(1);
            this._bLeave = true;
            this._VUnclosedTags.addElement(tempString);
        } else {
            if (ch == '/' && this.isEndOfXmlData() || ch == '/' && this.checkCharactor(1) != '>') {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            if (ch == '/' && this.checkCharactor(1) == '>') {
                this.skipCharactors(2);
                this._bLeave = true;
            }
        }
        return tempString;
    }

    private String getAttributeData() throws Exception {
        StringBuffer data = new StringBuffer();
        this.removeWhiteSpace();
        char ch = this.checkCharactor(0);
        if (ch != '\"') {
            throw new Exception(XML_NO_OPENING_QUOTE + this.getStringTillNewLine());
        }
        this.readCharactor();
        ch = this.checkCharactor(0);
        while (ch != '\"') {
            if (ch == '\r' || ch == '\n') {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            if (this.isEndOfXmlData()) {
                throw new Exception(XML_NO_ENDING_QUOTE + this.getStringTillNewLine());
            }
            data.append(ch);
            this.readCharactor();
            ch = this.checkCharactor(0);
        }
        this.skipCharactors(1);
        this.removeWhiteSpace();
        ch = this.checkCharactor(0);
        if (ch == '>') {
            this.skipCharactors(1);
            this._bLeave = true;
            this._VUnclosedTags.addElement(this.tag.get_TagName());
        } else {
            if (ch == '/' && this.isEndOfXmlData() || ch == '/' && this.checkCharactor(1) != '>') {
                throw new Exception(XML_INVALID_CHARACTOR + this.getStringTillNewLine());
            }
            if (ch == '/' && this.checkCharactor(1) == '>') {
                this.skipCharactors(2);
                this._bLeave = true;
            }
        }
        return data.toString();
    }

    private boolean isEndOfXmlData() {
        return this._iLocalCounter - this._SCharactorBuffer.length() >= this._iFileLength;
    }
}

