/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDDebug;
import com.distinctive.DDFile;
import com.distinctive.DDImage;
import com.distinctive.DDMath;
import com.distinctive.GameLogic;
import com.distinctive.Highlights;
import com.distinctive.MainFrame;
import com.distinctive.XMLMenuSystem;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;

class GameRender {
    private static final int G_TOP = 16;
    private static final int G_BOTTOM = 32;
    private static final int G_LEFT = 4;
    private static final int G_HCENTER = 1;
    private static final int G_RIGHT = 8;
    private static final int SPRITE_TRANS_NONE = 0;
    public static final int POS_X = 0;
    public static final int POS_Y = 1;
    static final int PITCHLINETHICKNESS = 1;
    public static int m_pitchEdgeLength = 2560;
    public static int m_pitchEdgeWidth = 1280;
    public static int m_viewTop;
    public static int m_viewLeft;
    public static int m_viewWidth;
    public static int m_viewHeight;
    public static int m_viewScaleX;
    public static int m_viewScaleY;
    public static final int COLOUR_WHITE = 0xFFFFFF;
    public static final int COLOUR_RED = 0xFF0000;
    public static final int COLOUR_GREEN = 65280;
    public static final int COLOUR_BLUE = 255;
    public static final int COLOUR_BALL = 16318261;
    public static final int COLOUR_PITCH = 0x22DD22;
    public static final int COLOUR_BLACK = 0;
    public static final int COLOUR_YELLOW = 0xFFFF00;
    public static final int COLOUR_HUMAN_CONTROL_PLAYER = 0xFFFFFF;
    public static final int COLOUR_TEAM_1_NORMAL = 16001030;
    public static final int COLOUR_TEAM_1_SHORT_PASS_TARGET = 16483955;
    public static final int COLOUR_TEAM_1_LONG_PASS_TARGET = 8918788;
    public static final int COLOUR_PLAIN_PITCH = 0x559922;
    public static final int COLOUR_BALL_SHADOW = 1385984;
    public static final int PLAYER_BOOTS_BLACK = 0;
    public static final int PLAYER_BOOTS_BLUE = 1;
    public static final int PLAYER_BOOTS_RED = 2;
    public static final int PLAYER_BOOTS_WHITE = 3;
    public static final int COLOUR_TEAM_2_NORMAL = 2051577;
    public static final int COLOUR_TEAM_2_SHORT_PASS_TARGET = 9348604;
    public static final int COLOUR_TEAM_2_LONG_PASS_TARGET = 205459;
    public static final int TARGETSIZE = 320;
    public static final int SCREEN_WIDTH = 240;
    public static final int SCREEN_HEIGHT = 320;
    public static final int VIEW_LEFT = 0;
    public static final int VIEW_TOP = 78;
    public static final int VIEW_WIDTH = 240;
    public static final int VIEW_HEIGHT = 218;
    public static int[] m_screenPos;
    public static final int CAM_X = 0;
    public static final int CAM_Y = 1;
    public static final int CAM_DATA_SIZE = 2;
    public static int[] m_camera;
    private static final int RECT_PLAYER_SIZE = 8;
    private static final int BALL_RADIUS = 2;
    public static final int COLOUR_STRIPES = 0;
    public static final int COLOUR_SHIRT = 1;
    public static final int COLOUR_SHORTS = 2;
    public static final int COLOUR_SLEEVES = 3;
    public static final int COLOUR_SOCKS = 4;
    public static final int COLOUR_ARMS = 5;
    public static final int COLOUR_SKIN = 6;
    public static final int COLOUR_SHOES = 7;
    public static final int COLOUR_HAIR = 8;
    public static final int NUM_COLOUR_GROUPS = 9;
    public static final int PLAYERS_NUM_PALETTE_ENTRIES = 31;
    public static final int GROUP_COMMON = 0;
    public static final int GROUP_OUTFIELD = 1;
    public static final int GROUP_GOALIE = 2;
    public static final int NUM_GROUPS = 3;
    public static final int LAYER_CLOTHES = 0;
    public static final int LAYER_ARMS = 1;
    public static final int LAYER_SKIN = 2;
    public static final int LAYER_HAIR = 3;
    public static final int LAYER_BOOTS = 4;
    public static final int NUM_LAYERS = 5;
    private static final int LAYER_ALL = 0;
    private static final int LAYER_SPECIAL_CLOTHES = 0;
    private static final int LAYER_SPECIAL_SKIN = 1;
    private static final int LAYER_SPECIAL_BOOTS = 2;
    private static final int NUM_SPECIAL_LAYERS = 3;
    private static final byte[] BOOT_COLOURS;
    public static final int BALL_EXTRA_DATA_HEADER_SIZE = 4;
    public static final int BALL_EXTRA_DATA_FRAME_ID_LOW = 0;
    public static final int BALL_EXTRA_DATA_FRAME_ID_HI = 1;
    public static final int BALL_EXTRA_DATA_FRAME_XPOS_LOW = 2;
    public static final int BALL_EXTRA_DATA_FRAME_XPOS_HI = 3;
    public static final int BALL_EXTRA_DATA_FRAME_YPOS_LOW = 4;
    public static final int BALL_EXTRA_DATA_FRAME_YPOS_HI = 5;
    public static final int BALL_EXTRA_DATA_FRAME_ZPOS_LOW = 6;
    public static final int BALL_EXTRA_DATA_FRAME_ZPOS_HI = 7;
    public static final int BALL_EXTRA_DATA_ENTRY_SIZE = 8;
    private static byte[][] m_ballbuildintoplayerData;
    private static DDImage[] m_ballbuiltintoplayerDDImages;
    private static DDImage[][] m_playerDDImages;
    private static DDImage[] m_playerSpecialDDImages;
    public static int m_playerWidth;
    public static int m_playerHeight;
    private static final boolean PLAYERS_ANIMATION_LOADER_DEBUG_OUTPUT = false;
    private static final int PLAYERS_ANIMATION_DIRECTIONS = 0;
    private static final int PLAYERS_ANIMATION_GROUP = 1;
    private static final int PLAYERS_ANIMATION_CONTROL_TYPE = 2;
    public static final int PLAYERS_ANIMATION_ACTION_TIME = 3;
    public static final int PLAYERS_ANIMATION_ACTION_DURATION = 4;
    public static final int PLAYERS_ANIMATION_ACTION_TEMPO = 5;
    public static final int PLAYERS_ANIMATION_NUM_FRAMES = 6;
    private static final int PLAYERS_ANIMATION_NUM_OBJECTS = 7;
    public static byte[][] playersAnimControl;
    public static short[][][] playersAnimFrameSequences;
    private static short[][] playersAnimSpecialFrames;
    private static final int PLAYERS_ANIMATION_SEQUENCE_EXTEND_LAST_FRAME = 0;
    private static final int PLAYERS_ANIMATION_SEQUENCE_LOOP = 1;
    private static DDImage m_Player_shadowDDImage;
    private static int[] skinColours;
    private static final int PLAYERS_NUM_SKIN_COLOURS = 1;
    private static int[] hairColours;
    private static final int NUM_HAIR_COLOURS = 1;
    public static final int NUM_BOOT_COLOURS = 1;
    public static int[][] m_kitColours;
    private static final int PLAYER_OFFSET_X = 0;
    private static final int PLAYER_OFFSET_Y = 2;
    private static final int PLAYER_SHADOW_OFFSET_X = 24;
    private static final int PLAYER_SHADOW_OFFSET_Y = 50;
    private static final int PLAYER_LEGS_OFFSET_X = -25;
    private static final int PLAYER_LEGS_OFFSET_Y = -52;
    private static final int PLAYER_BORDER_WIDTH = 20;
    private static final int PLAYER_BORDER_HEIGHT = 40;
    public static int SOP_ZY_MULTIPLIER;
    public static int PROJECTION_W1;
    public static int PROJECTION_W2;
    public static int PROJECTION_H1;
    public static int PROJECTION_H2;
    public static int PROJECTION_BX;
    public static int PROJECTION_BY;
    public static int IPROJECTION_YXSCALE;
    public static int IPROJECTION_YSCALE;
    public static int IPROJECTION_IYSCALE;
    private static final int PITCH_FLIP_FLAG = 49152;
    private static final int PITCH_FLIP_SHFT = 14;
    private static final int PITCH_FLIP_MASK = 16383;
    private static final int DATA_MASK = 65535;
    private static final int TILESHIFT = 4;
    private static final int TILE_SIZE = 16;
    private static final int TILEMASK = 15;
    private static final int MAX_SCROLLED_TILES = 1;
    public static int m_scrollX;
    public static int m_scrollY;
    private static SDKImage m_stadiumRendererBuffer;
    private static SDKGraphics m_stadiumRendererBufferGraphics;
    private static int m_stadiumRendererLastXOffset;
    private static int m_stadiumRendererLastYOffset;
    private static SDKImage m_stadiumRendererTwoDTilesheet;
    private static short[] m_stadiumRendererTwoDTilemap;
    private static final int STADIUM_RENDERER_TWOD_MAP_WIDTH = 150;
    private static final int STADIUM_RENDERER_TWOD_MAP_HEIGHT = 14;
    public static final int STADIUM_RENDERER_TWOD_MAP_PIXEL_HEIGHT = 224;
    private static SDKImage m_stadiumRendererThreeDTilesheet;
    private static byte[] STADIUM_RENDERER_GRASS_TEXTURE_OFFSETS;
    private static int m_stadiumRendererGrassDarkPalette;
    private static int m_stadiumRendererGrassLightPalette;
    private static final int STADIUM_RENDERER_GRASS_PALETTE_LIGHT_SUNNY = 1;
    private static final int STADIUM_RENDERER_GRASS_PALETTE_DARK_SUNNY = 0;
    private static final int STADIUM_RENDERER_GRASS_PALETTE_LIGHT_RAINY = 0;
    private static final int STADIUM_RENDERER_GRASS_PALETTE_DARK_RAINY = 1;
    private static int m_stadiumRendererThreeDMapWidth;
    private static final int STADIUM_RENDERER_THREED_MAP_HEIGHT = 42;
    private static SDKImage m_stadiumRendererStandShadowImage;
    private static final int STADIUM_RENDERER_STAND_SHADOW_Y_OFFSET = 6;
    private static int[] m_stadiumRendererTeamsColours;
    private static final int TILED_SCR_X = 240;
    private static final int TILED_SCR_Y = 224;
    private static final int TILED_IMG_X = 256;
    private static final int TILED_IMG_Y = 240;
    private static final int TILED_SCR_Y_L = 240;
    private static final int TILED_SCR_X_L = 224;
    private static final int TILED_IMG_X_L = 240;
    private static final int TILED_IMG_Y_L = 256;
    private static DDImage m_stadiumRendererLowEndGrassDark;
    private static DDImage m_stadiumRendererLowEndGrassLight;
    private static int[] m_stadiumRendererLowEndYLines;
    private static final int STADIUM_RENDERER_LOW_END_NUM_Y_LINES = 24;
    private static int m_stadiumRenderLowEndTileHeight;
    private static int m_stadiumRenderLowEndTileRepeatWidth;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_RANDOM_RANGE = 4;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_GRASS_INDEX = 0;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_GRASS_TRACK_INDEX = 1;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_TRACK_GRASS_INDEX = 2;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_TRACK_INDEX = 3;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_EDGE_0 = 12;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_EDGE_1 = 13;
    private static final int STADIUM_RENDERER_TRAINING_GROUND_EDGE_2 = 13;
    private static int[] m_stadiumRendererFlipTable;
    private static final int STADIUM_RENDERER_PITCHMAP_NUM_XPOSITIONS = 60;
    private static final int STADIUM_RENDERER_PITCHMAP_NUM_YPOSITIONS = 28;
    private static final int STADIUM_RENDERER_PITCHMAP_TILE_SIZE = 16;
    private static final int STADIUM_RENDERER_PITCHMAP_PITCH_WIDTH = 2416;
    private static final int STADIUM_RENDERER_PITCHMAP_PITCH_HEIGHT = 1136;
    private static final int STADIUM_RENDERER_PITCHMAP_MAP_XSIZE = 151;
    private static final int STADIUM_RENDERER_PITCHMAP_MAP_YSIZE = 71;
    private static final int STADIUM_RENDERER_PITCHMAP_CENTRE_LINE_X = 1192;
    private static final int STADIUM_RENDERER_PITCHMAP_CENTRE_LINE_X_TOP_OFFSET = 41;
    private static final int STADIUM_RENDERER_PITCHMAP_CENTRE_LINE_X_BOTTOM_OFFSET = 77;
    private static short[] m_stadiumRendererXStart;
    private static byte[] m_stadiumRendererXStep;
    private static byte[] m_stadiumRendererYChangeColour;
    public static final int PALLETE_OFF = 33;
    public static final int PALLETE_DATA_OFF = 41;
    private static SDKImage m_ballImage;
    private static int m_ballOldX;
    private static int m_ballOldY;
    private static final int BALL_SHADOW_FRAME = 64;
    private static final int BALL_SPRITE_SIZE = 6;
    private static final int BALL_SHADOW_OFFSET_X = -21;
    private static final int BALL_SHADOW_OFFSET_Y = -50;
    private static int m_ballLastAnimFrame;
    public static final int SOME_SMALL_TOLLERANCE = 50;
    private static final int BALL_LARGE_SHAD_MAX_Z = 512;
    private static final int BALL_MED_SHAD_MAX_Z = 1280;
    private static final int BALL_SMALL_SHAD_MAX_Z = 2048;
    private static DDImage m_cornerFlagsDDImage;
    private static int m_cornerFlagsWidth;
    private static int m_cornerFlagsHeight;
    private static DDImage m_cornerFlagsShadowDDImage;
    private static final int CORNER_FLAGS_NUM_FLAGS = 4;
    private static int[][] m_cornerFlagsCoordinates;
    private static int[][] m_goalPartPositions;
    private static final int GOALS_NUM_ELEMENTS = 4;
    private static DDImage m_goalShadowDDImage;
    private static DDImage m_goalDDImage;
    private static int m_goalWidth;
    private static int m_goalHeight;
    private static final int GOAL_SHADOW_X_LEFT = 263;
    private static final int GOAL_SHADOW_X_RIGHT = 1970;
    private static final int GOAL_SHADOW_Y = 223;
    private static int[] m_goalCoords;
    private static DDImage m_goalAnimatedNets;
    private static int m_goalAnimatedNetsFrame;
    private static int[] GOAL_ANIMATED_NETS_FRAME_SEQUENCE;
    private static final int GOAL_ANIMATED_NETS_FRAME_SEQUENCE_LENGTH = 7;
    private static final int GOAL_ANIMATED_NETS_UPDATE_EVERY_N_FRAMES = 2;
    private static final int GOAL_ANIMATED_NETS_LEFT_X = 331;
    private static final int GOAL_ANIMATED_NETS_RIGHT_X = 2012;
    private static final int GOAL_ANIMATED_NETS_Y = 180;
    private static final int GOAL_ANIMATED_NETS_FRAME_RECOIL = 0;
    private static final int GOAL_ANIMATED_NETS_FRAME_IDLE = 1;
    private static final int GOAL_ANIMATED_NETS_FRAME_SMALL_BULGE = 2;
    private static final int GOAL_ANIMATED_NETS_FRAME_LARGE_BULGE = 3;
    private static final int GOAL_ANIMATED_NETS_NUM_FRAMES = 4;
    public static boolean m_goalAnimateNet;
    public static final int SORT_BALL_ID = 30;
    public static final int SORT_GOAL_TOP_L = 31;
    public static final int SORT_GOAL_BOT_L = 32;
    public static final int SORT_GOAL_TOP_R = 33;
    public static final int SORT_GOAL_BOT_R = 34;
    public static final int SORT_CORNER_FLAG_TOP_L = 35;
    public static final int SORT_CORNER_FLAG_TOP_R = 36;
    public static final int SORT_CORNER_FLAG_BOT_L = 37;
    public static final int SORT_CORNER_FLAG_BOT_R = 38;
    public static int[] m_sortTable;
    public static final int SORT_TABLE_SIZE = 35;
    private static final int PITCH_LINE_COLOUR_LIGHT_SUNNY = 12249238;
    private static final int PITCH_LINE_COLOUR_LIGHT_RAINY = 12249238;
    private static final int PITCH_LINE_COLOUR_SHADOW = 12249238;
    private static int[] m_pitchLinesNonBitmappedInSunlight1;
    private static int[] m_pitchLinesNonBitmappedInSunlight2;
    private static int[] m_pitchLinesNonBitmappedInSunlight3;
    private static int[] m_pitchLinesNonBitmappedInSunlight4;
    private static int[] m_pitchLinesNonBitmappedInSunlight5;
    private static int[] m_pitchLinesNonBitmappedInShadow;
    private static int[] m_pitchLinesNonBitmappedArcSize;
    private static int[] m_pitchLinesNonBitmappedArcPositions;
    private static int[] m_pitchLinesNonBitmappedArcAngles;
    private static boolean m_pitchLinesNonBitmappedLoaded;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_GOAL = 0;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_6_YARD = 1;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_18_YARD = 2;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_HORIZONTAL = 3;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_VERTICAL = 4;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_TOP_CORNER = 5;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_BOTTOM_CORNER = 6;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_PENALTY_ARC = 7;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_CENTRE_CIRCLE_TOP = 8;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_CENTRE_CIRCLE_BOTTOM = 9;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_CENTRE_SPOT = 10;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_PENALTY_SPOT = 11;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_JOIN_GOAL_LINE = 12;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_JOIN_6YD_TOP = 13;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_JOIN_6YD_BOTTOM = 14;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_JOIN_18YD_TOP = 15;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_JOIN_18YD_BOTTOM = 16;
    public static final int PITCH_LINES_BITMAPPED_SPRITE_JOIN_CENTRELINE = 17;
    private static final int PITCH_LINES_BITMAPPED_NUM_SPRITES = 18;
    private static DDImage[] m_pitchLinesBitmappedDDImage;
    private static String[] m_pitchLinesBitmappedFilenames;
    private static final int PITCH_LINES_BITMAPPED_NUM_DRAWS = 48;
    private static final int PITCH_LINES_BITMAPPED_INDEX_SPRITE = 0;
    private static final int PITCH_LINES_BITMAPPED_INDEX_FRAME = 1;
    private static final int PITCH_LINES_BITMAPPED_INDEX_X = 2;
    private static final int PITCH_LINES_BITMAPPED_INDEX_Y = 3;
    private static final int PITCH_LINES_BITMAPPED_INDEX_WIDTH = 4;
    private static final int PITCH_LINES_BITMAPPED_INDEX_HEIGHT = 5;
    private static final int PITCH_LINES_BITMAPPED_INDEX_DX = 6;
    private static final int PITCH_LINES_BITMAPPED_INDEX_DY = 7;
    private static final int PITCH_LINES_BITMAPPED_NUM_ELEMENTS = 8;
    private static int[] m_pitchLinesBitmappedDrawList;

    GameRender() {
    }

    public static void gameRenderInit() {
        m_viewWidth = 240;
        m_viewHeight = 218;
        m_viewLeft = 0;
        m_viewTop = 78;
        m_screenPos = new int[2];
        m_camera = new int[2];
        GameRender.m_camera[0] = 445;
        GameRender.m_camera[1] = 195;
        m_sortTable = new int[35];
    }

    public static void load(int n) {
        try {
            switch (n) {
                case 0: {
                    GameRender.setTeamColours();
                    break;
                }
                case 1: {
                    GameRender.playersLoad();
                    break;
                }
                case 2: {
                    GameRender.playerAnimationLoad();
                    GameRender.goalsLoad();
                    GameRender.cornerFlagsLoad();
                    GameRender.pitchLinesLoad();
                    break;
                }
                case 3: {
                    GameRender.stadiumRendererLoad();
                    GameRender.ballLoad();
                }
            }
        }
        catch (Exception exception) {
            MainFrame.m_loadError = 1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MainFrame.m_loadError = 1;
        }
        catch (Error error) {
            MainFrame.m_loadError = 1;
        }
    }

    public static void unload() {
        GameRender.ballUnload();
        GameRender.stadiumRendererUnload();
        GameRender.pitchLinesUnload();
        GameRender.cornerFlagsUnload();
        GameRender.goalsUnload();
        GameRender.playerAnimationUnload();
        GameRender.playersUnload();
    }

    private static void setTeamColours() {
        short s = GameLogic.m_gameCurrentMatchMessage[6];
        short s2 = GameLogic.m_gameCurrentMatchMessage[3];
        short s3 = GameLogic.m_gameCurrentMatchMessage[7];
        short s4 = GameLogic.m_gameCurrentMatchMessage[4];
        int[] nArray = new int[]{0, 0};
        XMLMenuSystem.checkKitClashes(s, s2, s3, s4, nArray);
        XMLMenuSystem.getKitColours(m_kitColours[0], s, s2, nArray[0]);
        XMLMenuSystem.getKitColours(m_kitColours[1], s3, s4, nArray[1]);
    }

    public static void draw(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
        try {
            GameRender.renderScene(sDKGraphics);
        }
        catch (Exception exception) {
            DDDebug.msg("render exception " + exception);
        }
    }

    public static void updateCamera() {
        m_scrollX = m_camera[0] - (m_viewWidth >> 1);
        m_scrollY = m_camera[1] - (m_viewHeight >> 1);
        if (m_scrollX < 0) {
            m_camera[0] = m_camera[0] - m_scrollX;
            m_scrollX = 0;
        }
        if (m_scrollY < 0) {
            m_camera[1] = m_camera[1] - m_scrollY;
            m_scrollY = 0;
        }
    }

    public static void renderScene(SDKGraphics sDKGraphics) {
        GameRender.stadiumRendererDraw(sDKGraphics);
        GameRender.pitchLinesDraw(sDKGraphics);
        GameRender.goalsDrawShadows(sDKGraphics);
        GameRender.cornerFlagsDrawShadows(sDKGraphics);
        if (Highlights.m_playerStorage != null) {
            GameRender.drawSortTableShadows(sDKGraphics);
            GameRender.drawSortTable(sDKGraphics);
        }
    }

    public static void drawPitch(SDKGraphics sDKGraphics) {
        GameRender.drawPitchLines(sDKGraphics);
        GameRender.draw18YardBox(sDKGraphics);
        GameRender.draw5YardBox(sDKGraphics);
        GameRender.drawCentreCircle(sDKGraphics);
    }

    public static void drawPitchLines(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        GameRender.getScreenPosition(0, 0, 0);
        int n = m_screenPos[0];
        int n2 = m_screenPos[1];
        GameRender.getScreenPosition(0, 32015, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(24622, 32015, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(24622, 0, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(0, 0, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        GameRender.getScreenPosition(0, 16007, 0);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(24622, 16007, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
    }

    public static void drawGoals(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        GameRender.getScreenPosition(10948, 0, 0);
        int n = m_screenPos[0];
        int n2 = m_screenPos[1];
        GameRender.getScreenPosition(10948, -884, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(13674, -884, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(13674, 0, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        GameRender.getScreenPosition(10948, 32015, 0);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(10948, 32899, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(13674, 32899, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(13674, 32015, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
    }

    public static void draw18YardBox(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        GameRender.getScreenPosition(6641, 0, 0);
        int n = m_screenPos[0];
        int n2 = m_screenPos[1];
        GameRender.getScreenPosition(6641, 4633, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(17981, 4633, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(17981, 0, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        GameRender.getScreenPosition(6641, 32015, 0);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(6641, 27382, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(17981, 27382, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(17981, 32015, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
    }

    public static void draw5YardBox(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        GameRender.getScreenPosition(9214, 0, 0);
        int n = m_screenPos[0];
        int n2 = m_screenPos[1];
        GameRender.getScreenPosition(9214, 1543, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(15408, 1543, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(15408, 0, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        GameRender.getScreenPosition(9214, 32015, 0);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(9214, 30472, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(15408, 30472, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
        n = m_screenPos[0];
        n2 = m_screenPos[1];
        GameRender.getScreenPosition(15408, 32015, 0);
        sDKGraphics.drawLine(m_screenPos[0], m_screenPos[1], n, n2);
    }

    public static void drawCentreCircle(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        GameRender.getScreenPosition(9214, 12910, 0);
        int n = m_screenPos[0];
        int n2 = m_screenPos[1];
        GameRender.getScreenPosition(15408, 19104, 0);
        if (n < m_screenPos[0]) {
            sDKGraphics.drawArc(n, n2, m_screenPos[0] - n, m_screenPos[1] - n2, 0, 360);
        } else {
            sDKGraphics.drawArc(m_screenPos[0], m_screenPos[1], n - m_screenPos[0], n2 - m_screenPos[1], 0, 360);
        }
    }

    public static void drawSinglePlayer(SDKGraphics sDKGraphics, int[] nArray, int n) {
        GameRender.getScreenPosition(nArray[0], nArray[1], 0);
        sDKGraphics.setColor(n == Highlights.m_scoringTeam ? 16001030 : 2051577);
        sDKGraphics.fillRect(m_screenPos[0] - 4, m_screenPos[1] - 4, 8, 8);
        sDKGraphics.setColor(0);
        int n2 = nArray[7] + 15 >> 5 & 7;
        int[] nArray2 = new int[]{4, 3, 2, 1, 0, 7, 6, 5};
        int[] nArray3 = new int[]{0, 7, 6, 5, 4, 3, 2, 1};
        if (Highlights.m_hflip) {
            n2 = nArray2[n2];
        }
        if (Highlights.m_vflip) {
            n2 = nArray3[n2];
        }
        int[] nArray4 = new int[]{0, 0, -2, -4, -4, -4, -2, 0};
        int[] nArray5 = new int[]{-2, 0, 0, 0, -2, -4, -4, -4};
        sDKGraphics.fillRect(m_screenPos[0] + nArray4[n2], m_screenPos[1] + nArray5[n2], 4, 4);
    }

    public static void drawSortTable(SDKGraphics sDKGraphics) {
        for (int i = 0; i < 35; ++i) {
            if (m_sortTable[i] >= 30) {
                switch (m_sortTable[i]) {
                    case 30: {
                        GameRender.drawBall(sDKGraphics);
                        break;
                    }
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        GameRender.goalsDraw(sDKGraphics, m_sortTable[i] - 31);
                        break;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: {
                        GameRender.cornerFlagsDraw(sDKGraphics, m_sortTable[i] - 35);
                    }
                }
                continue;
            }
            int n = m_sortTable[i] / 11;
            int n2 = m_sortTable[i] % 11;
            int[] nArray = Highlights.m_playerStorage[n][n2];
            int n3 = GameRender.playerCalculateDisplayFrame(nArray);
            GameRender.getScreenPosition(nArray[0], nArray[1], nArray[2]);
            if (m_screenPos[0] <= m_viewLeft - 20 || m_screenPos[0] >= m_viewLeft + m_viewWidth + 20 || m_screenPos[1] <= m_viewTop - 40 || m_screenPos[1] >= m_viewTop + m_viewHeight + 40) continue;
            int n4 = (playersAnimControl[nArray[4]][1] & 3) << 6;
            if (n2 == 0) {
                n4 |= 0x20;
            }
            if (n != Highlights.m_scoringTeam) {
                n4 |= 0x100;
            }
            GameRender.playerDraw(sDKGraphics, m_screenPos[0], m_screenPos[1], n3, n4, false);
        }
    }

    public static void drawSortTableShadows(SDKGraphics sDKGraphics) {
        for (int i = 0; i < 35; ++i) {
            if (m_sortTable[i] >= 30) {
                switch (m_sortTable[i]) {
                    case 30: {
                        GameRender.drawBallShadow(sDKGraphics);
                    }
                }
                continue;
            }
            int n = m_sortTable[i] / 11;
            int n2 = m_sortTable[i] % 11;
            int[] nArray = Highlights.m_playerStorage[n][n2];
            int n3 = GameRender.playerCalculateDisplayFrame(nArray);
            GameRender.getScreenPosition(nArray[0], nArray[1], 0);
            if (m_screenPos[0] <= m_viewLeft - 20 || m_screenPos[0] >= m_viewLeft + m_viewWidth + 20 || m_screenPos[1] <= m_viewTop - 40 || m_screenPos[1] >= m_viewTop + m_viewHeight + 40) continue;
            int n4 = 0;
            if (nArray[4] == 16 || nArray[4] == 33 || nArray[4] == 27) {
                n4 = (nArray[7] + 16 >> 5 & 7) * 8 + (nArray[6] >> 1 & 7);
            }
            GameRender.playerDrawShadow(sDKGraphics, m_screenPos[0], m_screenPos[1], n4);
        }
    }

    public static void drawPlayers(SDKGraphics sDKGraphics) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 11; ++j) {
                int[] nArray = Highlights.m_playerStorage[i][j];
                int n = GameRender.playerCalculateDisplayFrame(nArray);
                GameRender.getScreenPosition(nArray[0], nArray[1], nArray[2]);
                int n2 = (playersAnimControl[nArray[4]][1] & 3) << 6;
                if (i != Highlights.m_scoringTeam) {
                    n2 |= 0x100;
                }
                GameRender.playerDraw(sDKGraphics, m_screenPos[0], m_screenPos[1], n, n2, false);
            }
        }
    }

    public static void drawBall(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(16318261);
        GameRender.getScreenPosition(Highlights.m_ballStorage[0], Highlights.m_ballStorage[1], Highlights.m_ballStorage[2]);
        sDKGraphics.drawImage(m_ballImage, m_screenPos[0] - 3, m_screenPos[1] - 3, 20);
    }

    public static void drawBallShadow(SDKGraphics sDKGraphics) {
        GameRender.getScreenPosition(Highlights.m_ballStorage[0], Highlights.m_ballStorage[1], 0);
        int n = 0;
        n = Highlights.m_ballStorage[2] < 512 ? 0 : (Highlights.m_ballStorage[2] < 1280 ? 1 : (Highlights.m_ballStorage[2] < 2048 ? 2 : 3));
        m_Player_shadowDDImage.drawFrame(sDKGraphics, m_screenPos[0] - (m_Player_shadowDDImage.getFrameWidth(64) >> 1) + -21, m_screenPos[1] - (m_Player_shadowDDImage.getFrameHeight(64) >> 2) + -50, 64 + n, 0, 20, 0);
    }

    public static void getPixelPosition(int n, int n2, int n3) {
        if (Highlights.m_hflip) {
            n2 = 32015 - n2;
        }
        if (Highlights.m_vflip) {
            n = 24622 - n;
        }
        GameRender.pitchProjectObject(n, n2, n3);
    }

    private static void getScreenPosition(int n, int n2, int n3) {
        GameRender.getPixelPosition(n, n2, n3);
        m_screenPos[0] = m_screenPos[0] - (m_camera[0] - m_viewWidth / 2);
        m_screenPos[0] = m_screenPos[0] + m_viewLeft;
        m_screenPos[1] = m_screenPos[1] - (m_camera[1] - m_viewHeight / 2);
        m_screenPos[1] = m_screenPos[1] + m_viewTop;
    }

    private static void ballBuiltInToPlayerImagesLoad() {
        m_ballbuiltintoplayerDDImages = new DDImage[3];
        GameRender.m_ballbuiltintoplayerDDImages[2] = DDImage.createSprite("/ball_goalkeeper.spr");
        GameRender.m_ballbuiltintoplayerDDImages[0] = DDImage.createSprite("/ball_common.spr");
        GameRender.m_ballbuiltintoplayerDDImages[1] = DDImage.createSprite("/ball_outfield.spr");
    }

    private static void ballBuiltInToPlayerImagesUnload() {
        m_ballbuiltintoplayerDDImages = null;
    }

    private static void playersLoad() {
        skinColours = new int[]{16766881, 9002575, 12884600, 10859450};
        hairColours = new int[]{0xEEDD66, 7820353, 0x222222, 12679976};
        m_playerDDImages = new DDImage[3][5];
        m_playerSpecialDDImages = new DDImage[3];
        int[] nArray = new int[9];
        nArray[7] = 0;
        nArray[0] = m_kitColours[1][0];
        nArray[1] = m_kitColours[1][1];
        nArray[2] = m_kitColours[1][2];
        nArray[3] = m_kitColours[1][3];
        nArray[4] = m_kitColours[1][4];
        String string = "/";
        byte[] byArray = new byte[372];
        nArray[0] = m_kitColours[0][0];
        nArray[1] = m_kitColours[0][1];
        nArray[2] = m_kitColours[0][2];
        nArray[3] = m_kitColours[0][3];
        nArray[4] = m_kitColours[0][4];
        byte[] byArray2 = GameRender.playerCreateKitPalette(nArray);
        nArray[0] = m_kitColours[1][0];
        nArray[1] = m_kitColours[1][1];
        nArray[2] = m_kitColours[1][2];
        nArray[3] = m_kitColours[1][3];
        nArray[4] = m_kitColours[1][4];
        byte[] byArray3 = GameRender.playerCreateKitPalette(nArray);
        nArray[0] = skinColours[3];
        nArray[1] = skinColours[3];
        nArray[2] = skinColours[3];
        nArray[3] = skinColours[3];
        nArray[4] = skinColours[3];
        byte[] byArray4 = GameRender.playerCreateKitPalette(nArray);
        System.arraycopy(byArray2, 0, byArray, 0, 93);
        System.arraycopy(byArray3, 0, byArray, 93, 93);
        System.arraycopy(byArray4, 0, byArray, 186, 93);
        GameRender.m_playerDDImages[2][0] = DDImage.createSprite(string + "goalkeeper_pg00.spr", byArray4, 0, 31, 1, false);
        GameRender.m_playerDDImages[1][0] = DDImage.createSprite(string + "outfield_pg00.spr", byArray, 0, 31, 2, false);
        GameRender.m_playerDDImages[0][0] = DDImage.createSprite(string + "player_base_pg00.spr", byArray, 0, 31, 3, false);
        GameRender.m_playerSpecialDDImages[0] = DDImage.createSprite("/legs_pg00.spr", byArray, 0, 31, 2, false);
        nArray[5] = skinColours[2];
        byArray2 = GameRender.playerCreateKitPalette(nArray);
        nArray[5] = skinColours[3];
        byte[] byArray5 = GameRender.playerCreateKitPalette(nArray);
        System.arraycopy(byArray5, 0, byArray, 93, 93);
        System.arraycopy(byArray2, 0, byArray, 0, 93);
        GameRender.m_playerDDImages[2][1] = DDImage.createSprite(string + "goalkeeper_pg01.spr", byArray5, 0, 31, 1, false);
        GameRender.m_playerDDImages[1][1] = DDImage.createSprite(string + "outfield_pg01.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[0][1] = DDImage.createSprite(string + "player_base_pg01.spr", byArray, 0, 31, 2, false);
        nArray[6] = skinColours[2];
        byArray2 = GameRender.playerCreateKitPalette(nArray);
        System.arraycopy(byArray2, 0, byArray, 0, 93);
        GameRender.m_playerDDImages[2][2] = DDImage.createSprite(string + "goalkeeper_pg02.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[1][2] = DDImage.createSprite(string + "outfield_pg02.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[0][2] = DDImage.createSprite(string + "player_base_pg02.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerSpecialDDImages[1] = DDImage.createSprite("/legskin.spr", byArray, 0, 31, 1, false);
        nArray[8] = hairColours[2];
        byArray2 = GameRender.playerCreateKitPalette(nArray);
        System.arraycopy(byArray2, 0, byArray, 0, 93);
        GameRender.m_playerDDImages[2][3] = DDImage.createSprite(string + "goalkeeper_pg03.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[1][3] = DDImage.createSprite(string + "outfield_pg03.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[0][3] = DDImage.createSprite(string + "player_base_pg03.spr", byArray, 0, 31, 1, false);
        nArray[7] = 0;
        byArray2 = GameRender.playerCreateKitPalette(nArray);
        System.arraycopy(byArray2, 0, byArray, 0, 93);
        GameRender.m_playerDDImages[2][4] = DDImage.createSprite(string + "goalkeeper_pg04.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[1][4] = DDImage.createSprite(string + "outfield_pg04.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerDDImages[0][4] = DDImage.createSprite(string + "player_base_pg04.spr", byArray, 0, 31, 1, false);
        GameRender.m_playerSpecialDDImages[2] = DDImage.createSprite("/legs_pg01.spr", byArray, 0, 31, 1, false);
        playersAnimSpecialFrames = new short[3][];
        GameRender.playersAnimSpecialFrames[2] = DDFile.loadFileShorts(string + "goalkeeper_lookup");
        GameRender.playersAnimSpecialFrames[1] = DDFile.loadFileShorts(string + "outfield_lookup");
        GameRender.playersAnimSpecialFrames[0] = DDFile.loadFileShorts(string + "player_base_lookup");
        m_playerWidth = m_playerDDImages[2][2].getFrameWidth(0);
        m_playerHeight = m_playerDDImages[2][0].getFrameHeight(0);
        m_Player_shadowDDImage = DDImage.createSprite("/shadows.spr");
    }

    private static void playersUnload() {
        m_playerDDImages = null;
        m_playerSpecialDDImages = null;
        m_Player_shadowDDImage = null;
    }

    public static void playerAnimationLoad() {
        int n;
        int n2;
        String string = "/player.anim";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = DDFile.getFileLength(string);
        byte[] byArray = DDFile.loadFileBytes(string, n6);
        int n7 = byArray[n5++] & 0xFF;
        int n8 = byArray[n5++] & 0xFF;
        int n9 = byArray[n5++] & 0xFF;
        int n10 = byArray[n5++] & 0xFF;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        if (n10 >= 2) {
            if (((n7 = byArray[n5++] & 0xFF) & 1) != 0) {
                bl = true;
            }
            if ((n7 & 2) == 0) {
                bl2 = false;
            }
            if ((n7 & 4) != 0) {
                bl3 = true;
            }
        }
        n7 = byArray[n5++] & 0xFF;
        n8 = byArray[n5++] & 0xFF;
        int n11 = n8 << 8 | n7;
        playersAnimControl = new byte[n11][7];
        playersAnimFrameSequences = new short[n11][8][];
        n7 = byArray[n5++] & 0xFF;
        n8 = byArray[n5++] & 0xFF;
        int n12 = n8 << 8 | n7;
        for (n2 = 0; n2 < n11; ++n2) {
            n5 += 2;
        }
        n7 = byArray[n5++] & 0xFF;
        n8 = byArray[n5++] & 0xFF;
        int n13 = n8 << 8 | n7;
        n2 = 0;
        for (n = 0; n < n11; ++n) {
            int n14;
            for (n14 = 0; n14 < 7; ++n14) {
                if (n14 == 6) continue;
                GameRender.playersAnimControl[n][n14] = byArray[n5++];
            }
            if (bl3) {
                n7 = byArray[n5++] & 0xFF;
                n8 = byArray[n5++] & 0xFF;
                n3 = n8 << 8 | n7;
                GameRender.playersAnimControl[n][6] = (byte)n3;
            }
            for (n14 = 0; n14 < DDMath.countSetBits(playersAnimControl[n][0] & 0xFF); ++n14) {
                int n15;
                int n16 = byArray[n5++] & 0xFF;
                if (!bl3) {
                    n7 = byArray[n5++] & 0xFF;
                    n8 = byArray[n5++] & 0xFF;
                    n3 = n8 << 8 | n7;
                    if (n14 == 0) {
                        GameRender.playersAnimControl[n][6] = (byte)n3;
                    }
                }
                if (bl2) {
                    n7 = byArray[n5++] & 0xFF;
                    n8 = byArray[n5++] & 0xFF;
                    n4 = n8 << 8 | n7;
                }
                GameRender.playersAnimFrameSequences[n][n16] = new short[n3];
                for (n15 = 0; n15 < n3; ++n15) {
                    n7 = byArray[n5++] & 0xFF;
                    n8 = bl ? 0 : byArray[n5++] & 0xFF;
                    GameRender.playersAnimFrameSequences[n][n16][n15] = (short)(n8 << 8 | n7);
                    if (n2 >= playersAnimFrameSequences[n][n16][n15]) continue;
                    n2 = playersAnimFrameSequences[n][n16][n15];
                }
                if (!bl2) continue;
                for (n15 = 0; n15 < n4; ++n15) {
                    ++n5;
                }
            }
        }
        for (n = 0; n < n11; ++n) {
            if (playersAnimControl[n][3] <= 0) continue;
            GameRender.playersAnimControl[n][3] = (byte)(playersAnimControl[n][4] - playersAnimControl[n][3]);
        }
    }

    public static void playerAnimationUnload() {
        playersAnimFrameSequences = null;
        playersAnimControl = null;
    }

    public static byte[] playerCreateKitPalette(int[] nArray) {
        int n = 0;
        int n2 = 3;
        byte[] byArray = new byte[93];
        for (int i = 0; i < 9; ++i) {
            int n3 = 3;
            if (i == 6) {
                n3 = 6;
            }
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int n4;
                    if (i != 7) {
                        n4 = nArray[n] >> (2 - k) * 8 & 0xFF;
                        n4 = i == 6 ? (n4 > 80 ? (n4 -= 25 * j) : (n4 -= 15 * j)) : (n4 -= (50 - 10 * j) * j);
                        if (n4 < 0) {
                            n4 = 0;
                        }
                    } else {
                        n4 = BOOT_COLOURS[nArray[n] * 9 + j * 3 + k];
                    }
                    if (n2 >= 93) continue;
                    byArray[n2 + k] = (byte)(n4 & 0xFF);
                }
                n2 += 3;
            }
            ++n;
        }
        return byArray;
    }

    public static void playerDraw(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, boolean bl) {
        try {
            int n5 = 0;
            int n6 = n4 >> 8 & 1;
            int n7 = n4 >> 6 & 3;
            int n8 = n4 >> 5 & 1;
            int n9 = n4 >> 3 & 3;
            int n10 = n4 >> 1 & 3;
            int n11 = n4 & 1;
            int n12 = n10;
            if (n8 != 0) {
                if (n7 == 2) {
                    n6 = 0;
                    n12 = 0;
                } else {
                    n6 = 2;
                    n12 = 1;
                }
            }
            int n13 = 0;
            m_playerDDImages[n7][0].drawFrame(sDKGraphics, n + n13, n2, n3, n6, 0, 0);
            m_playerDDImages[n7][1].drawFrame(sDKGraphics, n + n13, n2, n3, n12, 0, 0);
            m_playerDDImages[n7][2].drawFrame(sDKGraphics, n + n13, n2, n3, n10, 0, 0);
            m_playerDDImages[n7][3].drawFrame(sDKGraphics, n + n13, n2, n3, n9, 0, 0);
            m_playerDDImages[n7][4].drawFrame(sDKGraphics, n + n13, n2, n3, n5, 0, 0);
            if (playersAnimSpecialFrames[n7][n3] < playersAnimSpecialFrames[n7].length) {
                m_playerSpecialDDImages[0].drawFrame(sDKGraphics, n + -25, n2 + -52, playersAnimSpecialFrames[n7][n3], n6, 0, 0);
                m_playerSpecialDDImages[1].drawFrame(sDKGraphics, n + -25, n2 + -52, playersAnimSpecialFrames[n7][n3], n10, 0, 0);
                m_playerSpecialDDImages[2].drawFrame(sDKGraphics, n + -25, n2 + -52, playersAnimSpecialFrames[n7][n3], n5, 0, 0);
            }
            if (bl) {
                n13 = 0;
                int n14 = 0;
                m_ballbuiltintoplayerDDImages[n7].drawFrame(sDKGraphics, n + n13, n2 + n14, n3, 0, 0, 0);
            }
        }
        catch (Exception exception) {
            DDDebug.msg("JP Exception drawing player: " + exception);
        }
    }

    private static void playerDrawShadow(SDKGraphics sDKGraphics, int n, int n2, int n3) {
        sDKGraphics.setClip(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
        m_Player_shadowDDImage.drawFrame(sDKGraphics, n - 24, n2 - 50, n3, 0, 20, 0);
    }

    private static int playerCalculateDisplayFrame(int[] nArray) {
        int n = nArray[4];
        int n2 = nArray[7] + 16 >> 5 & 7;
        int[] nArray2 = new int[]{4, 3, 2, 1, 0, 7, 6, 5};
        int[] nArray3 = new int[]{0, 7, 6, 5, 4, 3, 2, 1};
        if (Highlights.m_hflip) {
            n2 = nArray2[n2];
        }
        if (Highlights.m_vflip) {
            n2 = nArray3[n2];
        }
        if (nArray[6] < 0) {
            nArray[6] = 0;
        }
        int n3 = nArray[6] / GameRender.animationGetTempo(nArray[4]);
        int n4 = -1;
        int n5 = 0;
        do {
            try {
                if (playersAnimFrameSequences[n][n2 + n5 & 7] != null) {
                    n4 = playersAnimFrameSequences[n][n2 + n5 & 7][n3];
                    continue;
                }
                if (playersAnimFrameSequences[n][n2 - n5 & 7] != null) {
                    n4 = playersAnimFrameSequences[n][n2 - n5 & 7][n3];
                    continue;
                }
                ++n5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (n4 == -1);
        return n4;
    }

    public static void playerUpdateAnimation(int[] nArray) {
        nArray[62] = nArray[62] + 1;
        int n = nArray[63];
        int n2 = nArray[62] / GameRender.animationGetTempo(n);
        if (n2 >= GameRender.animationGetNumFrames(n)) {
            nArray[62] = GameRender.animationGetPlayStyle(n) == 1 ? 0 : GameRender.animationGetNumFrames(n) * GameRender.animationGetTempo(n) - 1;
        }
    }

    public static int animationGetFramesUntilAction(int n) {
        return GameRender.animationGetDuration(n) - GameRender.animationGetActionTime(n);
    }

    public static int animationGetActionTime(int n) {
        return playersAnimControl[n][3] * 2;
    }

    public static int animationGetTempo(int n) {
        return playersAnimControl[n][5] * 2;
    }

    public static int animationGetNumFrames(int n) {
        return playersAnimControl[n][6];
    }

    public static int animationGetPlayStyle(int n) {
        return playersAnimControl[n][2];
    }

    public static int animationGetDuration(int n) {
        return playersAnimControl[n][4] * 2;
    }

    public static void pitchProjectObject(int n, int n2, int n3) {
        n2 = 32015 - n2;
        int n4 = n * IPROJECTION_IYSCALE >> 8;
        int n5 = (1024 - (PROJECTION_H1 - n4 << 10) / IPROJECTION_YSCALE) * n4 >> 10;
        int n6 = PROJECTION_W2 / 2 - ((PROJECTION_H1 - n5) * IPROJECTION_YXSCALE >> 8);
        int n7 = ((16007 - n2) * (n6 >> 4) / 16007 << 4) + PROJECTION_W2 / 2;
        GameRender.m_screenPos[0] = (n7 >> 8) + PROJECTION_BX;
        GameRender.m_screenPos[1] = (n5 >> 8) + PROJECTION_BY;
        GameRender.m_screenPos[0] = m_screenPos[0] * 150 / 100;
        GameRender.m_screenPos[1] = m_screenPos[1] * 150 / 100;
        m_screenPos[1] = m_screenPos[1] + (n3 * SOP_ZY_MULTIPLIER >> 16);
    }

    private static void stadiumRendererLoad() {
        short[] sArray = null;
        SDKImage sDKImage = null;
        SDKImage sDKImage2 = null;
        m_stadiumRendererTeamsColours = new int[4];
        for (int i = 0; i < 4; ++i) {
        }
        GameRender.m_stadiumRendererTeamsColours[0] = GameLogic.m_teamColourList[GameLogic.homeTeamColourID];
        GameRender.m_stadiumRendererTeamsColours[1] = GameLogic.m_teamColourList[GameLogic.homeTeamColourID];
        GameRender.m_stadiumRendererTeamsColours[2] = GameLogic.m_teamColourList[GameLogic.awayTeamColourID];
        GameRender.m_stadiumRendererTeamsColours[3] = GameLogic.m_teamColourList[GameLogic.awayTeamColourID];
        for (int i = 0; i < 2; ++i) {
            if (m_stadiumRendererTeamsColours[i << 1] != m_stadiumRendererTeamsColours[(i << 1) + 1]) continue;
            int n = (m_stadiumRendererTeamsColours[i << 1] >> 0 & 0xFF) + (m_stadiumRendererTeamsColours[i << 1] >> 8 & 0xFF) + (m_stadiumRendererTeamsColours[i << 1] >> 16 & 0xFF);
            GameRender.m_stadiumRendererTeamsColours[(i << 1) + 1] = n > 384 ? 0x444444 : 0xF7F7F7;
        }
        String string = "/pitch";
        byte[] byArray = DDFile.loadFileBytes(string + ".png");
        sDKImage = GameRender.stadiumRendererCreateCrowdImage(byArray, DDFile.getFileLength(string + ".png"), m_stadiumRendererTeamsColours, false);
        byArray = null;
        sArray = DDFile.loadFileShorts(string + ".chr");
        STADIUM_RENDERER_GRASS_TEXTURE_OFFSETS = new byte[]{32, 0, 32, 16, 32, 32, 32, 48, 48, 48, 48, 16, 0, 48, 0, 16};
        byArray = DDFile.loadFileBytes("/grass.png");
        sDKImage2 = SDKUtils.createImage(byArray, 0, DDFile.getFileLength("/grass.png"));
        m_stadiumRendererGrassLightPalette = 0;
        m_stadiumRendererGrassDarkPalette = 0;
        GameRender.stadiumRendererPitchMapGenerate();
        m_stadiumRendererFlipTable = new int[]{0, 2, 1, 3};
        GameRender.stadiumRendererCreate(sDKImage, sArray, sDKImage2);
    }

    private static void stadiumRendererUnload() {
        m_stadiumRendererBufferGraphics = null;
        m_stadiumRendererBuffer = null;
        m_stadiumRendererTwoDTilesheet = null;
        m_stadiumRendererTwoDTilemap = null;
        m_stadiumRendererThreeDTilesheet = null;
        GameRender.stadiumRendererPitchMapGeneratorUnload();
    }

    private static void stadiumRendererCreate(SDKImage sDKImage, short[] sArray, SDKImage sDKImage2) {
        m_stadiumRendererBuffer = SDKUtils.createImage(256, 240);
        m_stadiumRendererBufferGraphics = m_stadiumRendererBuffer.getGraphics();
        m_stadiumRendererBufferGraphics.setColor(0);
        m_stadiumRendererBufferGraphics.fillRect(0, 0, m_stadiumRendererBuffer.getWidth(), m_stadiumRendererBuffer.getHeight());
        m_stadiumRendererLastXOffset = Integer.MAX_VALUE;
        m_stadiumRendererLastYOffset = Integer.MAX_VALUE;
        m_stadiumRendererTwoDTilesheet = sDKImage;
        m_stadiumRendererTwoDTilemap = sArray;
        m_stadiumRendererThreeDTilesheet = sDKImage2;
        m_stadiumRendererThreeDMapWidth = 151;
    }

    public static void stadiumRendererDrawPlainPitch(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
        sDKGraphics.setColor(0x559922);
        sDKGraphics.fillRect(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
    }

    private static void stadiumRendererDraw(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 240;
        int n12 = 224;
        int n13 = 256;
        int n14 = 240;
        int n15 = m_scrollX;
        int n16 = m_scrollY;
        int n17 = n15 % n13;
        int n18 = (n16 += 224) % n14;
        int n19 = (n15 >> 4) - (m_stadiumRendererLastXOffset >> 4);
        int n20 = (n16 >> 4) - (m_stadiumRendererLastYOffset >> 4);
        if (n19 < 0) {
            n19 = -n19;
        }
        if (n20 < 0) {
            n20 = -n20;
        }
        if (n19 > 8 || n20 > 8) {
            n19 = n13 >> 4;
            n20 = 0;
        }
        m_stadiumRendererBufferGraphics.setClip(0, 0, m_stadiumRendererBuffer.getWidth(), m_stadiumRendererBuffer.getHeight());
        if (n19 > 0) {
            n10 = (n17 >> 4) * 16;
            n9 = n18 & 0xFFFFFFF0;
            n8 = (n16 >> 4) * 150 + (n15 >> 4);
            n7 = (n16 >> 4) * m_stadiumRendererThreeDMapWidth + (n15 >> 4);
            if (n15 > m_stadiumRendererLastXOffset) {
                if ((n10 += n11 - (n19 - 1) * 16) >= n13) {
                    n10 -= n13;
                }
                n8 += (n11 >> 4) - (n19 - 1);
                n7 += (n11 >> 4) - (n19 - 1);
            }
            n6 = n8;
            n5 = n7 -= 15 * m_stadiumRendererThreeDMapWidth;
            n7 -= m_stadiumRendererThreeDMapWidth;
            n4 = 0;
            while (n4 < n19) {
                n8 = n6;
                n7 = n5;
                for (n3 = n14 >> 4; n3 > 0; --n3) {
                    GameRender.stadiumRendererDrawThreeDTile(m_stadiumRendererBufferGraphics, n10, n9, n7 += m_stadiumRendererThreeDMapWidth);
                    if (n8 < 2100 && n8 >= 0) {
                        n2 = m_stadiumRendererTwoDTilemap[n8] & 0xFFFF;
                        n = (n2 & 0xC000) >> 14;
                        n2 = (n2 & 0x3FFF) << 4;
                        n = m_stadiumRendererFlipTable[n];
                        m_stadiumRendererBufferGraphics.setClip(n10, n9, 16, 16);
                        m_stadiumRendererBufferGraphics.drawRegion(m_stadiumRendererTwoDTilesheet, (n2 & 0xFF00) >> 4, n2 & 0xFF, 16, 16, n, n10, n9, 20);
                    }
                    n8 += 150;
                    if ((n9 += 16) < n14) continue;
                    n9 = 0;
                }
                if ((n10 += 16) >= n13) {
                    n10 = 0;
                }
                ++n4;
                ++n6;
                ++n5;
            }
        }
        if (n20 > 0) {
            n10 = (n17 >> 4) * 16;
            n9 = n18 & 0xFFFFFFF0;
            n8 = (n16 >> 4) * 150 + (n15 >> 4);
            n7 = (n16 >> 4) * m_stadiumRendererThreeDMapWidth + (n15 >> 4);
            if (n16 > m_stadiumRendererLastYOffset) {
                if ((n9 += n12 - (n20 - 1) * 16) >= n14) {
                    n9 -= n14;
                }
                n8 += ((n12 >> 4) - (n20 - 1)) * 150;
                n7 += ((n12 >> 4) - (n20 - 1)) * m_stadiumRendererThreeDMapWidth;
            }
            n6 = n8;
            n5 = n7 -= 14 * m_stadiumRendererThreeDMapWidth;
            n4 = 0;
            while (n4 < n20) {
                n8 = n6;
                n7 = n5;
                --n7;
                for (n3 = n13 >> 4; n3 > 0; --n3) {
                    GameRender.stadiumRendererDrawThreeDTile(m_stadiumRendererBufferGraphics, n10, n9, ++n7);
                    if (n8 < 2100 && n8 >= 0) {
                        n2 = m_stadiumRendererTwoDTilemap[n8] & 0xFFFF;
                        n = (n2 & 0xC000) >> 14;
                        n2 = (n2 & 0x3FFF) << 4;
                        n = m_stadiumRendererFlipTable[n];
                        m_stadiumRendererBufferGraphics.setClip(n10, n9, 16, 16);
                        m_stadiumRendererBufferGraphics.drawRegion(m_stadiumRendererTwoDTilesheet, (n2 & 0xFF00) >> 4, n2 & 0xFF, 16, 16, n, n10, n9, 20);
                    }
                    ++n8;
                    if ((n10 += 16) < n13) continue;
                    n10 = 0;
                }
                if ((n9 += 16) >= n14) {
                    n9 = 0;
                }
                ++n4;
                n6 += 150;
                n5 += m_stadiumRendererThreeDMapWidth;
            }
        }
        sDKGraphics.drawImage(m_stadiumRendererBuffer, m_viewLeft - n17, m_viewTop - n18, 20);
        sDKGraphics.drawImage(m_stadiumRendererBuffer, m_viewLeft - n17 + n13, m_viewTop - n18, 20);
        sDKGraphics.drawImage(m_stadiumRendererBuffer, m_viewLeft - n17, m_viewTop - n18 + n14, 20);
        sDKGraphics.drawImage(m_stadiumRendererBuffer, m_viewLeft - n17 + n13, m_viewTop - n18 + n14, 20);
        m_stadiumRendererLastXOffset = n15;
        m_stadiumRendererLastYOffset = n16;
    }

    private static SDKImage stadiumRendererCreateCrowdImage(byte[] byArray, int n, int[] nArray, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = bl ? 2 : 4;
        int n5 = DDImage.pngFindPLTE(byArray, n);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int n6 = nArray[n2] >> (2 - k) * 8 & 0xFF;
                    if ((n6 -= (45 - 3 * j) * j * 1000 / 1200) < 0) {
                        n6 = 0;
                    }
                    byArray[n5 + n3 + k] = (byte)(n6 & 0xFF);
                }
                n3 += 3;
            }
            ++n2;
        }
        DDImage.pngCalcCRC(byArray, n5);
        return SDKUtils.createImage(byArray, 0, n);
    }

    private static void stadiumRendererPitchMapGenerate() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[60];
        int[] nArray2 = new int[60];
        int[] nArray3 = new int[60];
        nArray[0] = 0;
        nArray[1] = 19;
        nArray[2] = 42;
        nArray[3] = 63;
        nArray[4] = 85;
        nArray[5] = 109;
        nArray[6] = 133;
        nArray[7] = 157;
        nArray[8] = 183;
        nArray[9] = 208;
        nArray[10] = 237;
        nArray[11] = 265;
        nArray[12] = 294;
        nArray[13] = 327;
        nArray[14] = 358;
        nArray[15] = 391;
        nArray[16] = 427;
        nArray[17] = 463;
        nArray[18] = 502;
        nArray[19] = 541;
        nArray[20] = 583;
        nArray[21] = 627;
        nArray[22] = 672;
        nArray[23] = 718;
        nArray[24] = 766;
        nArray[25] = 816;
        nArray[26] = 867;
        nArray[27] = 925;
        nArray[28] = 979;
        GameRender.stadiumRendererPitchMapGeneratorLoad();
        for (n3 = 0; n3 < 30; ++n3) {
            nArray2[n3] = 1192 - n3 * 41 - 20;
            nArray3[n3] = 1192 - n3 * 77 - 38;
        }
        for (n3 = 0; n3 < 30; ++n3) {
            nArray2[n3 + 30] = 1192 + (1192 - nArray2[n3]);
            nArray3[n3 + 30] = 1192 + (1192 - nArray3[n3]);
        }
        for (n3 = 0; n3 < 10721; ++n3) {
            GameRender.m_stadiumRendererXStart[n3] = Short.MAX_VALUE;
        }
        for (n3 = 0; n3 < 60; ++n3) {
            int n4 = (nArray3[n3] - nArray2[n3] << 16) / 71;
            n2 = nArray2[n3] << 16;
            n = 0;
            while (n < 72) {
                int n5 = n3 < 30 ? n3 & 1 : n3 & 1 ^ 1;
                if (n2 >= 0 && n2 >> 16 < 2416) {
                    int n6 = n * 151 + (n2 >> 16) / 16;
                    if (n < 71) {
                        GameRender.m_stadiumRendererXStart[n6] = (short)(n2 % 0x100000 >> 9 << 0);
                        GameRender.m_stadiumRendererXStep[n6] = (byte)((nArray3[n3] - nArray2[n3] << 7) / 1136);
                        GameRender.m_stadiumRendererYChangeColour[n6] = (byte)(n5 + GameRender.stadiumRendererFindStartColourY(n, nArray) * 2 << 6 | GameRender.stadiumRendererFindChangeColourY(n, nArray));
                    }
                    if (n > 0 && m_stadiumRendererXStart[n6 - 151] == Short.MAX_VALUE) {
                        GameRender.m_stadiumRendererXStart[n6 - 151] = (short)(n2 % 0x100000 >> 9 << 0);
                        GameRender.m_stadiumRendererXStep[n6 - 151] = (byte)((nArray3[n3] - nArray2[n3] << 7) / 1136);
                        int n7 = n6 - 151;
                        m_stadiumRendererXStart[n7] = (short)(m_stadiumRendererXStart[n7] - (short)(m_stadiumRendererXStep[n6 - 151] * 16));
                        GameRender.m_stadiumRendererYChangeColour[n6 - 151] = (byte)(n5 + GameRender.stadiumRendererFindStartColourY(n - 1, nArray) * 2 << 6 | GameRender.stadiumRendererFindChangeColourY(n - 1, nArray));
                    }
                }
                ++n;
                n2 += n4;
            }
        }
        for (n = 0; n < 71; ++n) {
            n2 = 0;
            if (m_stadiumRendererXStart[n * 151 + n2] == Short.MAX_VALUE && m_stadiumRendererXStart[n * 151 + n2 + 1] != Short.MAX_VALUE) {
                GameRender.m_stadiumRendererXStart[n * 151 + n2] = 2048;
                GameRender.m_stadiumRendererXStep[n * 151 + n2] = 0;
                GameRender.m_stadiumRendererYChangeColour[n * 151 + n2] = m_stadiumRendererXStep[n * 151 + n2 + 1] == 0 ? (byte)(m_stadiumRendererYChangeColour[n * 151 + n2 + 1] ^ 0x40) : m_stadiumRendererYChangeColour[n * 151 + n2 + 1];
            }
            for (n2 = 1; n2 < 151; ++n2) {
                if (m_stadiumRendererXStart[n * 151 + n2] != Short.MAX_VALUE || m_stadiumRendererXStart[n * 151 + n2 - 1] == Short.MAX_VALUE) continue;
                GameRender.m_stadiumRendererXStart[n * 151 + n2] = 2048;
                GameRender.m_stadiumRendererXStep[n * 151 + n2] = 0;
                GameRender.m_stadiumRendererYChangeColour[n * 151 + n2] = m_stadiumRendererXStep[n * 151 + n2 - 1] == 0 ? m_stadiumRendererYChangeColour[n * 151 + n2 - 1] : (byte)(m_stadiumRendererYChangeColour[n * 151 + n2 - 1] ^ 0x40);
            }
        }
    }

    private static void stadiumRendererPitchMapGeneratorLoad() {
        m_stadiumRendererXStart = new short[10721];
        m_stadiumRendererXStep = new byte[10721];
        m_stadiumRendererYChangeColour = new byte[10721];
    }

    private static void stadiumRendererPitchMapGeneratorUnload() {
        m_stadiumRendererXStart = null;
        m_stadiumRendererXStep = null;
        m_stadiumRendererYChangeColour = null;
    }

    private static int stadiumRendererFindStartColourY(int n, int[] nArray) {
        int n2 = n * 16;
        for (int i = 28; i > 0; --i) {
            if (n2 < nArray[i - 1]) continue;
            return i & 1;
        }
        return 0;
    }

    private static int stadiumRendererFindChangeColourY(int n, int[] nArray) {
        int n2 = n * 16;
        for (int i = 28; i > 0; --i) {
            if (nArray[i - 1] - n2 <= 0 || nArray[i - 1] - n2 >= 16) continue;
            return nArray[i - 1] - n2;
        }
        return 16;
    }

    private static void stadiumRendererDrawThreeDTile(SDKGraphics sDKGraphics, int n, int n2, int n3) {
        if (n3 < 0 || n3 >= m_stadiumRendererThreeDMapWidth * 42) {
            sDKGraphics.setColor(0x559922);
            sDKGraphics.fillRect(n, n2, 16, 16);
            return;
        }
        SDKImage sDKImage = m_stadiumRendererThreeDTilesheet;
        int n4 = m_stadiumRendererXStart[n3];
        byte by = m_stadiumRendererXStep[n3];
        int n5 = (m_stadiumRendererYChangeColour[n3] & 0x7F) + (m_stadiumRendererYChangeColour[n3] & 0x80);
        int n6 = n5 >> 5 & 6;
        int n7 = n5 & 0x3F;
        if (n4 == Short.MAX_VALUE) {
            sDKGraphics.setColor(65280);
            sDKGraphics.fillRect(n, n2, 16, 16);
        } else if (by == 0) {
            sDKGraphics.setClip(n, n2, 16, 16);
            sDKGraphics.drawImage(sDKImage, n - STADIUM_RENDERER_GRASS_TEXTURE_OFFSETS[n6 + 8 + 0], n2 - (STADIUM_RENDERER_GRASS_TEXTURE_OFFSETS[n6 + 8 + 1] - n7), 20);
        } else {
            for (int i = 0; i < 16; i += 2) {
                if (i == n7 || i + 1 == n7) {
                    n6 ^= 4;
                }
                sDKGraphics.setClip(n, n2 + i, 16, 2);
                sDKGraphics.drawImage(sDKImage, n - (STADIUM_RENDERER_GRASS_TEXTURE_OFFSETS[n6 + 0] - (n4 >> 7)), n2 - STADIUM_RENDERER_GRASS_TEXTURE_OFFSETS[n6 + 1], 20);
                n4 += by << 1;
            }
        }
    }

    private static void ballLoad() {
        m_ballImage = DDFile.loadImage("/sfball.png");
    }

    private static void ballUnload() {
        m_ballImage = null;
    }

    private static void ballUpdateAnimation() {
        Highlights.m_ballStorage[9] = 0;
        m_ballOldX = Highlights.m_ballStorage[0];
        m_ballOldY = Highlights.m_ballStorage[1];
        m_ballLastAnimFrame = Highlights.m_ballStorage[9];
    }

    private static void cornerFlagsLoad() {
        m_cornerFlagsDDImage = DDImage.createSprite("/corner_flag.spr");
        m_cornerFlagsWidth = m_cornerFlagsDDImage.getFrameWidth(0);
        m_cornerFlagsHeight = m_cornerFlagsDDImage.getFrameHeight(0);
        m_cornerFlagsShadowDDImage = DDImage.createSprite("/corner_shad.spr");
        m_cornerFlagsCoordinates = new int[4][2];
        GameRender.pitchProjectObject(0, 0, 0);
        GameRender.m_cornerFlagsCoordinates[0][0] = m_screenPos[0];
        GameRender.m_cornerFlagsCoordinates[0][1] = m_screenPos[1];
        GameRender.pitchProjectObject(0, 32015, 0);
        GameRender.m_cornerFlagsCoordinates[1][0] = m_screenPos[0];
        GameRender.m_cornerFlagsCoordinates[1][1] = m_screenPos[1];
        GameRender.pitchProjectObject(24622, 0, 0);
        GameRender.m_cornerFlagsCoordinates[2][0] = m_screenPos[0];
        GameRender.m_cornerFlagsCoordinates[2][1] = m_screenPos[1];
        GameRender.pitchProjectObject(24622, 32015, 0);
        GameRender.m_cornerFlagsCoordinates[3][0] = m_screenPos[0];
        GameRender.m_cornerFlagsCoordinates[3][1] = m_screenPos[1];
    }

    private static void cornerFlagsUnload() {
        m_cornerFlagsShadowDDImage = null;
        m_cornerFlagsDDImage = null;
        m_cornerFlagsCoordinates = null;
    }

    private static void cornerFlagsDraw(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setClip(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
        m_cornerFlagsDDImage.drawFrame(sDKGraphics, m_viewLeft + m_cornerFlagsCoordinates[n][0] - m_scrollX, m_viewTop + m_cornerFlagsCoordinates[n][1] - m_scrollY, n, 0, 20, 0);
    }

    private static void cornerFlagsDrawShadows(SDKGraphics sDKGraphics) {
        int n = 0;
        sDKGraphics.setClip(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = m_cornerFlagsCoordinates[i][0] - m_scrollX;
            if (n3 + m_cornerFlagsShadowDDImage.getFrameWidth(0) < 0 || n3 > m_viewWidth || (n2 = m_cornerFlagsCoordinates[i][1] - m_scrollY) + m_cornerFlagsShadowDDImage.getFrameHeight(0) < 0 || n2 > m_viewHeight) continue;
            m_cornerFlagsShadowDDImage.drawFrame(sDKGraphics, m_viewLeft + n3 + n, m_viewTop + n2, i, 0, 24, 0);
        }
    }

    private static void goalsLoad() {
        m_goalShadowDDImage = DDImage.createSprite("/net_shadow.spr");
        m_goalDDImage = DDImage.createSprite("/nets.spr");
        m_goalCoords = DDFile.loadFileInts("/ad21.bin");
        m_goalWidth = m_goalDDImage.getFrameWidth(0);
        m_goalHeight = m_goalDDImage.getFrameHeight(0);
    }

    private static void goalsUnload() {
        m_goalCoords = null;
        m_goalDDImage = null;
        m_goalShadowDDImage = null;
    }

    private static void goalsDraw(SDKGraphics sDKGraphics, int n) {
        m_goalDDImage.drawFrame(sDKGraphics, m_viewLeft + m_goalCoords[n << 1] - m_scrollX, m_viewTop + m_goalCoords[(n << 1) + 1] - m_scrollY, n, 0, 20, 0);
    }

    private static void goalsDrawShadows(SDKGraphics sDKGraphics) {
        int n = 223 - m_scrollY;
        int n2 = m_goalShadowDDImage.getFrameHeight(0);
        if (n >= -n2 && n <= m_viewHeight) {
            sDKGraphics.setClip(0, 0, 240, 320);
            int n3 = m_goalShadowDDImage.getFrameWidth(0);
            int n4 = 263 - m_scrollX;
            if (n4 >= -n3 && n4 <= m_viewWidth) {
                m_goalShadowDDImage.drawFrame(sDKGraphics, m_viewLeft + n4, m_viewTop + n, 0, 0, 20, 0);
            }
            if ((n4 = 1970 - m_scrollX) >= -n3 && n4 <= m_viewWidth) {
                m_goalShadowDDImage.drawFrame(sDKGraphics, m_viewLeft + n4, m_viewTop + n, 1, 0, 20, 0);
            }
        }
    }

    public static void sortFrame() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int[] nArray = new int[35];
        GameRender.m_sortTable[n4] = 30;
        nArray[n4] = Highlights.m_ballStorage[0];
        ++n4;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < n4 && m_cornerFlagsCoordinates[n3][0] > nArray[n2]; ++n2) {
            }
            if (n2 < n4) {
                for (n = n4; n > n2; --n) {
                    GameRender.m_sortTable[n] = m_sortTable[n - 1];
                    nArray[n] = nArray[n - 1];
                }
            }
            GameRender.m_sortTable[n2] = 35 + n3;
            nArray[n2] = m_cornerFlagsCoordinates[n3][0];
            ++n4;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < n4 && m_goalPartPositions[n3][0] > nArray[n2]; ++n2) {
            }
            if (n2 < n4) {
                for (n = n4; n > n2; --n) {
                    GameRender.m_sortTable[n] = m_sortTable[n - 1];
                    nArray[n] = nArray[n - 1];
                }
            }
            GameRender.m_sortTable[n2] = 31 + n3;
            nArray[n2] = m_goalPartPositions[n3][0];
            ++n4;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 0; n2 < 11; ++n2) {
                for (n = 0; n < n4 && Highlights.m_playerStorage[n3][n2][0] > nArray[n]; ++n) {
                }
                if (n < n4) {
                    for (int i = n4; i > n; --i) {
                        GameRender.m_sortTable[i] = m_sortTable[i - 1];
                        nArray[i] = nArray[i - 1];
                    }
                }
                GameRender.m_sortTable[n] = n3 * 11 + n2;
                nArray[n] = Highlights.m_playerStorage[n3][n2][0];
                ++n4;
            }
        }
        if (Highlights.m_vflip) {
            block16: for (n3 = 0; n3 < 35; ++n3) {
                nArray[34 - n3] = m_sortTable[n3];
                if (m_sortTable[n3] <= 30) continue;
                switch (nArray[34 - n3]) {
                    case 31: 
                    case 33: {
                        int n5 = 34 - n3;
                        nArray[n5] = nArray[n5] + 1;
                        continue block16;
                    }
                    case 32: 
                    case 34: {
                        int n6 = 34 - n3;
                        nArray[n6] = nArray[n6] - 1;
                        continue block16;
                    }
                    case 35: 
                    case 36: {
                        int n7 = 34 - n3;
                        nArray[n7] = nArray[n7] + 2;
                        continue block16;
                    }
                    case 37: 
                    case 38: {
                        int n8 = 34 - n3;
                        nArray[n8] = nArray[n8] - 2;
                    }
                }
            }
            System.arraycopy(nArray, 0, m_sortTable, 0, 35);
        }
    }

    private static void pitchLinesLoad() {
        GameRender.pitchLinesLoadNonBitmapped();
    }

    private static void pitchLinesLoadNonBitmapped() {
        if (!m_pitchLinesNonBitmappedLoaded) {
            m_pitchLinesNonBitmappedInSunlight1 = DDFile.loadFileInts("/ad05.bin");
            m_pitchLinesNonBitmappedInSunlight2 = DDFile.loadFileInts("/ad06.bin");
            m_pitchLinesNonBitmappedInSunlight3 = DDFile.loadFileInts("/ad07.bin");
            m_pitchLinesNonBitmappedInSunlight4 = DDFile.loadFileInts("/ad08.bin");
            m_pitchLinesNonBitmappedInSunlight5 = DDFile.loadFileInts("/ad09.bin");
            m_pitchLinesNonBitmappedInShadow = DDFile.loadFileInts("/ad10.bin");
            m_pitchLinesNonBitmappedArcSize = DDFile.loadFileInts("/ad11.bin");
            m_pitchLinesNonBitmappedArcPositions = DDFile.loadFileInts("/ad12.bin");
            m_pitchLinesNonBitmappedArcAngles = DDFile.loadFileInts("/ad13.bin");
            m_pitchLinesNonBitmappedLoaded = true;
        }
    }

    private static void pitchLinesLoadBitmapped() {
    }

    private static void pitchLinesUnload() {
        m_pitchLinesNonBitmappedInSunlight1 = null;
        m_pitchLinesNonBitmappedInSunlight2 = null;
        m_pitchLinesNonBitmappedInSunlight3 = null;
        m_pitchLinesNonBitmappedInSunlight4 = null;
        m_pitchLinesNonBitmappedInSunlight5 = null;
        m_pitchLinesNonBitmappedInShadow = null;
        m_pitchLinesNonBitmappedArcSize = null;
        m_pitchLinesNonBitmappedArcPositions = null;
        m_pitchLinesNonBitmappedArcAngles = null;
        m_pitchLinesNonBitmappedLoaded = false;
    }

    private static void pitchLinesDraw(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(m_viewLeft, m_viewTop, m_viewWidth, m_viewHeight);
        GameRender.pitchLinesDrawNonBitmapped(sDKGraphics);
    }

    private static void pitchLinesDrawNonBitmapped(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(12249238);
        GameRender.pitchLinesDrawLineStripArray(sDKGraphics, m_pitchLinesNonBitmappedInShadow, 0, 14);
        sDKGraphics.setColor(12249238);
        GameRender.pitchLinesDrawLineStripArray(sDKGraphics, m_pitchLinesNonBitmappedInSunlight1, 0, 14);
        GameRender.pitchLinesDrawLineStripArray(sDKGraphics, m_pitchLinesNonBitmappedInSunlight2, 0, 8);
        GameRender.pitchLinesDrawLineStripArray(sDKGraphics, m_pitchLinesNonBitmappedInSunlight3, 0, 8);
        GameRender.pitchLinesDrawLineStripArray(sDKGraphics, m_pitchLinesNonBitmappedInSunlight4, 0, 8);
        GameRender.pitchLinesDrawLineStripArray(sDKGraphics, m_pitchLinesNonBitmappedInSunlight5, 0, 8);
        sDKGraphics.setColor(12249238);
        for (int i = 0; i < 10; ++i) {
            if (i == 2) {
                sDKGraphics.setColor(12249238);
            }
            int n = m_pitchLinesNonBitmappedArcPositions[i << 1] - (m_pitchLinesNonBitmappedArcSize[i << 1] >> 1);
            int n2 = m_pitchLinesNonBitmappedArcPositions[(i << 1) + 1] - (m_pitchLinesNonBitmappedArcSize[(i << 1) + 1] >> 1);
            int n3 = m_pitchLinesNonBitmappedArcSize[i << 1];
            int n4 = m_pitchLinesNonBitmappedArcSize[(i << 1) + 1];
            int n5 = m_pitchLinesNonBitmappedArcAngles[i << 1];
            int n6 = m_pitchLinesNonBitmappedArcAngles[(i << 1) + 1];
            if (n + n3 < m_scrollX || n > m_scrollX + m_viewWidth || n2 + n3 < m_scrollY || n2 > m_scrollY + m_viewHeight) continue;
            n += m_viewLeft;
            n2 += m_viewTop;
            if (i < 7) {
                sDKGraphics.drawArc(n - m_scrollX, n2 - m_scrollY, n3, n4, n5, n6);
                continue;
            }
            sDKGraphics.fillArc(n - m_scrollX, n2 - m_scrollY, n3, n4, n5, n6);
        }
    }

    private static void pitchLinesDrawBitmapped(SDKGraphics sDKGraphics) {
    }

    private static void pitchLinesDrawLineStripArray(SDKGraphics sDKGraphics, int[] nArray, int n, int n2) {
        for (int i = n; i < n + n2 - 2; i += 2) {
            int n3 = nArray[i] - m_scrollX;
            int n4 = nArray[i + 1] - m_scrollY;
            int n5 = nArray[i + 2] - m_scrollX;
            int n6 = nArray[i + 2 + 1] - m_scrollY;
            if (n3 < 0 && n5 < 0 || n3 > m_viewWidth && n5 > m_viewWidth || n4 < 0 && n6 < 0 || n4 > m_viewHeight && n6 > m_viewHeight) continue;
            sDKGraphics.drawLine(n3 += m_viewLeft, n4 += m_viewTop, n5 += m_viewLeft, n6 += m_viewTop);
        }
    }

    static {
        BOOT_COLOURS = new byte[]{0, 0, 0, 43, 57, 50, 58, 104, 34, 40, 87, -96, 57, 107, -74, 79, -127, 92, -80, 0, 0, -52, 28, 27, -106, 88, 15, -40, -37, -46, -15, -14, -11, -86, -58, 120};
        m_kitColours = new int[3][5];
        SOP_ZY_MULTIPLIER = -5251;
        PROJECTION_W1 = 228096;
        PROJECTION_W2 = 329472;
        PROJECTION_H1 = 99840;
        PROJECTION_H2 = 41216;
        PROJECTION_BX = 152;
        PROJECTION_BY = 16;
        IPROJECTION_YXSCALE = 129;
        IPROJECTION_YSCALE = 286208;
        IPROJECTION_IYSCALE = (PROJECTION_H1 << 8) / 24622;
        m_ballLastAnimFrame = 0;
        m_goalPartPositions = new int[][]{{10948, 0}, {13674, 0}, {10948, 32015}, {13674, 32015}};
    }
}

