/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDDebug;
import com.distinctive.DDFile;
import com.distinctive.DDMath;
import com.distinctive.GameLogic;
import com.distinctive.GameRender;
import com.distinctive.MainFrame;
import com.distinctive.Match;
import com.distinctive.XMLMenuSystem;

public class Highlights {
    public static final boolean HIGHLIGHT_DEBUG = false;
    public static final int HSTATE_NONE = 0;
    public static final int HSTATE_PLAYING = 1;
    public static final int HSTATE_FINISHED = 2;
    private static final int HIGHLIGHT_END_DELAY = 3;
    public static int m_numHighlights;
    public static int[][][] m_playerStorage;
    public static int[] m_ballStorage;
    private static byte[] m_highlightData;
    private static int m_highlightIndex;
    public static int m_highlightState;
    private static int m_highlightDataLength;
    private static byte[][] m_highlightFiles;
    private static int[] m_highlightLengths;
    public static int m_highlight;
    private static int m_frame;
    private static final boolean DEBUG_VERBOSE = false;
    public static int FRAME_MARKER;
    public static int PLAYER_DATA_MARKER;
    public static int unsquashPosition1;
    public static int unsquashPosition2;
    public static int unsquashPosition3;
    public static int m_scoringTeam;
    public static boolean m_hflip;
    public static boolean m_vflip;
    private static final byte HL_OUTCOME_GOAL = 1;
    private static final byte HL_OUTCOME_GOAL_KICK = 2;
    private static final byte HL_OUTCOME_GK_HANDS = 4;
    private static final byte HL_OUTCOME_INTERCEPTED = 8;
    private static final byte HL_OUTCOME_CORNER = 16;
    public static final byte HL_SITUATION_OPEN_PLAY = 0;
    public static final byte HL_SITUATION_CORNER = 3;
    public static final byte HL_SITUATION_PENALTY = 5;
    public static final byte HL_SITUATION_FREE_KICK = 4;
    public static final byte HL_SITUATION_THROW = 1;
    public static final byte HL_SITUATION_KICK_OFF = 7;
    private static final byte HL_FLAG_LEFT = 1;
    private static final byte HL_FLAG_PASSED = 2;
    private static final byte HL_POS_CORNER = 6;
    private static final byte HL_POS_PENALTY = 7;
    private static final byte HL_POS_WIDE = 16;
    private static final byte HL_POS_DEPTH = 15;
    private static final int HLINFO_OUTCOME = 0;
    private static final int HLINFO_FLAGS = 1;
    private static final int HLINFO_POS = 2;
    private static final int HLINFO_SITUATION = 3;
    private static final int HLINFO_DATA_SIZE = 4;
    private static byte[] m_highlightInfo;
    private static int[] m_posToWidth;
    private static int[] m_posToDepth;
    private static int[] m_posToSide;

    public static void init() {
        m_playerStorage = new int[2][11][10];
        m_ballStorage = new int[6];
        m_highlightIndex = 0;
        m_highlightDataLength = 0;
        m_highlight = 0;
        m_numHighlights = 0;
        m_frame = 0;
    }

    public static void load(int n) {
        try {
            switch (n) {
                case 0: {
                    m_highlightInfo = DDFile.loadFileBytes("/hlinfo.bin");
                    if (m_highlightInfo == null) break;
                    m_numHighlights = m_highlightInfo.length / 4;
                    m_highlightFiles = new byte[m_numHighlights][];
                    m_highlightLengths = new int[m_numHighlights];
                    for (int i = 0; i < m_numHighlights; ++i) {
                        Highlights.m_highlightFiles[i] = DDFile.loadFileBytes("/hl" + i + ".bin");
                        Highlights.m_highlightLengths[i] = m_highlightFiles[i].length;
                    }
                    break;
                }
                case 1: {
                    byte[] byArray = DDFile.loadFileBytes("/hllook.bin");
                    if (byArray == null) break;
                    int n2 = 0;
                    m_posToWidth = new int[54];
                    m_posToDepth = new int[54];
                    m_posToSide = new int[54];
                    for (int i = 0; i < 54; ++i) {
                        Highlights.m_posToWidth[i] = byArray[n2++] & 0xFF;
                        Highlights.m_posToDepth[i] = byArray[n2++] & 0xFF;
                        Highlights.m_posToSide[i] = byArray[n2++] & 0xFF;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            MainFrame.m_loadError = 1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MainFrame.m_loadError = 1;
        }
        catch (Error error) {
            MainFrame.m_loadError = 1;
        }
    }

    public static void unload() {
        m_posToSide = null;
        m_posToDepth = null;
        m_posToWidth = null;
        m_highlightData = null;
        if (m_highlightFiles != null) {
            for (int i = 0; i < m_numHighlights; ++i) {
                Highlights.m_highlightFiles[i] = null;
            }
        }
        m_highlightFiles = null;
        m_highlightLengths = null;
        m_highlightInfo = null;
    }

    public static void update() {
        switch (m_highlightState) {
            case 0: {
                break;
            }
            case 1: {
                if (!Highlights.copyNextFrame()) {
                    Highlights.setHighlightState(2);
                    break;
                }
                GameRender.updateCamera();
                GameRender.sortFrame();
                break;
            }
            case 2: {
                if (++m_frame <= 3) break;
                GameLogic.m_gameState = 1;
                XMLMenuSystem.setMenu(29, false);
                Highlights.setHighlightState(0);
                Match.matchUpdate();
            }
        }
    }

    private static void setHighlightState(int n) {
        m_highlightState = n;
        DDDebug.msg("Set highlight state to " + n);
        m_frame = 0;
    }

    public static void playHighlight(int n) {
        DDDebug.msg("Play highlight " + n);
        if (m_numHighlights > 0) {
            m_highlightData = m_highlightFiles[n % m_numHighlights];
            m_highlightDataLength = m_highlightLengths[n % m_numHighlights];
            m_highlightIndex = 1;
            Highlights.setHighlightState(1);
        }
    }

    public static void stopHighlight() {
        Highlights.setHighlightState(0);
    }

    private static boolean copyNextFrame() {
        Highlights.playbackFindNextMarker();
        int n = Highlights.getInt();
        if (n == FRAME_MARKER) {
            int[] nArray;
            int n2;
            m_highlightIndex += 4;
            short s = Highlights.getShort();
            m_highlightIndex += 2;
            short s2 = Highlights.getShort();
            m_highlightIndex += 2;
            GameRender.getPixelPosition(s, s2, 0);
            GameRender.m_camera[0] = GameRender.m_screenPos[0];
            GameRender.m_camera[1] = GameRender.m_screenPos[1];
            Highlights.unsquashPosition(Highlights.getInt());
            m_highlightIndex += 4;
            Highlights.m_ballStorage[0] = unsquashPosition1;
            Highlights.m_ballStorage[1] = unsquashPosition2;
            Highlights.m_ballStorage[2] = unsquashPosition3;
            Highlights.m_ballStorage[4] = Highlights.getByte() & 0xFF;
            ++m_highlightIndex;
            for (n2 = 0; n2 < 2; ++n2) {
                for (int i = 0; i < 11; ++i) {
                    nArray = m_playerStorage[n2][i];
                    nArray[0] = -1426063361;
                    nArray[1] = -1426063361;
                }
            }
            while ((Highlights.getByte() & PLAYER_DATA_MARKER) == PLAYER_DATA_MARKER) {
                n2 = Highlights.getByte();
                ++m_highlightIndex;
                nArray = m_playerStorage[n2 & 1][n2 >> 1 & 0xF];
                Highlights.unsquashPosition(Highlights.getInt());
                m_highlightIndex += 4;
                nArray[0] = unsquashPosition1;
                nArray[1] = unsquashPosition2;
                nArray[2] = unsquashPosition3;
                n = Highlights.getShort();
                m_highlightIndex += 2;
                nArray[4] = n >> 9 & 0x7F;
                nArray[6] = n >> 3 & 0x3F;
                nArray[8] = nArray[7] = (n >> 0 & 7) << 5;
                if (nArray[6] != 63) continue;
                nArray[6] = -1;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void unsquashPosition(int n) {
        unsquashPosition1 = (n >> 20 & 0xFFF) << 4;
        unsquashPosition2 = (n >> 8 & 0xFFF) << 4;
        unsquashPosition3 = (n >> 0 & 0xFF) << 3;
    }

    public static void playbackFindNextMarker() {
        boolean bl = true;
        while (m_highlightIndex < m_highlightDataLength - 4 && Highlights.getInt() != FRAME_MARKER) {
            ++m_highlightIndex;
            bl = false;
        }
        bl = true;
    }

    public static int getInt() {
        if (m_highlightIndex + 4 < m_highlightDataLength) {
            return (m_highlightData[m_highlightIndex + 0] & 0xFF) << 24 | (m_highlightData[m_highlightIndex + 1] & 0xFF) << 16 | (m_highlightData[m_highlightIndex + 2] & 0xFF) << 8 | (m_highlightData[m_highlightIndex + 3] & 0xFF) << 0;
        }
        return 0;
    }

    public static short getShort() {
        if (m_highlightIndex + 2 < m_highlightDataLength) {
            return (short)((m_highlightData[m_highlightIndex + 0] & 0xFF) << 8 | (m_highlightData[m_highlightIndex + 1] & 0xFF) << 0);
        }
        return 0;
    }

    public static byte getByte() {
        if (m_highlightIndex + 1 < m_highlightDataLength) {
            return (byte)(m_highlightData[m_highlightIndex + 0] & 0xFF);
        }
        return 0;
    }

    public static void setOptions(int n, int n2, int n3) {
        m_scoringTeam = n;
        if (n == 1) {
            m_hflip = true;
            m_vflip = true;
        } else {
            m_hflip = false;
            m_vflip = false;
        }
        if (n2 != 1 - n) {
            m_hflip = !m_hflip;
            boolean bl = m_vflip = !m_vflip;
        }
        if (n3 != 0) {
            m_vflip = !m_vflip;
        }
    }

    public static boolean enabled() {
        return XMLMenuSystem.m_globalArray[26] == 0;
    }

    public static int selectHighlight(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int[] nArray = new int[m_numHighlights];
        int[] nArray2 = new int[m_numHighlights];
        int n11 = m_numHighlights;
        int n12 = 0;
        for (n10 = 0; n10 < m_numHighlights; ++n10) {
            nArray[n10] = n10;
        }
        n10 = 0;
        n10 = (n & 0x2000000) != 0 ? 1 : ((n & 0x4000000) != 0 ? 16 : ((n & 0x8000000) != 0 ? 4 : 2));
        for (n9 = 0; n9 < n11; ++n9) {
            if (m_highlightInfo[nArray[n9] * 4 + 0] != n10) continue;
            nArray2[n12] = nArray[n9];
            ++n12;
        }
        nArray = null;
        if (n12 == 0) {
            nArray2 = null;
            return 0;
        }
        nArray = nArray2;
        n11 = n12;
        nArray2 = new int[n12];
        n12 = 0;
        n9 = (byte)n5;
        if (n9 != 3 && n9 != 5) {
            n9 = 0;
        }
        for (n8 = 0; n8 < n11; ++n8) {
            if (m_highlightInfo[nArray[n8] * 4 + 3] != n9) continue;
            nArray2[n12] = nArray[n8];
            ++n12;
        }
        nArray = null;
        if (n12 == 0) {
            nArray2 = null;
            return 0;
        }
        nArray = nArray2;
        n11 = n12;
        nArray2 = new int[n12];
        n12 = 0;
        n8 = n3 != n4 ? 1 : 0;
        for (n7 = 0; n7 < n11; ++n7) {
            if (((m_highlightInfo[nArray[n7] * 4 + 1] & 2) != 0 ? 1 : 0) != n8) continue;
            nArray2[n12] = nArray[n7];
            ++n12;
        }
        nArray = null;
        if (n12 == 0) {
            nArray2 = null;
            return 0;
        }
        nArray = nArray2;
        n11 = n12;
        nArray2 = new int[n12];
        n12 = 0;
        n7 = m_posToWidth[n2];
        int n13 = m_posToDepth[n2];
        if (n9 == 3) {
            n13 = 6;
        } else if (n9 == 5) {
            n13 = 7;
        }
        for (n6 = 0; n6 < n11; ++n6) {
            int n14;
            if ((m_highlightInfo[nArray[n6] * 4 + 2] & 0xF) == n13) {
                nArray2[n12] = nArray[n6];
                ++n12;
                continue;
            }
            if ((m_highlightInfo[nArray[n6] * 4 + 2] & 0x10) != n7 || (n14 = (m_highlightInfo[nArray[n6] * 4 + 2] & 0xF) + 1 - n13) < 0 || n14 > 2) continue;
            nArray2[n12] = nArray[n6];
            ++n12;
        }
        nArray = null;
        if (n12 == 0) {
            nArray2 = null;
            return 0;
        }
        n6 = 0;
        n6 = n12 > 1 ? nArray2[(DDMath.getRandom() & 0xFFFF) % n12] : nArray2[0];
        nArray2 = null;
        if (m_posToSide[n2] != (m_highlightInfo[(++n6 - 1) * 4 + 1] & 1)) {
            n6 = -n6;
        }
        return n6;
    }

    static {
        FRAME_MARKER = -1426063361;
        PLAYER_DATA_MARKER = 224;
        unsquashPosition1 = 0;
        unsquashPosition2 = 0;
        unsquashPosition3 = 0;
        m_scoringTeam = 0;
        m_hflip = false;
        m_vflip = false;
    }
}

