/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextBox {
    private String text;
    private int textLength;
    int width;
    int height;
    private Font font = Font.getFont((int)64, (int)0, (int)0);
    private int maxLineNum;
    private int lineSize;
    private int totalPage;
    private int[] lineNum;
    private int[] linePos;
    private int currentLen;
    private int wordNumber;
    private int letterLength;
    private int currentIndex;
    private int currentLine;
    private int totalLine;
    private int lineIndex;
    private int pageIndex;

    public TextBox() {
        this.setBoxSize(176, 220);
    }

    public void Close() {
        this.text = null;
        this.lineNum = null;
        this.linePos = null;
    }

    private void resetBox() {
        if (this.width < 24 || this.height < 22) {
            System.out.println("TextBox create failed: size too small.");
            return;
        }
        this.lineSize = this.width - 4;
        this.maxLineNum = (this.height - 2) / (this.font.getHeight() + 2);
        if (this.text != null) {
            this.setString(this.text);
        }
    }

    private void newLine(int n) {
        ++this.currentLine;
        this.currentLen = 0;
        this.linePos[++this.lineIndex] = this.currentIndex - (n << 1);
        this.linePos[++this.lineIndex] = this.currentIndex + 1;
        if (this.currentLine == this.maxLineNum) {
            ++this.totalPage;
            this.totalLine += this.currentLine;
            this.lineNum[++this.pageIndex] = this.totalLine;
            this.currentLine = 0;
        }
    }

    public void setString(String string) {
        this.text = string;
        this.textLength = string.length();
        if (this.textLength == 0) {
            return;
        }
        this.lineNum = new int[this.textLength + 1];
        this.linePos = new int[this.textLength << 1];
        this.currentIndex = 0;
        this.wordNumber = 0;
        this.letterLength = 0;
        this.currentLen = 0;
        this.currentLine = 0;
        this.totalLine = 0;
        this.pageIndex = 0;
        this.lineIndex = 0;
        this.lineNum[this.pageIndex] = 0;
        this.linePos[this.lineIndex] = 0;
        this.totalPage = 0;
        while (this.currentIndex < this.textLength) {
            String string2 = string.substring(this.currentIndex, this.currentIndex + 1);
            if (string2.compareTo("A") >= 0 && string2.compareTo("z") <= 0) {
                this.wordNumber = 1;
                while (this.currentIndex + this.wordNumber < this.textLength && string.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).compareTo("A") >= 0 && string.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).compareTo("z") <= 0) {
                    ++this.wordNumber;
                }
                this.letterLength = this.font.substringWidth(string, this.currentIndex, this.wordNumber);
                if (this.letterLength > this.lineSize) {
                    for (int i = 0; i < this.wordNumber; ++i) {
                        string2 = string.substring(this.currentIndex, this.currentIndex + 1);
                        this.letterLength = this.font.stringWidth(string2);
                        if (this.currentLen + this.letterLength > this.lineSize) {
                            this.newLine(0);
                        } else {
                            this.currentLen += this.letterLength;
                        }
                        ++this.currentIndex;
                    }
                    continue;
                }
                if (this.currentLen + this.letterLength > this.lineSize) {
                    --this.currentIndex;
                    this.newLine(0);
                    this.currentIndex += this.wordNumber;
                    this.currentLen = this.letterLength;
                    continue;
                }
                this.currentIndex += this.wordNumber;
                this.currentLen += this.letterLength;
                continue;
            }
            if (string2.equals("/")) {
                ++this.currentIndex;
                if (this.currentIndex >= this.textLength) continue;
                string2 = string.substring(this.currentIndex, this.currentIndex + 1);
                if (string2.equals("n")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    this.newLine(1);
                } else if (string2.equals("p")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    ++this.currentLine;
                    this.currentLen = 0;
                    this.linePos[++this.lineIndex] = this.currentIndex - 2;
                    this.linePos[++this.lineIndex] = this.currentIndex + 1;
                    ++this.totalPage;
                    this.totalLine += this.currentLine;
                    this.lineNum[++this.pageIndex] = this.totalLine;
                    this.currentLine = 0;
                } else {
                    --this.currentIndex;
                    this.currentLen += this.font.stringWidth("/");
                    if (this.currentLen >= this.lineSize) {
                        if (this.currentLen > this.lineSize) {
                            --this.currentIndex;
                        }
                        this.newLine(0);
                    }
                }
                ++this.currentIndex;
                continue;
            }
            this.currentLen += this.font.stringWidth(string2);
            if (this.currentLen >= this.lineSize) {
                if (this.currentLen > this.lineSize) {
                    --this.currentIndex;
                }
                this.newLine(0);
            }
            ++this.currentIndex;
        }
        if (this.currentLine != 0 || this.currentLen != 0) {
            ++this.totalPage;
            this.totalLine += this.currentLine + 1;
            this.linePos[++this.lineIndex] = this.currentIndex - 1;
            this.lineNum[++this.pageIndex] = this.totalLine;
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetBox();
    }

    public void setBoxSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.resetBox();
    }

    public int page() {
        return Math.max(1, this.totalPage);
    }

    public int getYeH(int n) {
        return (this.font.getHeight() + 2) * (this.lineNum[n + 1] - this.lineNum[n]);
    }

    public int bian(int n) {
        switch (n) {
            case 0: 
            case 2: {
                return this.height % (this.font.getHeight() + 2);
            }
        }
        return 0;
    }

    public void paintText(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2) {
        int n10;
        if (this.text == null) {
            return;
        }
        if (this.textLength == 0) {
            return;
        }
        if (n5 >= this.totalPage) {
            System.out.println("TextBox page over flow:" + (n5 + 1) + "/" + this.totalPage);
            return;
        }
        graphics.setColor(n3);
        graphics.setFont(this.font);
        if (bl) {
            graphics.setClip(n, n2, this.width, this.height);
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        for (n10 = 0; n10 < this.lineNum[n5 + 1] - this.lineNum[n5]; ++n10) {
            if (n6 > -1 && n6 < this.totalPage) {
                if (n7 <= n8) {
                    switch (n9) {
                        case 0: {
                            if (bl2) {
                                n12 = -(this.height * n7 / n8);
                                n14 = this.height + n12;
                                break;
                            }
                            n12 = -((this.height - this.bian(n9)) * n7 / n8);
                            n14 = this.height + n12 - this.bian(n9);
                            break;
                        }
                        case 1: {
                            n11 = this.width * n7 / n8;
                            n13 = -this.width + n11;
                            break;
                        }
                        case 2: {
                            if (bl2) {
                                n12 = this.height * n7 / n8;
                                n14 = -this.height + n12;
                                break;
                            }
                            n12 = (this.height - this.bian(n9)) * n7 / n8;
                            n14 = -this.height + n12 + this.bian(n9);
                            break;
                        }
                        case 3: {
                            n11 = -(this.width * n7 / n8);
                            n13 = this.width + n11;
                            break;
                        }
                        default: {
                            System.out.println("TextBox direct error:" + n9);
                            return;
                        }
                    }
                    if (n4 < 0) {
                        if (bl2) {
                            graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1) + n11, n2 + (this.height - (this.lineNum[n5 + 1] - this.lineNum[n5]) * (this.font.getHeight() + 2) >> 1) + n10 * (this.font.getHeight() + 2) + n12, 17);
                            continue;
                        }
                        graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1) + n11, n2 + n10 * (this.font.getHeight() + 2) + n12, 17);
                        continue;
                    }
                    if (bl2) {
                        TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1) + n11, n2 + (this.height - (this.lineNum[n5 + 1] - this.lineNum[n5]) * (this.font.getHeight() + 2) >> 1) + n10 * (this.font.getHeight() + 2) + n12, 17, n3, n4);
                        continue;
                    }
                    TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1) + n11, n2 + n10 * (this.font.getHeight() + 2) + n12, 17, n3, n4);
                    continue;
                }
                System.out.println("TextBox index error:" + n7 + "/" + n8);
                return;
            }
            if (n4 < 0) {
                if (bl2) {
                    graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1), n2 + (this.height - (this.lineNum[n5 + 1] - this.lineNum[n5]) * (this.font.getHeight() + 2) >> 1) + n10 * (this.font.getHeight() + 2), 17);
                    continue;
                }
                graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1), n2 + n10 * (this.font.getHeight() + 2), 17);
                continue;
            }
            if (bl2) {
                TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1), n2 + (this.height - (this.lineNum[n5 + 1] - this.lineNum[n5]) * (this.font.getHeight() + 2) >> 1) + n10 * (this.font.getHeight() + 2), 17, n3, n4);
                continue;
            }
            TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n5] << 1], this.linePos[(n10 + this.lineNum[n5] << 1) + 1] + 1), n + (this.width >> 1), n2 + n10 * (this.font.getHeight() + 2), 17, n3, n4);
        }
        if (n6 > -1 && n6 < this.totalPage && n7 <= n8) {
            for (n10 = 0; n10 < this.lineNum[n6 + 1] - this.lineNum[n6]; ++n10) {
                if (n4 < 0) {
                    if (bl2) {
                        graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n6] << 1], this.linePos[(n10 + this.lineNum[n6] << 1) + 1] + 1), n + (this.width >> 1) + n13, n2 + (this.height - (this.lineNum[n6 + 1] - this.lineNum[n6]) * (this.font.getHeight() + 2) >> 1) + n10 * (this.font.getHeight() + 2) + n14, 17);
                        continue;
                    }
                    graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n6] << 1], this.linePos[(n10 + this.lineNum[n6] << 1) + 1] + 1), n + (this.width >> 1) + n13, n2 + n10 * (this.font.getHeight() + 2) + n14, 17);
                    continue;
                }
                if (bl2) {
                    TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n6] << 1], this.linePos[(n10 + this.lineNum[n6] << 1) + 1] + 1), n + (this.width >> 1) + n13, n2 + (this.height - (this.lineNum[n6 + 1] - this.lineNum[n6]) * (this.font.getHeight() + 2) >> 1) + n10 * (this.font.getHeight() + 2) + n14, 17, n3, n4);
                    continue;
                }
                TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n6] << 1], this.linePos[(n10 + this.lineNum[n6] << 1) + 1] + 1), n + (this.width >> 1) + n13, n2 + n10 * (this.font.getHeight() + 2) + n14, 17, n3, n4);
            }
        }
        if (n7 == 0 && !bl2 && n9 == 2 && n5 + 1 > -1 && n5 + 1 < this.totalPage) {
            for (n10 = 0; n10 < this.lineNum[n5 + 2] - this.lineNum[n5 + 1]; ++n10) {
                if (n4 < 0) {
                    graphics.drawString(this.text.substring(this.linePos[n10 + this.lineNum[n5 + 1] << 1], this.linePos[(n10 + this.lineNum[n5 + 1] << 1) + 1] + 1), n + (this.width >> 1), n2 + n10 * (this.font.getHeight() + 2) + this.height + n12 - this.bian(n9), 17);
                    continue;
                }
                TextBox.drawString(graphics, this.text.substring(this.linePos[n10 + this.lineNum[n5 + 1] << 1], this.linePos[(n10 + this.lineNum[n5 + 1] << 1) + 1] + 1), n + (this.width >> 1), n2 + n10 * (this.font.getHeight() + 2) + this.height + n12 - this.bian(n9), 17, n3, n4);
            }
        }
        graphics.setClip(0, 0, 176, 220);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n5);
        graphics.drawString(string, n - 1, n2, n3);
        graphics.drawString(string, n + 1, n2, n3);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n4);
        graphics.drawString(string, n, n2, n3);
    }
}

