/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FrameWork
extends Canvas
implements Runnable {
    private Main main;
    Record record;
    Display display;
    SpriteLibrary spriteLib;
    public Font font = Font.getFont((int)32, (int)0, (int)8);
    public Effect[] effect;
    public static Random rnd;
    public boolean bRunning;
    public boolean bPause;
    public static int iClock;
    public static int iShowTime;
    private Image imgLogo;
    public static int frameStateNew;
    public static int frameStateOld;
    public static int frameState;
    private int state;
    public static Resource pic;
    public static Game game;
    public TextBox textBox;
    public static Sound sound1;
    public boolean loadRecord;
    public Font smallFont;
    public int iLoadingSteps;
    public int iLoadingStep;
    public int iLoading;
    private int iKeyManageIndex;
    private int iKeyBufferIndex;
    private int[][] keyBuffer;
    public boolean bWarning;
    private int warningWidthLeft;
    private int warningWidthRight;
    private int warningHeight;
    public boolean bSound;
    public byte bySoundState;
    public byte bySoundLevel;
    public static boolean bGameRunning;
    private static long lThreadTime1;
    private int menuLength;
    public byte bySelectMenu;
    private int focus;
    private String[] menu;
    private boolean menuIN;
    private boolean menuOUT;
    private int gridW;
    private int gridH;
    public boolean command_menu;
    public boolean command_left;
    public boolean command_right;
    public int soundH;
    public boolean levelIn;
    public byte[] levelState = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public int currentLevel;
    public byte[] unfinishGate = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public byte[] finishGate = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private byte[] currentGate;
    public int progress;
    int iPage;
    public int nextiPage = -1;
    public int iPageindex = 0;
    public int iPageindex2 = 0;
    public int iPagedirect = 0;
    public long threadTime;
    public Image[] backImg;
    public Image[][] tangramImage;
    public Image[] fuhaoImg;
    public Image[] gameUI;
    public Image[] soundImg;
    public Image[] levelImg;
    public Image szImg;
    public Image numImg;
    public Image[] charImg;
    public Image handImg;
    public Image[] menuImg;
    public Image[] scoreImg;
    private Image wenzi;
    public Image[] dialogImg;
    private int wenziW;
    private String name;
    private char[] nameArray;
    private boolean writeName;
    private String[] recordName = new String[]{"admin", "admin", "admin", "admin", "admin"};
    public int[] recordScore = new int[]{5000, 4000, 3000, 2000, 1000};
    public static int[] colorArray;
    public byte selectMenu;
    private int Index;
    private boolean hideNotify = false;
    private int compet;

    public FrameWork(Main main, Display display) {
        this.display = display;
        this.main = main;
        frameState = -1;
        frameStateNew = -2;
        frameStateOld = -1;
        this.iKeyBufferIndex = 0;
        this.keyBuffer = new int[5][2];
        this.smallFont = Font.getFont((int)64, (int)0, (int)8);
        bGameRunning = false;
        pic = new Resource();
        this.textBox = new TextBox();
        rnd = new Random();
        this.record = new Record();
        this.bySelectMenu = 1;
        this.setFullScreenMode(true);
        this.bySoundState = 0;
        this.Start();
    }

    public void Release() {
        if (!bGameRunning && game != null) {
            game.Close();
            game = null;
        }
    }

    public void Start() {
        this.bRunning = true;
        this.bPause = false;
    }

    public void Stop() {
        this.bRunning = false;
    }

    protected void hideNotify() {
        this.bPause = true;
        if (frameState != -3 && frameState != 11 && frameState != 52 && frameState != -7) {
            this.state = 52;
        }
        if (frameState == 11) {
            this.hideNotify = true;
        }
        if (this.bSound && sound1 != null) {
            sound1.soundPause();
            this.bySoundState = (byte)2;
        }
    }

    protected void showNotify() {
        this.bPause = false;
    }

    public void run() {
        while (this.bRunning) {
            if (this.bPause) continue;
            lThreadTime1 = System.currentTimeMillis();
            this.KeyManage();
            this.Close();
            try {
                this.Init();
            }
            catch (Exception exception) {
                System.out.println("Init err ..." + frameStateNew);
            }
            this.Running();
            this.repaint();
            try {
                this.serviceRepaints();
            }
            catch (Exception exception) {
                System.out.println("serviceRepaints err ...");
            }
            while (System.currentTimeMillis() - lThreadTime1 < 80L) {
                Thread.yield();
            }
        }
    }

    public void Init() {
        if (frameStateNew == frameState) {
            return;
        }
        iClock = 0;
        this.bySelectMenu = 1;
        this.deleteCommand();
        switch (frameStateNew) {
            case -2: {
                this.InitLegal();
                break;
            }
            case -3: {
                this.InitLoading();
                break;
            }
            case -5: {
                this.InitGame();
                break;
            }
            case 9: {
                this.InitSoundPrepare();
                break;
            }
            case 8: {
                this.InitMenuPrepare();
                break;
            }
            case 7: {
                this.InitScoreBoard();
                break;
            }
            case 10: {
                this.InitInputName();
                break;
            }
            case 6: {
                this.InitLevel();
                break;
            }
            case -4: {
                this.InitMenu();
                break;
            }
            case 5: {
                this.InitSelectMode();
                break;
            }
            case 11: {
                this.InitGameLoading();
                break;
            }
            case 2: {
                this.InitConfiguration();
                break;
            }
            case 4: {
                this.InitHelp();
                break;
            }
            case 3: {
                this.InitAbout();
                break;
            }
            case -6: {
                this.InitWarning();
                break;
            }
            case -7: {
                this.InitQuit();
            }
        }
        frameStateOld = frameState;
        frameState = frameStateNew;
    }

    public void Running() {
        iClock = iClock < 2520 ? ++iClock : 0;
        if (this.state == 52) {
            return;
        }
        switch (frameState) {
            case -2: {
                this.RunningLegal();
                break;
            }
            case -3: {
                this.RunningLoading();
                break;
            }
            case -4: 
            case 5: {
                this.RunningMenu();
                break;
            }
            case 11: {
                this.RunningGameLoading();
                break;
            }
            case -5: {
                this.RunningGame();
                break;
            }
            case 2: {
                this.RunningInfoOut(80);
                break;
            }
            case 3: 
            case 4: {
                this.RunningInfoOut(112);
                break;
            }
            case -6: {
                this.RunningWarning();
                break;
            }
            case -7: {
                this.RunningQuit();
            }
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setClip(0, 0, 176, 220);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        if (this.state == 52) {
            this.PaintPause(graphics);
            return;
        }
        try {
            switch (frameState) {
                case -2: {
                    this.PaintLegal(graphics);
                    break;
                }
                case -3: {
                    this.PaintLoading(graphics);
                    break;
                }
                case -4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, 176, 220);
                    if (this.imgLogo == null) {
                        return;
                    }
                    graphics.drawImage(this.imgLogo, 176 - this.imgLogo.getWidth() >> 1, 220 - this.imgLogo.getHeight() >> 1, 20);
                    if (frameState == 8) {
                        this.PaintMenuPrepare(graphics);
                        break;
                    }
                    if (frameState == 9) {
                        this.PaintSoundPrepare(graphics);
                        break;
                    }
                    if (frameState == 6) {
                        if (this.levelIn) {
                            this.PaintSelectGate(graphics);
                            break;
                        }
                        this.PaintSelectLevel(graphics);
                        break;
                    }
                    this.PaintMenu(graphics);
                    break;
                }
                case 11: {
                    this.PaintGameLoading(graphics);
                    break;
                }
                case -5: {
                    this.PaintGame(graphics);
                    break;
                }
                case 10: {
                    this.PaintInputName(graphics);
                    break;
                }
                case 7: {
                    this.PaintScoreBoard(graphics);
                    break;
                }
                case 2: {
                    this.PaintConfiguration(graphics);
                    break;
                }
                case 3: 
                case 4: {
                    this.PaintIntroduction(graphics);
                    break;
                }
                case -6: {
                    this.PaintWarning(graphics);
                    break;
                }
                case -7: {
                    this.PaintQuit(graphics);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("paint mode err:" + frameState);
        }
        this.paintCommand(graphics);
        this.threadTime = System.currentTimeMillis();
    }

    public void addCommand(int n) {
        if (n == 1) {
            this.command_left = true;
        } else if (n == 2) {
            this.command_right = true;
        } else {
            this.command_menu = true;
        }
    }

    public void deleteCommand() {
        this.command_left = false;
        this.command_right = false;
        this.command_menu = false;
    }

    public void paintCommand(Graphics graphics) {
        if (this.state == 52) {
            return;
        }
        graphics.setClip(0, 208, 176, 12);
        if (this.command_left) {
            graphics.drawImage(this.fuhaoImg[1], 7, 208, 20);
        }
        if (this.command_right) {
            graphics.drawImage(this.fuhaoImg[2], 158, 208, 20);
        }
        if (this.command_menu) {
            graphics.drawImage(this.fuhaoImg[0], 6, 210 - iClock % 2, 20);
        }
    }

    public void Close() {
        if (frameStateNew == frameState) {
            return;
        }
        switch (frameState) {
            case -3: 
            case 11: {
                this.CloseLoading();
                break;
            }
            case -5: {
                this.CloseGame();
                break;
            }
            case 2: {
                this.CloseConfiguration();
                break;
            }
            case 7: {
                this.CloseScoreBoard();
                break;
            }
            case 6: {
                this.CloseLevel();
                break;
            }
            case 10: {
                this.CloseInputName();
                break;
            }
            case -6: {
                this.CloseWarning();
                break;
            }
            case -7: {
                this.CloseQuit();
                break;
            }
        }
    }

    public void keyPressed(int n) {
        if (this.iKeyBufferIndex < 5) {
            this.keyBuffer[this.iKeyBufferIndex][0] = 1;
            this.keyBuffer[this.iKeyBufferIndex++][1] = Environment.getGameKey(n);
        }
    }

    public void keyReleased(int n) {
        if (this.iKeyBufferIndex < 5) {
            this.keyBuffer[this.iKeyBufferIndex][0] = 2;
            this.keyBuffer[this.iKeyBufferIndex++][1] = Environment.getGameKey(n);
        }
    }

    public void KeyManage() {
        this.iKeyManageIndex = 0;
        if (this.state == 52) {
            while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                    this.OnKeyPressedPause(this.keyBuffer[this.iKeyManageIndex++][1]);
                    continue;
                }
                ++this.iKeyManageIndex;
            }
        }
        switch (frameState) {
            case -2: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedLegal(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 8: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedMenuPrepare(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 9: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedSoundPrepare(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case -4: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedMenu(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 10: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedInputName(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 7: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedScoreBoard(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case -5: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedGame(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    this.OnKeyReleasedGame(this.keyBuffer[this.iKeyManageIndex++][1]);
                }
                break;
            }
            case 2: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedConfiguration(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 3: 
            case 4: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedAbout(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 5: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedSelectMode(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case 6: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedSelectLevel(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
            case -6: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedWarning(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    ++this.iKeyManageIndex;
                }
                break;
            }
        }
        this.iKeyBufferIndex = 0;
    }

    private void OnKeyPressedSoundPrepare(int n) {
        switch (n) {
            case 4: 
            case 14: {
                this.bySelectMenu = 1;
                break;
            }
            case 6: 
            case 16: {
                this.bySelectMenu = (byte)2;
                break;
            }
            case 5: 
            case 10: {
                if (this.bySelectMenu == 1) {
                    this.bSound = true;
                    sound1.soundLevel(this.bySoundLevel);
                } else {
                    this.bySoundLevel = 0;
                    this.bSound = false;
                    sound1.soundStop();
                }
                byte[] byArray = new byte[]{this.bySoundLevel};
                this.record.saveRecord("tangram", 1, byArray);
                frameStateNew = 8;
            }
        }
    }

    private void OnKeyPressedMenuPrepare(int n) {
        if (n != -100) {
            frameStateNew = -4;
        }
    }

    protected void OnKeyPressedAbout(int n) {
        switch (n) {
            case 2: 
            case 12: {
                if (this.iPagedirect == 2) {
                    if (this.iPage <= 0) break;
                    ++this.iPageindex;
                    if (this.iPageindex != this.iPageindex2) break;
                    this.iPage = this.nextiPage--;
                    this.iPageindex = 0;
                    break;
                }
                if (this.iPagedirect != 0) break;
                --this.iPageindex;
                if (this.iPageindex == 0) {
                    this.iPagedirect = 2;
                    this.iPageindex = 0;
                    this.nextiPage = (this.iPage + (this.textBox.page() - 1)) % this.textBox.page();
                    break;
                }
                if (this.iPageindex != -1) break;
                this.iPagedirect = 2;
                this.iPageindex = 1;
                this.nextiPage = (this.iPage + (this.textBox.page() - 1)) % this.textBox.page();
                break;
            }
            case 8: 
            case 18: {
                if (this.iPagedirect == 0) {
                    if (this.iPage == this.textBox.page() - 1) break;
                    ++this.iPageindex;
                    if (this.iPageindex != this.iPageindex2) break;
                    this.iPage = this.nextiPage;
                    this.iPageindex = 0;
                    this.nextiPage = (this.iPage + 1) % this.textBox.page();
                    if (this.nextiPage != 0) break;
                    this.nextiPage = -1;
                    break;
                }
                if (this.iPagedirect != 2 || this.textBox.page() <= 1) break;
                --this.iPageindex;
                if (this.iPageindex == 0) {
                    this.iPagedirect = 0;
                    this.iPageindex = 0;
                    this.nextiPage = (this.iPage + 1) % this.textBox.page();
                    if (this.nextiPage != 0) break;
                    this.nextiPage = -1;
                    break;
                }
                if (this.iPageindex != -1) break;
                this.iPagedirect = 0;
                this.iPageindex = 1;
                this.nextiPage = (this.iPage + 1) % this.textBox.page();
                if (this.nextiPage != 0) break;
                this.nextiPage = -1;
                break;
            }
            case 3: {
                frameStateNew = frameStateOld;
            }
        }
    }

    private void InitLegal() {
        iShowTime = 0;
    }

    private void RunningLegal() {
        if ((iShowTime & 0xF) == 0) {
            this.imgLogo = pic.getImage("Logo" + ((iShowTime >> 4) + 1));
            if (this.imgLogo == null) {
                frameStateNew = -3;
            }
        }
        ++iShowTime;
    }

    private void PaintLegal(Graphics graphics) {
        if (this.imgLogo == null) {
            return;
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 176, 220);
        graphics.drawImage(this.imgLogo, 176 - this.imgLogo.getWidth() >> 1, 220 - this.imgLogo.getHeight() >> 1, 20);
    }

    private void OnKeyPressedLegal(int n) {
        if (n != -1) {
            frameStateNew = -3;
        }
    }

    private void InitLoading() {
        this.iLoadingSteps = 11;
        this.iLoadingStep = 0;
        this.iLoading = 0;
    }

    public void LoadingRefresh() {
        ++this.iLoadingStep;
        this.iLoading = this.iLoadingStep * 148 / this.iLoadingSteps;
    }

    public void LoadResources() {
        this.LoadingRefresh();
        switch (this.iLoadingStep) {
            case 1: {
                game = new Game(this);
                this.spriteLib = new SpriteLibrary();
                byte[] byArray = this.record.loadRecord("tangram", 1);
                if (byArray == null) {
                    byArray = new byte[1];
                    this.bSound = true;
                    byArray[0] = this.bySoundLevel = (byte)3;
                    this.record.saveRecord("tangram", 1, byArray);
                    break;
                }
                this.bySoundLevel = byArray[0];
                if (this.bySoundLevel > 0) {
                    this.bSound = true;
                    break;
                }
                this.bSound = false;
                break;
            }
            case 2: {
                this.loadArrange();
                this.loadLevel();
                break;
            }
            case 3: {
                this.charImg = new Image[2];
                this.numImg = pic.getImage("number");
                this.charImg[0] = pic.getImage("charactor1");
                this.charImg[1] = pic.getImage("charactor2");
                break;
            }
            case 5: {
                this.spriteLib.reset(5, Constant.SPRITE_TYPE_KEY);
                break;
            }
            case 7: {
                this.effect = new Effect[5];
                for (int i = 0; i < 5; ++i) {
                    this.effect[i] = new Effect(this.spriteLib, game);
                }
                break;
            }
            case 8: {
                this.fuhaoImg = new Image[5];
                for (int i = 0; i < 5; ++i) {
                    this.fuhaoImg[i] = pic.getImage("fuhao" + i);
                }
                break;
            }
            case 9: {
                sound1 = new Sound(1, 3);
                System.out.println("=====sound load over!=====");
            }
        }
    }

    private void InitGameLoading() {
        this.CloseMenu();
        sound1.soundStop();
        this.soundH = 80;
        this.iPage = 0;
        this.iLoadingStep = 0;
        this.wenzi = pic.getImage("loading");
    }

    private void RunningGameLoading() {
        switch (this.iLoadingStep) {
            case 1: {
                this.backImg = new Image[9];
                for (int i = 0; i < 8; ++i) {
                    this.backImg[i] = pic.getImage("back" + (i + 1));
                }
                break;
            }
            case 2: {
                this.tangramImage = new Image[7][8];
                for (int i = 0; i < 8; ++i) {
                    this.tangramImage[0][i] = pic.getImage("4ban" + (i + 1));
                    this.tangramImage[1][i] = pic.getImage("5ban" + (i + 1));
                    this.tangramImage[3][i] = pic.getImage("3ban" + (i + 1));
                    this.tangramImage[5][i] = pic.getImage("1ban" + (i + 1));
                    this.tangramImage[6][i] = pic.getImage("2ban" + (i + 1));
                    if (i < 4) {
                        this.tangramImage[2][i] = pic.getImage("6ban" + (i + 1));
                    }
                    if (i >= 2) continue;
                    this.tangramImage[4][i] = pic.getImage("7ban" + (i + 1));
                }
                break;
            }
            case 3: {
                this.gameUI = new Image[8];
                for (int i = 0; i < 8; ++i) {
                    this.gameUI[i] = pic.getImage("ui" + i);
                }
                break;
            }
            case 4: {
                this.dialogImg = new Image[2];
                this.dialogImg[0] = pic.getImage("dialog1");
                this.dialogImg[1] = pic.getImage("dialog2");
                game.setBackMap(this.Index);
                break;
            }
            case 5: {
                this.bySoundState = 1;
                if (this.hideNotify) {
                    this.state = 52;
                    this.bySoundState = (byte)2;
                }
                frameStateNew = -5;
            }
        }
        ++this.iLoadingStep;
    }

    private void PaintGameLoading(Graphics graphics) {
        this.drawInfoBack(graphics, colorArray[3]);
        graphics.drawImage(this.wenzi, 35, 90, 20);
        for (int i = 0; i < 10; ++i) {
            graphics.setColor(0);
            graphics.drawRect(44 + i * 11 - 10, 109, 7, 7);
            graphics.setColor(0xFFFFFF);
            if (i / 2 < this.iLoadingStep) {
                graphics.setColor(colorArray[5]);
            }
            graphics.fillRect(44 + i * 11 - 9, 110, 6, 6);
        }
    }

    private void RunningLoading() {
        this.LoadResources();
        if (this.iLoadingStep > 10) {
            frameStateNew = 9;
        }
    }

    private void PaintLoading(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
        graphics.setFont(this.smallFont);
        graphics.setColor(0xBBBBBB);
        graphics.drawString("Loading", 88, 108, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(12, 112, 152, 12);
        for (int i = 0; i < this.iLoading; ++i) {
            int n = 64 + (Math.abs(32 - (i & 0x3F)) << 2);
            graphics.setColor(n, n, n);
            graphics.fillRect(14 + i, 114, 1, 9);
        }
    }

    private void InitSoundPrepare() {
        this.imgLogo = pic.getImage("prepare1");
        this.wenzi = pic.getImage("soundprepare");
    }

    private void CloseLoading() {
        this.wenzi = null;
    }

    private void InitMenuPrepare() {
        if (this.bySoundLevel > 0) {
            sound1.soundPlay(1, -1);
        }
        this.wenzi = pic.getImage("prepare2");
    }

    private void InitMenu() {
        bGameRunning = false;
        if (this.bySoundLevel > 0) {
            sound1.soundPlay(1, -1);
        }
        this.addCommand(1);
        this.gridW = 0;
        this.gridH = 0;
        this.menuOUT = true;
        this.levelIn = false;
        if (this.menuImg == null) {
            this.menuImg = new Image[6];
            for (int i = 0; i < 6; ++i) {
                this.menuImg[i] = pic.getImage("menu" + (i + 1));
            }
        }
        this.wenzi = this.menuImg[4];
        this.menu = Language.SYSTEM_MENU;
        this.wenziW = 65;
        this.loadRecord = false;
        this.imgLogo = pic.getImage("Title");
        this.menuLength = Language.SYSTEM_MENU.length;
    }

    private void RunningMenu() {
        this.menuIn();
        this.menuOut();
    }

    private void CloseMenu() {
        this.imgLogo = null;
        this.menuImg = null;
        this.wenzi = null;
        this.levelImg = null;
        System.gc();
    }

    private void PaintMenuPrepare(Graphics graphics) {
        this.drawCharactor(graphics, "press any key", 53, 188, iClock / 2 % 2);
        this.selectMenu = this.selectMenu != 2 ? (byte)(this.selectMenu + 1) : (byte)0;
    }

    private void PaintSoundPrepare(Graphics graphics) {
        graphics.drawImage(this.wenzi, 88, 100, 17);
        this.drawCharactor(graphics, "yes", 53, 120, this.bySelectMenu % 2);
        this.drawCharactor(graphics, "no", 117, 120, (this.bySelectMenu + 1) % 2);
    }

    private void menuIn() {
        if (this.menuIN) {
            if (this.gridW > 0) {
                this.gridW -= 10;
                int n = this.gridW = this.gridW <= 0 ? 0 : this.gridW;
            }
            if (this.gridH > 0) {
                this.gridH -= 2;
                this.gridH = this.gridH >= 0 ? this.gridH : 0;
            } else {
                this.menuIN = false;
                if (frameState == -4) {
                    frameStateNew = 5;
                } else if (frameState == 5) {
                    frameStateNew = -4;
                }
            }
        }
    }

    private void menuOut() {
        if (this.menuOUT) {
            if (this.gridW < 80) {
                this.gridW += 16;
                ++this.gridH;
            } else {
                this.gridW = 80;
                this.gridH = 9;
                this.menuOUT = false;
            }
        }
    }

    private void PaintMenu(Graphics graphics) {
        graphics.setFont(this.font);
        int n = 60;
        int n2 = 60;
        this.drawMenuLine(graphics);
        graphics.drawImage(this.menuImg[0], 1, 42, 20);
        graphics.drawImage(this.menuImg[1], 10, 42, 20);
        graphics.drawImage(this.menuImg[2], 20, 59 + (this.bySelectMenu - 1) * 15, 20);
        graphics.drawImage(this.menuImg[3], 160, 64 + (this.bySelectMenu - 1) * 15, 20);
        if (!bGameRunning) {
            for (int i = 0; i < this.menu.length; ++i) {
                if (i == this.bySelectMenu - 1 && !this.menuIN && !this.menuOUT) {
                    graphics.setClip(n - this.selectMenu - 1, n2 - this.selectMenu + i * 15, this.gridW + this.selectMenu * 2 + 3, this.gridH + this.selectMenu * 2 + 4);
                    this.drawPane(graphics, -this.selectMenu + n, -this.selectMenu + i * 15 + n2 + 2, this.gridW + this.selectMenu * 2, this.gridH + this.selectMenu * 2, colorArray[1], 0xFFFFFF);
                    graphics.drawRect(-this.selectMenu + n - 1, -this.selectMenu + i * 15 + n2, this.gridW + this.selectMenu * 2 + 2, this.gridH + this.selectMenu * 2 + 3);
                    graphics.setClip(40 + n - 1 - this.wenziW / 2, i * 15 + n2 + 4, this.wenziW - (80 - this.gridW), 5 - (9 - this.gridH));
                    graphics.drawImage(this.wenzi, 40 + n + this.wenziW / 2, i * 15 - i * 5 + n2 + 4, 17);
                    continue;
                }
                graphics.setClip(n - 1, i * 15 + n2, this.gridW + 3, this.gridH + 4);
                this.drawPane(graphics, n, i * 15 + n2 + 2, this.gridW, this.gridH, 0, colorArray[0]);
                graphics.drawRect(n - 1, i * 15 + n2, this.gridW + 2, this.gridH + 3);
                graphics.setClip(40 + n - this.wenziW / 2, i * 15 + n2 + 4, this.wenziW - (80 - this.gridW), 5 - (9 - this.gridH));
                graphics.drawImage(this.wenzi, 40 + n - this.wenziW / 2, i * 15 - i * 5 + n2 + 4, 17);
            }
        }
        this.selectMenu = this.menuIN || this.menuOUT ? (byte)0 : (this.selectMenu != 2 ? (byte)(this.selectMenu + 1) : (byte)0);
    }

    private void drawMenuLine(Graphics graphics) {
        graphics.setColor(0);
        graphics.drawLine(0, 50, 40, 50);
        graphics.drawLine(40, 50, 40, 65 + (this.menu.length - 1) * 15);
        for (int i = 0; i < this.menu.length; ++i) {
            this.drawMenuGrid(graphics, 39, 65 + i * 15);
            graphics.setColor(0);
            graphics.drawLine(42, 66 + i * 15, 52, 66 + i * 15);
        }
    }

    private void drawMenuGrid(Graphics graphics, int n, int n2) {
        graphics.setColor(0);
        graphics.drawRect(n, n2, 3, 3);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n + 1, n2 + 1, 1, 1);
    }

    private void OnKeyPressedMenu(int n) {
        block21: {
            if (this.menuIN || this.menuOUT) {
                return;
            }
            block0 : switch (n) {
                case 2: 
                case 12: {
                    this.selectMenu = 0;
                    if (this.bySelectMenu > 1) {
                        this.bySelectMenu = (byte)(this.bySelectMenu - 1);
                        break;
                    }
                    this.bySelectMenu = (byte)this.menuLength;
                    break;
                }
                case 8: 
                case 18: {
                    this.selectMenu = 0;
                    if (this.bySelectMenu < this.menuLength) {
                        this.bySelectMenu = (byte)(this.bySelectMenu + 1);
                        break;
                    }
                    this.bySelectMenu = 1;
                    break;
                }
                case 5: 
                case 10: 
                case 15: {
                    switch (this.bySelectMenu) {
                        case 1: {
                            this.menuIN = true;
                            break block0;
                        }
                        case 2: {
                            if (!bGameRunning && this.loadGame()) {
                                System.out.println("loadGame :" + FrameWork.game.level);
                                FrameWork.game.playMode = 2;
                                this.Index = Math.abs(rnd.nextInt()) % 20 + 1;
                                this.loadRecord = true;
                                frameStateNew = 11;
                                break block0;
                            }
                            break block21;
                        }
                        case 3: {
                            if (!bGameRunning) {
                                frameStateNew = 7;
                                break block0;
                            }
                            break block21;
                        }
                        case 4: {
                            if (bGameRunning) {
                                frameStateNew = 3;
                                break block0;
                            }
                            frameStateNew = 2;
                            break block0;
                        }
                        case 5: {
                            if (bGameRunning) {
                                frameStateNew = -6;
                                break block0;
                            }
                            frameStateNew = 4;
                            break block0;
                        }
                        case 6: {
                            frameStateNew = 3;
                            break block0;
                        }
                        case 7: {
                            frameStateNew = -7;
                        }
                    }
                }
            }
        }
    }

    public void InitConfiguration() {
        this.deleteCommand();
        this.addCommand(1);
        this.addCommand(2);
        this.soundImg = new Image[3];
        for (int i = 0; i < 3; ++i) {
            this.soundImg[i] = pic.getImage("sound" + i);
        }
        this.soundH = 0;
        this.menuIN = false;
        this.menuOUT = true;
        this.bySelectMenu = this.bySoundLevel;
    }

    private void CloseConfiguration() {
        this.soundImg = null;
    }

    private void RunningInfoOut(int n) {
        if (this.menuOUT) {
            if (this.soundH < n) {
                this.soundH += 16;
            } else {
                this.menuOUT = false;
            }
        }
    }

    public void drawInfoBack(Graphics graphics, int n) {
        graphics.setClip(0, 110 - this.soundH / 2, 176, this.soundH);
        graphics.setColor(colorArray[2]);
        graphics.fillRect(0, 110 - this.soundH / 2, 176, 2);
        graphics.fillRect(0, 110 + this.soundH / 2 - 2, 176, 2);
        graphics.setColor(0);
        graphics.drawLine(0, 110 - this.soundH / 2 + 2, 176, 110 - this.soundH / 2 + 2);
        graphics.drawLine(0, 110 + this.soundH / 2 - 3, 176, 110 + this.soundH / 2 - 3);
        graphics.setColor(n);
        graphics.fillRect(0, 110 - this.soundH / 2 + 3, 176, this.soundH - 6);
        graphics.setClip(0, 110 - this.soundH / 2 + 5, 176, this.soundH - 10);
    }

    public void PaintConfiguration(Graphics graphics) {
        this.drawBack(graphics);
        this.drawInfoBack(graphics, colorArray[3]);
        for (int i = 0; i < 5; ++i) {
            graphics.setColor(0);
            graphics.drawLine(55 + i * 15, 110 + this.soundH / 2 - 25 - i * 10, 55 + (i + 1) * 15, 110 + this.soundH / 2 - 25 - i * 10);
            if (i < 4) {
                graphics.drawLine(70 + i * 15, 110 + this.soundH / 2 - 35 - i * 10, 70 + i * 15, 110 + this.soundH / 2 - 25 - i * 10);
            }
            graphics.drawRect(57 + i * 15, 110 + this.soundH / 2 - 23 - i * 10, 10, 8 + i * 10);
            graphics.setColor(colorArray[4]);
            if (i >= this.bySelectMenu) continue;
            graphics.fillRect(58 + i * 15, 110 + this.soundH / 2 - 22 - i * 10, 9, 7 + i * 10);
        }
        graphics.drawImage(this.soundImg[0], 50, 110 - this.soundH / 2 + 10, 20);
        graphics.drawImage(this.soundImg[1], 40, 110 + this.soundH / 2 - 25, 20);
        graphics.drawImage(this.soundImg[2], 135, 110 - this.soundH / 2 + 15, 20);
    }

    protected void OnKeyPressedConfiguration(int n) {
        if (this.menuOUT) {
            return;
        }
        switch (n) {
            case 5: 
            case 10: 
            case 15: {
                this.bySoundLevel = this.bySelectMenu;
                if (this.bySoundLevel > 0) {
                    this.bSound = true;
                    sound1.soundLevel(this.bySoundLevel);
                    sound1.soundPlay(1, -1);
                } else {
                    this.bSound = false;
                    sound1.soundStop();
                }
                byte[] byArray = new byte[]{this.bySoundLevel};
                this.record.saveRecord("tangram", 1, byArray);
                frameStateNew = frameStateOld;
                break;
            }
            case 4: 
            case 14: {
                if (this.bySelectMenu <= 0) break;
                this.bySelectMenu = (byte)(this.bySelectMenu - 1);
                break;
            }
            case 6: 
            case 16: {
                if (this.bySelectMenu >= 5) break;
                this.bySelectMenu = (byte)(this.bySelectMenu + 1);
                break;
            }
            case 3: {
                frameStateNew = frameStateOld;
            }
        }
    }

    public void InitHelp() {
        this.addCommand(2);
        this.soundH = 0;
        this.menuOUT = true;
        this.iPage = 0;
        this.nextiPage = 6;
        this.iPageindex = 0;
        this.iPageindex2 = 5;
        this.iPagedirect = 2;
        this.textBox.setBoxSize(144, 87);
        this.textBox.setString("Game introduction:/n/nTangram is a jigsaw puzzle in ancient history of china./n Tangram contains square, parallelogram and triangle./nSmall amount but can be combined to be many kinds of graphs, such as 0 to 9 that 10 numbers or Chinese Phonetic Alphabet as well as Geometry shape, animal and construction./nSuch simple Tangram but can be combined to get thousands of graphs./n/n/nOperation Introduction:/nSelect Tangram/n Left/4, Right/6/nconfirm/5/nMovement Arrow key:/n2,4,6,8/nLeft circumrotate/1,/n Right circumrotate/3,/n Put down/5/nPrevious action/*,/n Restart/#/nEnter:Left soft key/nReturn:Right soft key");
        this.textBox.setFont(Font.getFont((int)64, (int)0, (int)8));
    }

    public void InitAbout() {
        this.addCommand(2);
        this.soundH = 0;
        this.menuOUT = true;
        this.iPage = 0;
        this.nextiPage = 6;
        this.iPageindex = 0;
        this.iPageindex2 = 5;
        this.iPagedirect = 2;
        this.textBox.setBoxSize(144, 80);
        this.textBox.setString("Tangram/nVersion 1.0/n/nCopyright:/nSOCO SOFTWARE/n/nInformation and Support:/nSOCO SOFTWARE/nwww.socogame.com/nsoco@socogame.com/n(c)  2007 SOCO SOFT");
        this.textBox.setFont(Font.getFont((int)64, (int)0, (int)8));
    }

    private void drawBack(Graphics graphics) {
        if (bGameRunning) {
            game.PaintInGame(graphics);
        } else {
            graphics.drawImage(this.imgLogo, 176 - this.imgLogo.getWidth() >> 1, 220 - this.imgLogo.getHeight() >> 1, 20);
            this.PaintMenu(graphics);
        }
    }

    public void PaintIntroduction(Graphics graphics) {
        int n = 16;
        int n2 = 59;
        this.drawBack(graphics);
        this.drawInfoBack(graphics, colorArray[3]);
        graphics.setColor(0);
        this.textBox.paintText(graphics, n, n2 + 1, 0x393939, -1, this.iPage, this.nextiPage, this.iPageindex, this.iPageindex2, this.iPagedirect, false, false);
        this.paintArrow(graphics);
    }

    public void paintArrow(Graphics graphics) {
        int n;
        graphics.setColor(255, 200, 200);
        if (this.iPage != this.textBox.page() - 1 || this.iPageindex != 0) {
            for (n = Math.abs(4 - (iClock & 7)); n < 9 - Math.abs(4 - (iClock & 7)); ++n) {
                graphics.drawLine(165, 150, 161 + n, 144);
            }
        }
        if (this.iPage != 0 || this.iPageindex != 0) {
            for (n = Math.abs(4 - (iClock & 7)); n < 9 - Math.abs(4 - (iClock & 7)); ++n) {
                graphics.drawLine(165, 64, 161 + n, 70);
            }
        }
    }

    private void InitScoreBoard() {
        this.deleteCommand();
        this.addCommand(1);
        this.addCommand(2);
        this.scoreImg = new Image[4];
        for (int i = 0; i < 4; ++i) {
            this.scoreImg[i] = pic.getImage("score" + i);
        }
        this.soundH = 80;
    }

    private void CloseScoreBoard() {
        this.scoreImg = null;
    }

    private void PaintScoreBoard(Graphics graphics) {
        this.drawBack(graphics);
        this.drawInfoBack(graphics, colorArray[6]);
        graphics.setColor(0);
        graphics.drawRect(52, 81, 70, 9);
        graphics.setColor(colorArray[7 + iClock / 2 % 2]);
        graphics.fillRect(53, 82, 69, 8);
        graphics.drawImage(this.scoreImg[3], 32, 92, 20);
        graphics.setClip(56, 84, 64, 5);
        graphics.drawImage(this.scoreImg[0], 56, 84 - iClock / 2 % 2 * 5, 20);
        for (int i = 0; i < 5; ++i) {
            if (i < 3) {
                graphics.setClip(23, 95 + i * 8, 7, 7);
                graphics.drawImage(this.scoreImg[1], 23 - iClock / 2 % 2 * 7, 95 - i * 7 + i * 8, 20);
            }
            game.drawNum(graphics, this.numImg, 43, 96 + i * 8, i + 1, 5, 5, 0);
            graphics.setClip(44, 96 + i * 8, 11, 5);
            graphics.drawImage(this.scoreImg[2], 44, 96 - i * 5 + i * 8, 20);
            game.drawNum(graphics, this.numImg, 97, 96 + i * 8, this.recordScore[i], 5, 5, 0);
            this.drawCharactor(graphics, this.recordName[i], 112, 96 + i * 8, 0);
        }
    }

    private void OnKeyPressedScoreBoard(int n) {
        switch (n) {
            case 3: 
            case 10: {
                frameStateNew = -4;
            }
        }
    }

    private void InitGame() {
        if (this.bySoundLevel > 0 && this.bySoundState != 2) {
            sound1.soundPlay(2, -1);
        }
        if (bGameRunning) {
            return;
        }
        System.out.println("======framework initgame=====");
        FrameWork.game.gameState = 0;
        FrameWork.game.gameStateNew = 41;
        game.Init();
        bGameRunning = true;
    }

    private void RunningGame() {
        game.Init();
        game.Running();
    }

    private void PaintGame(Graphics graphics) {
        game.paint(graphics);
    }

    private void CloseGame() {
        if (bGameRunning) {
            return;
        }
        if (game != null) {
            game.Close();
        }
        this.backImg = null;
        this.tangramImage = null;
        this.gameUI = null;
        this.dialogImg = null;
        System.gc();
    }

    private void OnKeyPressedGame(int n) {
        game.keyPressed(n);
    }

    private void OnKeyReleasedGame(int n) {
        game.keyReleased(n);
    }

    public void InitWarning() {
        this.textBox.setBoxSize(144, 130);
        this.textBox.setString("exit game{");
        this.textBox.setFont(this.smallFont);
        this.bWarning = false;
        this.warningWidthLeft = this.smallFont.stringWidth("yes") + 2;
        this.warningWidthRight = this.smallFont.stringWidth("no") + 2;
        this.warningHeight = this.smallFont.getHeight() + 2;
    }

    public void RunningWarning() {
    }

    public void CloseWarning() {
    }

    public void PaintWarning(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
        graphics.setFont(this.smallFont);
        this.textBox.paintText(graphics, 16, 16, 0xFFDF7F, -1, this.iPage, this.nextiPage, this.iPageindex, this.iPageindex2, this.iPagedirect, false, false);
        if (this.bWarning) {
            graphics.fillRect(58 - (this.warningWidthLeft >> 1), 146, this.warningWidthLeft, this.warningHeight);
            graphics.drawString("no", 117, 147, 17);
            graphics.setColor(0);
            graphics.drawString("yes", 58, 147, 17);
        } else {
            graphics.fillRect(117 - (this.warningWidthRight >> 1), 146, this.warningWidthRight, this.warningHeight);
            graphics.drawString("yes", 58, 147, 17);
            graphics.setColor(0);
            graphics.drawString("no", 117, 147, 17);
        }
    }

    public void OnKeyPressedWarning(int n) {
        switch (n) {
            case 4: 
            case 6: {
                if (this.bWarning) {
                    this.bWarning = false;
                    break;
                }
                this.bWarning = true;
                break;
            }
            case 10: {
                if (this.bWarning) {
                    this.CloseGame();
                    sound1.soundReset(0L);
                    bGameRunning = false;
                    frameStateNew = -4;
                    break;
                }
                frameStateNew = frameStateOld;
            }
        }
    }

    private void InitQuit() {
        sound1.soundPause();
        this.saveLevel();
        this.imgLogo = pic.getImage("end");
        iShowTime = 20;
    }

    private void RunningQuit() {
        if (iShowTime > 0 && --iShowTime == 0) {
            this.Release();
            this.Stop();
            this.main.destroyApp(true);
        }
    }

    private void PaintQuit(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
        graphics.drawImage(this.imgLogo, 0, 0, 20);
        graphics.setFont(this.smallFont);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Thank you!", 88, 105, 17);
    }

    private void CloseQuit() {
    }

    private void InitSelectMode() {
        bGameRunning = false;
        this.addCommand(1);
        this.addCommand(2);
        this.gridW = 0;
        this.gridH = 0;
        this.menuOUT = true;
        this.menu = Language.SYSTEM_MODE;
        if (this.menuImg == null) {
            this.menuImg = new Image[6];
            for (int i = 0; i < 6; ++i) {
                this.menuImg[i] = pic.getImage("menu" + (i + 1));
            }
        }
        this.wenzi = this.menuImg[5];
        this.wenziW = 73;
        if (this.bySoundLevel > 0) {
            sound1.soundPlay(1, -1);
        }
    }

    private void OnKeyPressedSelectMode(int n) {
        switch (n) {
            case 2: 
            case 12: {
                if (this.bySelectMenu > 1) {
                    this.bySelectMenu = (byte)(this.bySelectMenu - 1);
                    break;
                }
                this.bySelectMenu = (byte)Language.SYSTEM_MODE.length;
                break;
            }
            case 8: 
            case 18: {
                if (this.bySelectMenu < Language.SYSTEM_MODE.length) {
                    this.bySelectMenu = (byte)(this.bySelectMenu + 1);
                    break;
                }
                this.bySelectMenu = 1;
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                switch (this.bySelectMenu) {
                    case 3: {
                        FrameWork.game.playMode = 1;
                        game.setLevel((byte)(Math.abs(rnd.nextInt()) % 10 + 1));
                        this.Index = Math.abs(rnd.nextInt()) % 10 + 1;
                        frameStateNew = 11;
                        break;
                    }
                    case 2: {
                        FrameWork.game.playMode = 2;
                        game.setLevel((byte)1);
                        this.Index = Math.abs(rnd.nextInt()) % 20 + 1;
                        frameStateNew = 11;
                        break;
                    }
                    case 1: {
                        FrameWork.game.playMode = 3;
                        frameStateNew = 6;
                        break;
                    }
                    case 4: {
                        FrameWork.game.playMode = 4;
                        frameStateNew = 11;
                    }
                }
                break;
            }
            case 3: {
                this.menuIN = true;
            }
        }
    }

    private void InitInputName() {
        this.addCommand(1);
        this.name = "";
        this.bySelectMenu = 1;
        this.focus = 0;
        bGameRunning = false;
        this.wenzi = pic.getImage("nameBG");
    }

    private void CloseInputName() {
        this.wenzi = null;
    }

    private void PaintInputName(Graphics graphics) {
        int n = 28;
        int n2 = 79;
        graphics.drawImage(this.wenzi, n, n2 - 10, 20);
        graphics.setColor(0);
        graphics.fillRect(n + 44 + this.bySelectMenu * 6, n2 + 31, 7, 8);
        this.drawCharactor(graphics, this.name, n + 50, n2 + 32, 1);
        graphics.setClip(n + 45 + this.bySelectMenu * 6, n2 + 32, 5, 5);
        graphics.drawImage(this.charImg[1], n + 45 + this.bySelectMenu * 6 - this.focus * 5, n2 + 32, 20);
    }

    private void OnKeyPressedInputName(int n) {
        switch (n) {
            case 4: {
                if (this.bySelectMenu > 1) {
                    this.bySelectMenu = (byte)(this.bySelectMenu - 1);
                    this.name = this.name.substring(0, this.bySelectMenu - 1);
                }
                this.focus = 0;
                break;
            }
            case 5: 
            case 6: {
                if (this.bySelectMenu >= 5) break;
                this.name = this.name + Language.SYSTEM_LETTER[this.focus];
                this.bySelectMenu = (byte)(this.name.length() + 1);
                this.focus = 0;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.focus = (n - 12) * 3 + ++this.focus % 3;
                break;
            }
            case 18: {
                this.focus = (n - 12) * 3 + 1 + (++this.focus - ((n - 12) * 3 + 1)) % 3;
                if (this.focus >= (n - 12) * 3 + 1) break;
                this.focus = (n - 12) * 3 + 1;
                break;
            }
            case 17: {
                this.focus = (n - 12) * 3 + (++this.focus - (n - 12) * 3) % 4;
                if (this.focus >= (n - 12) * 3) break;
                this.focus = (n - 12) * 3;
                break;
            }
            case 19: {
                this.focus = (n - 12) * 3 + 1 + (++this.focus - ((n - 12) * 3 + 1)) % 4;
                if (this.focus >= (n - 12) * 3 + 1) break;
                this.focus = (n - 12) * 3 + 1;
                break;
            }
            case 10: {
                this.recordName[this.compet] = this.name = this.name + Language.SYSTEM_LETTER[this.focus];
                this.saveArrange();
                frameStateNew = 7;
            }
        }
    }

    private void PaintPause(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Press left soft key", 88, 110, 17);
    }

    private void OnKeyPressedPause(int n) {
        if (n == 10) {
            if (this.hideNotify) {
                this.hideNotify = false;
                if (this.bySoundLevel > 0) {
                    FrameWork.sound1.soundon[0] = 2;
                    FrameWork.sound1.soundon[1] = -1;
                }
            }
            this.state = 0;
            if (this.bySoundLevel > 0 && this.bySoundState == 2) {
                if (FrameWork.sound1.soundon[0] != -1 && FrameWork.sound1.soundon[1] != 1) {
                    sound1.soundPlay(FrameWork.sound1.soundon[0], FrameWork.sound1.soundon[1]);
                }
                this.bySoundState = 1;
            }
        }
    }

    private void InitLevel() {
        this.bySelectMenu = 1;
        bGameRunning = false;
        this.soundH = 80;
        this.addCommand(1);
        this.addCommand(2);
        this.levelImg = new Image[10];
        for (int i = 0; i < 10; ++i) {
            this.levelImg[i] = pic.getImage("level" + i);
        }
        if (this.imgLogo == null) {
            this.imgLogo = pic.getImage("Title");
        }
        if (this.bySoundLevel > 0) {
            sound1.soundPlay(1, -1);
        }
    }

    private void CloseLevel() {
        this.levelImg = null;
    }

    private void PaintSelectLevel(Graphics graphics) {
        this.drawInfoBack(graphics, colorArray[3]);
        graphics.drawImage(this.levelImg[0], 68, 78, 20);
        graphics.drawImage(this.fuhaoImg[3], 78, 78, 20);
        graphics.drawImage(this.levelImg[5], 7, 114, 20);
        graphics.drawImage(this.levelImg[4], 17 + (this.bySelectMenu - 1) * 15, 116, 20);
        graphics.drawImage(this.fuhaoImg[4], 123, 87, 20);
        for (int i = 0; i < 10; ++i) {
            graphics.drawImage(this.levelImg[this.levelState[i] + 1], 13 + i * 15, i % 2 == 0 ? 97 : 129, 20);
        }
        game.drawNum(graphics, this.numImg, 116, 78, this.bySelectMenu, 5, 5, 0);
        this.drawCharactor(graphics, "progress", 60, 87, 1);
        game.drawNum(graphics, this.numImg, 123, 87, this.progress, 5, 5, 1);
    }

    private void PaintSelectGate(Graphics graphics) {
        this.drawInfoBack(graphics, colorArray[3]);
        graphics.drawImage(this.levelImg[0], 68, 78, 20);
        graphics.drawImage(this.fuhaoImg[3], 78, 78, 20);
        graphics.setClip(25 + (this.bySelectMenu - 1) % 5 * 24, 96 + (this.bySelectMenu - 1) / 5 * 21, 23, 17);
        graphics.drawImage(this.levelImg[9], 25 + (this.bySelectMenu - 1) % 5 * 24 - iClock / 2 % 2 * 23, 96 + (this.bySelectMenu - 1) / 5 * 21, 20);
        byte[] byArray = this.levelState[FrameWork.game.level - 1] == 2 ? this.finishGate : this.unfinishGate;
        for (int i = 0; i < 10; ++i) {
            graphics.setClip(25 + i % 5 * 24, 96 + i / 5 * 21, 23, 17);
            graphics.drawImage(this.levelImg[6 + byArray[i]], 29 + i % 5 * 24, 100 + i / 5 * 21, 20);
            if (byArray[i] == 1) {
                graphics.drawImage(this.levelImg[8], 36 + i % 5 * 24, 107 + i / 5 * 21, 20);
            }
            if (i < 9) {
                game.drawNum(graphics, this.numImg, 37 + i % 5 * 24, 102 + i / 5 * 21, 0, 5, 5, 0);
            }
            game.drawNum(graphics, this.numImg, 42 + i % 5 * 24, 102 + i / 5 * 21, i + 1, 5, 5, 0);
        }
        game.drawNum(graphics, this.numImg, 116, 78, FrameWork.game.level, 5, 5, 0);
    }

    private void OnKeyPressedSelectLevel(int n) {
        switch (n) {
            case 4: 
            case 14: {
                if (this.bySelectMenu > 1) {
                    this.bySelectMenu = (byte)(this.bySelectMenu - 1);
                    break;
                }
                this.bySelectMenu = (byte)10;
                break;
            }
            case 6: 
            case 16: {
                if (this.bySelectMenu < 10) {
                    this.bySelectMenu = (byte)(this.bySelectMenu + 1);
                    break;
                }
                this.bySelectMenu = 1;
                break;
            }
            case 2: 
            case 12: {
                if (this.bySelectMenu <= 5) break;
                this.bySelectMenu = (byte)(this.bySelectMenu - 5);
                break;
            }
            case 8: 
            case 18: {
                if (this.bySelectMenu > 5) break;
                this.bySelectMenu = (byte)(this.bySelectMenu + 5);
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                if (this.levelIn) {
                    this.Index = this.bySelectMenu;
                    frameStateNew = 11;
                    break;
                }
                if (this.levelState[this.bySelectMenu - 1] == 0) break;
                game.setLevel(this.bySelectMenu);
                this.levelIn = true;
                this.bySelectMenu = 1;
                if (this.levelState[this.bySelectMenu - 1] != 1) break;
                this.currentGate = this.unfinishGate;
                break;
            }
            case 3: {
                if (this.levelIn) {
                    this.levelIn = false;
                    this.bySelectMenu = 1;
                    break;
                }
                frameStateNew = 5;
            }
        }
    }

    public void drawCharactor(Graphics graphics, String string, int n, int n2, int n3) {
        for (int i = 0; i < string.length(); ++i) {
            graphics.setClip(n + i * 6, n2, 5, 5);
            graphics.drawImage(this.charImg[n3], n - (string.charAt(i) - 97) * 5 + i * 6, n2, 20);
        }
    }

    public void drawPane(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(n6);
        graphics.drawRect(n, n2 - 1, n3, n4 + 1);
    }

    private void drawARGBImage(Graphics graphics) {
        graphics.setClip(50, 50, 100, 100);
        int[] nArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            nArray[i] = -1436142797;
        }
        Image image = Image.createRGBImage((int[])nArray, (int)10, (int)10, (boolean)true);
        graphics.drawImage(image, 50, 50, 20);
    }

    public void saveGame(int n) {
        System.out.println("====save game 3=====");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(FrameWork.game.score);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.record.saveRecord("tangram", 3, byteArrayOutputStream.toByteArray());
    }

    public boolean loadGame() {
        byte[] byArray = this.record.loadRecord("tangram", 3);
        if (byArray != null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                FrameWork.game.level = dataInputStream.readInt();
                FrameWork.game.score = dataInputStream.readInt();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void saveArrange() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (int i = 0; i < 5; ++i) {
                dataOutputStream.writeUTF(this.recordName[i]);
                dataOutputStream.writeInt(this.recordScore[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.record.saveRecord("tangram", 2, byteArrayOutputStream.toByteArray());
    }

    public void loadArrange() {
        byte[] byArray = this.record.loadRecord("tangram", 2);
        if (byArray != null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                for (int i = 0; i < 5; ++i) {
                    this.recordName[i] = dataInputStream.readUTF();
                    this.recordScore[i] = dataInputStream.readInt();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void saveLevel() {
        System.out.println("===========save level data=============");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.progress);
            for (int i = 0; i < 10; ++i) {
                dataOutputStream.writeByte(this.levelState[i]);
                dataOutputStream.writeByte(this.unfinishGate[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.record.saveRecord("tangram", 4, byteArrayOutputStream.toByteArray());
    }

    public void loadLevel() {
        System.out.println("===========load level data=============");
        byte[] byArray = this.record.loadRecord("tangram", 4);
        if (byArray != null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                dataInputStream.readInt();
                for (int i = 0; i < 10; ++i) {
                    this.levelState[i] = dataInputStream.readByte();
                    if (this.levelState[i] == 2) {
                        this.progress += 10;
                    }
                    this.unfinishGate[i] = dataInputStream.readByte();
                    if (this.unfinishGate[i] != 1) continue;
                    ++this.progress;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean highScoreUpdate() {
        int n;
        int n2 = 0;
        try {
            for (n = 0; n < 5; ++n) {
                int n3 = this.recordScore[n];
                if (FrameWork.game.score <= n3) continue;
                n2 = n + 1;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 != 0) {
            try {
                for (n = 4; n > n2; --n) {
                    this.recordName[n] = this.recordName[n - 1];
                    this.recordScore[n] = this.recordScore[n - 1];
                }
                this.recordScore[n2 - 1] = FrameWork.game.score;
                this.compet = n2 - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    static {
        colorArray = new int[]{10329760, 12243929, 4213338, 16030512, 8710140, 51917, 16766756, 2749166, 14099478};
    }
}

