/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class GVMedia {
    public static final int MAX_VOLUME = 80;
    private static Player player;
    private static int volume;
    private static boolean nowLoop;

    public static void stop() {
        if (player != null) {
            try {
                player.stop();
                player.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void stopLoop() {
        if (player != null) {
            try {
                player.stop();
                player.close();
                player = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void playSound(int _soundNum, boolean _loop) {
        if (player == null || player.getState() != 400) {
            GVMedia.play(_soundNum, _loop);
        }
    }

    private static void play(int _soundNum, boolean loop) {
        if (volume == 0) {
            return;
        }
        String fileName = null;
        fileName = _soundNum + ".mid";
        try {
            GVMedia.stop();
            byte[] _temp = null;
            _temp = GVUtil.readFile("/" + fileName);
            ByteArrayInputStream _is = new ByteArrayInputStream(_temp);
            player = Manager.createPlayer((InputStream)_is, (String)GVMedia.guessContentType(fileName));
            player.realize();
            player.prefetch();
            nowLoop = loop;
            if (nowLoop) {
                player.setLoopCount(nowLoop ? -1 : 1);
            }
            ((VolumeControl)player.getControl("VolumeControl")).setLevel(volume);
            player.start();
        }
        catch (Exception e) {
            System.out.println(" Exception: playSound " + fileName + ":" + e);
        }
    }

    public static void setVolume(int vol) {
        volume = vol;
    }

    public static int getVolume() {
        return volume;
    }

    private static String guessContentType(String url) throws Exception {
        String ctype = null;
        if (url.endsWith("wav")) {
            ctype = "audio/x-wav";
        } else if (url.endsWith("jts")) {
            ctype = "audio/x-tone-seq";
        } else if (url.endsWith("mid")) {
            ctype = "audio/midi";
        } else if (url.endsWith("mp3")) {
            ctype = "audio/mpeg";
        } else {
            throw new Exception("Cannot guess content type from URL: " + url);
        }
        return ctype;
    }

    static {
        volume = 80;
    }
}

