/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;

public class GVOutputPacket {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public void reset() {
        this.baos.reset();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public void initCommand(int command) {
        this.baos.reset();
        this.baos.write((byte)(command >>> 0 & 0xFF));
        this.baos.write((byte)(command >>> 8 & 0xFF));
    }

    public void writeBoolean(boolean v) {
        this.baos.write((byte)(v ? 1 : 0));
    }

    public void writeByte(byte v) {
        this.baos.write(v);
    }

    public void writeShort(short v) {
        this.baos.write((byte)(v >>> 0 & 0xFF));
        this.baos.write((byte)(v >>> 8 & 0xFF));
    }

    public void writeInt(int v) {
        this.baos.write((byte)(v >>> 0 & 0xFF));
        this.baos.write((byte)(v >>> 8 & 0xFF));
        this.baos.write((byte)(v >>> 16 & 0xFF));
        this.baos.write((byte)(v >>> 24 & 0xFF));
    }

    public void writeLong(long v) {
        this.baos.write((byte)(v >>> 0 & 0xFFL));
        this.baos.write((byte)(v >>> 8 & 0xFFL));
        this.baos.write((byte)(v >>> 16 & 0xFFL));
        this.baos.write((byte)(v >>> 24 & 0xFFL));
        this.baos.write((byte)(v >>> 32 & 0xFFL));
        this.baos.write((byte)(v >>> 40 & 0xFFL));
        this.baos.write((byte)(v >>> 48 & 0xFFL));
        this.baos.write((byte)(v >>> 56 & 0xFFL));
    }

    public void writeString(String str) {
        byte[] temp = str.getBytes();
        this.writeInt(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            this.baos.write(temp[i]);
        }
    }

    public void writeString(String str, int len) {
        byte[] temp = str.getBytes();
        for (int i = 0; i < len; ++i) {
            if (i < temp.length) {
                this.baos.write(temp[i]);
                continue;
            }
            this.baos.write(0);
        }
    }

    public void writeData(byte[] src) {
        int size = src.length;
        this.baos.write(src, 0, src.length);
    }

    public void writeData(byte[] src, int off, int len) {
        this.baos.write(src, off, len);
    }

    public void printPacket() {
        byte[] data = this.baos.toByteArray();
        System.out.print("packet = ");
        for (int i = 0; i < data.length; ++i) {
            System.out.print("[" + i + "]" + data[i] + " ");
        }
    }
}

