/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public final class GameMap {
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    int[] mapSize = new int[3];
    static int setOffX;
    static int setOffY;
    static Random rnd;
    short[][] mapData = null;
    byte[][] buttonData;
    short[] tileProperties;
    String[] name;
    int tileWidth = 32;
    int tileHeight = 16;
    int cellHeight = 24;
    int lw = 16;
    int lh = 8;
    short buffWidth = (short)((176 / this.lw + 1) * this.lw);
    short buffHeight = (short)((220 / this.lh + 1) * this.lh);
    int setOffXBak = setOffX;
    int setOffYBak = setOffY;
    byte bgIndex;
    int posX = SCREEN_WIDTH / 2;
    int posY = SCREEN_HEIGHT / 2;
    public static final byte SCEEN_MOVE = 32;
    static byte shakeTime;
    short ofy;

    public void free() {
        System.gc();
    }

    public GameMap(int sw, int sh) {
        SCREEN_WIDTH = sw;
        SCREEN_HEIGHT = sh;
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void init(int GameRank) {
        this.bgIndex = (byte)this.nextInt(5);
        this.free();
        this.loadMap("map" + GameRank + ".dat");
        this.getNewMapData();
        int sX = setOffX / this.lw * this.lw - (setOffX < 0 ? this.lw : 0);
        int sXbak = this.setOffXBak / this.lw * this.lw - (this.setOffXBak < 0 ? this.lw : 0);
        int sY = setOffY / this.lh * this.lh - (setOffY < 0 ? this.lh : 0);
        int sYbak = this.setOffYBak / this.lh * this.lh - (this.setOffYBak < 0 ? this.lh : 0);
        sXbak = sX;
        sYbak = sY;
        this.setOffYBak = setOffY;
        this.setOffXBak = setOffX;
        this.posX = SCREEN_WIDTH / 2;
        this.posY = SCREEN_HEIGHT / 3;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public void loadMap(String file) {
        byte[] datBuff = null;
        this.tileProperties = null;
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream("/" + file));
        try {
            this.mapSize[0] = GameMap.bToi(in.readByte());
            this.mapSize[1] = GameMap.bToi(in.readByte());
            this.tileWidth = GameMap.bToi(in.readByte());
            this.tileHeight = GameMap.bToi(in.readByte());
            int size = this.mapSize[0] * this.mapSize[1] * 2;
            datBuff = new byte[size];
            in.read(datBuff);
            this.mapData = new short[this.mapSize[1]][this.mapSize[0]];
            int i = 0;
            while (i < size / 2) {
                this.mapData[i % this.mapSize[1]][i / this.mapSize[1]] = (short)(GameMap.bToi(datBuff[i * 2]) << 8 | GameMap.bToi(datBuff[i * 2 + 1]));
                ++i;
            }
            int len = in.readShort();
            this.name = new String[len];
            this.tileProperties = new short[len];
            int i2 = 0;
            while (i2 < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[i2] = new String(names);
                this.tileProperties[i2] = in.readShort();
                ++i2;
            }
            this.mapSize[1] = (short)this.mapData.length;
            this.mapSize[2] = (short)(this.mapData.length + this.mapData.length / 3);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Tools.createImage(this.name, 0);
    }

    public boolean isNull(int x, int y) {
        return this.mapData[x][y] == -1;
    }

    public boolean haveTitle(int i, int j, int cell) {
        return i < this.mapData.length && j < this.mapData[i].length && !this.isNull(i, j) && (this.mapData[i][j] & 0x3F) >= cell;
    }

    public boolean frontHaveTitle(int i, int j, int cell) {
        boolean isEnd = true;
        int k = 1;
        while (isEnd) {
            if (i + k < this.mapData.length && j + k < this.mapData[i + k].length) {
                if (!this.isNull(i + k, j + k) && (this.mapData[i + k][j + k] & 0x3F) >= k * 2 + cell) {
                    return true;
                }
            } else {
                isEnd = false;
            }
            ++k;
        }
        return false;
    }

    public void getNewMapData() {
        short[][] tmpData = new short[this.mapData.length][this.mapData[0].length];
        int i = 0;
        while (i < this.mapData.length) {
            int j = 0;
            while (j < this.mapData[i].length) {
                int index = this.mapData[i][j] >> 6 & 0xFF;
                int high = this.mapData[i][j] & 0x3F;
                int startCell = 0;
                if (!this.isNull(i, j)) {
                    int k = 0;
                    while (k <= high) {
                        if ((k != high || this.frontHaveTitle(i, j, k)) && (this.haveTitle(i + 1, j, k) || this.frontHaveTitle(i + 1, j, k)) && (this.haveTitle(i, j + 1, k) || this.frontHaveTitle(i, j + 1, k)) && (startCell = k) == high) {
                            startCell = 31;
                        }
                        ++k;
                    }
                } else {
                    startCell = 31;
                }
                tmpData[i][j] = (short)(index << 10 | startCell << 5 | high);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mapData.length) {
            System.arraycopy(tmpData[i2], 0, this.mapData[i2], 0, this.mapData[i2].length);
            ++i2;
        }
    }

    public void drawMap(Graphics g) {
        g.setColor(0);
        g.setClip(setOffX, setOffY, SCREEN_WIDTH, SCREEN_HEIGHT);
        int sX = setOffX / this.lw * this.lw - (setOffX < 0 ? this.lw : 0);
        int sY = setOffY / this.lh * this.lh - (setOffY < 0 ? this.lh : 0);
        this.drawBuffer(sX, sY, this.buffWidth, this.buffHeight, g, 0, 0);
    }

    public int getIndex(int x, int y) {
        return this.mapData[x][y] >> 10 & 0x3F;
    }

    public int getStartHigh(int x, int y) {
        return this.mapData[x][y] >> 5 & 0x1F;
    }

    public int getHigh(int x, int y) {
        return this.mapData[x][y] & 0x1F;
    }

    public boolean canDefend(int x, int y) {
        return this.mapData[x][y] == -1;
    }

    public boolean canPass(int x, int y) {
        return Tools.getProperties(this.tileProperties[this.getIndex(x, y)], (byte)15);
    }

    public boolean canRepose(int x, int y) {
        return Tools.getProperties(this.tileProperties[this.getIndex(x, y)], (byte)14);
    }

    public boolean canCulvert(int x, int y) {
        return Tools.getProperties(this.tileProperties[this.getIndex(x, y)], (byte)13);
    }

    public void drawBuffer(int bX, int bY, int bW, int bH, Graphics g, int mX, int mY) {
        int h = this.cellHeight - this.tileHeight;
        g.setClip(mX, mY, bW, bH);
        g.fillRect(mX, mY, bW, bH);
        int i = 0;
        while (i < this.mapData.length) {
            int tempIw = i * this.tileWidth / 2;
            int tempIh = i * this.tileHeight / 2;
            int j = 0;
            while (j < this.mapData[i].length) {
                if (!this.isNull(i, j)) {
                    byte imgId = (byte)this.getIndex(i, j);
                    int x = j * this.tileWidth / 2 - tempIw;
                    if (x >= bX - 32 && x < bX + bW) {
                        int startIndex;
                        int tempJ = j * this.tileHeight / 2 + tempIh;
                        int k = startIndex = this.getStartHigh(i, j);
                        while (k <= this.getHigh(i, j)) {
                            int y = -k * h + tempJ;
                            if (y >= bY - 24 && y < bY + bH) {
                                Tools.addObject(imgId + 300, x - bX + mX, y - bY + mY, 20, (byte)0, 1);
                                if (this.canRepose(i, j) && GCanvas.culvertIndex != -2) {
                                    if (GCanvas.culvertIndex == -1) {
                                        Tools.addObject(24, x - bX + mX, y - bY + mY, GCanvas.imgCulvert[0], 20, (byte)0, 1);
                                    } else {
                                        Tools.addObject(24, x - bX + mX, y - bY + mY, GCanvas.imgCulvert[GCanvas.culvertIndex], 20, (byte)0, 1);
                                    }
                                }
                                if (this.buttonData != null) {
                                    int i2 = 0;
                                    while (i2 < this.buttonData.length) {
                                        int i1 = 0;
                                        while (i1 < (this.buttonData[i2].length - 4) / 3) {
                                            if (this.canCulvert(i, j) && this.buttonData[i2][5 + i1 * 3] == j && this.buttonData[i2][6 + i1 * 3] == i && this.buttonData[i2][7 + i1 * 3] == 1) {
                                                Tools.addObject(25, x - bX + mX, y - bY + mY, 20, (byte)0, 1);
                                            }
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                }
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (GCanvas.culvertIndex >= 0 && GCanvas.gameStatus != 10 && (GCanvas.culvertIndex = (byte)(GCanvas.culvertIndex + 1)) >= GCanvas.imgCulvert.length) {
            GCanvas.culvertIndex = (byte)-2;
            shakeTime = (byte)10;
            GCanvas.setST((byte)10);
        }
    }

    public void setMap(Graphics g) {
        Tools.addObject(this.bgIndex, 0, 0, 20, (byte)0, 0);
        this.drawMap(g);
    }

    public static void drawFullScreenBG(int imgIndex, int y, int speed, int level, boolean isTransNone) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int times = SCREEN_WIDTH / imgW + 2;
        int startPos = -(setOffX * speed * 10) / 800;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * imgW, y, 20, isTransNone ? (byte)0 : 1, level);
            ++i;
        }
    }

    public int getSetOffX(int x) {
        short dx = (short)(x - this.posX);
        return dx;
    }

    public int getSetOffY(int y) {
        short dy = (short)(y - this.posY);
        return dy;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.posX) > 32 ? (x - setOffX - this.posX >= 32 ? (setOffX += 32) : (setOffX -= 32)) : (int)((short)(x - this.posX));
        setOffY = Math.abs(y - setOffY - this.posY) > 32 ? (y - setOffY - this.posY >= 32 ? (setOffY += 32) : (setOffY -= 32)) : (int)((short)(y - this.posY));
    }

    public int nextInt(int n) {
        return Math.abs(rnd.nextInt()) % (n + 1);
    }

    public void screenShake() {
        this.ofy = shakeTime > 0 ? (short)((shakeTime = (byte)(shakeTime - 1)) % 2 == 0 ? 5 : -5) : (short)0;
        setOffY += this.ofy;
    }

    static {
        rnd = new Random();
        shakeTime = 0;
    }
}

