/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common.midp20;

import com.kitmaker.games.common.ISoundController;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundController
implements ISoundController {
    private Player[] a;

    public void initializeSound(byte by) {
        this.destroy();
        this.a = new Player[by];
    }

    public byte loadMIDI(InputStream inputStream) {
        int n = -1;
        if (this.a != null) {
            n = 0;
            boolean bl = false;
            while (n < this.a.length && !bl) {
                if (this.a[n] == null) {
                    bl = true;
                    continue;
                }
                n = (byte)(n + 1);
            }
            if (!bl) {
                n = -1;
            } else {
                try {
                    this.a[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                    this.a[n].realize();
                }
                catch (Exception exception) {
                    this.a[n] = null;
                    n = -1;
                }
            }
        }
        return (byte)n;
    }

    public boolean prefetch(byte by) {
        boolean bl = false;
        if (this.a != null && by > -1 && by < this.a.length && this.a[by] != null && this.a[by].getState() == 200) {
            try {
                this.a[by].prefetch();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean close(byte by) {
        boolean bl = false;
        if (this.a != null && by > -1 && by < this.a.length && this.a[by] != null) {
            try {
                this.a[by].close();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                this.a[by] = null;
            }
        }
        return bl;
    }

    public boolean deallocate(byte by) {
        boolean bl = false;
        if (this.a != null && by > -1 && by < this.a.length && this.a[by] != null && this.a[by].getState() == 300) {
            try {
                this.a[by].deallocate();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean play(byte by) {
        boolean bl = false;
        if (this.a != null && by > -1 && by < this.a.length && this.a[by] != null) {
            try {
                this.a[by].setLoopCount(1);
                this.a[by].start();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public byte getPlayerState(byte by) {
        int n = -1;
        if (this.a != null && by > -1 && by < this.a.length && this.a[by] != null) {
            switch (this.a[by].getState()) {
                case 200: {
                    n = 1;
                    break;
                }
                case 300: {
                    n = 0;
                    break;
                }
                case 400: {
                    n = 2;
                    break;
                }
                default: {
                    n = -1;
                }
            }
        }
        return (byte)n;
    }

    public boolean stop(byte by) {
        boolean bl = false;
        if (this.a != null && by > -1 && by < this.a.length && this.a[by] != null && this.a[by].getState() == 400) {
            try {
                this.a[by].stop();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public void destroy() {
        if (this.a != null) {
            for (int i = 0; i < this.a.length; ++i) {
                if (this.a[i] == null) continue;
                this.a[i].close();
                this.a[i] = null;
            }
        }
    }

    public byte getFirstPrefetchedPlayer() {
        byte by = -1;
        if (this.a != null) {
            for (int i = 0; i < this.a.length; ++i) {
                Player player;
                int n;
                if (this.a[i] == null || (n = (player = this.a[i]).getState()) == 300 || n == 400) continue;
                by = (byte)i;
                break;
            }
        }
        return by;
    }

    public boolean isSoundSupported() {
        return true;
    }
}

