/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class BorderLayout
extends Layout {
    private Component north;
    private Component south;
    private Component center;
    private Component west;
    private Component east;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String CENTER = "Center";
    public static final String WEST = "West";
    public static final String EAST = "East";

    public void addLayoutComponent(Object name, Component comp, Container c) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot add component to BorderLayout Container without constraint parameter");
        }
        Component previous = null;
        if (CENTER.equals(name)) {
            previous = this.center;
            this.center = comp;
        } else if (NORTH.equals(name)) {
            previous = this.north;
            this.north = comp;
        } else if (SOUTH.equals(name)) {
            previous = this.south;
            this.south = comp;
        } else if (EAST.equals(name)) {
            previous = this.east;
            this.east = comp;
        } else if (WEST.equals(name)) {
            previous = this.west;
            this.west = comp;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
        }
        if (previous != null && previous != comp) {
            c.removeComponent(previous);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.center) {
            this.center = null;
        } else if (comp == this.north) {
            this.north = null;
        } else if (comp == this.south) {
            this.south = null;
        } else if (comp == this.east) {
            this.east = null;
        } else if (comp == this.west) {
            this.west = null;
        }
    }

    public Object getComponentConstraint(Component comp) {
        if (comp == this.center) {
            return CENTER;
        }
        if (comp == this.north) {
            return NORTH;
        }
        if (comp == this.south) {
            return SOUTH;
        }
        if (comp == this.east) {
            return EAST;
        }
        return WEST;
    }

    public void layoutContainer(Container target) {
        Component c;
        Component c2;
        Style s = target.getStyle();
        int top = s.getPadding(false, 0);
        int bottom = target.getLayoutHeight() - target.getBottomGap() - s.getPadding(false, 2);
        int left = s.getPadding(target.isRTL(), 1);
        int right = target.getLayoutWidth() - target.getSideGap() - s.getPadding(target.isRTL(), 3);
        int targetWidth = target.getWidth();
        int targetHeight = target.getHeight();
        boolean rtl = target.isRTL();
        if (rtl) {
            left += target.getSideGap();
        }
        if (this.north != null) {
            c2 = this.north;
            this.positionTopBottom(target, c2, right, left, targetHeight);
            c2.setY(top + c2.getStyle().getMargin(false, 0));
            top += c2.getHeight() + c2.getStyle().getMargin(false, 0) + c2.getStyle().getMargin(false, 2);
        }
        if (this.south != null) {
            c2 = this.south;
            this.positionTopBottom(target, c2, right, left, targetHeight);
            c2.setY(bottom - c2.getHeight() - c2.getStyle().getMargin(false, 2));
            bottom -= c2.getHeight() + c2.getStyle().getMargin(false, 0) + c2.getStyle().getMargin(false, 2);
        }
        Component realEast = this.east;
        Component realWest = this.west;
        if (rtl) {
            realEast = this.west;
            realWest = this.east;
        }
        if (realEast != null) {
            c = realEast;
            this.positionLeftRight(realEast, targetWidth, bottom, top);
            c.setX(right - c.getWidth() - c.getStyle().getMargin(target.isRTL(), 3));
            right -= c.getWidth() + c.getStyle().getMargin(false, 1) + c.getStyle().getMargin(false, 3);
        }
        if (realWest != null) {
            c = realWest;
            this.positionLeftRight(realWest, targetWidth, bottom, top);
            c.setX(left + c.getStyle().getMargin(target.isRTL(), 1));
            left += c.getWidth() + c.getStyle().getMargin(false, 1) + c.getStyle().getMargin(false, 3);
        }
        if (this.center != null) {
            c = this.center;
            c.setWidth(right - left - c.getStyle().getMargin(false, 1) - c.getStyle().getMargin(false, 3));
            c.setHeight(bottom - top - c.getStyle().getMargin(false, 0) - c.getStyle().getMargin(false, 2));
            c.setX(left + c.getStyle().getMargin(target.isRTL(), 1));
            c.setY(top + c.getStyle().getMargin(false, 0));
        }
    }

    private void positionLeftRight(Component c, int targetWidth, int bottom, int top) {
        c.setWidth(Math.min(targetWidth, c.getPreferredW()));
        c.setHeight(bottom - top - c.getStyle().getMargin(false, 0) - c.getStyle().getMargin(false, 2));
        c.setY(top + c.getStyle().getMargin(false, 0));
    }

    private void positionTopBottom(Component target, Component c, int right, int left, int targetHeight) {
        c.setWidth(right - left - c.getStyle().getMargin(false, 1) - c.getStyle().getMargin(false, 3));
        c.setHeight(Math.min(targetHeight, c.getPreferredH()));
        c.setX(left + c.getStyle().getMargin(target.isRTL(), 1));
    }

    public Dimension getPreferredSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        if (this.east != null) {
            dim.setWidth(this.east.getPreferredW() + this.east.getStyle().getMargin(false, 1) + this.east.getStyle().getMargin(false, 3));
            dim.setHeight(Math.max(this.east.getPreferredH() + this.east.getStyle().getMargin(false, 0) + this.east.getStyle().getMargin(false, 2), dim.getHeight()));
        }
        if (this.west != null) {
            dim.setWidth(dim.getWidth() + this.west.getPreferredW() + this.west.getStyle().getMargin(false, 1) + this.west.getStyle().getMargin(false, 3));
            dim.setHeight(Math.max(this.west.getPreferredH() + this.west.getStyle().getMargin(false, 0) + this.west.getStyle().getMargin(false, 2), dim.getHeight()));
        }
        if (this.center != null) {
            dim.setWidth(dim.getWidth() + this.center.getPreferredW() + this.center.getStyle().getMargin(false, 1) + this.center.getStyle().getMargin(false, 3));
            dim.setHeight(Math.max(this.center.getPreferredH() + this.center.getStyle().getMargin(false, 0) + this.center.getStyle().getMargin(false, 2), dim.getHeight()));
        }
        if (this.north != null) {
            dim.setWidth(Math.max(this.north.getPreferredW() + this.north.getStyle().getMargin(false, 1) + this.north.getStyle().getMargin(false, 3), dim.getWidth()));
            dim.setHeight(dim.getHeight() + this.north.getPreferredH() + this.north.getStyle().getMargin(false, 0) + this.north.getStyle().getMargin(false, 2));
        }
        if (this.south != null) {
            dim.setWidth(Math.max(this.south.getPreferredW() + this.south.getStyle().getMargin(false, 1) + this.south.getStyle().getMargin(false, 3), dim.getWidth()));
            dim.setHeight(dim.getHeight() + this.south.getPreferredH() + this.south.getStyle().getMargin(false, 0) + this.south.getStyle().getMargin(false, 2));
        }
        dim.setWidth(dim.getWidth() + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3));
        dim.setHeight(dim.getHeight() + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
        return dim;
    }

    protected Component getSouth() {
        return this.south;
    }

    protected Component getCenter() {
        return this.center;
    }

    protected Component getNorth() {
        return this.north;
    }

    protected Component getEast() {
        return this.east;
    }

    protected Component getWest() {
        return this.west;
    }
}

