/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IndexedImage
extends Image {
    private int width;
    private int height;
    byte[] imageDataByte;
    int[] palette;
    static int[] lineCache;

    public IndexedImage(int width, int height, int[] palette, byte[] data) {
        super(null);
        this.width = width;
        this.height = height;
        this.palette = palette;
        this.imageDataByte = data;
        this.initOpaque();
    }

    private void initOpaque() {
        if (this.palette != null) {
            for (int iter = 0; iter < this.palette.length; ++iter) {
                if ((this.palette[iter] & 0xFF000000) == -16777216) continue;
                this.setOpaque(false);
                return;
            }
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    private IndexedImage(int width, int height, int[] palette, int[] rgb) {
        super(null);
        this.width = width;
        this.height = height;
        this.palette = palette;
        this.imageDataByte = new byte[width * height];
        for (int iter = 0; iter < this.imageDataByte.length; ++iter) {
            this.imageDataByte[iter] = (byte)this.paletteOffset(rgb[iter]);
        }
        this.initOpaque();
    }

    private int paletteOffset(int rgb) {
        for (int iter = 0; iter < this.palette.length; ++iter) {
            if (rgb != this.palette[iter]) continue;
            return iter;
        }
        throw new IllegalStateException("Invalid palette request in paletteOffset");
    }

    public static Image pack(String imageName) throws IOException {
        return IndexedImage.pack(Image.createImage(imageName));
    }

    public Image subImage(int x, int y, int width, int height, boolean processAlpha) {
        byte[] arr = new byte[width * height];
        for (int iter = 0; iter < arr.length; ++iter) {
            int destY = iter / width;
            int destX = iter % width;
            int offset = x + destX + (y + destY) * this.width;
            arr[iter] = this.imageDataByte[offset];
        }
        return new IndexedImage(width, height, this.palette, arr);
    }

    public Image rotate(int degrees) {
        throw new RuntimeException("The rotate method is not supported by indexed images at the moment");
    }

    public Image modifyAlpha(byte alpha) {
        int[] newPalette = new int[this.palette.length];
        System.arraycopy(this.palette, 0, newPalette, 0, this.palette.length);
        int alphaInt = alpha << 24 & 0xFF000000;
        for (int iter = 0; iter < this.palette.length; ++iter) {
            if ((this.palette[iter] & 0xFF000000) == 0) continue;
            newPalette[iter] = this.palette[iter] & 0xFFFFFF | alphaInt;
        }
        return new IndexedImage(this.width, this.height, newPalette, this.imageDataByte);
    }

    public Graphics getGraphics() {
        throw new RuntimeException("Indexed image objects are immutable");
    }

    void getRGB(int[] rgbData, int offset, int x, int y, int width, int height) {
        int startPoint = y * this.width + x;
        for (int rows = 0; rows < height; ++rows) {
            int currentRow = rows * width;
            for (int columns = 0; columns < width; ++columns) {
                int i = this.imageDataByte[startPoint + columns] & 0xFF;
                rgbData[offset + currentRow + columns] = this.palette[i];
            }
            startPoint += this.width;
        }
    }

    public static IndexedImage pack(int[] rgb, int width, int height) {
        int arrayLength = width * height;
        int[] tempPalette = new int[256];
        int paletteLocation = 0;
        for (int iter = 0; iter < arrayLength; ++iter) {
            int current = rgb[iter];
            if (IndexedImage.contains(tempPalette, paletteLocation, current)) continue;
            if (paletteLocation > 255) {
                return null;
            }
            tempPalette[paletteLocation] = current;
            ++paletteLocation;
        }
        if (paletteLocation != tempPalette.length) {
            int[] newArray = new int[paletteLocation];
            System.arraycopy(tempPalette, 0, newArray, 0, paletteLocation);
            tempPalette = newArray;
        }
        IndexedImage i = new IndexedImage(width, height, tempPalette, rgb);
        return i;
    }

    public static Image pack(Image sourceImage) {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        int[] rgb = sourceImage.getRGBCached();
        IndexedImage i = IndexedImage.pack(rgb, width, height);
        if (i == null) {
            return sourceImage;
        }
        return i;
    }

    private static boolean contains(int[] array, int length, int value) {
        for (int iter = 0; iter < length; ++iter) {
            if (array[iter] != value) continue;
            return true;
        }
        return false;
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        if (lineCache == null || lineCache.length < this.width * 3) {
            lineCache = new int[this.width * 3];
        }
        int clipY = g.getClipY();
        int clipBottomY = g.getClipHeight() + clipY;
        int firstLine = 0;
        int lastLine = this.height;
        if (clipY > y) {
            firstLine = clipY - y;
        }
        if (clipBottomY < y + this.height) {
            lastLine = clipBottomY - y;
        }
        for (int line = firstLine; line < lastLine; line += 3) {
            int currentPos = line * this.width;
            int rowsToDraw = Math.min(3, this.height - line);
            int amount = this.width * rowsToDraw;
            for (int position = 0; position < amount; ++position) {
                int i = this.imageDataByte[position + currentPos] & 0xFF;
                IndexedImage.lineCache[position] = this.palette[i];
            }
            g.drawRGB(lineCache, 0, x, y + line, this.width, rowsToDraw, true);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void scale(int width, int height) {
        IndexedImage p = (IndexedImage)this.scaled(width, height);
        this.imageDataByte = p.imageDataByte;
        this.width = width;
        this.height = height;
    }

    public Image scaled(int width, int height) {
        int srcWidth = this.getWidth();
        int srcHeight = this.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return this;
        }
        Dimension d = new Dimension(width, height);
        Image i = this.getCachedImage(d);
        i = new IndexedImage(width, height, this.palette, this.scaleArray(this.imageDataByte, width, height));
        this.cacheImage(d, i);
        return i;
    }

    byte[] scaleArray(byte[] sourceArray, int width, int height) {
        int srcWidth = this.getWidth();
        int srcHeight = this.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return sourceArray;
        }
        byte[] destinationArray = new byte[width * height];
        int yRatio = (srcHeight << 16) / height;
        int xRatio = (srcWidth << 16) / width;
        int xPos = xRatio / 2;
        int yPos = yRatio / 2;
        for (int x = 0; x < width; ++x) {
            int srcX = xPos >> 16;
            for (int y = 0; y < height; ++y) {
                int srcY = yPos >> 16;
                int destPixel = x + y * width;
                int srcPixel = srcX + srcY * srcWidth;
                if (destPixel >= 0 && destPixel < destinationArray.length && srcPixel >= 0 && srcPixel < sourceArray.length) {
                    destinationArray[destPixel] = sourceArray[srcPixel];
                }
                yPos += yRatio;
            }
            yPos = yRatio / 2;
            xPos += xRatio;
        }
        return destinationArray;
    }

    int[] getRGBImpl() {
        int[] rgb = new int[this.width * this.height];
        for (int iter = 0; iter < rgb.length; ++iter) {
            int i = this.imageDataByte[iter] & 0xFF;
            rgb[iter] = this.palette[i];
        }
        return rgb;
    }

    public final int[] getPalette() {
        return this.palette;
    }

    public final byte[] getImageDataByte() {
        return this.imageDataByte;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(array);
            out.writeShort(this.width);
            out.writeShort(this.height);
            out.writeByte(this.palette.length);
            for (int iter = 0; iter < this.palette.length; ++iter) {
                out.writeInt(this.palette[iter]);
            }
            ((OutputStream)out).write(this.imageDataByte);
            out.close();
            return array.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IndexedImage load(byte[] data) {
        try {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
            short width = input.readShort();
            short height = input.readShort();
            int[] palette = new int[input.readByte() & 0xFF];
            for (int iter = 0; iter < palette.length; ++iter) {
                palette[iter] = input.readInt();
            }
            byte[] arr = new byte[width * height];
            input.readFully(arr);
            return new IndexedImage((int)width, (int)height, palette, arr);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

