/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.spinner;

import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Date;

class SpinnerDateModel
implements ListModel {
    private EventDispatcher dataListener = new EventDispatcher();
    private EventDispatcher selectionListener = new EventDispatcher();
    private long min;
    private long max;
    private long currentValue;
    private static final long DAY = 86400000L;

    void setValue(Date value) {
        this.currentValue = value.getTime();
    }

    Object getValue() {
        return new Date(this.currentValue);
    }

    public SpinnerDateModel(long min, long max, long currentValue) {
        this.max = max;
        this.min = min;
        this.currentValue = currentValue;
    }

    public Object getItemAt(int index) {
        return new Date(this.min + 86400000L * (long)index);
    }

    public int getSize() {
        return (int)((this.max - this.min) / 86400000L);
    }

    public int getSelectedIndex() {
        return (int)((this.currentValue - this.min) / 86400000L);
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.getSelectedIndex();
        this.currentValue = this.min + (long)index * 86400000L;
        int newIndex = this.getSelectedIndex();
        this.selectionListener.fireSelectionEvent(oldIndex, newIndex);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.dataListener.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListener.removeListener(l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.addListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.removeListener(l);
    }

    public void addItem(Object item) {
    }

    public void removeItem(int index) {
    }
}

