/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

class Particles2 {
    static final int MAX_PARTICLES = 100;
    static final int INT_NULL = -9999;
    private static int[] partX = new int[100];
    private static int[] partY = new int[100];
    private static int[] partVelX = new int[100];
    private static int[] partVelY = new int[100];
    private static int[] partAccX = new int[100];
    private static int[] partAccY = new int[100];
    private static int[] partCol = new int[100];
    private static int[] partSize = new int[100];
    private static int[] partLife = new int[100];
    private static Sprite[] partSprite = new Sprite[100];
    private static int[] partFrame = new int[100];

    Particles2() {
    }

    public static void resetParticles() {
        Particles2.resetIntsArray(partX);
        Particles2.resetObjectsArray(partSprite);
        System.gc();
    }

    public static int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, int Size, int Col) {
        for (int i = partX.length - 1; i >= 0; --i) {
            if (partX[i] != -9999) continue;
            Particles2.partSprite[i] = null;
            Particles2.partFrame[i] = 0;
            Particles2.partX[i] = X2;
            Particles2.partY[i] = Y;
            Particles2.partVelX[i] = VelX;
            Particles2.partVelY[i] = VelY;
            Particles2.partAccX[i] = AccX;
            Particles2.partAccY[i] = AccY;
            Particles2.partSize[i] = Size;
            Particles2.partCol[i] = Col;
            Particles2.partLife[i] = 5 + Common.getRandomUInt(3);
            return i;
        }
        return -1;
    }

    public static void paintParticles(Graphics g, boolean onlyAbs) {
        for (int i = partX.length - 1; i >= 0; --i) {
            if (partX[i] == -9999) continue;
            if (partLife[i] <= 0) {
                Particles2.partX[i] = -9999;
                continue;
            }
            int n = i;
            partLife[n] = partLife[n] - 1;
            int n2 = i;
            partX[n2] = partX[n2] + partVelX[i] / 10;
            int n3 = i;
            partY[n3] = partY[n3] + partVelY[i] / 10;
            int n4 = i;
            partVelX[n4] = partVelX[n4] + partAccX[i];
            int n5 = i;
            partVelY[n5] = partVelY[n5] + partAccY[i];
            int tmp = partSize[i] / 2;
            int px = partX[i];
            int py = partY[i];
            if (partSprite[i] != null) {
                partSprite[i].setPosition(px + tmp, py + tmp);
                partSprite[i].setFrame(partFrame[i]);
                partSprite[i].paint(g);
                continue;
            }
            g.setColor(partCol[i]);
            g.fillRect(px - tmp, py - tmp, partSize[i], partSize[i]);
        }
    }

    static void createBubbles(int xpos, int ypos, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            int tmpX = Common.getRandomInt(1);
            int tmpY = -Common.getRandomUInt(4) * 2;
            int pidx = Particles2.createParticle(xpos + Common.getRandomInt(8), ypos + Common.getRandomInt(8), tmpX, tmpY, 0, tmpY <= 0 ? -1 : 1, 2 + Common.getRandomUInt(4), 0xFFFFFF);
            if (pidx == -1) continue;
            Particles2.partSprite[pidx] = null;
            Particles2.partLife[pidx] = 8;
        }
    }

    public static void paintParticles(Graphics g) {
        Particles2.paintParticles(g, false);
    }

    public static int activeParticles() {
        return Particles2.intsInArray(partX);
    }

    public final void resizeArray(Object[] arrayToResize, int newSize) {
        Object[] newArray = new Object[newSize];
        System.arraycopy(arrayToResize, 0, newArray, 0, arrayToResize.length);
        arrayToResize = newArray;
        newArray = null;
    }

    static final int objectsInArray(Object[] objArray) {
        int counter = 0;
        for (int i = 0; i < objArray.length; ++i) {
            if (objArray[i] == null) continue;
            ++counter;
        }
        return counter;
    }

    static final Object objectInArray(Object[] objArray, int index) {
        int counter = 0;
        for (int i = 0; i < objArray.length; ++i) {
            if (objArray[i] == null) continue;
            if (counter == index) {
                return objArray[i];
            }
            ++counter;
        }
        return null;
    }

    static final void resetObjectsArray(Object[] objArray) {
        if (objArray == null) {
            return;
        }
        for (int i = 0; i < objArray.length; ++i) {
            objArray[i] = null;
        }
    }

    static final void addObjectToArray(Object[] objArray, Object obj) {
        for (int i = 0; i < objArray.length; ++i) {
            if (objArray[i] != null) continue;
            objArray[i] = obj;
            return;
        }
    }

    static final boolean arrayContainsObject(Object[] objArray, Object obj) {
        for (int i = 0; i < objArray.length; ++i) {
            if (objArray[i] != obj) continue;
            return true;
        }
        return false;
    }

    static final void resetIntsArray(int[] intArray) {
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            intArray[i] = -9999;
        }
    }

    static final int addIntToArray(int[] intArray, int intVal) {
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] != -9999) continue;
            intArray[i] = intVal;
            return i;
        }
        return -1;
    }

    static final int intInArray(int[] intArray, int index) {
        int counter = 0;
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] == -9999) continue;
            if (counter == index) {
                return intArray[i];
            }
            ++counter;
        }
        return -9999;
    }

    static final void changeIntInArray(int[] intArray, int index, int val) {
        int counter = 0;
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] == -9999) continue;
            if (counter == index) {
                intArray[i] = val;
                return;
            }
            ++counter;
        }
    }

    static final int intsInArray(int[] intArray) {
        int counter = 0;
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] == -9999) continue;
            ++counter;
        }
        return counter;
    }

    static final int countIntInArray(int[] intArray, int intVal) {
        int counter = 0;
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] != intVal) continue;
            ++counter;
        }
        return counter;
    }

    static final boolean arrayContainsInt(int[] intArray, int intVal) {
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] != intVal) continue;
            return true;
        }
        return false;
    }

    static final void addUniqueIntToArray(int[] intArray, int intVal) {
        if (!Particles2.arrayContainsInt(intArray, intVal)) {
            Particles2.addIntToArray(intArray, intVal);
        }
    }

    static final void addUniqueIntsToArray(int[] intArray, int[] intVals) {
        for (int i = 0; i < intVals.length; ++i) {
            Particles2.addUniqueIntToArray(intArray, intVals[i]);
        }
    }

    static final void addIntsToArray(int[] intArray, int[] intVals) {
        for (int i = 0; i < intVals.length; ++i) {
            Particles2.addIntToArray(intArray, intVals[i]);
        }
    }

    static final void swapIntArrayVals(int[] intArray, int idx1, int idx2) {
        int tmp = intArray[idx1];
        intArray[idx1] = intArray[idx2];
        intArray[idx2] = tmp;
    }

    static final void printIntArray(int[] intArray) {
        int len = Particles2.intsInArray(intArray);
        for (int i = 0; i < len; ++i) {
            System.out.print(Particles2.intInArray(intArray, i) + ",");
        }
        System.out.println("");
    }

    static final void removeIntFromArray(int[] intArray, int intVal) {
        int len;
        for (int i = len = intArray.length - 1; i >= 0; --i) {
            if (intArray[i] != intVal) continue;
            intArray[i] = -9999;
            return;
        }
    }

    static final void saveIntArrayValues(int[] intArray, DataOutputStream data) throws IOException {
        int len = Particles2.intsInArray(intArray);
        data.writeInt(len);
        for (int i = 0; i < len; ++i) {
            data.writeInt(Particles2.intInArray(intArray, i));
        }
    }

    static final void loadIntArrayValues(int[] intArray, DataInputStream data) throws IOException {
        int len = data.readInt();
        Particles2.resetIntsArray(intArray);
        for (int i = 0; i < len; ++i) {
            intArray[i] = data.readInt();
        }
    }
}

