/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.component;

import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.engine.Bitmap;
import javax.microedition.lcdui.Graphics;

public class CustomIntButton
extends Field {
    private static final int NORMAL = 0;
    private static final int PRESSED = 1;
    private int status;
    private Bitmap[] font;
    private int string_lng;
    private Bitmap[] symbols;
    private int[] digitXes;
    private int[] digitYs;
    private int digitsCount;
    private int x_coord;
    private int y_coord;
    private int numberWidth;
    private int current_num;
    private Bitmap imgPressed;
    private Bitmap imgDefault;
    private boolean isEnabled = true;

    public CustomIntButton(int number, int x, int y, Bitmap[] fnt) {
        this.font = fnt;
        this.set_int(number);
        this.status = 0;
        this.x_coord = x;
        this.y_coord = y;
    }

    public CustomIntButton(Bitmap offImage, Bitmap onImage, int lbl, Bitmap[] fnt) {
        this.status = 0;
        this.font = fnt;
        if (offImage != null) {
            this.imgDefault = offImage;
            this.width = this.imgDefault.getWidth();
            this.height = this.imgDefault.getHeight();
            this.status = 0;
        }
        this.set_int(lbl);
        this.imgPressed = onImage;
    }

    public void onPaint(Graphics g) {
        switch (this.status) {
            case 0: {
                if (this.imgDefault == null) break;
                this.imgDefault.draw(g, this.left, this.top);
                break;
            }
            case 1: {
                if (this.imgPressed == null) break;
                this.imgPressed.draw(g, this.left, this.top);
            }
        }
        int currX = (this.width - this.numberWidth) / 2;
        for (int i = 0; i < this.string_lng; ++i) {
            this.symbols[i].draw(g, this.left + this.x_coord + currX, this.top + this.y_coord);
            currX += this.symbols[i].getWidth();
        }
    }

    public void set_int(int number) {
        int i;
        this.current_num = number;
        this.string_lng = 0;
        for (i = number; i != 0; i /= 10) {
            ++this.string_lng;
        }
        if (number == 0) {
            this.string_lng = 1;
        }
        this.numberWidth = 0;
        this.symbols = new Bitmap[this.string_lng];
        i = 0;
        int _num = number;
        while (i < this.string_lng) {
            this.symbols[this.string_lng - i - 1] = this.font[_num % 10];
            this.numberWidth += this.symbols[this.string_lng - i - 1].getWidth();
            ++i;
            _num /= 10;
        }
    }

    public int get_int() {
        return this.current_num;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        if (!this.isEnabled) {
            return false;
        }
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1) {
                    this.touchAction();
                    this.status = 0;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    protected void touchAction() {
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setOffImage(Bitmap offImage) {
        this.imgDefault = offImage;
        this.repaint();
    }

    public void setOnImage(Bitmap onImage) {
        this.imgPressed = onImage;
        this.repaint();
    }

    public void setFont(Bitmap[] font) {
        this.font = font;
        this.repaint();
    }

    public void setDigitOffsetX(int offsetX) {
        this.x_coord = offsetX;
    }

    public void setDigitOffsetY(int offsetY) {
        this.y_coord = offsetY;
    }
}

