/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Bitmap;
import javax.microedition.lcdui.Graphics;

public class HintButton
extends Field {
    private static final int NORMAL = 0;
    private static final int PRESSED = 1;
    private int status;
    private Bitmap currentPicture;
    public boolean isEnabled;
    private int timeToPass;
    public String time;
    public boolean isFocused = false;

    public HintButton(long timeFromBeg) {
        this.timeToPass = (int)((long)Board.getInstance().hintTime - timeFromBeg);
        if (this.timeToPass <= 0) {
            this.isEnabled = true;
            this.currentPicture = Board.getInstance().hints.isActive ? ImagesResources.gameMenuImages[6][3] : ImagesResources.gameMenuImages[6][1];
            this.width = this.currentPicture.getWidth();
            this.height = this.currentPicture.getHeight();
        } else {
            this.isEnabled = false;
            this.currentPicture = ImagesResources.gameMenuImages[6][0];
        }
    }

    protected void onFocus() {
        this.currentPicture = Board.getInstance().hints.isActive ? ImagesResources.gameMenuImages[6][4] : ImagesResources.gameMenuImages[6][2];
        this.repaint();
    }

    protected void onUnfocus() {
        this.currentPicture = Board.getInstance().hints.isActive ? ImagesResources.gameMenuImages[6][3] : ImagesResources.gameMenuImages[6][1];
        this.isFocused = false;
        this.repaint();
    }

    public void onPaint(Graphics g) {
        this.currentPicture.draw(g, this.left, this.top);
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                if (!this.isEnabled) break;
                this.onFocus();
                this.repaint();
                break;
            }
            case 1: {
                if (this.status != 1) {
                    out = true;
                }
                this.onUnfocus();
                if (!out && this.isEnabled) {
                    this.touchAction();
                    break;
                }
                this.repaint();
            }
        }
        return !out;
    }

    public void setFocus() {
        this.isFocused = true;
    }

    public boolean getFocusState() {
        return this.isFocused;
    }

    protected void touchAction() {
    }
}

