/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.utils;

public class ArrayList {
    private Object[] mArray;
    private int size;
    private int capacity = 32;
    private int[] nArray;
    private int isize;

    public ArrayList() {
        this.mArray = new Object[this.capacity];
        this.size = 0;
        this.nArray = new int[64];
        this.isize = 0;
    }

    public ArrayList(int mCap) {
        this.capacity = mCap < 1 ? 8 : (mCap > 128 ? 128 : mCap);
        this.mArray = new Object[this.capacity];
        this.size = 0;
    }

    public void add(Object mObject) {
        this.mArray[this.size] = mObject;
        ++this.size;
        if (this.size > this.capacity - 1) {
            this.capacity *= 2;
            Object[] tmpArray = new Object[this.capacity];
            for (int i = 0; i < this.mArray.length; ++i) {
                tmpArray[i] = this.mArray[i];
            }
            this.mArray = tmpArray;
        }
    }

    public void remove(int k) {
        if (this.isize < 0 || this.isize >= this.nArray.length + 1) {
            return;
        }
        this.nArray[this.isize] = k;
        ++this.isize;
    }

    public void remove(Object object) {
        int k = -1;
        for (int i = 0; i < this.mArray.length; ++i) {
            if (this.mArray[i] == null || !this.mArray[i].equals(object)) continue;
            k = i;
            break;
        }
        if (k != -1) {
            this.remove(k);
        }
    }

    public int size() {
        return this.size;
    }

    public Object get(int i) {
        return this.mArray[i];
    }

    public int getIndex(Object object) {
        for (int i = 0; i < this.mArray.length; ++i) {
            if (this.mArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.mArray[i] = null;
        }
        this.size = 0;
    }

    public void set(int i, Object object) {
        if (i < 0 || i >= this.mArray.length) {
            return;
        }
        this.mArray[i] = object;
        if (object == null) {
            this.nArray[this.isize] = i;
            ++this.isize;
        }
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.mArray.length; ++i) {
            if (this.mArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    private void swap(int a, int b) {
        this.mArray[a] = this.mArray[b];
        this.mArray[b] = null;
    }

    private int findNext(int k) {
        for (int i = k; i < this.size; ++i) {
            if (this.mArray[i] == null) continue;
            return i;
        }
        return -1;
    }

    public void clearDeleted() {
        if (this.isize > 0) {
            int i;
            for (i = 0; i < this.isize; ++i) {
                this.mArray[this.nArray[i]] = null;
            }
            if (this.isize != this.size) {
                for (i = this.indexOf(null); i < this.size - this.isize; ++i) {
                    this.swap(i, this.findNext(i + 1));
                }
            }
            this.size -= this.isize;
            this.isize = 0;
        }
    }
}

