/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.components.ImagesResources;
import javax.microedition.lcdui.Graphics;

public class Battery {
    private boolean isFlyingAnimationInProgress;
    public boolean isOverAnimationInProgress;
    private int flyingAnimationCounter;
    private boolean isOscillatorAnimationInProgress;
    private int animationFrame;
    public int pX;
    public int pY;
    public int x;
    public int y;
    public int xR;
    public int yR;
    public int xRR;
    public int yRR;
    private int xAdd;
    private int yAdd;
    private int stepX;
    private int stepY;
    public int initCounter;
    public int counter;
    private boolean isCounterNeeded;
    public boolean isActive;
    private int dir;
    public boolean isAlreadyShow;

    public Battery(int parentX, int parentY, int iX, int iY, int iCount) {
        this.pX = parentX;
        this.pY = parentY;
        this.x = iX;
        this.y = iY;
        this.initCounter = iCount;
        this.xR = Constants.bBc[0][0] * this.x + Constants.bBc[0][1] * this.y + Constants.bBc[0][2];
        this.yR = Constants.bBc[1][0] * this.x + Constants.bBc[1][1] * this.y + Constants.bBc[1][2];
        this.isCounterNeeded = false;
        this.isOscillatorAnimationInProgress = false;
        this.isFlyingAnimationInProgress = false;
        this.isAlreadyShow = false;
    }

    public void activate() {
        if (!this.isAlreadyShow) {
            this.isActive = true;
            this.isFlyingAnimationInProgress = true;
            this.stepX = this.xR / 10;
            this.stepY = this.yR / 10;
            if (this.stepY < 0) {
                this.stepY = -this.stepY;
            }
            this.flyingAnimationCounter = 0;
            this.counter = this.initCounter;
            this.isAlreadyShow = true;
        }
    }

    public void deactivate() {
        this.isActive = false;
        this.isCounterNeeded = false;
    }

    public void disable() {
        this.isAlreadyShow = true;
    }

    public void flyAway() {
        this.isOverAnimationInProgress = true;
        this.isCounterNeeded = false;
        this.stepX = 64;
        this.stepY = -36;
        this.flyingAnimationCounter = 0;
    }

    public void paint(Graphics g, int shiftX, int shiftY) {
        ++this.animationFrame;
        if (this.isFlyingAnimationInProgress) {
            ++this.flyingAnimationCounter;
            this.xAdd = (-10 + this.flyingAnimationCounter) * this.stepX;
            this.yAdd = (-10 + this.flyingAnimationCounter) * this.stepY;
            if (this.flyingAnimationCounter > 10) {
                this.isFlyingAnimationInProgress = false;
                this.xAdd = 0;
                this.yAdd = 0;
                this.isCounterNeeded = true;
                this.isOscillatorAnimationInProgress = true;
                this.dir = 1;
            }
        }
        if (this.isOverAnimationInProgress) {
            ++this.flyingAnimationCounter;
            this.xAdd = this.flyingAnimationCounter * this.stepX;
            this.yAdd = this.flyingAnimationCounter * this.stepY;
            if (this.flyingAnimationCounter > 10) {
                this.isOverAnimationInProgress = false;
                this.deactivate();
            }
        }
        if (this.animationFrame > 5) {
            this.animationFrame = 0;
            this.dir *= -1;
        }
        if (this.isOscillatorAnimationInProgress) {
            this.yAdd += this.dir * this.animationFrame;
        }
        this.xRR = this.xR + shiftX + this.xAdd;
        this.yRR = this.yR + shiftY + this.yAdd;
        ImagesResources.batteryImages[this.animationFrame].draw(g, this.xRR, this.yRR);
        if (this.isCounterNeeded) {
            ImagesResources.batteryIndicatorImages[this.counter].draw(g, this.xRR + Constants.BATTERY_SIZE[0], this.yRR + 3);
        }
    }
}

