/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.screens.LevelSelectorScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LevelSelectorButton
extends Field {
    public boolean isLevelEnabled = false;
    private int level;
    private int batNum;
    private int colBatNum;
    private int width;
    private int height;
    public boolean isFocused = false;
    private int animationFrame;
    private int textX;
    Font levelFont;

    public LevelSelectorButton(boolean isEnabled, int iLevel, int iColBatNum, int iBatNum) {
        this.isLevelEnabled = isEnabled;
        this.level = iLevel + 1;
        this.batNum = iColBatNum;
        this.colBatNum = iBatNum;
        if (!isEnabled) {
            this.animationFrame = 0;
        }
        this.levelFont = LevelSelectorScreen.levelNumberFont;
        if (this.level != 25) {
            this.width = ImagesResources.levelSelectorButtonsImages[0][0].getWidth();
            this.height = ImagesResources.levelSelectorButtonsImages[0][0].getHeight();
            this.textX = (this.width - this.levelFont.stringWidth(String.valueOf(this.level))) / 2;
        } else {
            this.width = ImagesResources.levelSelectorButtonsImages[1][0].getWidth();
            this.height = ImagesResources.levelSelectorButtonsImages[1][0].getHeight();
        }
    }

    public void reinitialize(boolean isEnabled, int iLevel, int iColBatNum, int iBatNum) {
        this.isLevelEnabled = isEnabled;
        this.level = iLevel + 1;
        this.batNum = iColBatNum;
        this.colBatNum = iBatNum;
        if (!isEnabled) {
            this.animationFrame = 0;
        }
        if (this.level != 25) {
            this.width = ImagesResources.levelSelectorButtonsImages[0][0].getWidth();
            this.height = ImagesResources.levelSelectorButtonsImages[0][0].getHeight();
            this.textX = (this.width - this.levelFont.stringWidth(String.valueOf(this.level))) / 2;
        } else {
            this.width = ImagesResources.levelSelectorButtonsImages[1][0].getWidth();
            this.height = ImagesResources.levelSelectorButtonsImages[1][0].getHeight();
        }
    }

    public void enableLevel() {
        this.isLevelEnabled = true;
    }

    public int getPreferredHeight() {
        return this.height;
    }

    public int getPreferredWidth() {
        return this.width;
    }

    protected void onFocus(int direction) {
        this.isFocused = true;
    }

    protected void onUnfocus() {
        this.isFocused = false;
    }

    public boolean getFocusState() {
        return this.isFocused;
    }

    protected void drawFocus(Graphics graphics, boolean on) {
    }

    public void onPaint(Graphics g) {
        if (this.isLevelEnabled) {
            if (this.isFocused) {
                if (this.level == 25) {
                    ImagesResources.levelSelectorButtonsImages[1][1].draw(g, this.left, this.top);
                } else {
                    ImagesResources.levelSelectorButtonsImages[0][1].draw(g, this.left, this.top);
                    g.setColor(0xFFFFFF);
                    g.drawString(String.valueOf(this.level), this.left + this.textX, this.top + Constants.LEVEL_SELECTOR_COORDS[25][0], 0);
                }
            } else if (this.level == 25) {
                ImagesResources.levelSelectorButtonsImages[1][0].draw(g, this.left, this.top);
            } else {
                ImagesResources.levelSelectorButtonsImages[0][0].draw(g, this.left, this.top);
                g.setColor(47871);
                g.drawString(String.valueOf(this.level), this.left + this.textX, this.top + Constants.LEVEL_SELECTOR_COORDS[25][0], 0);
            }
            switch (this.colBatNum) {
                case 1: {
                    if (this.batNum == 0) {
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[0][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[0][1]);
                        break;
                    }
                    if (this.batNum != 1) break;
                    ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[0][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[0][1]);
                    break;
                }
                case 2: {
                    if (this.batNum == 0) {
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[1][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[1][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[2][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[2][1]);
                        break;
                    }
                    if (this.batNum == 1) {
                        ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[1][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[1][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[2][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[2][1]);
                        break;
                    }
                    if (this.batNum != 2) break;
                    ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[1][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[1][1]);
                    ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[2][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[2][1]);
                    break;
                }
                case 3: {
                    if (this.batNum == 0) {
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][1]);
                        break;
                    }
                    if (this.batNum == 1) {
                        ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][1]);
                        break;
                    }
                    if (this.batNum == 2) {
                        ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][1]);
                        ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][1]);
                        ImagesResources.levelSelectorButtonsImages[2][0].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][1]);
                        break;
                    }
                    if (this.batNum != 3) break;
                    ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[3][1]);
                    ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[4][1]);
                    ImagesResources.levelSelectorButtonsImages[2][1].draw(g, this.left + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][0], this.top + Constants.LEVEL_SELECTOR_BATTARIES_COORDS[5][1]);
                }
            }
        } else {
            if (this.level == 25) {
                ImagesResources.levelSelectorButtonsImages[1][this.animationFrame].draw(g, this.left, this.top);
            } else {
                ImagesResources.levelSelectorButtonsImages[0][this.animationFrame].draw(g, this.left, this.top);
            }
            ++this.animationFrame;
            if (this.animationFrame == 4) {
                this.animationFrame = 2;
            }
        }
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out || !this.isLevelEnabled) {
                    return false;
                }
                this.status = 1;
                if (this.isLevelEnabled) {
                    this.isFocused = true;
                }
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1 && this.isLevelEnabled) {
                    this.touchAction();
                    this.status = 0;
                    this.isFocused = false;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.isFocused = false;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    public void touchAction() {
    }
}

