/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.engine;

import com.flurry.javame.FlurryAgent;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.MainCanvas;
import com.ximad.braincube2.engine.Screen;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.EndGameScreen;
import com.ximad.braincube2.screens.GameScreen;
import com.ximad.braincube2.screens.HelpScreen;
import com.ximad.braincube2.screens.PauseScreen;
import com.ximad.braincube2.screens.SplashScreen;
import com.ximad.braincube2.screens.TurboGameScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet {
    public static boolean isRating = false;
    private static long deactTime = 0L;
    public static MainCanvas canvas;
    private static Application instance;
    public static QueueThread queue;
    public static int screenWidth;
    public static int screenHeight;
    public static DataManager dataManager;
    public static boolean isForeground;
    public static Screen screen;
    private static Command quitCommand;

    public Application() {
        instance = this;
        canvas = new MainCanvas();
        canvas.setFullScreenMode(true);
    }

    public void startApp() {
        queue = new QueueThread();
        queue.start();
        canvas.setFullScreenMode(true);
        canvas.start();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)canvas);
        Screen.sleep(50L);
        screenWidth = canvas.getWidth();
        screenHeight = canvas.getHeight();
        if (screenHeight < screenWidth) {
            screenWidth = canvas.getHeight();
            screenHeight = canvas.getWidth();
        }
        isForeground = true;
        FlurryAgent.onStartApp(this, "FB479SWGYK9RCNENCS6B");
        screen = new SplashScreen();
        screen.repaint();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        DataManager.saveSettings();
        if (SoundSystem.isInited) {
            SoundSystem.release();
        }
        FlurryAgent.onDestroyApp();
        canvas.stop();
    }

    public static void setScreen(Screen screen) {
        if (Application.screen != null) {
            Application.screen.onHide();
        }
        Application.screen = screen;
        if (screen != null) {
            screen.onShow();
        }
    }

    public static Screen getScreen() {
        return screen;
    }

    public static void activate() {
        if (isRating && System.currentTimeMillis() - deactTime > 40000L) {
            DataManager.rateApp();
        }
        isRating = false;
        if (!(screen instanceof HelpScreen || screen instanceof GameScreen || screen instanceof EndGameScreen || screen instanceof PauseScreen || screen instanceof SplashScreen)) {
            if (DataManager.isSoundMusicEnabled) {
                SoundSystem.playBackgroundMusic();
            }
        } else if (screen instanceof HelpScreen && ((HelpScreen)Application.screen).tutorialMode && DataManager.isSoundMusicEnabled) {
            SoundSystem.playBackgroundMusic();
        }
        if (screen instanceof TurboGameScreen && DataManager.isSoundEffectsEnabled) {
            SoundSystem.startTurbo();
        }
        if (screen instanceof PauseScreen && DataManager.isSoundEffectsEnabled && SoundSystem.globalLock) {
            SoundSystem.startTurbo();
        }
        if (screen != null) {
            ((UiScreen)screen).resume();
        }
        FlurryAgent.onStartApp(instance, "FB479SWGYK9RCNENCS6B");
        isForeground = true;
        canvas.start();
    }

    public static void deactivate() {
        if (isRating) {
            deactTime = System.currentTimeMillis();
        }
        if (!(screen instanceof GameScreen) && DataManager.isSoundMusicEnabled) {
            SoundSystem.stopBackgroundMusic();
        }
        ((UiScreen)screen).pause();
        if (DataManager.isSoundEffectsEnabled) {
            SoundSystem.stopSounds();
        }
        FlurryAgent.onPauseApp();
        canvas.stop();
        isForeground = false;
    }

    public static void quit() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
    }

    public static MIDlet getInstance() {
        return instance;
    }

    public static void invokeLater(XRunnable msg) {
        queue.invokeLater(msg);
    }

    public static int invokeLater(XRunnable msg, long time, boolean repeat) {
        return queue.invokeLater(msg, time, repeat);
    }

    public static void invokeAndWait(XRunnable msg) {
        queue.invokeAndWait(msg);
    }

    public static void cancelInvokeLater(int runnableID) {
        queue.cancelInvokeLater(runnableID);
    }

    static {
        isForeground = false;
    }

    public static abstract class XRunnable
    implements Runnable {
        long lastExecTime;
        long sleepInterval;
        boolean repeat;
    }

    public class QueueThread
    extends Thread {
        private static final int QUEUE_LENGTH = 25;
        private static final int QUEUE_STEP = 5;
        private static final int REPEATABLE_TASKS_COUNT = 24;
        private XRunnable[] tasks = new XRunnable[24];
        private int[] taskIDs = new int[24];
        private int tasksCount = 0;
        private int idCounter = 1;
        private long minWaitTime;
        private long currentTime;
        private boolean stopped = false;
        public Object[] cmdEvents = new Object[25];
        private int cmdEventsCount = 0;
        private int i;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeLater(XRunnable msg) {
            Object[] objectArray = this.cmdEvents;
            synchronized (this.cmdEvents) {
                if (msg != null) {
                    if (this.cmdEventsCount == this.cmdEvents.length) {
                        Object[] tmp = new Object[this.cmdEventsCount + 5];
                        System.arraycopy(this.cmdEvents, 0, tmp, 0, this.cmdEventsCount);
                        this.cmdEvents = tmp;
                    }
                    this.cmdEvents[this.cmdEventsCount++] = msg;
                    this.cmdEvents.notifyAll();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int invokeLater(XRunnable msg, long time, boolean repeat) {
            int taskID = 0;
            Object[] objectArray = this;
            synchronized (this) {
                if (this.tasksCount == 24) {
                    throw new Error("Too many delayed tasks");
                }
                msg.sleepInterval = time;
                msg.repeat = repeat;
                msg.lastExecTime = System.currentTimeMillis();
                this.tasks[this.tasksCount] = msg;
                ++this.idCounter;
                taskID = this.taskIDs[this.tasksCount];
                ++this.tasksCount;
                // ** MonitorExit[var6_5] (shouldn't be in output)
                objectArray = this.cmdEvents;
                synchronized (this.cmdEvents) {
                    this.cmdEvents.notifyAll();
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return taskID;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeAndWait(XRunnable msg) {
            Object object = this.cmdEvents;
            synchronized (this.cmdEvents) {
                if (msg != null) {
                    if (this.cmdEventsCount == this.cmdEvents.length) {
                        Object[] tmp = new Object[this.cmdEventsCount + 5];
                        System.arraycopy(this.cmdEvents, 0, tmp, 0, this.cmdEventsCount);
                        this.cmdEvents = tmp;
                    }
                    this.cmdEvents[this.cmdEventsCount++] = msg;
                    this.cmdEvents.notifyAll();
                }
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                if (msg != null) {
                    try {
                        object = msg;
                        synchronized (object) {
                            msg.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelInvokeLater(int runnableID) {
            QueueThread queueThread = this;
            synchronized (queueThread) {
                for (int j = 0; j < this.tasksCount; ++j) {
                    if (this.taskIDs[j] != runnableID) continue;
                    for (int k = j + 1; k < this.tasksCount; ++k) {
                        this.tasks[k - 1] = this.tasks[k];
                        this.taskIDs[k - 1] = this.taskIDs[k];
                    }
                    if (j < this.i) {
                        --this.i;
                    }
                    --this.tasksCount;
                    this.tasks[this.tasksCount] = null;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                XRunnable msg = null;
                while (!this.stopped) {
                    Object object = this.cmdEvents;
                    // MONITORENTER : this.cmdEvents
                    if (this.cmdEventsCount > 0) {
                        msg = (XRunnable)this.cmdEvents[0];
                        System.arraycopy(this.cmdEvents, 1, this.cmdEvents, 0, this.cmdEventsCount - 1);
                        --this.cmdEventsCount;
                    }
                    // MONITOREXIT : object
                    if (msg != null) {
                        msg.run();
                        msg = null;
                    }
                    object = this;
                    // MONITORENTER : object
                    this.i = 0;
                    while (this.i < this.tasksCount) {
                        XRunnable currentTask = this.tasks[this.i];
                        this.currentTime = System.currentTimeMillis();
                        if (this.currentTime - currentTask.lastExecTime >= currentTask.sleepInterval) {
                            currentTask.lastExecTime = this.currentTime;
                            currentTask.run();
                            if (!currentTask.repeat && this.tasks[this.i] == currentTask) {
                                for (int j = this.i + 1; j < this.tasksCount; ++j) {
                                    this.tasks[j - 1] = this.tasks[j];
                                    this.taskIDs[j - 1] = this.taskIDs[j];
                                }
                                --this.tasksCount;
                                --this.i;
                            }
                        }
                        ++this.i;
                    }
                    this.minWaitTime = 92233720368547758L;
                    this.currentTime = System.currentTimeMillis();
                    this.i = 0;
                    while (this.i < this.tasksCount) {
                        long currDelta = this.tasks[this.i].sleepInterval - this.currentTime + this.tasks[this.i].lastExecTime;
                        if (currDelta <= this.minWaitTime) {
                            this.minWaitTime = currDelta;
                        }
                        ++this.i;
                    }
                    this.minWaitTime -= 5L;
                    // MONITOREXIT : object
                    object = this.cmdEvents;
                    // MONITORENTER : this.cmdEvents
                    if (this.cmdEventsCount == 0 && this.minWaitTime > 0L) {
                        this.cmdEvents.wait(this.minWaitTime);
                    }
                    // MONITOREXIT : object
                }
                return;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

