/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.components.Help;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.GameScreen;
import com.ximad.braincube2.screens.HelpScreen;
import com.ximad.braincube2.screens.MagnetoGameScreen;
import com.ximad.braincube2.screens.NormalGameScreen;
import com.ximad.braincube2.screens.TurboGameScreen;
import com.ximad.braincube2.utils.Utils;

class AnimatorRunnable
extends Application.XRunnable {
    int currWorld;
    int currLevel;
    UiScreen parent;

    public AnimatorRunnable(int world, int level, UiScreen screen) {
        this.currWorld = world;
        this.currLevel = level;
        this.parent = screen;
    }

    public void reinitialize(int world, int level, UiScreen screen) {
        this.currWorld = world;
        this.currLevel = level;
        this.parent = screen;
    }

    public void run() {
        try {
            GameScreen newScr = null;
            try {
                newScr = this.currLevel == 24 && this.currWorld == 0 ? MagnetoGameScreen.getInstance(this.currWorld, this.currLevel) : (this.currLevel == 24 && this.currWorld == 1 ? TurboGameScreen.getInstance(this.currWorld, this.currLevel) : NormalGameScreen.getInstance(this.currWorld, this.currLevel));
            }
            catch (Exception e) {
                Utils.showMessage("Error on OpenPrevScreen - " + e.getMessage());
            }
            if (DataManager.isNeedToShowHelp(Help.HELP_MATRIX[this.currWorld][this.currLevel]) && Help.HELP_MATRIX[this.currWorld][this.currLevel] != -1) {
                Application.setScreen(HelpScreen.getInstance(newScr, Help.HELP_MATRIX[this.currWorld][this.currLevel], false));
            } else {
                Application.setScreen(newScr);
            }
        }
        catch (Exception e) {
            Utils.showMessage(e.getMessage());
        }
    }
}

