/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.CustomLabelField;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ConfirmationScreen
extends UiScreen {
    private UiScreen parent;
    private int type;
    private CustomButton yesButton;
    private CustomButton noButton;
    private CustomLabelField titleLabel;
    private CustomLabelField bodyLabel;
    private String dialogTitle;
    private String dialogBody;
    private Font bodyFont;
    private CustomManager layoutManager;

    public ConfirmationScreen(UiScreen iParent, int iType) {
        this.parent = iParent;
        this.type = iType;
        ImagesResources.initCommonPupupButtons();
        this.yesButton = new CustomButton(ImagesResources.commonPopupButtons[5][0], ImagesResources.commonPopupButtons[5][1], null, null){

            protected void touchAction() {
                ConfirmationScreen.this.yesButtonClick();
            }
        };
        this.noButton = new CustomButton(ImagesResources.commonPopupButtons[2][0], ImagesResources.commonPopupButtons[2][1], null, null){

            protected void touchAction() {
                ConfirmationScreen.this.noButtonClick();
            }
        };
        switch (this.type) {
            case 0: {
                this.dialogBody = "Are you sure want to \n RESTART the game?";
                break;
            }
            case 1: 
            case 2: {
                this.dialogBody = "Are you sure want to \n    EXIT the game?";
            }
        }
        this.titleLabel = new CustomLabelField("", 28);
        this.bodyFont = Utils.getFont(64, 1, 28);
        this.bodyLabel = new CustomLabelField(this.dialogBody, 28);
        this.bodyLabel.setFont(this.bodyFont);
        this.layoutManager = new CustomManager();
        this.layoutManager.add(this.titleLabel, Constants.CONFIRMATION_SCREEN_COORDS[0][0], Constants.CONFIRMATION_SCREEN_COORDS[0][1]);
        this.layoutManager.add(this.bodyLabel, Constants.CONFIRMATION_SCREEN_COORDS[1][0], Constants.CONFIRMATION_SCREEN_COORDS[1][1]);
        this.layoutManager.add(this.yesButton, Constants.CONFIRMATION_SCREEN_COORDS[2][0], Constants.CONFIRMATION_SCREEN_COORDS[2][1]);
        this.layoutManager.add(this.noButton, Constants.CONFIRMATION_SCREEN_COORDS[3][0], Constants.CONFIRMATION_SCREEN_COORDS[3][1]);
    }

    private void yesButtonClick() {
        SoundSystem.playButtonSound();
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                this.closeScreen();
            }
        }
    }

    private void noButtonClick() {
        SoundSystem.playButtonSound();
        this.closeScreen();
    }

    public void closeScreen() {
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }
}

