/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.CustomTextBox;
import com.ximad.braincube2.components.Help;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.GameScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class HelpScreen
extends UiScreen {
    private static HelpScreen instance;
    CustomManager manager;
    private CustomButton nextButton;
    private CustomButton previousButton;
    private CustomButton cancelButton;
    private CustomTextBox titleLabel;
    private CustomTextBox bodyLabel;
    private int curPage;
    public boolean tutorialMode;
    private int totalWidth;
    private int startX;
    private int width;
    private Font titleFont;
    private Font bodyFont;
    private Font buttonFont;
    private long initTime = System.currentTimeMillis();
    private UiScreen prevScreen;

    private HelpScreen(UiScreen prevScreen, int page, boolean isTutorial) {
        this.prevScreen = prevScreen;
        ImagesResources.initCommonPupupButtons();
        this.curPage = page;
        this.tutorialMode = isTutorial;
        ImagesResources.initHelpImages(24);
        this.titleFont = Utils.getFont(64, 1, 28);
        this.titleLabel = new CustomTextBox(640, 50, this.titleFont, 1);
        this.titleLabel.setText(Help.titleText[page]);
        this.titleLabel.setFontColor(16765696);
        this.bodyLabel = new CustomTextBox(560, 145, Utils.getFont(0, 0, 8), 1);
        this.bodyLabel.setText(Help.helpText[page]);
        this.bodyLabel.setFontColor(0xFFFFFF);
        this.nextButton = new CustomButton(ImagesResources.commonPopupButtons[3][0], ImagesResources.commonPopupButtons[3][1], null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                HelpScreen.this.curPage++;
                if (HelpScreen.this.curPage >= 9) {
                    HelpScreen.this.curPage = 0;
                }
                HelpScreen.this.titleLabel.setText(Help.titleText[HelpScreen.this.curPage]);
                HelpScreen.this.bodyLabel.setText(Help.helpText[HelpScreen.this.curPage]);
                HelpScreen.this.bodyLabel.setVerticalScroll(0);
                HelpScreen.this.setTotalWidth();
                this.repaint();
            }
        };
        this.previousButton = new CustomButton(ImagesResources.commonPopupButtons[4][0], ImagesResources.commonPopupButtons[4][1], null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                HelpScreen.this.curPage--;
                if (HelpScreen.this.curPage < 0) {
                    HelpScreen.this.curPage = 8;
                }
                HelpScreen.this.titleLabel.setText(Help.titleText[HelpScreen.this.curPage]);
                HelpScreen.this.bodyLabel.setText(Help.helpText[HelpScreen.this.curPage]);
                HelpScreen.this.bodyLabel.setVerticalScroll(0);
                HelpScreen.this.setTotalWidth();
                this.repaint();
            }
        };
        if (!this.tutorialMode) {
            this.nextButton.setVisible(false);
            this.previousButton.setVisible(false);
        }
        this.cancelButton = new CustomButton(ImagesResources.commonPopupButtons[2][0], ImagesResources.commonPopupButtons[2][1], null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                if (HelpScreen.this.prevScreen instanceof GameScreen) {
                    GameScreen.gameStatus = 0;
                }
                Application.setScreen(HelpScreen.this.prevScreen);
            }
        };
        this.manager = new CustomManager(){

            public void onPaint(Graphics g) {
                ImagesResources.shadowImage.draw(g, (640 - ImagesResources.shadowImage.getWidth()) / 2, (360 - ImagesResources.shadowImage.getHeight()) / 2);
                for (int i = 0; i < Help.imageMatrix[HelpScreen.this.curPage].length; ++i) {
                    ImagesResources.helpImages[Help.imageMatrix[HelpScreen.this.curPage][i]].draw(g, HelpScreen.this.startX + i * ImagesResources.helpImages[Help.imageMatrix[HelpScreen.this.curPage][i]].getWidth(), 70);
                }
                super.onPaint(g);
            }
        };
        this.manager.add(this.titleLabel, (640 - this.titleLabel.getWidth()) / 2, 40);
        this.manager.add(this.bodyLabel, (640 - this.bodyLabel.getWidth()) / 2, 140);
        this.manager.add(this.nextButton, 443, 285);
        this.manager.add(this.previousButton, 151, 285);
        this.manager.add(this.cancelButton, 289, 285);
        this.setTotalWidth();
        if (!this.tutorialMode) {
            DataManager.showHelpDialog(this.curPage);
        }
    }

    public void onPaint(Graphics g) {
        if (this.prevScreen != null) {
            this.prevScreen.onPaint(g);
        }
        this.manager.onPaint(g);
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.manager.touchEvent(touchEventType, eventX, eventY);
    }

    private void setTotalWidth() {
        this.totalWidth = Help.imageMatrix[this.curPage].length * ImagesResources.helpImages[Help.imageMatrix[this.curPage][0]].getWidth();
        this.startX = (640 - this.totalWidth) / 2;
    }

    public boolean onClose() {
        if (this.prevScreen instanceof GameScreen) {
            GameScreen.gameStatus = 0;
        }
        Application.setScreen(this.prevScreen);
        return true;
    }

    public static HelpScreen getInstance(UiScreen prevScreen, int page, boolean isTutorial) {
        if (instance == null) {
            instance = new HelpScreen(prevScreen, page, isTutorial);
        } else {
            instance.reinitialize(prevScreen, page, isTutorial);
        }
        return instance;
    }

    private void reinitialize(UiScreen prevScreen, int page, boolean isTutorial) {
        this.prevScreen = prevScreen;
        this.curPage = page;
        this.tutorialMode = isTutorial;
        ImagesResources.initHelpImages(24);
        this.titleLabel.setText(Help.titleText[page]);
        this.bodyLabel.setText(Help.helpText[page]);
        this.bodyLabel.setVerticalScroll(0);
        if (this.tutorialMode) {
            this.nextButton.setVisible(true);
            this.previousButton.setVisible(true);
        } else {
            this.nextButton.setVisible(false);
            this.previousButton.setVisible(false);
        }
        this.setTotalWidth();
        if (!this.tutorialMode) {
            DataManager.showHelpDialog(this.curPage);
        }
    }
}

