/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;

public class EdgeSweep {
    private ProjectedVertex current;
    private Vector2f sweepDir;

    public EdgeSweep(ROVector2f sweepDir) {
        this.sweepDir = new Vector2f(sweepDir);
    }

    private void insertBackwards(int vertex, boolean isA, float distance) {
        ProjectedVertex svl = new ProjectedVertex(vertex, isA, distance);
        if (this.current == null) {
            this.current = svl;
            return;
        }
        while (this.current.distance > svl.distance) {
            if (this.current.previous == null) {
                this.current.previous = svl;
                svl.next = this.current;
                this.current = svl;
                return;
            }
            this.current = this.current.previous;
        }
        svl.next = this.current.next;
        svl.previous = this.current;
        this.current.next = svl;
        if (svl.next != null) {
            svl.next.previous = svl;
        }
        this.current = svl;
    }

    public void insert(int vertex, boolean isA, float distance) {
        if (this.current == null || this.current.distance <= distance) {
            this.insertForwards(vertex, isA, distance);
        } else {
            this.insertBackwards(vertex, isA, distance);
        }
    }

    private void insertForwards(int vertex, boolean isA, float distance) {
        ProjectedVertex svl = new ProjectedVertex(vertex, isA, distance);
        if (this.current == null) {
            this.current = svl;
            return;
        }
        while (this.current.distance <= svl.distance) {
            if (this.current.next == null) {
                this.current.next = svl;
                svl.previous = this.current;
                this.current = svl;
                return;
            }
            this.current = this.current.next;
        }
        svl.next = this.current;
        svl.previous = this.current.previous;
        this.current.previous = svl;
        if (svl.previous != null) {
            svl.previous.next = svl;
        }
        this.current = svl;
    }

    private void goToStart() {
        while (this.current.previous != null) {
            this.current = this.current.previous;
        }
    }

    public int[][] getOverlappingEdges() {
        if (this.current == null) {
            return new int[0][2];
        }
        this.goToStart();
        CurrentEdges edgesA = new CurrentEdges();
        CurrentEdges edgesB = new CurrentEdges();
        EdgePairs collidingEdges = new EdgePairs();
        float lastDist = -3.4028235E38f;
        while (this.current != null) {
            int i;
            if (this.current.distance > lastDist) {
                lastDist = this.current.distance;
                edgesA.removeScheduled();
                edgesB.removeScheduled();
            }
            if (this.current.isA) {
                if (!edgesA.contains(this.current.vertex)) {
                    edgesA.addEdge(this.current.vertex);
                    int[] edgeListB = edgesB.getEdges();
                    for (i = 0; i < edgeListB.length; ++i) {
                        collidingEdges.add(this.current.vertex, edgeListB[i]);
                    }
                } else {
                    edgesA.scheduleRemoval(this.current.vertex);
                }
            } else if (!edgesB.contains(this.current.vertex)) {
                edgesB.addEdge(this.current.vertex);
                int[] edgeListA = edgesA.getEdges();
                for (i = 0; i < edgeListA.length; ++i) {
                    collidingEdges.add(edgeListA[i], this.current.vertex);
                }
            } else {
                edgesB.scheduleRemoval(this.current.vertex);
            }
            this.current = this.current.next;
        }
        return collidingEdges.toList();
    }

    public void addVerticesToSweep(boolean isA, Vector2f[] verts) {
        int i = 0;
        int j = verts.length - 1;
        while (i < verts.length) {
            float dist = this.sweepDir.dot(verts[i]);
            this.insert(i, isA, dist);
            this.insert(j, isA, dist);
            j = i++;
        }
    }

    public ROVector2f getSweepDir() {
        return this.sweepDir;
    }

    private class EdgePairs {
        private EdgePair first;
        private int size = 0;

        private EdgePairs() {
        }

        public void add(int idA, int idB) {
            this.first = new EdgePair(idA, idB, this.first);
            ++this.size;
        }

        public int[][] toList() {
            int[][] list = new int[this.size][2];
            EdgePair current = this.first;
            for (int i = 0; i < this.size; ++i) {
                list[i][0] = current.a;
                list[i][1] = current.b;
                current = current.next;
            }
            return list;
        }

        class EdgePair {
            public int a;
            public int b;
            public EdgePair next;

            public EdgePair(int a2, int b, EdgePair next) {
                this.a = a2;
                this.b = b;
                this.next = next;
            }
        }
    }

    private class CurrentEdges {
        private LinkedEdgeList currentEdges;
        private LinkedEdgeList scheduledForRemoval;

        private CurrentEdges() {
        }

        public void addEdge(int e) {
            this.currentEdges = new LinkedEdgeList(e, this.currentEdges);
        }

        public void scheduleRemoval(int e) {
            if (this.currentEdges == null) {
                return;
            }
            if (this.currentEdges.edge == e) {
                this.currentEdges = this.currentEdges.next;
            } else {
                LinkedEdgeList current = this.currentEdges.next;
                LinkedEdgeList last = this.currentEdges;
                while (current != null) {
                    if (current.edge == e) {
                        last.next = current.next;
                        this.scheduledForRemoval = new LinkedEdgeList(e, this.scheduledForRemoval);
                        return;
                    }
                    last = current;
                    current = current.next;
                }
            }
        }

        public void removeScheduled() {
            this.scheduledForRemoval = null;
        }

        public boolean contains(int e) {
            LinkedEdgeList current = this.currentEdges;
            while (current != null) {
                if (current.edge == e) {
                    return true;
                }
                current = current.next;
            }
            current = this.scheduledForRemoval;
            while (current != null) {
                if (current.edge == e) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        public int getNoEdges() {
            int count = 0;
            LinkedEdgeList current = this.currentEdges;
            while (current != null) {
                ++count;
                current = current.next;
            }
            current = this.scheduledForRemoval;
            while (current != null) {
                ++count;
                current = current.next;
            }
            return count;
        }

        public int[] getEdges() {
            int[] returnEdges = new int[this.getNoEdges()];
            int i = 0;
            LinkedEdgeList current = this.currentEdges;
            while (current != null) {
                returnEdges[i] = current.edge;
                ++i;
                current = current.next;
            }
            current = this.scheduledForRemoval;
            while (current != null) {
                returnEdges[i] = current.edge;
                ++i;
                current = current.next;
            }
            return returnEdges;
        }

        class LinkedEdgeList {
            public int edge;
            public LinkedEdgeList next;

            public LinkedEdgeList(int edge, LinkedEdgeList next) {
                this.edge = edge;
                this.next = next;
            }
        }
    }

    class ProjectedVertex {
        public int vertex;
        public boolean isA;
        public float distance;
        public ProjectedVertex next;
        public ProjectedVertex previous;

        public ProjectedVertex(int vertex, boolean isA, float distance) {
            this.vertex = vertex;
            this.isA = isA;
            this.distance = distance;
        }
    }
}

