/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.Util;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HailScreen
extends GameScreen {
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    private Image bgrImage;
    protected GameSprite[] weatherSprite;
    Image pipoShad;
    int keyLand;
    int bgr_x = 23;
    int bgr_y = 8;

    public HailScreen(int keyLand) {
        this.keyLand = keyLand;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 400;
        this.transitionOnTime = 400;
    }

    public void loadContent() throws Exception {
        super.loadContent();
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.paperTopImage = this.loadImage(0);
        this.paperBotImage = this.loadImage(1);
        this.paperMidImage = this.loadImage(2);
        this.pipoShad = this.loadImage(51);
        this.bgrImage = Lands.getBgrImage(this.keyLand);
        Graphics g = this.bgrImage.getGraphics();
        Drawer.drawBg(g, 0, 0, this.bgrImage.getWidth(), this.bgrImage.getHeight(), 0x30000000);
        GameSprite sprite = new GameSprite(this.loadImage(54), 3, 1);
        sprite.setTimeSequence(150);
        this.weatherSprite = new GameSprite[90];
        for (int i = 0; i < this.weatherSprite.length; ++i) {
            this.weatherSprite[i] = new GameSprite(sprite);
            this.weatherSprite[i].setPosition(Util.RANDOM.nextInt(_width), Util.RANDOM.nextInt(_height) - _height);
        }
        this.asset = null;
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isFirePrd()) {
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
        int foot = this.bgr_y + this.bgrImage.getHeight() - 60;
        for (int i = 0; i < this.weatherSprite.length; ++i) {
            GameSprite sprite = this.weatherSprite[i];
            if (sprite.getFootY() < foot + i % 30) {
                sprite.move(10, 220 - i % 30, frameTime);
                continue;
            }
            sprite.updateFrame(frameTime, false);
            if (!sprite.isLastFrame()) continue;
            sprite.setFootPosition(Util.RANDOM.nextInt(_width), -Util.RANDOM.nextInt(30));
            sprite.reset();
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, this.bgr_x, this.bgr_y, 0);
        for (int i = 0; i < this.weatherSprite.length; ++i) {
            this.weatherSprite[i].paint(g);
        }
        HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.drawFade(g, 0);
            }
        }
    }
}

