/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MeetGirlScreen
extends GameScreen {
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    private Image bgrImage;
    protected Image girlImage;
    protected GameSprite[] heartSprite = new GameSprite[3];
    private GameSprite pipoSprite;
    private Image pipoShad;
    protected int keyLand = 6;
    int poSpeed = 20;
    int fadeCounter;
    static final int FADE_TIME = 600;
    boolean heart1Update;
    boolean heart2Update;
    int bgr_x = 23;
    int bgr_y = 8;
    int road_y;
    int girl_x;
    int girl_y;

    public MeetGirlScreen(int keyLand) {
        this.keyLand = keyLand;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 500;
        this.transitionOnTime = 500;
    }

    public void loadContent() throws Exception {
        super.loadContent();
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.paperTopImage = this.loadImage(0);
        this.paperBotImage = this.loadImage(1);
        this.paperMidImage = this.loadImage(2);
        this.pipoSprite = this.screenManager.store.getInt(strings.CHAR_SLTD) == 2 ? new GameSprite(this.loadImage(47), 6, 1) : new GameSprite(this.loadImage(46), 6, 1);
        this.pipoSprite.setTimeSequence(150);
        this.pipoShad = this.loadImage(51);
        this.bgrImage = Lands.getBgrImage(this.keyLand);
        this.road_y = this.bgr_y + this.bgrImage.getHeight() - 42;
        this.pipoSprite.setPositionFoot(this.bgr_x, this.road_y);
        GameSprite sprite = new GameSprite(this.loadImage(55), 3, 1);
        sprite.setTimeSequence(150);
        sprite.setVisible(false);
        this.heartSprite[0] = new GameSprite(sprite);
        this.heartSprite[1] = new GameSprite(sprite);
        this.heartSprite[2] = new GameSprite(sprite);
        this.girlImage = this.loadImage(53);
        this.girl_x = _width - 90;
        this.girl_y = this.road_y - 28;
    }

    public void handleInput(Input input, int frameTime) {
        if (this.heart2Update && input.isFirePrd()) {
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
        if (this.pipoSprite.getX() > this.girl_x - this.pipoSprite.getWidth() - 10) {
            this.poSpeed = 0;
            this.pipoSprite.setFrame(0);
            this.heartSprite[0].setPositionFoot(this.pipoSprite.getX() + 15, this.pipoSprite.getY());
            this.heartSprite[1].setPosition(this.pipoSprite.getX(), this.pipoSprite.getY());
            this.heartSprite[2].setPosition(this.pipoSprite.getLeftX() - this.heartSprite[0].getWidth(), this.pipoSprite.getY());
            this.heartSprite[0].updateFrame(frameTime, true);
            this.heartSprite[0].setVisible(true);
            if (!this.heart1Update && this.heartSprite[0].isLastFrameWhenLooping()) {
                this.heart1Update = true;
            }
            if (this.heart1Update) {
                this.heartSprite[1].updateFrame(frameTime, true);
                this.heartSprite[1].setVisible(true);
                if (!this.heart2Update && this.heartSprite[1].isLastFrameWhenLooping()) {
                    this.heart2Update = true;
                }
            }
            if (this.heart2Update) {
                this.heartSprite[2].updateFrame(frameTime, true);
                this.heartSprite[2].setVisible(true);
            }
            this.fadeCounter += frameTime;
            if (this.fadeCounter > 400) {
                this.fadeCounter = 400;
            }
        } else {
            this.pipoSprite.updateFrame(frameTime, true);
            this.pipoSprite.move(this.poSpeed, 0, frameTime);
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, this.bgr_x, this.bgr_y, 0);
        this.drawPiPo(g);
        HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.drawFade(g, 0);
            }
        }
    }

    public void finalize() {
        super.finalize();
    }

    protected void drawPiPo(Graphics g) {
        g.drawImage(this.girlImage, this.girl_x + 10, this.girl_y - 10, 0);
        g.drawImage(this.girlImage, this.girl_x - 10, this.girl_y - 10, 0);
        if (this.heartSprite[0].isVisible()) {
            this.drawFade(g, 0, (float)this.fadeCounter / 600.0f);
        }
        g.drawImage(this.girlImage, this.girl_x, this.girl_y, 0);
        this.pipoSprite.paint(g);
        g.drawImage(this.pipoShad, this.pipoSprite.getX(), this.pipoSprite.getFootY() - this.pipoShad.getHeight() / 2, 0);
        this.heartSprite[0].paint(g);
        this.heartSprite[1].paint(g);
        this.heartSprite[2].paint(g);
    }
}

