/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NarratorScreen
extends GameScreen {
    protected byte[][] intro;
    protected Image bgrImage;
    protected Image nextBtnImage;
    protected Image backBtnImage;
    protected int y;
    protected int tran_bg_x;
    protected int tran_bg_y;
    protected int tran_bg_w = 170;
    protected int tran_bg_h;
    private int timeIntroCounter;
    private int key;
    private GameScreen nextScreen;
    protected boolean playString = true;

    public NarratorScreen(int key, GameScreen nextScreen) {
        this.key = key;
        this.nextScreen = nextScreen;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOnTime = 500;
        this.transitionOffTime = 500;
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.intro = PFont.breakString(this.asset.getString(this.key), this.tran_bg_w - 10, Store.ENC_UTF8);
        this.tran_bg_h = 17 * (this.intro.length - 1);
        if (this.tran_bg_h > 160) {
            this.tran_bg_h = 160;
        } else if (this.tran_bg_h < 102) {
            this.tran_bg_h = 102;
        }
        this.tran_bg_y = (_height - this.tran_bg_h) / 2;
        this.tran_bg_x = (_width - this.tran_bg_w) / 2;
        this.y = this.tran_bg_y + this.tran_bg_h;
    }

    public void loadContent() throws Exception {
        super.loadContent();
        this.bgrImage = ImageTool.createImage(_width, _height);
        Graphics g = this.bgrImage.getGraphics();
        g.drawImage(Lands.getIntroBgrImage(this.screenManager.screenType), 0, 0, 0);
        Drawer.drawBg(g, this.tran_bg_x, this.tran_bg_y, this.tran_bg_w, this.tran_bg_h, -2009720832);
        this.nextBtnImage = this.loadImage(29);
        this.backBtnImage = ImageTool.getImageByFrame(this.nextBtnImage, 4, 1, 0);
        this.nextBtnImage = ImageTool.getImageByFrame(this.nextBtnImage, 4, 1, 3);
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isSoftRightPrd() || input.isFirePrd()) {
            if (this.nextScreen != null) {
                this.screenManager.addScreen(this.nextScreen);
            }
            this.exitScreen();
        } else if (input.isSoftLeftPrd()) {
            this.screenManager.addScreen(new MenuScreen());
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
        if (!this.isExiting() && this.y + this.intro.length * 17 < this.tran_bg_y) {
            if (this.nextScreen != null) {
                this.screenManager.addScreen(this.nextScreen);
            }
            this.screenManager.cancelOneDraw();
            this.exitScreen();
        }
    }

    public void draw(Graphics g, int frameTime) {
        this.drawBackground(g, frameTime);
        this.drawButtons(g, frameTime);
        if (this.playString) {
            this.timeIntroCounter += frameTime;
            g.setClip(this.tran_bg_x, this.tran_bg_y, this.tran_bg_w, this.tran_bg_h);
            for (int i = 0; i < this.intro.length; ++i) {
                int yy = this.y + i * 17;
                if (this.tran_bg_y - 17 >= yy || yy >= this.tran_bg_y + this.tran_bg_h) continue;
                PFont.drawString(g, this.tran_bg_x + 5, yy, this.intro[i], 0, -1);
            }
            if (this.timeIntroCounter >= 80) {
                this.timeIntroCounter -= 80;
                this.y -= 2;
            } else if (this.timeIntroCounter >= 40) {
                this.timeIntroCounter -= 40;
                --this.y;
            }
        }
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.screenManager.restoreClipping();
                Drawer.drawBg(g, 0, 0, _width, _height, (int)(this.transitionPos * 255.0f) << 24);
            }
        }
    }

    protected void drawBackground(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, 0, 0, 0);
    }

    protected void drawButtons(Graphics g, int frameTime) {
        g.drawImage(this.backBtnImage, 0, _height - this.backBtnImage.getHeight(), 0);
        g.drawImage(this.nextBtnImage, _width - this.nextBtnImage.getWidth(), _height - this.nextBtnImage.getHeight(), 0);
    }

    public void finalize() {
        this.bgrImage = null;
        this.backBtnImage = null;
        this.nextBtnImage = null;
    }
}

