/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Dialog;
import com.pipogame.util.ImageTool;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TalkBeforeGameScreen
extends GameScreen {
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    Image rightBoxImage;
    Image topBoxImage;
    protected Image landImage;
    protected Dialog firstCharDialog;
    protected Dialog secondCharDialog;
    protected Image firstAvaImage;
    protected Image secondAvaImage;
    protected Image backBtnImage;
    protected Image nextBtnImage;
    protected Store speeches;
    protected int talkOrder = 2;
    protected int maxSpeeches = 6;
    private byte[] message;
    String speechFilename;
    String firstCharString;
    String secondCharString;
    String landString;
    protected int paddBottom;
    private int keyLand;
    protected int f1DlWidth;
    protected int f2DlWidth;
    protected int dlHeight;
    protected int f2_x;
    protected int f2_y;
    protected int f1_x;
    protected int f1_y;
    public static int land_x = 23;
    public static int land_y = 8;
    private int timeCounter;
    private static final int MAX_TIME = 800;
    private boolean dir;

    public TalkBeforeGameScreen(String speechFilename, String firstChar, String secondChar, int keyLand, int maxSpeech) {
        this.speechFilename = speechFilename;
        this.firstCharString = firstChar;
        this.secondCharString = secondChar;
        this.keyLand = keyLand;
        this.maxSpeeches = maxSpeech + 1;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOnTime = 500;
        this.transitionOffTime = 500;
    }

    public void loadContent() throws Exception {
        this.landImage = Lands.getBgrImage(this.keyLand);
        this.speeches = Store.loadJar("/res/intro/" + this.speechFilename);
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.firstAvaImage = Image.createImage((String)this.firstCharString);
        this.secondAvaImage = Image.createImage((String)this.secondCharString);
        this.rightBoxImage = this.loadImage(25);
        this.topBoxImage = this.loadImage(26);
        this.paperTopImage = this.loadImage(0);
        this.paperBotImage = this.loadImage(1);
        this.paperMidImage = this.loadImage(2);
        this.nextBtnImage = this.loadImage(29);
        this.backBtnImage = ImageTool.getImageByFrame(this.nextBtnImage, 4, 1, 0);
        this.nextBtnImage = ImageTool.getImageByFrame(this.nextBtnImage, 4, 1, 3);
        this.message = PFont.toBytesIndex(this.asset.getString(41), null);
        this.paddBottom = this.nextBtnImage.getHeight();
        this.calParams(this.paddBottom);
        this.firstCharDialog = this.getFirstCharDialog(this.talkOrder);
        super.loadContent();
    }

    private void calParams(int padBottom) {
        int boxW = this.rightBoxImage.getWidth();
        int boxH = this.rightBoxImage.getHeight();
        this.dlHeight = boxH - boxW * 2 - 4;
        this.f1_x = boxW + 2;
        this.f1_y = _height - boxH + boxW + 2 - padBottom;
        this.f2_x = boxW + this.secondAvaImage.getWidth() + 2;
        this.f2_y = boxW + 2;
        boxH = this.topBoxImage.getWidth();
        this.f1DlWidth = boxH - boxW * 2 - this.firstAvaImage.getWidth() - 4;
        this.f2DlWidth = boxH - boxW * 2 - this.secondAvaImage.getWidth() - 4;
    }

    protected Dialog getFirstCharDialog(int order) {
        return new Dialog(PFont.breakString(this.speeches.getString(order), this.f1DlWidth), this.f1_x, this.f1_y, this.f1DlWidth, this.dlHeight, this.screenManager, true);
    }

    protected Dialog getSecondCharDialog(int order) {
        return new Dialog(PFont.breakString(this.speeches.getString(order), this.f2DlWidth), this.f2_x, this.f2_y, this.f2DlWidth, this.dlHeight, this.screenManager, true);
    }

    public void handleInput(Input input, int frameTime) {
        if (this.talkOrder > this.maxSpeeches && input.isSomeKeyPrd()) {
            this.exitScreen();
        } else if (input.isSoftRightPrd()) {
            if (this.talkOrder > this.maxSpeeches && !this.isExiting()) {
                this.exitScreen();
                return;
            }
            switch (this.talkOrder % 2) {
                case 0: {
                    this.firstCharDialog.finishDraw();
                    break;
                }
                case 1: {
                    this.secondCharDialog.finishDraw();
                }
            }
        } else if (input.isSoftLeftPrd()) {
            this.screenManager.removeAllScreens();
            this.screenManager.addScreen(new MenuScreen());
        } else if (input.isFirePrd()) {
            this.exitScreen();
        }
    }

    public void draw(Graphics g, int frameTime) {
        this.drawBackground(g, frameTime);
        this.drawButtons(g);
        switch (this.screenState) {
            case 1: {
                int delta1 = (int)(MathExt.sqr(this.transitionPos) * (float)(_width + 30));
                HelpDraw.drawTalkPipoDialog(g, delta1, this.firstAvaImage, this.secondAvaImage, this.rightBoxImage, this.topBoxImage, this.paddBottom);
                break;
            }
            case 4: {
                int delta2 = (int)(MathExt.sqr(this.transitionPos) * (float)(_width + 30));
                HelpDraw.drawTalkPipoDialog(g, -delta2, this.firstAvaImage, this.secondAvaImage, this.rightBoxImage, this.topBoxImage, this.paddBottom);
                break;
            }
            case 2: {
                HelpDraw.drawTalkPipoDialog(g, 0, this.firstAvaImage, this.secondAvaImage, this.rightBoxImage, this.topBoxImage, this.paddBottom);
                if (this.talkOrder > this.maxSpeeches) {
                    this.drawString(g, frameTime);
                    break;
                }
                if (this.talkOrder % 2 == 0) {
                    if (!this.firstCharDialog.drawDialog(g, frameTime, true, true)) break;
                    ++this.talkOrder;
                    if (this.talkOrder > this.maxSpeeches) break;
                    this.secondCharDialog = this.getSecondCharDialog(this.talkOrder);
                    break;
                }
                if (!this.secondCharDialog.drawDialog(g, frameTime, true, true)) break;
                ++this.talkOrder;
                if (this.talkOrder > this.maxSpeeches) break;
                this.firstCharDialog = this.getFirstCharDialog(this.talkOrder);
            }
        }
    }

    protected void drawBackground(Graphics g, int frameTime) {
        g.drawImage(this.landImage, land_x, land_y, 0);
        HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
    }

    protected void drawButtons(Graphics g) {
        g.drawImage(this.backBtnImage, 0, _height - this.backBtnImage.getHeight(), 0);
        g.drawImage(this.nextBtnImage, _width - this.nextBtnImage.getWidth(), _height - this.nextBtnImage.getHeight(), 0);
    }

    protected void drawString(Graphics g, int frameTime) {
        this.timeCounter = this.dir ? (this.timeCounter += frameTime) : (this.timeCounter -= frameTime);
        if (this.timeCounter >= 800) {
            this.timeCounter = 800;
            this.dir = false;
        } else if (this.timeCounter <= 0) {
            this.timeCounter = 0;
            this.dir = true;
        }
        int color = this.timeCounter * 255 / 800 << 24 | 0xFFFF00;
        int colorOut = this.timeCounter * 255 / 800 << 24;
        PFont.drawCenterString(g, _width / 2, (_height - 17) / 2, this.message, colorOut, color, 0, this.message.length);
    }

    public void update(int frameTime, boolean covered) {
    }
}

