/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.GameScreen;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;

public class BlinkingText {
    protected byte[][] texts;
    protected int[] widths;
    protected int timeCounter;
    public final int time;
    public static final int MIN_TIME = 800;
    protected int dir = 1;
    protected int[] x;
    protected int[] y;

    public BlinkingText(byte[] text, int time) {
        this.texts = PFont.breakString(text, GameScreen.width() * 2 / 3);
        this.time = time + 800;
        this.widths = new int[this.texts.length];
        for (int i = 0; i < this.widths.length; ++i) {
            this.widths[i] = PFont.getStringWidth(this.texts[i]) / 2;
        }
    }

    public void draw(Graphics g, int frameTime, int colorOut, int colorIn) {
        this.update(frameTime);
        int transparent = (int)(MathExt.sqr((float)this.timeCounter / (float)this.time) * 255.0f) << 24;
        int _colorOut = transparent | colorOut;
        int _colorIn = transparent | colorIn;
        int center = GameScreen.width() / 2;
        int centerY = (GameScreen.height() - this.texts.length * 17) / 2;
        for (int i = 0; i < this.texts.length; ++i) {
            PFont.drawString(g, center - this.widths[i], centerY + i * 17, this.texts[i], _colorOut, _colorIn);
        }
    }

    private void update(int frameTime) {
        this.timeCounter += this.dir * frameTime;
        if (this.timeCounter > this.time) {
            this.timeCounter = this.time;
            this.dir = -1;
        } else if (this.timeCounter < 800) {
            this.timeCounter = 800;
            this.dir = 1;
        }
    }

    public void draw(Graphics g, int frameTime, int color) {
        this.update(frameTime);
        color = (int)(MathExt.sqr((float)this.timeCounter / (float)this.time) * 255.0f) << 24 | color;
        int center = GameScreen.width() / 2;
        int centerY = (GameScreen.height() - this.texts.length * 17) / 2;
        for (int i = 0; i < this.texts.length; ++i) {
            PFont.drawString(g, center - this.widths[i], centerY + i * 17, this.texts[i], color);
        }
    }
}

