/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.components;

import com.pipogame.components.ISprite;
import com.pipogame.components.Rect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class GameSprite
extends Sprite
implements ISprite {
    private int timeSequence = 80;
    private int timePlayedOnFrame;
    private boolean isLastFrameReached;
    private Image image;
    protected float dx;
    protected float dy;

    public GameSprite(Image image) {
        super(image);
        this.image = image;
    }

    public GameSprite(GameSprite gs) {
        super((Sprite)gs);
        this.timeSequence = gs.timeSequence;
        this.image = gs.image;
    }

    public GameSprite(Image image, short frameWidth, short frameHeight) {
        super(image, (int)frameWidth, (int)frameHeight);
        this.image = image;
    }

    public GameSprite(Image image, int numFramesHorizon, int numFramesVertical) {
        super(image, image.getWidth() / numFramesHorizon, image.getHeight() / numFramesVertical);
        this.image = image;
    }

    public void setTimeSequence(int timeSequence) {
        this.timeSequence = timeSequence;
    }

    public void setFootPosition(int x, int y) {
        this.setPosition(x, y - this.getHeight());
    }

    public void updateFrame(int frameTime, boolean looping) {
        this.timePlayedOnFrame += frameTime;
        if (this.timePlayedOnFrame >= this.timeSequence && (looping || this.getFrame() != this.getFrameSequenceLength() - 1)) {
            this.nextFrame();
            this.timePlayedOnFrame -= this.timeSequence;
        }
        if (this.getFrame() == this.getFrameSequenceLength() - 1) {
            this.isLastFrameReached = true;
        }
    }

    public void move(int speedX, int speedY, int frameTime) {
        this.dx += (float)(speedX * frameTime) / 1000.0f;
        this.dy += (float)(speedY * frameTime) / 1000.0f;
        this.move((int)this.dx, (int)this.dy);
        this.dx -= (float)((int)this.dx);
        this.dy -= (float)((int)this.dy);
    }

    public void paintCenterX(Graphics g, int x, int y) {
        this.setPosition(x - this.getWidth() / 2, y);
        this.paint(g);
    }

    public void paintCenterY(Graphics g, int x, int y) {
        this.setPosition(x, y - this.getHeight() / 2);
        this.paint(g);
    }

    public void paintCenter(Graphics g) {
        this.setPosition(this.getX() - this.getWidth() / 2, this.getY() - this.getHeight() / 2);
        this.paint(g);
        this.setPosition(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
    }

    public int getTimeSequence() {
        return this.timeSequence;
    }

    public int getTimePlayedOnFrame() {
        return this.timePlayedOnFrame;
    }

    public boolean isLastFrame() {
        return this.timePlayedOnFrame >= this.timeSequence && this.getFrame() == this.getFrameSequenceLength() - 1;
    }

    public boolean isLastFrameWhenLooping() {
        return this.isLastFrameReached;
    }

    public void reset() {
        this.timePlayedOnFrame = 0;
        this.isLastFrameReached = false;
        this.setFrame(0);
    }

    public static Sprite newSprite(Image i, int numFrameHorizon, int numFrameVertical) {
        return new Sprite(i, i.getWidth() / numFrameHorizon, i.getHeight() / numFrameVertical);
    }

    public Image getImage() {
        return this.image;
    }

    public void addCollisionRectangle(Rect r) {
        this.defineCollisionRectangle(r.x, r.y, r.width, r.height);
    }

    public void removeCollisionRectangle(Rect r) {
        this.defineCollisionRectangle(0, 0, 0, 0);
    }

    public int getFootY() {
        return this.getY() + this.getHeight();
    }

    public int getLeftX() {
        return this.getX() + this.getWidth();
    }

    public void setPositionFoot(int x, int y) {
        this.setPosition(x, y - this.getHeight());
    }

    public void drawAll(Graphics g) {
    }
}

