/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Music;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.GameplayScreen;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.SmsDecode;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.MathExt;
import com.pipogame.util.MessageBox;
import com.pipogame.util.PFont;
import com.pipogame.util.SMSender;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class SubMenu {
    public static int MENU_X;
    public final int[] MENU_Y = new int[3];
    protected Sprite[] menuSprites = new Sprite[3];
    private Image soundBarImage;
    private Image soundBtnImage;
    private int selectedIndex = 0;
    private int barWidth;
    private int soundBtnPos;
    private int soundLevel;
    private boolean exiting;
    public static final int MAX_SOUND_LEVEL = 10;
    private static final float TIME_FLY = 370.0f;
    private int barFlyCounter = 370;
    private int exitCounter = 0;
    private static int snd_bar_x;
    private static int snd_bar_y;
    private static int snd_buttonX;
    private static int bgr_x;
    private static int bgr_y;
    private static int bgr_w;
    private static int bgr_h;
    public int gameState;
    private MessageBox messageBox;
    private boolean message;
    private GameplayScreen screen;
    private byte[] backBtn = PFont.toBytesIndex("Quay l\u1ea1i", null);
    private Store asset;

    public SubMenu(GameplayScreen screen) {
        this.screen = screen;
    }

    public void load(Store asset) throws Exception {
        this.exiting = false;
        this.asset = asset;
        this.soundBarImage = this.loadImage(9);
        this.soundBtnImage = this.loadImage(10);
        Image image = this.loadImage(11);
        this.menuSprites[0] = GameSprite.newSprite(image, 2, 1);
        this.menuSprites[0].setFrame(1);
        image = this.loadImage(12);
        this.menuSprites[1] = GameSprite.newSprite(image, 2, 1);
        image = this.loadImage(13);
        this.menuSprites[2] = GameSprite.newSprite(image, 2, 1);
        this.barWidth = this.soundBarImage.getWidth() - this.soundBtnImage.getWidth();
        this.soundLevel = this.screen.getScreenManager().music.getVolume() / 10;
        this.soundBtnPos = this.soundLevel * this.barWidth / 10;
        MENU_X = (GameScreen.width() - this.menuSprites[0].getWidth()) / 2;
        this.MENU_Y[1] = (GameScreen.height() - this.menuSprites[0].getHeight()) / 2;
        this.MENU_Y[0] = this.MENU_Y[1] - 15 - this.menuSprites[0].getHeight();
        this.MENU_Y[2] = this.MENU_Y[1] + 15 + this.menuSprites[0].getHeight();
        snd_buttonX = MENU_X + this.menuSprites[1].getWidth() + 5;
        snd_bar_x = snd_buttonX + this.soundBarImage.getWidth() / 2;
        snd_bar_y = this.MENU_Y[1] + this.menuSprites[1].getHeight() / 2;
        bgr_x = MENU_X - 10;
        bgr_y = this.MENU_Y[0] - 10;
        bgr_w = this.menuSprites[0].getWidth() + 20;
        bgr_h = this.MENU_Y[2] - this.MENU_Y[0] + this.menuSprites[2].getHeight() + 20;
        this.messageBox = new MessageBox(asset, 72, 180);
        this.messageBox.setX((GameScreen.width() - 180) / 2);
        this.messageBox.setY((GameScreen.height() - this.messageBox.getHeight()) / 2);
    }

    protected final Image loadImage(int key) throws Exception {
        return Image.createImage((String)this.asset.getString(key));
    }

    public void paint(Graphics g) {
        Drawer.drawBg(g, bgr_x, bgr_y, bgr_w, bgr_h, -1717344767);
        g.setColor(10708481);
        g.drawRect(bgr_x + 1, bgr_y + 1, bgr_w - 2, bgr_h - 2);
        g.drawRect(bgr_x, bgr_y, bgr_w, bgr_h);
        this.menuSprites[0].paint(g);
        this.menuSprites[1].paint(g);
        this.menuSprites[2].paint(g);
        if (this.exiting && this.selectedIndex == 1) {
            int delta = (int)(MathExt.sqr((float)this.exitCounter / 370.0f) * (float)GameScreen.width());
            if (delta + snd_bar_x <= GameScreen.width()) {
                Drawer.drawCenter(g, this.soundBarImage, snd_bar_x + delta, snd_bar_y);
                g.drawImage(this.soundBtnImage, snd_buttonX + this.soundBtnPos + delta, snd_bar_y - this.soundBtnImage.getHeight() / 2, 0);
            }
        } else {
            int delta = (int)(MathExt.sqr((float)this.barFlyCounter / 370.0f) * (float)GameScreen.width());
            if (snd_bar_x - delta <= GameScreen.width()) {
                Drawer.drawCenter(g, this.soundBarImage, snd_bar_x + delta, snd_bar_y);
                g.drawImage(this.soundBtnImage, snd_buttonX + this.soundBtnPos + delta, snd_bar_y - this.soundBtnImage.getHeight() / 2, 0);
            }
        }
        if (this.message) {
            this.message = this.messageBox.draw(g, 33);
        } else {
            PFont.drawString(g, 10, GameScreen.height() - 20, this.backBtn, -1);
        }
    }

    public void update(int frameTime, float tranpos2) {
        int d2 = GameScreen.width() - MENU_X;
        int x = this.exiting ? (int)((float)MENU_X + MathExt.sqr((float)this.exitCounter / 370.0f) * (float)(d2 + 200)) : MENU_X - (int)(tranpos2 * 700.0f);
        this.menuSprites[0].setPosition(x, this.MENU_Y[0]);
        x = this.exiting ? (int)((float)MENU_X + MathExt.sqr((float)this.exitCounter / 370.0f) * (float)(d2 + 100)) : MENU_X - (int)(tranpos2 * 500.0f);
        this.menuSprites[1].setPosition(x, this.MENU_Y[1]);
        x = this.exiting ? (int)((float)MENU_X + MathExt.sqr((float)this.exitCounter / 370.0f) * (float)d2) : MENU_X - (int)(tranpos2 * 300.0f);
        this.menuSprites[2].setPosition(x, this.MENU_Y[2]);
        if (this.selectedIndex == 1) {
            this.barFlyCounter -= frameTime;
            if (this.barFlyCounter < 0) {
                this.barFlyCounter = 0;
            }
        } else {
            this.barFlyCounter += frameTime;
            if ((float)this.barFlyCounter > 370.0f) {
                this.barFlyCounter = 370;
            }
        }
        if (this.exiting) {
            this.exitCounter += frameTime;
            if ((float)this.exitCounter > 370.0f) {
                this.exitCounter = 0;
                this.exiting = false;
                this.barFlyCounter = 370;
                this.screen.gameState = this.gameState;
                this.screen.resume();
            }
        }
        if (this.soundBtnPos != (x = this.soundLevel * this.barWidth / 10)) {
            this.soundBtnPos += this.soundBtnPos < x ? 1 : -1;
        }
    }

    public void handleInput(Input input) {
        if (this.message) {
            if (this.messageBox.handleInput(input) == 1) {
                try {
                    if (SmsDecode.getNummerMobile(0) > 0 && new SMSender().send(SmsDecode.getStringSms(0), SmsDecode.getNummerMobile(0))) {
                        this.screen.getScreenManager().store.changeInt(strings.LIFE, 3);
                    }
                }
                catch (Exception ex) {}
            } else if (this.messageBox.handleInput(input) == 2) {
                this.message = false;
            }
        } else {
            if (input.isUpPrd()) {
                this.selectedIndex = (this.selectedIndex + 2) % 3;
            } else if (input.isDownPrd()) {
                this.selectedIndex = (this.selectedIndex + 1) % 3;
            } else if (input.isSoftLeftPrd()) {
                this.exiting = true;
            }
            if (this.selectedIndex == 1) {
                Music music = this.screen.getScreenManager().music;
                if (input.isLeftPrd()) {
                    if (this.soundLevel > 0) {
                        --this.soundLevel;
                        music.setVolume(10 * this.soundLevel);
                    }
                } else if (input.isRightPrd() && this.soundLevel < 10) {
                    ++this.soundLevel;
                    if (music.setVolume(10 * this.soundLevel)) {
                        music.playMusic("m");
                    }
                }
            }
            if (input.isSomeKeyPrd()) {
                this.menuSprites[0].setFrame(0);
                this.menuSprites[1].setFrame(0);
                this.menuSprites[2].setFrame(0);
                this.menuSprites[this.selectedIndex].setFrame(1);
            }
            if (input.isFirePrd()) {
                switch (this.selectedIndex) {
                    case 0: {
                        if (this.screen.getScreenManager().store.getInt(strings.LIFE) > 0) {
                            this.screen.replay();
                            this.gameState = 2;
                            this.exiting = true;
                            break;
                        }
                        this.message = true;
                        break;
                    }
                    case 2: {
                        this.exiting = true;
                        this.screen.save();
                        this.screen.getScreenManager().removeAllScreens();
                        this.screen.getScreenManager().addScreen(new MenuScreen());
                    }
                }
            }
        }
    }

    static {
        bgr_x = 12;
        bgr_y = 11;
        bgr_w = 12;
        bgr_h = 12;
    }
}

