/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.GameplayScreen;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.scen.NarratorScreen;
import com.pipogame.fad.scen.TalkGameCompleteScreen;
import com.pipogame.fad.scen.TravelScreen;
import com.pipogame.fad.strings;
import com.pipogame.util.BlinkingText;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import com.pipogame.util.PFont;
import com.pipogame.util.Util;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SumUpScreen
extends GameScreen {
    private Image[] itemsImages;
    private Image bgrImage;
    protected GameSprite camelSprite;
    private int total;
    private int score;
    private int bonus;
    private GameScreen nextScreen;
    GameSprite goldSprite;
    private boolean gameComplete;
    protected int[] numEatenItems;
    protected int[] basicScores;
    protected int[] numCounter = new int[7];
    private BlinkingText rewardText;
    private boolean win;
    private boolean rewarded;
    private int tbl_x;
    private int tbl_y;
    private int tbl_w = 180;
    private int tbl_h = 196;
    private int center;
    private int WxH = 28;
    protected int index;
    protected boolean done;
    protected boolean userReuestOut;
    private int timeHoldScreen;
    int fColor = -1;

    public SumUpScreen(GameplayScreen screen) {
        this(screen, new TravelScreen());
    }

    public SumUpScreen(GameplayScreen screen, GameScreen nextScreen) {
        this.bgrImage = screen.bgrImage;
        this.numEatenItems = screen.numEatenItems;
        this.basicScores = screen.basicScores;
        this.itemsImages = screen.itemImages;
        this.bonus = (int)Math.sqrt(Math.max(0, screen.MAX_TIME_PLAY - screen.timePlayed) / 1000) * 100;
        this.nextScreen = nextScreen;
        screen.getScreenManager().store.changeInt(strings.SILVER, this.bonus);
        this.win = screen.isLevelUp;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 500;
        for (int i = 0; i < 7; ++i) {
            this.total += this.numEatenItems[i];
            this.score += this.numEatenItems[i] * this.basicScores[i];
        }
        this.tbl_x = (_width - this.tbl_w) / 2;
        this.tbl_y = (_height - this.tbl_h - 34) / 2;
        if (this.tbl_y < 17) {
            this.tbl_y = 17;
        }
        Store store = this.screenManager.store;
        int currentCity = TravelScreen.getCurrentCity(store.getInt(strings.CHAR_SLTD), store.getInt(strings.STAGE));
        if (this.win && currentCity > store.getInt(strings.LAST_CITY_RWD)) {
            int i;
            int[] collection = store.getIntArray(strings.COLLECTION);
            Vector<Integer> notCollected = new Vector<Integer>(collection.length);
            for (i = 0; i < collection.length; ++i) {
                notCollected.addElement(new Integer(i));
            }
            for (i = 0; i < collection.length && collection[i] != -1; ++i) {
                Integer ii = new Integer(collection[i]);
                if (!notCollected.contains(ii)) continue;
                notCollected.removeElement(ii);
            }
            if (i < collection.length) {
                collection[i] = (Integer)notCollected.elementAt(Util.RANDOM.nextInt(notCollected.size()));
                store.set(strings.LAST_CITY_RWD, currentCity);
                this.rewarded = true;
                this.screenManager.store.set(strings.COLLECTION, collection);
            }
        }
    }

    public void loadContent() throws Exception {
        int i;
        Image face;
        Graphics g = this.bgrImage.getGraphics();
        Store s = this.screenManager.store;
        this.gameComplete = TravelScreen.getCurrentCity(s.getInt(strings.CHAR_SLTD), s.getInt(strings.STAGE)) == 17;
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.drawFade(g, 0, 0.7f);
        Image im = this.loadImage(29);
        g.drawImage(ImageTool.getImageByFrame(im, 4, 1, 2), 0, _height - im.getHeight(), 0);
        im = ImageTool.getImageByFrame(im, 4, 1, 3);
        g.drawImage(im, _width - im.getWidth(), _height - im.getHeight(), 0);
        this.camelSprite = new GameSprite(this.loadImage(44), 6, 1);
        this.camelSprite.setPosition((_width - this.camelSprite.getWidth()) / 2, _height - this.camelSprite.getHeight());
        this.camelSprite.setTimeSequence(100);
        if (this.win) {
            this.goldSprite = new GameSprite(this.loadImage(67), 8, 1);
            this.goldSprite.setPositionFoot(0, _height - 17);
            this.goldSprite.setTimeSequence(120);
            if (this.rewarded) {
                this.rewardText = new BlinkingText(PFont.toBytesIndex(this.asset.getString(68), null), 500);
            }
        }
        if (this.screenManager.store.getInt(strings.CHAR_SLTD) == 1) {
            face = this.makePiImage(this.win);
            g.drawImage(face, _width - face.getWidth(), 0, 0);
        } else {
            face = this.makePoImage(this.win);
            g.drawImage(face, 0, 0, 0);
        }
        g.setColor(8335360);
        g.drawRect(this.tbl_x, this.tbl_y, this.tbl_w, this.tbl_h);
        for (i = 1; i <= 6; ++i) {
            g.drawLine(this.tbl_x, this.tbl_y + i * this.WxH, this.tbl_x + this.tbl_w, this.tbl_y + i * this.WxH);
        }
        this.center = this.tbl_x + (this.tbl_w + this.WxH) / 2;
        g.drawLine(this.tbl_x + this.WxH, this.tbl_y, this.tbl_x + this.WxH, this.tbl_y + this.tbl_h);
        g.drawLine(this.center, this.tbl_y, this.center, this.tbl_y + this.tbl_h);
        for (i = 0; i < 6; ++i) {
            g.drawImage(this.itemsImages[i], this.tbl_x + 1, this.tbl_y + 1 + this.WxH * i, 0);
        }
        if (this.itemsImages[6] != null) {
            g.drawImage(this.itemsImages[6], this.tbl_x + 1, this.tbl_y + 1 + this.WxH * 6, 0);
        }
        PFont.drawStringL(g, this.center - 5, this.tbl_y - 17, PFont.toBytesIndex("Bonus", null), this.fColor);
    }

    public void update(int frameTime, boolean covered) {
        this.camelSprite.updateFrame(frameTime, true);
        if (this.userReuestOut) {
            this.timeHoldScreen += frameTime;
            if (this.timeHoldScreen > 1000) {
                this.exitScreen();
            }
        }
        if (this.win) {
            this.goldSprite.updateFrame(frameTime, true);
        }
        if (this.index >= 7) {
            this.done = true;
            return;
        }
        int n = this.index;
        this.numCounter[n] = this.numCounter[n] + frameTime / 3;
        if (this.numCounter[this.index] > this.numEatenItems[this.index]) {
            this.numCounter[this.index] = this.numEatenItems[this.index];
            ++this.index;
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, 0, 0, 0);
        if (this.win) {
            this.goldSprite.paint(g);
        }
        this.camelSprite.paint(g);
        PFont.drawNumberL(g, this.bonus, this.tbl_x + this.tbl_w - 5, this.tbl_y - 17, this.fColor);
        for (int i = 0; i < 7; ++i) {
            PFont.drawNumberL(g, this.numCounter[i], this.center - 5, this.tbl_y + this.WxH * i + 6, this.fColor);
            PFont.drawNumberL(g, this.numCounter[i] * this.basicScores[i], this.tbl_x + this.tbl_w - 5, this.tbl_y + this.WxH * i + 6, this.fColor);
        }
        if (this.done) {
            PFont.drawNumberL(g, this.total, this.center - 5, this.tbl_y + this.tbl_h + 6, this.fColor);
            PFont.drawNumberL(g, this.score, this.tbl_x + this.tbl_w - 5, this.tbl_y + this.tbl_h + 6, this.fColor);
            if (this.rewarded) {
                this.rewardText.draw(g, frameTime, 255, 0xFFFFFF);
            }
        }
        if (this.screenState == 4) {
            Drawer.drawBg(g, 0, 0, _width, _height, (int)(this.tranPos2 * 255.0f) << 24);
        }
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isSoftLeftPrd()) {
            this.index = 8;
            System.arraycopy(this.numEatenItems, 0, this.numCounter, 0, 7);
        } else if (input.isSoftRightPrd() || input.isFirePrd()) {
            if (this.gameComplete) {
                try {
                    this.screenManager.addScreen(new TalkGameCompleteScreen(this.screenManager.screenType));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.screenManager.addScreen(new NarratorScreen(71, new MenuScreen()));
                MenuScreen.resetGame(this.screenManager.store);
                this.exitScreen();
            } else if (this.done) {
                this.screenManager.addScreen(this.nextScreen);
                this.exitScreen();
            }
            this.index = 8;
            System.arraycopy(this.numEatenItems, 0, this.numCounter, 0, 7);
            this.userReuestOut = true;
            this.done = true;
        }
    }

    private Image makePiImage(boolean win) throws Exception {
        Image pi = this.loadImage(27);
        Image image = ImageTool.makePsudoTransparentImageBuffer(pi);
        Graphics g = image.getGraphics();
        Image face = this.loadImage(59);
        face = win ? ImageTool.getImageByFrame(face, 2, 1, 1) : ImageTool.getImageByFrame(face, 2, 1, 0);
        g.drawImage(face, 13, 24, 0);
        return ImageTool.getImageRegion(image, 5, 0, 48, 48);
    }

    private Image makePoImage(boolean win) throws Exception {
        Image po = this.loadImage(28);
        Image i = ImageTool.makePsudoTransparentImageBuffer(po);
        Graphics g = i.getGraphics();
        if (!win) {
            Image face = this.loadImage(60);
            g.drawImage(face, 48, 25, 0);
        }
        return ImageTool.getImageRegion(i, 34, 2, 46, 56);
    }
}

