/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.util.ArrayUtils;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class Queue
implements Enumeration {
    public final int bufferSize;
    private final Object[] packetBuffer;
    private int lastPacketRemoved = 0;
    private int lastPacketAdded = 0;
    private boolean containsItems = false;

    public Queue(int bufferSize) {
        this.bufferSize = bufferSize;
        this.packetBuffer = new Object[bufferSize];
    }

    public Queue(Queue other) {
        this.bufferSize = other.bufferSize;
        this.lastPacketRemoved = other.lastPacketRemoved;
        this.lastPacketAdded = other.lastPacketAdded;
        this.containsItems = other.containsItems;
        this.packetBuffer = new Object[this.bufferSize];
        System.arraycopy(other.packetBuffer, 0, this.packetBuffer, 0, this.bufferSize);
    }

    public int occupiedSlots() {
        if (this.lastPacketRemoved < this.lastPacketAdded) {
            return this.lastPacketAdded - this.lastPacketRemoved;
        }
        if (!this.containsItems && this.lastPacketRemoved == this.lastPacketAdded) {
            return 0;
        }
        return this.lastPacketAdded + this.bufferSize - this.lastPacketRemoved;
    }

    public Object poll() {
        if (this.isEmpty()) {
            return null;
        }
        if (++this.lastPacketRemoved >= this.bufferSize) {
            this.lastPacketRemoved = 0;
        }
        Object result = this.packetBuffer[this.lastPacketRemoved];
        this.packetBuffer[this.lastPacketRemoved] = null;
        if (this.lastPacketRemoved == this.lastPacketAdded) {
            this.containsItems = false;
        }
        return result;
    }

    public boolean offer(Object o) {
        if (this.isFull()) {
            return false;
        }
        if (++this.lastPacketAdded >= this.bufferSize) {
            this.lastPacketAdded = 0;
        }
        this.packetBuffer[this.lastPacketAdded] = o;
        this.containsItems = true;
        return true;
    }

    public boolean offerAll(Enumeration other) {
        if (other == this) {
            throw new IllegalArgumentException("Do not use queue as an enumeration");
        }
        while (other.hasMoreElements()) {
            if (this.offer(other.nextElement())) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        return this.occupiedSlots() >= this.bufferSize;
    }

    public boolean isEmpty() {
        return this.occupiedSlots() == 0;
    }

    public Enumeration getEnumeration() {
        return new Queue(this);
    }

    public boolean hasMoreElements() {
        return !this.isEmpty();
    }

    public Object nextElement() {
        Object result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public void clear() {
        this.lastPacketAdded = this.lastPacketRemoved;
        this.containsItems = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        return ArrayUtils.equals((Object)this.getEnumeration(), other.getEnumeration());
    }

    public int hashCode() {
        return ArrayUtils.hashCode(this.getEnumeration());
    }

    public String toString() {
        return ArrayUtils.arrayToString(this);
    }

    public Object peek() {
        return this.peek(0);
    }

    public Object peek(int index) {
        if (index >= this.occupiedSlots()) {
            return null;
        }
        int i = (this.lastPacketRemoved + 1 + index) % this.bufferSize;
        Object result = this.packetBuffer[i];
        return result;
    }

    public Object removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        Object result = this.packetBuffer[this.lastPacketAdded];
        this.packetBuffer[this.lastPacketAdded] = null;
        if (--this.lastPacketAdded < 0) {
            this.lastPacketAdded = this.bufferSize - 1;
        }
        if (this.lastPacketRemoved == this.lastPacketAdded) {
            this.containsItems = false;
        }
        return result;
    }
}

