/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.Input;
import com.pipogame.util.Drawer;
import com.pipogame.util.PFont;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RichPage {
    private Vector element;
    private int[] endIndexOfPage = new int[30];
    private int x;
    private int y;
    private int width;
    private int height;
    private int currentPageHeight;
    private int time;
    private int TIME = 200;
    private int totalPages;
    private int curPage;
    private int oldPage;
    private int transitionStyle = 1;
    private float transPos;
    private boolean pageChanged;
    public static final int TRAN_LINEAR = 1;
    public static final int TRAN_SQUARE_ROOT = 2;
    public static final int TRAN_SQUARE = 3;

    public RichPage(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.element = new Vector(30);
        this.totalPages = 1;
    }

    public RichPage append(String text) {
        byte[][] b = PFont.breakString(text, this.width);
        for (int i = 0; i < b.length; ++i) {
            this.element.addElement(b[i]);
            this.checkHeight(17);
        }
        this.endIndexOfPage[this.totalPages] = this.element.size();
        return this;
    }

    public RichPage append(Image image) {
        this.element.addElement(image);
        this.checkHeight(image.getHeight());
        this.endIndexOfPage[this.totalPages] = this.element.size();
        return this;
    }

    public RichPage breakPage() {
        this.currentPageHeight = 0;
        ++this.totalPages;
        this.endIndexOfPage[this.totalPages] = this.element.size();
        return this;
    }

    private void checkHeight(int height) {
        if (this.currentPageHeight + height + height > this.height) {
            this.currentPageHeight = height;
            this.endIndexOfPage[this.totalPages] = this.element.size();
            ++this.totalPages;
            if (this.totalPages == this.endIndexOfPage.length) {
                int[] array = new int[this.totalPages + 10];
                System.arraycopy(this.endIndexOfPage, 0, array, 0, this.totalPages);
                this.endIndexOfPage = array;
            }
        } else {
            this.currentPageHeight += height;
        }
    }

    public void handleInput(Input input) {
        if (input.isLeftPrd() || input.isUpPrd()) {
            --this.curPage;
            if (this.curPage < 0) {
                this.curPage = 0;
            } else {
                this.oldPage = this.curPage + 1;
                this.pageChanged = true;
                this.time = this.TIME;
            }
        } else if (input.isRightPrd() || input.isDownPrd()) {
            ++this.curPage;
            if (this.curPage == this.totalPages) {
                this.curPage = this.totalPages - 1;
            } else {
                this.pageChanged = true;
                this.oldPage = this.curPage - 1;
                this.time = this.TIME;
            }
        }
    }

    public void draw(Graphics g, int frameTime) {
        int pos = 0;
        int clIn = -1;
        int clOut = 0;
        if (this.pageChanged) {
            this.time -= frameTime;
            if (this.time < 0) {
                this.time = 0;
                this.pageChanged = false;
            }
            pos = this.calPos();
            clIn = 0xFFFFFF | (int)((1.0f - this.transPos) * 255.0f) << 24;
            clOut = 0xFFFFFF | (int)(this.transPos * 255.0f) << 24;
        }
        int curHei = this.y;
        g.setClip(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
        for (int i = this.endIndexOfPage[this.curPage]; i < this.endIndexOfPage[this.curPage + 1]; ++i) {
            Object o = this.element.elementAt(i);
            if (o instanceof Image) {
                Drawer.drawAtCenterX(g, (Image)o, this.x + this.width / 2 + pos, curHei);
                curHei += ((Image)o).getHeight();
                continue;
            }
            PFont.drawString(g, this.x + pos, curHei, (byte[])o, clIn);
            curHei += 17;
        }
        if (this.pageChanged) {
            curHei = this.y;
            int _x = this.x + (this.oldPage - this.curPage) * this.width;
            for (int i = this.endIndexOfPage[this.oldPage]; i < this.endIndexOfPage[this.oldPage + 1]; ++i) {
                Object o = this.element.elementAt(i);
                if (o instanceof Image) {
                    Drawer.drawAtCenterX(g, (Image)o, _x + this.width / 2 + pos, curHei);
                    curHei += ((Image)o).getHeight();
                    continue;
                }
                PFont.drawString(g, _x + pos, curHei, (byte[])o, clOut);
                curHei += 17;
            }
        }
    }

    private int calPos() {
        this.transPos = (float)this.time / (float)this.TIME;
        switch (this.transitionStyle) {
            case 1: {
                return (int)((float)this.width * this.transPos) * (this.curPage - this.oldPage);
            }
            case 3: {
                this.transPos *= this.transPos;
                return (int)((float)this.width * this.transPos) * (this.curPage - this.oldPage);
            }
            case 2: {
                this.transPos = (float)Math.sqrt(this.transPos);
                return (int)((float)this.width * this.transPos) * (this.curPage - this.oldPage);
            }
        }
        return 0;
    }

    public void setTransitionStyle(int transitionStyle) {
        this.transitionStyle = transitionStyle;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isFirstPage() {
        return this.curPage == 0;
    }

    public boolean isLastPage() {
        return this.curPage == this.totalPages - 1;
    }

    public void setTransitionTime(int time) {
        this.TIME = time;
    }
}

