/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.media;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;

public class J2DM_SoundManager
implements PlayerListener {
    private static J2DM_SoundManager _instance;
    private boolean _enable = true;
    private Hashtable _clipsMap = new Hashtable();
    private boolean _isDeviceAvailable = true;

    private J2DM_SoundManager() {
    }

    public static J2DM_SoundManager getInstance() {
        if (_instance == null) {
            _instance = new J2DM_SoundManager();
        }
        return _instance;
    }

    public void setEnable(boolean value) {
        this._enable = value;
    }

    public boolean getEnable() {
        return this._enable;
    }

    public boolean loadMusic(String fnm, boolean loop) {
        return this.load(fnm);
    }

    public boolean playMusic(String fnm) {
        if (!this._enable) {
            return false;
        }
        return this.play(fnm, true);
    }

    public boolean playMusic(String fnm, boolean loop) {
        if (!this._enable) {
            return false;
        }
        return this.play(fnm, loop);
    }

    public boolean stopMusic(String fnm) {
        if (!this._enable) {
            return false;
        }
        return this.stop(fnm);
    }

    public boolean destroyMusic(String fnm) {
        return false;
    }

    public boolean load(String fnm) {
        if (this._clipsMap.containsKey(fnm)) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::load", String.valueOf(fnm) + "already stored", J2DM_ConsoleMessageTypes.LOG);
            return true;
        }
        Player clip = this.loadClip(fnm);
        if (clip != null) {
            this._clipsMap.put(fnm, clip);
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::load", "Loaded " + fnm, J2DM_ConsoleMessageTypes.LOG);
            return true;
        }
        return false;
    }

    private Player loadClip(String fnm) {
        String contentType = this.extractContentType(fnm);
        Player clip = null;
        try {
            clip = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(fnm), (String)contentType);
            clip.addPlayerListener((PlayerListener)this);
            clip.realize();
            clip.prefetch();
            this.useSpeaker(clip);
        }
        catch (Exception e) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::loadClip", "Could not load " + fnm, J2DM_ConsoleMessageTypes.ERROR);
        }
        return clip;
    }

    private String extractContentType(String fnm) {
        int lastDot = fnm.lastIndexOf(46);
        if (lastDot == -1) {
            return "audio/x-wav";
        }
        String extStr = fnm.substring(lastDot + 1).toLowerCase();
        if (extStr.endsWith("au")) {
            return "audio/basic";
        }
        if (extStr.endsWith("mp3")) {
            return "audio/mpeg";
        }
        if (extStr.endsWith("mid")) {
            return "audio/midi";
        }
        if (extStr.endsWith("jts")) {
            return "audio/x-tone-seq";
        }
        return "audio/x-wav";
    }

    private void useSpeaker(Player clip) {
    }

    public boolean play(String fnm) {
        if (!this._enable) {
            return false;
        }
        return this.play(fnm, false);
    }

    private boolean play(String fnm, boolean isRepeating) {
        Player clip;
        if (!this._isDeviceAvailable) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::play", "Device not available", J2DM_ConsoleMessageTypes.LOG);
        }
        if ((clip = (Player)this._clipsMap.get(fnm)) == null) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::play", "No loaded clip for " + fnm, J2DM_ConsoleMessageTypes.LOG);
        }
        if (clip.getState() == 400) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::play", "Clip for " + fnm + " already playing", J2DM_ConsoleMessageTypes.LOG);
        }
        try {
            if (isRepeating) {
                clip.setLoopCount(-1);
            }
            clip.realize();
            clip.prefetch();
            clip.start();
            return true;
        }
        catch (Exception e) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::play", "Could not play " + fnm, J2DM_ConsoleMessageTypes.LOG);
            return false;
        }
    }

    public boolean loadPlay(String fnm) {
        boolean isLoaded = this.load(fnm);
        if (!isLoaded) {
            return false;
        }
        return this.play(fnm);
    }

    public boolean isPlaying(String fnm) {
        if (!this._isDeviceAvailable) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::isPlaying", "Device not available", J2DM_ConsoleMessageTypes.LOG);
            return false;
        }
        Player clip = (Player)this._clipsMap.get(fnm);
        if (clip == null) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::isPlaying", "No loaded clip for " + fnm, J2DM_ConsoleMessageTypes.LOG);
            return false;
        }
        return clip.getState() == 400;
    }

    public boolean loop(String fnm) {
        return this.play(fnm, true);
    }

    public boolean loadLoop(String fnm) {
        boolean isLoaded = this.load(fnm);
        if (!isLoaded) {
            return false;
        }
        return this.loop(fnm);
    }

    public boolean stop(String fnm) {
        Player clip = (Player)this._clipsMap.get(fnm);
        if (clip == null) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::stop", "No loaded clip for " + fnm, J2DM_ConsoleMessageTypes.LOG);
            return false;
        }
        try {
            clip.stop();
            return true;
        }
        catch (Exception e) {
            J2DM_Console.getInstance().addLog("J2DM_SoundManager::stop", "Could not stop " + fnm, J2DM_ConsoleMessageTypes.LOG);
            return false;
        }
    }

    public void close() {
        Enumeration keys = this._clipsMap.keys();
        while (keys.hasMoreElements()) {
            this.close((String)keys.nextElement());
        }
    }

    public void close(String fnm) {
        Player clip = (Player)this._clipsMap.get(fnm);
        if (clip != null) {
            try {
                clip.removePlayerListener((PlayerListener)this);
                clip.stop();
                clip.deallocate();
                clip.close();
                clip = null;
                this._clipsMap.remove(fnm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playerUpdate(Player clip, String event, Object eventData) {
        try {
            if (event.equals("deviceUnavailable")) {
                this._isDeviceAvailable = false;
            } else if (event.equals("deviceAvailable")) {
                this._isDeviceAvailable = true;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

