/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.persistentData;

import tv.ingames.j2dm.ingames.J2DM_Ingames;
import tv.ingames.j2dm.persistentData.J2DM_RMSException;
import tv.ingames.j2dm.persistentData.J2DM_RecordManager;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;

public class J2DM_RecordLevel {
    private static J2DM_RecordLevel _instance;
    private String rmsRecordLevel = "rmsRecordLevel";

    private J2DM_RecordLevel() {
    }

    public static J2DM_RecordLevel getInstance() {
        if (_instance == null) {
            _instance = new J2DM_RecordLevel();
        }
        return _instance;
    }

    public int getRecordLevelByModeGame(int modeGame) {
        int lastLevel = 0;
        J2DM_RecordManager rc = J2DM_RecordManager.getInstance();
        String stLastLevel = "";
        try {
            stLastLevel = rc.readData(String.valueOf(this.rmsRecordLevel) + "_" + J2DM_Ingames.getInstance().getMyGameData().getGameId() + "_" + modeGame);
            if (!stLastLevel.equals("")) {
                lastLevel = Integer.parseInt(this.getStringUntilEnter(stLastLevel));
            }
        }
        catch (J2DM_RMSException e) {
            J2DM_Console.getInstance().addLog("J2DM_RecordLevel::getRecordLevelByModeGame", "The level does not exist:" + stLastLevel, J2DM_ConsoleMessageTypes.WARNING);
        }
        return lastLevel;
    }

    public void recordLevelByModeGame(int modeGame, int lastLevel) {
        J2DM_RecordManager rc = J2DM_RecordManager.getInstance();
        try {
            rc.saveData(String.valueOf(this.rmsRecordLevel) + "_" + J2DM_Ingames.getInstance().getMyGameData().getGameId() + "_" + modeGame, String.valueOf(lastLevel));
        }
        catch (J2DM_RMSException e) {
            J2DM_Console.getInstance().addLog("J2DM_RecordLevel::recordLevelByModeGame", "Error saving level:" + this.rmsRecordLevel + modeGame, J2DM_ConsoleMessageTypes.ERROR);
        }
    }

    private String getStringUntilEnter(String lastLevel) {
        String newString = "";
        int length = lastLevel.length();
        int i = 0;
        char character = ' ';
        if (i < length) {
            character = lastLevel.charAt(i);
        }
        while (i < length && character != '\n') {
            newString = String.valueOf(newString) + character;
            if (++i >= length) continue;
            character = lastLevel.charAt(i);
        }
        return newString;
    }
}

