/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display;

import java.util.Vector;
import tv.ingames.j2dm.display.J2DM_Display;
import tv.ingames.j2dm.display.J2DM_GameObject;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_DisplayContainer
extends J2DM_GameObject {
    protected Vector _elements;

    public J2DM_DisplayContainer(String name) {
        super(name);
    }

    public J2DM_DisplayContainer() {
    }

    public int getChildCount() {
        int cantChilds = this._elements.size();
        int loopChilds = this._elements.size();
        int i = 0;
        while (i < loopChilds) {
            Object element = this._elements.elementAt(i);
            cantChilds = element instanceof J2DM_DisplayContainer ? (cantChilds += ((J2DM_DisplayContainer)element).getChildCount()) : ++cantChilds;
            ++i;
        }
        return cantChilds;
    }

    protected void init(String name) {
        super.init(name);
        this._elements = new Vector();
    }

    public void setX(int x) {
        super.setX(x);
        this.refreshXChildrens();
    }

    public void setY(int y) {
        super.setY(y);
        this.refreshYChildrens();
    }

    public void setXGlobal(int xGlobal) {
        super.setXGlobal(xGlobal);
        this.refreshXChildrens();
    }

    public void setYGlobal(int yGlobal) {
        super.setYGlobal(yGlobal);
        this.refreshYChildrens();
    }

    public void setMask(J2DM_Rect rect) {
        super.setMask(rect);
        this.refreshMaskChildrens();
    }

    public void setMaskGlobal(J2DM_Rect rect) {
        super.setMaskGlobal(rect);
        this.refreshMaskGlobalChildrens();
    }

    public boolean addChild(J2DM_Display element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::addChild", "The element to be added can not be null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (element.getHasParent()) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::addChild", "The element is attached to another DisplayContainer", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._elements.addElement(element);
        element.setHasParent(true);
        element.setXGlobal(this._x + this._xGlobal);
        element.setYGlobal(this._y + this._yGlobal);
        if (this._maskLocal != null) {
            this.refreshMaskChildrens();
        } else if (this._maskGlobal != null) {
            this.refreshMaskGlobalChildrens();
        }
        return true;
    }

    public boolean addChildAt(J2DM_Display element, int index) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::addChild", "The element to be added can not be null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (element.getHasParent()) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::addChild", "The element is attached to another DisplayContainer", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (index < 0 || index >= this._elements.size()) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::addChild", "Invalid Index, index:" + index, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._elements.insertElementAt(element, index);
        element.setHasParent(true);
        element.setXGlobal(this._x + this._xGlobal);
        element.setYGlobal(this._y + this._yGlobal);
        if (this._maskLocal != null) {
            this.refreshMaskChildrens();
        } else if (this._maskGlobal != null) {
            this.refreshMaskGlobalChildrens();
        }
        return true;
    }

    public boolean removeChild(J2DM_Display element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::removeChild", "The element to be removed can not be null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (!this._elements.contains(element)) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::removeChild", "The element isn't in the container", J2DM_ConsoleMessageTypes.WARNING);
            return false;
        }
        this._elements.removeElement(element);
        element.setHasParent(false);
        return true;
    }

    public J2DM_DisplayContainer getChildAt(int ind) {
        if (ind < 0 || ind >= this._elements.size()) {
            J2DM_Console.getInstance().addLog("J2DM_DisplayContainer::getChild", "invalid ind, ind=" + ind, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        return (J2DM_DisplayContainer)this._elements.elementAt(ind);
    }

    public J2DM_DisplayContainer getChildByName(String name) {
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            String actualName = ((J2DM_DisplayContainer)this._elements.elementAt(i)).getName();
            if (actualName == name) {
                return (J2DM_DisplayContainer)this._elements.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public boolean contains(J2DM_Display element) {
        return this._elements.contains(element);
    }

    public void draw(J2DM_Graphics g) {
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            J2DM_Display element = (J2DM_Display)this._elements.elementAt(i);
            if (element.getVisible()) {
                element.draw(g);
            }
            ++i;
        }
    }

    public void destroy() {
        super.destroy();
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            ((J2DM_Display)this._elements.elementAt(i)).destroy();
            ++i;
        }
        this._elements.removeAllElements();
    }

    private void refreshXChildrens() {
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            ((J2DM_Display)this._elements.elementAt(i)).setXGlobal(this._x + this._xGlobal);
            ++i;
        }
    }

    private void refreshYChildrens() {
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            ((J2DM_Display)this._elements.elementAt(i)).setYGlobal(this._y + this._yGlobal);
            ++i;
        }
    }

    private void refreshMaskChildrens() {
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            ((J2DM_Display)this._elements.elementAt(i)).setMaskGlobal(this._maskLocal);
            ++i;
        }
    }

    private void refreshMaskGlobalChildrens() {
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            ((J2DM_Display)this._elements.elementAt(i)).setMaskGlobal(this._maskGlobal);
            ++i;
        }
    }
}

