/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.utils;

import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_FrameBitmapData;
import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_StructSecuence;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Point;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_SpriteTools {
    public static J2DM_StructSecuence createSecuence(J2DM_Image image, J2DM_Rect[] rectArray, J2DM_Point[] pointArray) {
        if (rectArray == null || pointArray == null || rectArray.length != pointArray.length) {
            J2DM_Console.getInstance().addLog("J2DM_StructSecuence::createSecuence", "invalid pointArray or rectArray", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        J2DM_StructSecuence _secuence = new J2DM_StructSecuence();
        int cant = rectArray.length;
        int i = 0;
        while (i < cant) {
            J2DM_FrameBitmapData frame = new J2DM_FrameBitmapData(image, rectArray[i], pointArray[i]);
            _secuence.addFrame(frame);
            ++i;
        }
        return _secuence;
    }

    public static J2DM_StructSecuence createSecuence(J2DM_Image image, J2DM_Rect[] rectArray, int anchorX, int anchorY) {
        if (rectArray == null) {
            J2DM_Console.getInstance().addLog("J2DM_StructSecuence::createSecuence", "invalid pointArray or rectArray", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        J2DM_StructSecuence _secuence = new J2DM_StructSecuence();
        int cant = rectArray.length;
        int i = 0;
        while (i < cant) {
            J2DM_Point point = new J2DM_Point(J2DM_Image.getXRegpoint(rectArray[i], anchorX), J2DM_Image.getYRegpoint(rectArray[i], anchorY));
            J2DM_FrameBitmapData frame = new J2DM_FrameBitmapData(image, rectArray[i], point);
            _secuence.addFrame(frame);
            ++i;
        }
        return _secuence;
    }

    public static J2DM_Rect[] getRectVectorFromImageSize(int width, int height, int maxX, int maxY, int start, int end) {
        int totalFrames = maxX * maxY;
        if (start < 0 || start >= totalFrames || end < 0 || end >= totalFrames || end < start) {
            J2DM_Console.getInstance().addLog("J2DM_StructSecuence::getRectVectorFromImageSize", "invalid start or end index, start=" + start + " end=" + end, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        int widthRect = width / maxX;
        int heightRect = height / maxY;
        int cantFrames = end - start + 1;
        J2DM_Rect[] rect = new J2DM_Rect[cantFrames];
        int i = 0;
        while (i < cantFrames) {
            rect[i] = new J2DM_Rect(widthRect * ((i + start) % maxX), heightRect * ((i + start) / maxX), widthRect - 1, heightRect - 1);
            ++i;
        }
        return rect;
    }
}

