/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.cubeMatch.gamePlay.modes;

import java.util.Vector;
import tv.ingames.cubeMatch.application.ScreenParametersApplication;
import tv.ingames.cubeMatch.gamePlay.SettingsGamePlay;
import tv.ingames.cubeMatch.gamePlay.levels.LevelsAction;
import tv.ingames.cubeMatch.gamePlay.modes.AbstractGamePlayMode;
import tv.ingames.j2dm.display.textfield.J2DM_NumberField;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.gameplay.IStatePlaying;
import tv.ingames.j2dm.media.languaje.J2DM_Language;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class PlayingModeAction
extends AbstractGamePlayMode {
    private int _cubesLeft;
    private int _timeLimit;
    private J2DM_NumberField _textfieldCubesLeft;
    private J2DM_TextField _textfieldTimeLeft;

    public PlayingModeAction(IStatePlaying statePlaying, J2DM_Image imageBackGround, J2DM_Graphics graphicsBackGround) {
        super(statePlaying, imageBackGround, graphicsBackGround);
        this._levelManager = new LevelsAction();
        SettingsGamePlay.getInstance().setTotalLevels(this._levelManager.getCantLevels());
    }

    protected boolean canClick() {
        return !this.checkIfThereIsAnyBallMoving();
    }

    protected boolean canMoveHorizontal() {
        return false;
    }

    protected boolean canAddNewBrickonExplode() {
        return true;
    }

    protected void callInitLevel_2() {
        this._cubesLeft = this._dataLevel.cantBallsToDestroy;
        this._timeLimit = this._dataLevel.timeDownGameOver;
        J2DM_TextField textField = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(90));
        textField.setX(ScreenParametersApplication.PLY_TXT_CUBES_LEFT_X);
        textField.setY(ScreenParametersApplication.PLY_TXT_CUBES_LEFT_Y);
        textField.setAnchorX(1);
        textField.setAnchorY(2);
        textField.draw(this._graphicsBackGround);
        textField.setText(J2DM_Language.getInstance().getTextByKey(91));
        textField.setX(ScreenParametersApplication.PLY_TXT_TIME_LEFT_X);
        textField.setY(ScreenParametersApplication.PLY_TXT_TIME_LEFT_Y);
        textField.draw(this._graphicsBackGround);
        textField.destroy();
        textField = null;
        this._textfieldCubesLeft = new J2DM_NumberField(ScreenParametersApplication.NUMBER_FONT_GAME, this._cubesLeft);
        this._textfieldCubesLeft.setX(ScreenParametersApplication.PLY_VALUE_CUBES_LEFT_X);
        this._textfieldCubesLeft.setY(ScreenParametersApplication.PLY_VALUE_CUBES_LEFT_Y);
        this._textfieldCubesLeft.setAnchorX(1);
        this._textfieldCubesLeft.setAnchorY(2);
        J2DM_Stage.getInstance().addElement(this._textfieldCubesLeft, 2);
        this._textfieldTimeLeft = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, J2DM_StringTools.getTimeFromMilliseconds(this._timeLimit));
        this._textfieldTimeLeft.setX(ScreenParametersApplication.PLY_VALUE_TIME_LEFT_X);
        this._textfieldTimeLeft.setY(ScreenParametersApplication.PLY_VALUE_TIME_LEFT_Y);
        this._textfieldTimeLeft.setAnchorX(1);
        this._textfieldTimeLeft.setAnchorY(2);
        J2DM_Stage.getInstance().addElement(this._textfieldTimeLeft, 2);
    }

    protected boolean canDestroyOneBall() {
        return false;
    }

    protected void callDestroyVectorOfBalls(Vector structBalls) {
        if (structBalls != null) {
            this._cubesLeft -= structBalls.size();
            if (this._cubesLeft < 0) {
                this._cubesLeft = 0;
            }
        }
        this._textfieldCubesLeft.setTextNumber(this._cubesLeft);
    }

    public void destroy() {
        J2DM_Stage.getInstance().removeElement(this._textfieldCubesLeft, 2);
        this._textfieldCubesLeft.destroy();
        this._textfieldCubesLeft = null;
        J2DM_Stage.getInstance().removeElement(this._textfieldTimeLeft, 2);
        this._textfieldTimeLeft.destroy();
        this._textfieldTimeLeft = null;
        super.destroy();
    }

    protected boolean hasLevelFinished() {
        return !this.checkIfThereIsAnyBallMoving() && this._cubesLeft <= 0;
    }

    protected void takeScreenShot(J2DM_Graphics graphics) {
        super.takeScreenShot(graphics);
        this._textfieldCubesLeft.draw(graphics);
        this._textfieldTimeLeft.draw(graphics);
    }

    protected boolean isGameOver() {
        long timeNow = System.currentTimeMillis();
        int timeLeft = (int)((long)this._timeLimit - (timeNow - this._timePause - this._timeStart));
        if (timeLeft < 0) {
            timeLeft = 0;
        }
        this._textfieldTimeLeft.setText(J2DM_StringTools.getTimeFromMilliseconds(timeLeft));
        return !this.checkIfThereIsAnyBallMoving() && timeLeft <= 0 && this._cubesLeft > 0;
    }
}

