/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.GameManager;
import com.twistfuture.Game.LevelCanvas;
import com.twistfuture.Game.ScoreCanvas;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.app.GeneralInfo;
import com.twistfuture.utility.Button;
import com.twistfuture.utility.Timer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainCanvas
extends Canvas
implements TwistMidlet.Callback,
Button.ButtonCallback {
    private final Image bg;
    private final GameManager manager;
    private ScoreCanvas scoreCanvas;
    private final Timer timer;
    private final Button back;
    private final String levelStr;
    private final String levelNo;
    private final Font font;
    private final int levelStrX;
    public static boolean threadStatus;

    public MainCanvas() {
        this.levelStr = "Level";
        this.setFullScreenMode(true);
        this.bg = GeneralFunction.createImage("maincanvas/bg.png");
        this.manager = new GameManager();
        this.timer = new Timer();
        if (!GeneralInfo.ISASHA) {
            this.back = new Button(GeneralFunction.createImage("general/backun.png"), GeneralFunction.createImage("general/backp.png"), 0, 0, 0, this);
            this.back.SetCordinate(this.getWidth() - this.back.getWidth(), this.getHeight() - this.back.getHeight());
        } else {
            this.back = null;
            this.addCommand(new Command("back", 2, 0));
            this.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    MainCanvas.this.buttonClicked(0);
                }
            });
        }
        this.levelNo = "" + LevelCanvas.mCurrentLevel;
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.levelStrX = 390 - this.font.stringWidth("Level");
    }

    protected void showNotify() {
        threadStatus = true;
        this.startThread();
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        g.setFont(this.font);
        g.setColor(0xFFFFFF);
        g.drawString("Level", this.levelStrX, 105, 0);
        g.drawString(this.levelNo, this.levelStrX + 5, 130, 0);
        this.timer.paint(g);
        if (!GeneralInfo.ISASHA) {
            this.back.paint(g);
        }
        this.manager.paint(g);
        if (this.scoreCanvas != null) {
            this.scoreCanvas.paint(g);
        }
    }

    public void buttonClicked(int buttonId) {
        if (buttonId == 0) {
            if (threadStatus) {
                this.timer.setTimeOut(true);
            } else {
                TwistMidlet.mMidlet.showMiddleAd((Displayable)new LevelCanvas());
            }
        }
    }

    public void callRepaint(int x, int y, int width, int height) {
    }

    protected void pointerPressed(int x, int y) {
        if (threadStatus) {
            this.manager.pointerPressed(x, y);
        } else {
            this.scoreCanvas.pointerPressed(x, y);
        }
        if (!GeneralInfo.ISASHA) {
            this.back.pointerPressed(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        if (threadStatus) {
            this.manager.pointerReleased(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        if (threadStatus && x > 60 && x < 340 && y > 10 && y < 340) {
            this.manager.pointerDragged(x, y);
        }
    }

    private void startThread() {
        new Thread(new Runnable(){

            public void run() {
                while (threadStatus) {
                    MainCanvas.this.repaint();
                    GeneralFunction.sleepThread(80);
                    MainCanvas.this.timer.updateTimer();
                    if (!MainCanvas.this.timer.isTimeOut()) continue;
                    GeneralFunction.sleepThread(100);
                    threadStatus = false;
                }
                MainCanvas.this.scoreCanvas = new ScoreCanvas(!MainCanvas.this.timer.isTimeOut(), MainCanvas.this.timer.getRemainingTimeIndex());
                MainCanvas.this.repaint();
            }
        }).start();
    }
}

