/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import com.spice.twozerofoureight.gamescreen.Config;
import com.spice.twozerofoureight.gamescreen.ScaleImage;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class YeloFocus {
    public boolean IsFocus = false;
    private String Focusbutton;
    private String Unfocusbutton;
    private String theme = "";
    private int x_coor;
    private int y_coor;
    private Image button_img;
    private Image button_focus;
    int x1;
    int y1;
    Font font = Font.getFont((int)0, (int)1, (int)0);

    public YeloFocus(String fimg, String unfimg, int xPos, int yPos, String folderName, int buttonImageWidth, int buttonImageHeight) {
        this.Focusbutton = fimg;
        this.Unfocusbutton = unfimg;
        this.theme = folderName;
        this.button_img = ScaleImage.CreateScaledImage(Config.getFolderImage(this.theme, this.Unfocusbutton), Config.DISPLAY_WIDTH * buttonImageWidth / 100, Config.DISPLAY_HEIGHT * buttonImageHeight / 100);
        this.button_focus = ScaleImage.CreateScaledImage(Config.getFolderImage(this.theme, this.Focusbutton), Config.DISPLAY_WIDTH * buttonImageWidth / 100, Config.DISPLAY_HEIGHT * buttonImageHeight / 100);
        this.x_coor = (Config.DISPLAY_WIDTH - this.button_img.getWidth()) * xPos / 100;
        this.y_coor = Config.DISPLAY_HEIGHT * yPos / 100;
    }

    public int getXCordinate() {
        return this.x_coor;
    }

    public int getyCordinates() {
        return this.y_coor;
    }

    public void drawImage(Graphics g, int anchor) {
        g.drawImage(this.button_img, this.x_coor, this.y_coor, anchor);
        if (this.IsFocus) {
            g.drawImage(this.button_focus, this.x_coor, this.y_coor, anchor);
        }
    }

    public void draw(Graphics g, int x, int y, int baseImagewidth, int baseImageHeight, int xpercentage, int ypercentage, String text, int color, int anchor) {
        g.setColor(color);
        this.x1 = x + (baseImagewidth - this.button_img.getWidth()) * xpercentage / 100;
        this.y1 = y + (baseImageHeight - this.button_img.getHeight()) * ypercentage / 100;
        g.drawImage(this.button_img, this.x1, this.y1, anchor);
        if (this.IsFocus) {
            g.drawImage(this.button_focus, this.x1, this.y1, anchor);
        }
        g.drawString(text, this.x1 + (this.button_img.getWidth() - g.getFont().stringWidth(text)) / 2, this.y1 + (this.button_img.getHeight() - g.getFont().getHeight()) / 2, 0);
    }

    public int getX() {
        return this.x1;
    }

    public int getY() {
        return this.y1;
    }

    public int getImageWidth() {
        return this.button_img.getWidth();
    }

    public int getImageHeight() {
        return this.button_img.getHeight();
    }

    public void drawString(Graphics g, String stringName, int color, int anchor) {
        g.setColor(color);
        g.setFont(this.font);
        g.drawString(stringName, this.x_coor + (this.getImageWidth() - g.getFont().stringWidth(stringName)) / 2, this.y_coor + (this.getImageHeight() - g.getFont().getHeight()) / 2, anchor);
    }

    public void setFocus(boolean b) {
        this.IsFocus = b;
    }
}

