/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import com.spice.twozerofoureight.gamescreen.Config;
import com.spice.twozerofoureight.gamescreen.ExitScreen;
import com.spice.twozerofoureight.gamescreen.GameScreen;
import com.spice.twozerofoureight.gamescreen.HelpScreen;
import com.spice.twozerofoureight.gamescreen.MainMidlet;
import com.spice.twozerofoureight.gamescreen.RMSData;
import com.spice.twozerofoureight.gamescreen.ScaleImage;
import com.spice.twozerofoureight.gamescreen.YeloFocus;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HomeScreen
extends Canvas
implements CommandListener {
    public static MainMidlet midlet;
    YeloFocus focus1;
    YeloFocus focus2;
    YeloFocus focus3;
    public static Image homeScreenImage;
    private Command backCommand;
    Alert alert;

    public HomeScreen(MainMidlet midlet) {
        this.setFullScreenMode(true);
        HomeScreen.midlet = midlet;
        homeScreenImage = ScaleImage.CreateScaledImage(Config.getFolderImage("homeScreen", Config.home_bg), Config.DISPLAY_WIDTH, Config.DISPLAY_HEIGHT);
        this.focus1 = new YeloFocus(Config.focusButton, Config.unFocusButton, 50, 50, "homeScreen", 25, 11);
        this.focus2 = new YeloFocus(Config.focusButton, Config.unFocusButton, 50, 65, "homeScreen", 25, 11);
        this.focus3 = new YeloFocus(Config.focusButton, Config.unFocusButton, 50, 80, "homeScreen", 25, 11);
        this.focus1.setFocus(true);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    protected void paint(Graphics g) {
        g.drawImage(homeScreenImage, 0, 0, 0);
        this.focus1.drawImage(g, 0);
        this.focus2.drawImage(g, 0);
        this.focus3.drawImage(g, 0);
        this.focus1.drawString(g, "Play", 0, 0);
        this.focus2.drawString(g, "Help", 0, 0);
        this.focus3.drawString(g, Config.EXIT_TEXT, 0, 0);
    }

    protected void showConfirmation(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    HomeScreen.midlet.display.setCurrent((Displayable)new GameScreen(RMSData.getGridData(), midlet));
                }
                if (c.getLabel().equals("No")) {
                    HomeScreen.this.closeAlert();
                }
            }
        });
        HomeScreen.midlet.display.setCurrent((Displayable)this.alert);
    }

    private void closeAlert() {
        HomeScreen.midlet.display.setCurrent((Displayable)new GameScreen(null, midlet));
        this.alert = null;
    }

    protected void pointerPressed(int x, int y) {
        if (x > this.focus1.getXCordinate() && x < this.focus1.getXCordinate() + this.focus1.getImageWidth() && y > this.focus1.getyCordinates() && y < this.focus1.getyCordinates() + this.focus1.getImageHeight()) {
            System.out.println("hi");
            this.focus1.setFocus(true);
            this.focus2.setFocus(false);
            this.focus3.setFocus(false);
        } else if (x > this.focus2.getXCordinate() && x < this.focus2.getXCordinate() + this.focus2.getImageWidth() && y > this.focus2.getyCordinates() && y < this.focus2.getyCordinates() + this.focus2.getImageHeight()) {
            this.focus1.setFocus(false);
            this.focus2.setFocus(true);
            this.focus3.setFocus(false);
        } else if (x > this.focus3.getXCordinate() && x < this.focus3.getXCordinate() + this.focus3.getImageWidth() && y > this.focus3.getyCordinates() && y < this.focus3.getyCordinates() + this.focus3.getImageHeight()) {
            this.focus1.setFocus(false);
            this.focus2.setFocus(false);
            this.focus3.setFocus(true);
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (x > this.focus1.getXCordinate() && x < this.focus1.getXCordinate() + this.focus1.getImageWidth() && y > this.focus1.getyCordinates() && y < this.focus1.getyCordinates() + this.focus1.getImageHeight()) {
            if (RMSData.doWeHaveAnySavedGameState()) {
                this.showConfirmation("", String.valueOf(Config.replaySavedGameText) + " " + "Your saved game will be discarded if you opt for 'No'.");
            } else {
                RMSData.getGridScore();
                HomeScreen.midlet.display.setCurrent((Displayable)new GameScreen(null, midlet));
            }
        } else if (x > this.focus2.getXCordinate() && x < this.focus2.getXCordinate() + this.focus2.getImageWidth() && y > this.focus2.getyCordinates() && y < this.focus2.getyCordinates() + this.focus2.getImageHeight()) {
            HomeScreen.midlet.display.setCurrent((Displayable)new HelpScreen("Help", Config.helpText, null, midlet));
        } else if (x > this.focus3.getXCordinate() && x < this.focus3.getXCordinate() + this.focus3.getImageWidth() && y > this.focus3.getyCordinates() && y < this.focus3.getyCordinates() + this.focus3.getImageHeight()) {
            HomeScreen.midlet.display.setCurrent((Displayable)new ExitScreen(midlet));
        }
    }

    protected void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                if (this.focus3.IsFocus) {
                    this.focus2.setFocus(true);
                    this.focus3.setFocus(false);
                    this.focus1.setFocus(false);
                } else if (this.focus2.IsFocus) {
                    this.focus1.setFocus(true);
                    this.focus3.setFocus(false);
                    this.focus2.setFocus(false);
                }
                this.repaint();
                break;
            }
            case 6: {
                if (this.focus1.IsFocus) {
                    this.focus2.setFocus(true);
                    this.focus3.setFocus(false);
                    this.focus1.setFocus(false);
                } else if (this.focus2.IsFocus) {
                    this.focus3.setFocus(true);
                    this.focus2.setFocus(false);
                    this.focus1.setFocus(false);
                }
                this.repaint();
                break;
            }
            case 8: {
                if (this.focus1.IsFocus) {
                    HomeScreen.midlet.display.setCurrent((Displayable)new GameScreen(null, midlet));
                    break;
                }
                if (this.focus2.IsFocus) {
                    HomeScreen.midlet.display.setCurrent((Displayable)new HelpScreen("Help", Config.helpText, null, midlet));
                    break;
                }
                if (!this.focus3.IsFocus) break;
                HomeScreen.midlet.display.setCurrent((Displayable)new ExitScreen(midlet));
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            HomeScreen.midlet.display.setCurrent((Displayable)new ExitScreen(midlet));
        }
    }
}

