/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jellyworld.store;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMSData {
    private static RecordStore rs = null;
    public static final String SCORE_RECSTORE = "SCORE";
    public static final String GEM_RECSTORE = "GEM";
    public static final String SOUND_RECSTORE = "SOUND";
    private static long score = 0L;
    private static boolean flag = true;
    static int id;

    public static void openRecStore(String RecordStoreName) {
        try {
            rs = RecordStore.openRecordStore((String)RecordStoreName, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeRecStore() {
        try {
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addRecStore(String RecordStoreName, long value) {
        RMSData.openRecStore(RecordStoreName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(value);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] rec = baos.toByteArray();
        try {
            int id = rs.addRecord(rec, 0, rec.length);
            System.out.println("id hai: " + id);
        }
        catch (RecordStoreException e) {
            System.out.println("addrecord catch");
        }
    }

    public static long readRecRecords(String RecordStoreName, int recordID, int firstValue) {
        RMSData.openRecStore(RecordStoreName);
        try {
            if (rs.getNumRecords() != 0) {
                if (rs.getRecord(recordID) != null) {
                    score = RMSData.byteArraytoInt(rs.getRecord(recordID));
                }
            } else {
                RMSData.addRecStore(RecordStoreName, firstValue);
                score = RMSData.byteArraytoInt(rs.getRecord(recordID));
                System.out.println(" added");
            }
        }
        catch (Exception e) {
            System.out.println(" readRecRecords catch");
        }
        RMSData.closeRecStore();
        return score;
    }

    public static long getScore() {
        return RMSData.readRecRecords(SCORE_RECSTORE, 1, 0);
    }

    public static void setScore(long score) {
        RMSData.updateRecRecords(SCORE_RECSTORE, 1, score);
    }

    public static boolean isSoundEnabled() {
        return RMSData.readRecRecords(SOUND_RECSTORE, 1, 1) == 1L;
    }

    public static void setSoundEnabled(boolean isEnabled) {
        if (isEnabled) {
            RMSData.updateRecRecords(SOUND_RECSTORE, 1, 1L);
        } else {
            RMSData.updateRecRecords(SOUND_RECSTORE, 1, 0L);
        }
    }

    public static void updateRecRecords(String recordStoreName, int recordId, long score) {
        RMSData.openRecStore(recordStoreName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(score);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] rec = baos.toByteArray();
        try {
            rs.setRecord(recordId, rec, 0, rec.length);
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public static void incrementNoOfGems(int numGems) {
        if (RMSData.readRecRecords(GEM_RECSTORE, 1, 0) == 0L || RMSData.readRecRecords(GEM_RECSTORE, 1, 0) != 0L) {
            RMSData.updateRecRecords(GEM_RECSTORE, 1, RMSData.readRecRecords(GEM_RECSTORE, 1, 0) + (long)numGems);
        }
    }

    public static long getNoOfGems() {
        return RMSData.readRecRecords(GEM_RECSTORE, 1, 0);
    }

    public static void reduceGems(int numGems) {
        if (RMSData.readRecRecords(GEM_RECSTORE, 1, 0) > 0L) {
            RMSData.updateRecRecords(GEM_RECSTORE, 1, RMSData.readRecRecords(GEM_RECSTORE, 1, 0) - (long)numGems);
        }
    }

    public static int byteArraytoInt(byte[] by) {
        int value = 0;
        int i = 0;
        while (i < by.length) {
            value = (value << 8) + (by[i] & 0xFF);
            ++i;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteRecRecords() {
        RecordEnumeration re = null;
        try {
            re = rs.enumerateRecords(null, null, true);
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        int rid = 0;
        try {
            while (true) {
                if (!re.hasNextElement()) {
                    return;
                }
                rid = re.nextRecordId();
                try {
                    rs.deleteRecord(rid);
                }
                catch (RecordStoreNotOpenException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidRecordIDException ex) {
                    ex.printStackTrace();
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
    }
}

