/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import com.inode.pictorama.Level;
import com.inode.pictorama.MenuQuest;
import com.inode.utils.SSFunctions;
import com.inode.utils.SSMath;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BoardManager {
    GameEngine ge;
    public static final int ROBOT_OFFSET_X = 35;
    public static final int ROBOT_OFFSET_Y = 47;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int MAX_CELL_SIZE = 20;
    public static final int MIN_CELL_SIZE = 5;
    public static final int RATIO_SIZE_BORDER = 6;
    public static final int RATIO_SPACING = 2;
    public static final int ZOOM_IN = -1;
    public static final int ZOOM_OUT = 1;
    public static final int SMALL = 0;
    public static final int BIG = 1;
    public static final byte CELL_BLANK = 0;
    public static final byte CELL_MARKED = 1;
    public static final byte CELL_CROSS = 2;
    public static final int REFERENCE_BOARD = 0;
    public static final int REFERENCE_POINTER = 1;
    public static final int BOARD_WAITING = 0;
    public static final int BOARD_PLAYING = 1;
    public static final int BOARD_COMPLETED_A = 2;
    public static final int BOARD_COMPLETED_B = 3;
    public static final int BOARD_SOLVED = 4;
    public static final int BOARD_MENU_IN_GAME = 5;
    public static final int BOARD_PAUSE = 6;
    public static final int BOARD_FAILED = 7;
    public static final int BOARD_USE_ITEM = 8;
    public static final int BOARD_PRESS_ANY_KEY = 9;
    public static final int BOARD_BLOCK_RESUME = 10;
    public static final int BOARD_HELP_IN_GAME = 11;
    public int boardState = 9;
    public int boardFrames = 0;
    public int boardFramesAux = 0;
    public int skin = 0;
    public static final int[][] skinEmptyCells = new int[][]{{14215404, 13426920, 15003888, 14215404}, {16697996, 16706956, 16706956, 16697996}, {14219500, 13431016, 0xF0F4F0, 14219500}};
    public static final int[][] skinPanelColors = new int[][]{{11848932, 15003888}, {16706956, 16697996}, {11855052, 15790308}};
    public static final int[][] skinPointer = new int[][]{{0xFF0000, 0xFF4444, 0xFF7777, 0xFFAAAA}, {0xFF0000, 0xFF4444, 0xFF7777, 0xFFAAAA}, {0xFF0000, 0xFF4444, 0xFF7777, 0xFFAAAA}};
    public String boardFileName = null;
    public static int boardX = 0;
    public static int boardY = 0;
    public static int boardXfinal = 0;
    public static int boardYfinal = 0;
    public static int boardXfixed = 0;
    public static int boardYfixed = 0;
    public static int boardMargin = 0;
    public static int miniMapSize = 40;
    public static boolean zoomEnabled = true;
    public static boolean zooming = false;
    public static boolean scroll = false;
    public static int pointerCol = 0;
    public static int pointerRow = 0;
    public static int cellSizeSolution = 0;
    public static int cellSizeFinal = 0;
    public static int cellSize = 0;
    public static int cellBorder = 0;
    public static int cellSpacing = 0;
    public static int maxCellSize = 0;
    public static int minCellSize = 0;
    public static int boardSize = 0;
    public static int boardPalette = 0;
    public static int zoomState = 0;
    public static int scrollSpeed = 6;
    public static byte[] dataInput = null;
    public static byte[] dataBW = null;
    public static byte[] dataColor = null;
    public static int[][] panelRows = null;
    public static int[][] panelCols = null;
    public static boolean[][] panelRowsFill = null;
    public static boolean[][] panelColsFill = null;
    public static int panelRowsMaxIndex = 0;
    public static int panelColsMaxIndex = 0;
    public static int panelMaxIndex = 0;
    public static Image numbersImg = null;
    public static int numbersWidth = 0;
    public static int numbersHeight = 0;
    public static int[] bonusX = new int[32];
    public static int[] bonusY = new int[32];
    public static long[] bonusTimestamp = new long[32];
    public long[] bonusDuration = new long[32];
    public static int[] bonusType = new int[32];
    public static int bonusIndex = 0;
    public int itemSelected = 0;
    public long[] itemAnimateTime = new long[5];
    byte[] levelData = null;
    byte[] patternHorizontal = null;
    byte[] patternVertical = null;
    int[] inputPatternH = null;
    int[] inputPatternV = null;
    int[] output = null;
    int[] outputAux = null;
    int auxInt = 0;
    long auxLong = 0L;
    String auxString = "";
    public int loadIndex;

    public BoardManager(GameEngine _ge, String fileName) {
        this.ge = _ge;
        System.out.println("BoardManager(" + fileName + ")");
        this.ge.auxString = "BoardManager()";
        this.initLevel(fileName);
    }

    public void initLevel(String fileName) {
        System.out.println("BoardManager.initLevel(" + fileName + ")");
        for (int i = 0; i < bonusTimestamp.length; ++i) {
            BoardManager.bonusTimestamp[i] = 0L;
            this.bonusDuration[i] = 0L;
        }
        this.loadLevel(fileName);
        this.optimizeBoard();
        if (this.ge.sound.isSound(this.ge.soundMusic)) {
            this.ge.sound.stopSound(this.ge.soundMusic);
        }
    }

    public void unload() {
        this.itemAnimateTime = null;
        this.patternHorizontal = null;
        this.patternVertical = null;
    }

    public int getBoardSize() {
        return (boardSize + panelMaxIndex) * cellSize + (boardSize + panelMaxIndex - 1) * cellSpacing;
    }

    public int getPanelSize() {
        return panelMaxIndex * cellSize + (panelMaxIndex - 1) * cellSpacing;
    }

    public int getCellsX() {
        return boardX + panelMaxIndex * (cellSize + cellSpacing);
    }

    public int getCellsY() {
        return boardY + panelMaxIndex * (cellSize + cellSpacing);
    }

    public int getPointerX() {
        return boardX + (panelMaxIndex + pointerCol) * (cellSize + cellSpacing);
    }

    public int getPointerY() {
        return boardY + (panelMaxIndex + pointerRow) * (cellSize + cellSpacing);
    }

    public int getPointerXcenter() {
        return this.getPointerX() + cellSize / 2;
    }

    public int getPointerYcenter() {
        return this.getPointerY() + cellSize / 2;
    }

    public void setBoardState(int _state) {
        this.boardFramesAux = 0;
        if (this.ge.configIsLowPerformance) {
            this.boardFramesAux = 100;
        }
        this.boardState = _state;
        switch (_state) {
            case 1: {
                break;
            }
            case 2: {
                this.auxInt = 0;
                boardX = this.getCellsX();
                boardY = this.getCellsY();
                break;
            }
            case 3: {
                this.auxInt = 0;
                break;
            }
            case 7: {
                this.auxInt = 0;
                boardX = this.getCellsX();
                boardY = this.getCellsY();
                break;
            }
            case 11: {
                this.auxInt = 0;
            }
        }
    }

    public void setCellSize(int _pixels) {
        int oldBoardSize = this.getBoardSize();
        int oldPointerXcenter = this.getPointerXcenter();
        int oldPointerYcenter = this.getPointerYcenter();
        int zoom = 0;
        int step = 0;
        cellSize = Math.max(minCellSize, Math.min(_pixels, maxCellSize));
        cellBorder = _pixels / 6;
        cellSpacing = Math.max(1, cellBorder / 2);
        if (oldBoardSize != this.getBoardSize()) {
            step = oldBoardSize - this.getBoardSize();
            zoom = step / Math.abs(step);
            step = Math.abs(step);
        }
        boardX += zoom * step;
        boardY += zoom * step;
        int diff = this.getPointerXcenter() - oldPointerXcenter;
        boardX -= diff;
        diff = this.getPointerYcenter() - oldPointerYcenter;
        boardY -= diff;
    }

    public void setPointerCell(int _row, int _col) {
        pointerRow = Math.max(0, Math.min(_row, boardSize - 1));
        pointerCol = Math.max(0, Math.min(_col, boardSize - 1));
    }

    public int setItemSelected(int _item) {
        if (_item < 0) {
            _item = 4;
        }
        if (_item >= 5) {
            _item = 0;
        }
        this.itemAnimateTime[this.itemSelected] = System.currentTimeMillis();
        this.itemAnimateTime[_item] = System.currentTimeMillis();
        this.itemSelected = _item;
        return _item;
    }

    public int setUseItemSelected(int _item) {
        if (_item < 0) {
            _item = 5;
        }
        if (_item >= 6) {
            _item = 0;
        }
        this.itemSelected = _item;
        return _item;
    }

    public boolean checkLevelCompleted() {
        for (int i = 0; i < boardSize * boardSize; ++i) {
            if (dataBW[i] != 1 || dataInput[i] == 1) continue;
            return false;
        }
        return true;
    }

    public void useItemShowCol() {
        int col = SSMath.rand(0, boardSize - 1);
        for (int i = 0; i < boardSize; ++i) {
            BoardManager.dataInput[i * BoardManager.boardSize + col] = dataBW[i * boardSize + col];
            if (dataInput[i * boardSize + col] == 0) {
                BoardManager.dataInput[i * BoardManager.boardSize + col] = 2;
            }
            this.checkPatterns(i, col);
        }
    }

    public void useItemShowRow() {
        int row = SSMath.rand(0, boardSize - 1);
        for (int i = 0; i < boardSize; ++i) {
            BoardManager.dataInput[row * BoardManager.boardSize + i] = dataBW[row * boardSize + i];
            if (dataInput[row * boardSize + i] == 0) {
                BoardManager.dataInput[row * BoardManager.boardSize + i] = 2;
            }
            this.checkPatterns(row, i);
        }
    }

    public void useItemBomd() {
        int row = SSMath.rand(0, boardSize - 3);
        int col = SSMath.rand(0, boardSize - 3);
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                BoardManager.dataInput[(row + i) * BoardManager.boardSize + col + j] = dataBW[(row + i) * boardSize + col + j];
                if (dataInput[(row + i) * boardSize + col + j] == 0) {
                    BoardManager.dataInput[(row + i) * BoardManager.boardSize + col + j] = 2;
                }
                this.checkPatterns(i, j);
            }
        }
    }

    public void movePointer(int _direction) {
        switch (_direction) {
            case 0: {
                this.setPointerCell(pointerRow - 1, pointerCol);
                break;
            }
            case 1: {
                this.setPointerCell(pointerRow + 1, pointerCol);
                break;
            }
            case 2: {
                this.setPointerCell(pointerRow, pointerCol - 1);
                break;
            }
            case 3: {
                this.setPointerCell(pointerRow, pointerCol + 1);
            }
        }
    }

    public boolean markCell(byte _value, boolean _forced) {
        boolean output;
        boolean bl = output = _value == dataBW[pointerRow * boardSize + pointerCol];
        if (_forced) {
            BoardManager.dataInput[BoardManager.pointerRow * BoardManager.boardSize + BoardManager.pointerCol] = _value;
        } else {
            if (_value == 2 && dataInput[pointerRow * boardSize + pointerCol] == 2) {
                _value = 0;
            } else if (_value == 1 && dataInput[pointerRow * boardSize + pointerCol] == 1) {
                _value = 0;
            }
            BoardManager.dataInput[BoardManager.pointerRow * BoardManager.boardSize + BoardManager.pointerCol] = _value;
            this.checkPatterns(pointerRow, pointerCol);
        }
        return output;
    }

    public byte getCellDataInput() {
        return dataInput[pointerRow * boardSize + pointerCol];
    }

    public byte getCellDataBW() {
        return dataBW[pointerRow * boardSize + pointerCol];
    }

    public byte[] getDataColor() {
        return dataColor;
    }

    public void zoomChange() {
        if (cellSizeFinal == cellSize) {
            zooming = false;
            zoomState = (zoomState + 1) % 2;
        } else {
            int diff = cellSizeFinal - cellSize;
            if (diff > 0) {
                this.zoomIn();
            } else {
                this.zoomOut();
            }
        }
        scroll = false;
        if (this.getBoardSize() > 240 - 2 * boardMargin) {
            scroll = true;
        }
        if (this.getBoardSize() > 320 - 2 * boardMargin) {
            scroll = true;
        }
    }

    public void zoomOut() {
        this.setCellSize(cellSize - 1);
    }

    public void zoomIn() {
        this.setCellSize(cellSize + 1);
    }

    public void scroll(int _toX, int _toY, int _reference) {
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        switch (_reference) {
            case 0: {
                diffX = _toX - boardX;
                diffY = _toY - boardY;
                break;
            }
            case 1: {
                diffX = _toX - this.getPointerXcenter();
                diffY = _toY - this.getPointerYcenter();
            }
        }
        boardXfinal = boardX + diffX;
        boardYfinal = boardY + diffY;
        if (this.getBoardSize() > 240 - 2 * boardMargin) {
            if (boardXfinal > boardMargin) {
                boardXfinal = boardMargin;
                diffX = boardXfinal - boardX;
            } else if (boardXfinal < 240 - boardMargin - this.getBoardSize()) {
                boardXfinal = 240 - boardMargin - this.getBoardSize();
                diffX = boardXfinal - boardX;
            }
        } else {
            boardXfinal = boardXfixed;
            diffX = boardXfinal - boardX;
        }
        if (this.getBoardSize() > 320 - 2 * boardMargin) {
            if (boardYfinal > boardMargin) {
                boardYfinal = boardMargin;
                diffY = boardYfinal - boardY;
            } else if (boardYfinal < 320 - boardMargin - this.getBoardSize()) {
                boardYfinal = 320 - boardMargin - this.getBoardSize();
                diffY = boardYfinal - boardY;
            }
        } else {
            boardYfinal = boardYfixed;
            diffY = boardYfinal - boardY;
        }
        if (boardXfinal != boardX) {
            step = Math.max(1, Math.abs(diffX / scrollSpeed));
            if (Math.abs(diffX) < step) {
                boardX = boardXfinal;
            } else if (diffX > 0) {
                boardX += step;
            } else if (diffX < 0) {
                boardX -= step;
            }
        }
        if (boardYfinal != boardY) {
            step = Math.max(1, Math.abs(diffY / scrollSpeed));
            if (Math.abs(diffY) < step) {
                boardY = boardYfinal;
            } else if (diffY > 0) {
                boardY += step;
            } else if (diffY < 0) {
                boardY -= step;
            }
        }
    }

    public void paint(Graphics _g) {
        switch (this.boardState) {
            case 1: {
                this.paintBackground(_g);
                this.paintPanels(_g);
                this.paintBoardCells(_g);
                this.paintPointer(_g);
                this.paintPanelOverHorizontal(_g, pointerRow - 1, false);
                this.paintPanelOverHorizontal(_g, pointerRow, true);
                this.paintPanelOverHorizontal(_g, pointerRow + 1, false);
                this.paintPanelOverVertical(_g, pointerCol - 1, false);
                this.paintPanelOverVertical(_g, pointerCol, true);
                this.paintPanelOverVertical(_g, pointerCol + 1, false);
                this.ge.gcTime = this.ge.clock.getMilliseconds();
                this.paintScoreboard(_g, this.ge.clock.getTimeString(3));
                this.paintAnimations(_g);
                GameCanvas cfr_ignored_0 = this.ge.gc;
                if (boardY + this.getBoardSize() >= 320 - GameCanvas.resFonts[1].getFontHeight() - 2) break;
                if (zoomEnabled) {
                    GameCanvas cfr_ignored_1 = this.ge.gc;
                    GameCanvas.resFonts[1].drawString(_g, this.ge.lang[48].toCharArray(), 2, 318, 68);
                }
                GameCanvas cfr_ignored_2 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.lang[49].toCharArray(), 238, 318, 72);
                break;
            }
            case 2: {
                this.paintCompletedA(_g);
                break;
            }
            case 3: {
                this.paintCompletedB(_g);
                break;
            }
            case 7: {
                this.paintFailed(_g);
                break;
            }
            case 5: {
                this.paintMenuInGame(_g);
                break;
            }
            case 11: {
                this.paintInGameHelp(_g);
                break;
            }
            case 8: {
                this.paintUseItem(_g);
                break;
            }
            case 9: {
                this.paintPressAnyKey(_g);
                break;
            }
            case 10: {
                this.paintBlockResume(_g);
            }
        }
        ++this.boardFrames;
        ++this.boardFramesAux;
    }

    public void paintBackground(Graphics _g) {
        this.ge.gc.resetClip(_g);
        this.ge.gc.paintBackground(_g);
        _g.setColor(11058380);
        int squareSize = boardSize * (cellSize + cellSpacing);
        _g.fillRect(this.getCellsX() - 1, this.getCellsY() - 1, squareSize, squareSize);
    }

    public void paintPanels(Graphics _g) {
        int j;
        int i;
        int des = 0;
        int type = 0;
        for (i = 0; i < panelCols.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX + (panelMaxIndex + i) * (cellSize + cellSpacing), boardY, cellSize, this.getPanelSize());
            des = panelMaxIndex - panelCols[i].length;
            for (j = 0; j < panelCols[i].length; ++j) {
                type = 0;
                if (i == pointerCol - 1 || i == pointerCol + 1) {
                    type = 2;
                }
                if (i == pointerCol) {
                    type = 3;
                }
                if (panelColsFill[i][j]) {
                    type = 1;
                }
                this.drawNumber(_g, panelCols[i][j], type, boardX + (panelMaxIndex + i) * (cellSize + cellSpacing), boardY + (des + j) * (cellSize + cellSpacing), cellSize);
            }
        }
        for (i = 0; i < panelRows.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX, boardY + (panelMaxIndex + i) * (cellSize + cellSpacing), this.getPanelSize(), cellSize);
            des = panelMaxIndex - panelRows[i].length;
            for (j = 0; j < panelRows[i].length; ++j) {
                type = 0;
                if (i == pointerRow - 1 || i == pointerRow + 1) {
                    type = 2;
                }
                if (i == pointerRow) {
                    type = 3;
                }
                if (panelRowsFill[i][j]) {
                    type = 1;
                }
                this.drawNumber(_g, panelRows[i][j], type, boardX + (des + j) * (cellSize + cellSpacing), boardY + (panelMaxIndex + i) * (cellSize + cellSpacing), cellSize);
            }
        }
    }

    public void paintPanelOverHorizontal(Graphics g, int _row, boolean _light) {
        this.ge.gc.resetClip(g);
        if (_row < 0 || _row >= boardSize) {
            return;
        }
        int numbersType = 2;
        if (_light) {
            numbersType = 3;
        }
        int numbersOver = 0;
        int numbersFixed = panelRows[_row].length;
        int sizePanel = boardX + (cellSize + cellSpacing) * panelMaxIndex;
        int panelX = boardX + (cellSize + cellSpacing) * (panelMaxIndex - numbersFixed);
        if (panelX <= 0) {
            while (--numbersFixed > 0 && ++numbersOver * numbersWidth + numbersFixed * (cellSize + cellSpacing) > sizePanel) {
            }
            g.setColor(skinPanelColors[this.skin][_row % 2]);
            g.fillRect(panelX, boardY + (panelMaxIndex + _row) * (cellSize + cellSpacing), numbersOver * (cellSize + cellSpacing), cellSize);
            for (int j = 0; j < numbersOver; ++j) {
                numbersType = 2;
                if (_light) {
                    numbersType = 3;
                }
                if (panelRowsFill[_row][j]) {
                    numbersType = 1;
                }
                this.drawNumber(g, panelRows[_row][j], numbersType, j * numbersWidth, boardY + (panelMaxIndex + _row) * (cellSize + cellSpacing), cellSize);
            }
        }
    }

    public void paintPanelOverVertical(Graphics g, int _col, boolean _light) {
        this.ge.gc.resetClip(g);
        if (_col < 0 || _col >= boardSize) {
            return;
        }
        int numbersType = 2;
        if (_light) {
            numbersType = 3;
        }
        int numbersOver = 0;
        int numbersFixed = panelCols[_col].length;
        int sizePanel = boardY + (cellSize + cellSpacing) * panelMaxIndex;
        int panelY = boardY + (cellSize + cellSpacing) * (panelMaxIndex - numbersFixed);
        if (panelY <= 0) {
            while (--numbersFixed > 0 && ++numbersOver * numbersHeight + numbersFixed * (cellSize + cellSpacing) > sizePanel) {
            }
            g.setColor(skinPanelColors[this.skin][_col % 2]);
            g.fillRect(boardX + (panelMaxIndex + _col) * (cellSize + cellSpacing), panelY, cellSize, numbersOver * (cellSize + cellSpacing));
            for (int j = 0; j < numbersOver; ++j) {
                numbersType = 2;
                if (_light) {
                    numbersType = 3;
                }
                if (panelColsFill[_col][j]) {
                    numbersType = 1;
                }
                this.drawNumber(g, panelCols[_col][j], numbersType, boardX + (panelMaxIndex + _col) * (cellSize + cellSpacing), j * numbersHeight, cellSize);
            }
        }
    }

    public void paintBoardCells(Graphics _g) {
        _g.setColor(0x666666);
        int boardCellsX = this.getCellsX();
        int boardCellsY = this.getCellsY();
        for (int col = 0; col < boardSize; ++col) {
            for (int row = 0; row < boardSize; ++row) {
                this.paintCell(_g, row, col, boardCellsX + col * (cellSize + cellSpacing), boardCellsY + row * (cellSize + cellSpacing));
            }
        }
        this.ge.gc.resetClip(_g);
        _g.setColor(0xFF8000);
        int squaresW = boardSize / 5;
        int squaresH = boardSize / 5;
        int squareSize = 5 * (cellSize + cellSpacing);
        for (int row = 0; row < squaresH; ++row) {
            for (int col = 0; col < squaresW; ++col) {
                _g.drawRect(boardCellsX - 1 + col * squareSize, boardCellsY - 1 + row * squareSize, squareSize, squareSize);
            }
        }
        _g.setColor(0);
        squareSize = boardSize * (cellSize + cellSpacing);
        _g.drawRect(boardCellsX - 1, boardCellsY - 1, squareSize, squareSize);
    }

    public void paintPointer(Graphics _g) {
        this.ge.gc.resetClip(_g);
        int color = this.ge.gameFrames / 4 % 2;
        if (this.ge.gameType == 1 && this.ge.gqJoker) {
            _g.setColor(skinPointer[this.skin][color]);
            _g.drawArc(this.getPointerX() - 2, this.getPointerY() - 2, cellSize + 3, cellSize + 3, 0, 360);
            _g.setColor(skinPointer[this.skin][color + 1]);
            _g.drawArc(this.getPointerX() - 1, this.getPointerY() - 1, cellSize + 1, cellSize + 1, 0, 360);
            _g.setColor(skinPointer[this.skin][color + 2]);
            _g.drawArc(this.getPointerX(), this.getPointerY(), cellSize - 1, cellSize - 1, 0, 360);
        } else {
            _g.setColor(skinPointer[this.skin][color]);
            _g.drawRect(this.getPointerX() - 2, this.getPointerY() - 2, cellSize + 3, cellSize + 3);
            _g.setColor(skinPointer[this.skin][color + 1]);
            _g.drawRect(this.getPointerX() - 1, this.getPointerY() - 1, cellSize + 1, cellSize + 1);
            _g.setColor(skinPointer[this.skin][color + 2]);
            _g.drawRect(this.getPointerX(), this.getPointerY(), cellSize - 1, cellSize - 1);
        }
    }

    public void paintScoreboard(Graphics _g, String clock) {
        this.ge.gc.resetClip(_g);
        _g.drawImage(this.ge.gc.resImages[26], 0, 0, 20);
        int miniMapOffsetX = 10;
        int miniMapOffsetY = 9;
        if (boardSize == 15) {
            miniMapOffsetX = 13;
            miniMapOffsetY = 12;
        }
        int pixelSize = miniMapSize / boardSize;
        _g.setColor(0);
        for (int row = 0; row < boardSize; ++row) {
            for (int col = 0; col < boardSize; ++col) {
                if (dataInput[row * boardSize + col] != 1) continue;
                _g.fillRect(miniMapOffsetX + col * pixelSize, miniMapOffsetY + row * pixelSize, pixelSize, pixelSize);
            }
        }
        int clockOffsetX = 10;
        int clockOffsetY = 49;
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameCanvas.resFonts[0].drawString(_g, clock.toCharArray(), clockOffsetX, clockOffsetY, 20);
    }

    public void paintCell(Graphics _g, int _row, int _col, int _x, int _y) {
        _g.setClip(_x - 1, _y - 1, cellSize + 2, cellSize + 2);
        switch (dataInput[_row * boardSize + _col]) {
            case 0: {
                _g.setColor(skinEmptyCells[this.skin][2 * (_row % 2) + _col % 2]);
                _g.fillRect(_x, _y, cellSize, cellSize);
                break;
            }
            case 2: {
                _g.setColor(skinEmptyCells[this.skin][2 * (_row % 2) + _col % 2]);
                _g.fillRect(_x, _y, cellSize, cellSize);
                _g.setColor(0x9999FF);
                _g.fillArc(_x + cellSize / 4, _y + cellSize / 4, cellSize / 2, cellSize / 2, 0, 360);
                break;
            }
            case 1: {
                _g.setColor(0x6666FF);
                _g.fillRect(_x, _y, cellSize, cellSize);
            }
        }
    }

    public void paintCompletedA(Graphics _g) {
        this.ge.gc.resetClip(_g);
        this.ge.gc.paintBackground(_g);
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        int step = 1;
        boardXfinal = (240 - boardSize * cellSize) / 2;
        boardYfinal = (320 - boardSize * cellSize) / 2;
        int diffX = boardXfinal - boardX;
        int diffY = boardYfinal - boardY;
        if (boardXfinal != boardX) {
            step = Math.max(1, Math.abs(diffX / 6));
            if (Math.abs(diffX) < step) {
                boardX = boardXfinal;
            } else if (diffX > 0) {
                boardX += step;
            } else if (diffX < 0) {
                boardX -= step;
            }
        }
        if (boardYfinal != boardY) {
            step = Math.max(1, Math.abs(diffY / 6));
            if (Math.abs(diffY) < step) {
                boardY = boardYfinal;
            } else if (diffY > 0) {
                boardY += step;
            } else if (diffY < 0) {
                boardY -= step;
            }
        }
        _g.setClip(boardX - 1, boardY - 1, boardSize * cellSize + 1, boardSize * cellSize + 1);
        for (int col = 0; col < boardSize; ++col) {
            for (int row = 0; row < boardSize; ++row) {
                if (this.boardFramesAux > 40 + row + col) {
                    if (dataColor[row * boardSize + col] == 0) continue;
                    _g.setColor(this.ge.palettes[boardPalette][dataColor[row * boardSize + col]]);
                } else {
                    _g.setColor(0xFFFFFF);
                    if (dataBW[row * boardSize + col] == 1) {
                        _g.setColor(0);
                    }
                }
                _g.fillRect(boardX + col * cellSize, boardY + row * cellSize, cellSize, cellSize);
            }
        }
        if (this.boardFramesAux < 40) {
            _g.setColor(0);
            _g.drawRect(boardX - 1, boardY - 1, boardSize * cellSize, boardSize * cellSize);
        }
        if (this.boardFramesAux > 20) {
            int oldBoardSize = this.getBoardSize();
            int oldXcenter = boardX + oldBoardSize / 2;
            int oldYcenter = boardY + oldBoardSize / 2;
            int zoom = 0;
            if (cellSize < cellSizeSolution) {
                cellSize = Math.min(cellSize + 1, cellSizeSolution);
            } else if (cellSize > cellSizeSolution) {
                cellSize = Math.max(cellSize - 1, cellSizeSolution);
            }
            if (oldBoardSize != this.getBoardSize()) {
                step = oldBoardSize - this.getBoardSize();
                zoom = step / Math.abs(step);
                step = Math.abs(step);
            }
            int diff = (boardX += zoom * step) + this.getBoardSize() / 2 - oldXcenter;
            boardX -= diff;
            diff = (boardY += zoom * step) + this.getBoardSize() / 2 - oldYcenter;
            boardY -= diff;
        }
        if (this.boardFramesAux > 30) {
            GameCanvas cfr_ignored_0 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[52].toCharArray(), 120, 74, 33);
            if (this.ge.gameType == 0 && (this.ge.gcTime < this.ge.gcHighScoresTime[this.ge.gcLastLevelPlayed] || this.ge.gcHighScoresTime[this.ge.gcLastLevelPlayed] == 0L)) {
                GameCanvas cfr_ignored_1 = this.ge.gc;
                GameCanvas cfr_ignored_2 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, (this.ge.lang[53] + ": " + SSFunctions.getTimeText(this.ge.gcTime)).toCharArray(), 120, 80 + GameCanvas.resFonts[1].getFontHeight() + 2, 33);
            }
        }
        this.ge.gc.resAnimations[1].drawAnimation(_g, 5, System.currentTimeMillis(), 35, 273, true);
        GameCanvas cfr_ignored_3 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[6].toCharArray(), 238, 318, 72);
    }

    public void paintCompletedB(Graphics _g) {
        this.ge.gc.resetClip(_g);
        this.ge.gc.paintBackground(_g);
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        GameCanvas cfr_ignored_0 = this.ge.gc;
        int frameWidth = Math.min(21 * GameCanvas.resFonts[1].getFontHeight(), 20 * this.boardFramesAux);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        int frameHeight = Math.min(20 * GameCanvas.resFonts[1].getFontHeight(), 20 * this.boardFramesAux);
        this.ge.gc.paintItem(_g, (240 - frameWidth) / 2, (320 - frameHeight) / 2, frameWidth, frameHeight);
        int pixelX = 120;
        GameCanvas cfr_ignored_2 = this.ge.gc;
        int pixelY = (320 - frameHeight) / 2 + GameCanvas.resFonts[1].getFontHeight();
        if (this.boardFramesAux > 20) {
            if (this.ge.gameType == 0) {
                GameCanvas cfr_ignored_3 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.lang[52].toCharArray(), pixelX, pixelY, 17);
            } else if (this.ge.gameType == 1) {
                GameCanvas cfr_ignored_4 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.lang[98].toCharArray(), pixelX, pixelY, 17);
            }
        }
        GameCanvas cfr_ignored_5 = this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(0);
        if (this.boardFramesAux > 25) {
            GameCanvas cfr_ignored_6 = this.ge.gc;
            GameCanvas cfr_ignored_7 = this.ge.gc;
            GameCanvas.resFonts[2].drawString(_g, this.ge.lang[54].toCharArray(), pixelX, pixelY += 2 * GameCanvas.resFonts[1].getFontHeight(), 3);
        }
        if (this.boardFramesAux > 30) {
            GameCanvas cfr_ignored_8 = this.ge.gc;
            _g.setClip(pixelX - frameWidth / 3, pixelY += 2 * GameCanvas.resFonts[2].getFontHeight(), 2 * frameWidth / 3, pixelY + 3);
            _g.setColor(15376436);
            _g.drawLine(pixelX - frameWidth / 3, pixelY, pixelX + frameWidth / 3, pixelY);
            _g.setColor(16442030);
            _g.drawLine(pixelX - frameWidth / 3, pixelY + 1, pixelX + frameWidth / 3, pixelY + 1);
        }
        if (this.boardFramesAux > 35) {
            if (this.ge.gameType == 0 || this.ge.gameType == 3) {
                GameCanvas cfr_ignored_9 = this.ge.gc;
                GameCanvas cfr_ignored_10 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[55] + ":").toCharArray(), pixelX, pixelY += 2 * GameCanvas.resFonts[2].getFontHeight(), 10);
                GameCanvas cfr_ignored_11 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, SSFunctions.getTimeText(1000 * this.ge.gcTimeLimits[boardSize / 5 - 1]).toCharArray(), pixelX + 5, pixelY, 6);
            } else if (this.ge.gameType == 1) {
                GameCanvas cfr_ignored_12 = this.ge.gc;
                GameCanvas cfr_ignored_13 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[83] + " 1/4:").toCharArray(), pixelX, pixelY += GameCanvas.resFonts[2].getFontHeight(), 10);
                GameCanvas cfr_ignored_14 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, Integer.toString(this.ge.gqPointsLevel[0]).toCharArray(), pixelX + 5, pixelY, 6);
            }
        }
        if (this.boardFramesAux > 40) {
            GameCanvas cfr_ignored_15 = this.ge.gc;
            pixelY += 2 * GameCanvas.resFonts[2].getFontHeight();
            if (this.ge.gameType == 0 || this.ge.gameType == 3) {
                GameCanvas cfr_ignored_16 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[56] + ":").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_17 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, SSFunctions.getTimeText(this.ge.gcTime).toCharArray(), pixelX + 5, pixelY, 6);
            } else if (this.ge.gameType == 1) {
                GameCanvas cfr_ignored_18 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[83] + " 2/4:").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_19 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, Integer.toString(this.ge.gqPointsLevel[1]).toCharArray(), pixelX + 5, pixelY, 6);
            }
        }
        if (this.boardFramesAux > 45) {
            GameCanvas cfr_ignored_20 = this.ge.gc;
            pixelY += 2 * GameCanvas.resFonts[2].getFontHeight();
            if (this.ge.gameType == 0 || this.ge.gameType == 3) {
                GameCanvas cfr_ignored_21 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[57] + ":").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_22 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, Integer.toString(this.ge.gcPenalties).toCharArray(), pixelX + 5, pixelY, 6);
            } else if (this.ge.gameType == 1) {
                GameCanvas cfr_ignored_23 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[83] + " 3/4:").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_24 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, Integer.toString(this.ge.gqPointsLevel[2]).toCharArray(), pixelX + 5, pixelY, 6);
            }
        }
        if (this.boardFramesAux > 50) {
            GameCanvas cfr_ignored_25 = this.ge.gc;
            pixelY += 2 * GameCanvas.resFonts[2].getFontHeight();
            if (this.ge.gameType == 0 || this.ge.gameType == 3) {
                this.auxInt = (int)((long)this.ge.gcTimeLimits[boardSize / 5 - 1] - this.ge.gcTime / 1000L);
                if (this.auxInt < 0) {
                    this.auxInt = 0;
                }
                this.auxString = this.auxInt + "x" + Math.max(5, 10 - this.ge.gcPenalties) + "=" + this.auxInt * Math.max(5, 10 - this.ge.gcPenalties);
                GameCanvas cfr_ignored_26 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[58] + ":").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_27 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, this.auxString.toCharArray(), pixelX + 5, pixelY, 6);
            } else if (this.ge.gameType == 1) {
                GameCanvas cfr_ignored_28 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[83] + " 4/4:").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_29 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, Integer.toString(this.ge.gqPointsLevel[3]).toCharArray(), pixelX + 5, pixelY, 6);
            }
        }
        if (this.boardFramesAux > 55) {
            GameCanvas cfr_ignored_30 = this.ge.gc;
            pixelY += 2 * GameCanvas.resFonts[2].getFontHeight();
            if (this.ge.gameType == 0 || this.ge.gameType == 3) {
                _g.setClip(pixelX - frameWidth / 3, pixelY, 2 * frameWidth / 3, pixelY + 3);
                _g.setColor(15376436);
                _g.drawLine(pixelX - frameWidth / 3, pixelY, pixelX + frameWidth / 3, pixelY);
                _g.setColor(16442030);
                _g.drawLine(pixelX - frameWidth / 3, pixelY + 1, pixelX + frameWidth / 3, pixelY + 1);
            } else if (this.ge.gameType == 1) {
                GameCanvas cfr_ignored_31 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[58] + ":").toCharArray(), pixelX, pixelY, 10);
                GameCanvas cfr_ignored_32 = this.ge.gc;
                GameCanvas.resFonts[0].drawString(_g, Integer.toString(SSMath.sum(this.ge.gqPointsLevel)).toCharArray(), pixelX + 5, pixelY, 6);
            }
        }
        if (this.boardFramesAux > 60) {
            GameCanvas cfr_ignored_33 = this.ge.gc;
            pixelY += 3 * GameCanvas.resFonts[1].getFontHeight();
            if (this.ge.gameType == 0 && this.ge.gcHighScoresTime[this.ge.gcLastLevelPlayed] == 0L || this.ge.gameType == 1 && this.ge.gqHighScoresTime[MenuQuest.getIndex(this.ge.gqLevelRow, this.ge.gqLevelCol)] == 0L) {
                if (this.ge.gameType == 0) {
                    GameCanvas cfr_ignored_34 = this.ge.gc;
                    GameCanvas.resFonts[1].drawString(_g, "1 x ".toCharArray(), pixelX + 5, pixelY, 72);
                } else if (this.ge.gameType == 1) {
                    GameCanvas cfr_ignored_35 = this.ge.gc;
                    GameCanvas cfr_ignored_36 = this.ge.gc;
                    GameCanvas.resFonts[1].drawString(_g, "6 x ".toCharArray(), pixelX + 5, pixelY += GameCanvas.resFonts[2].getFontHeight(), 72);
                }
                this.ge.gc.resAnimations[8].drawAnimation(_g, 0, System.currentTimeMillis(), pixelX + 15, pixelY, true);
                GameCanvas cfr_ignored_37 = this.ge.gc;
                GameCanvas cfr_ignored_38 = this.ge.gc;
                GameCanvas cfr_ignored_39 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.lang[59].toCharArray(), (240 - 4 * frameWidth / 5) / 2, pixelY += GameCanvas.resFonts[1].getFontHeight(), 4 * frameWidth / 5, 3 * GameCanvas.resFonts[1].getFontHeight(), 17);
            } else {
                GameCanvas cfr_ignored_40 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.lang[103].toCharArray(), 120, pixelY, 65);
            }
            this.ge.pressedAnyKey = true;
        }
        this.ge.gc.resAnimations[1].drawAnimation(_g, 5, System.currentTimeMillis(), 35, 273, true);
        GameCanvas cfr_ignored_41 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[6].toCharArray(), 238, 318, 72);
    }

    public void paintBlockResume(Graphics _g) {
        this.ge.gc.resetClip(_g);
        this.ge.gc.paintBackground(_g);
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        int frameWidth = 200;
        int pixelX = (240 - frameWidth) / 2;
        int iconSize = 20;
        int pixelY = 31 + this.ge.gc.resImages[14].getHeight();
        this.ge.gc.paintItem(_g, pixelX, pixelY, frameWidth, 36);
        this.ge.gc.resetClip(_g);
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameCanvas cfr_ignored_1 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.gqLevelDescription[MenuQuest.getIndex(this.ge.gqLevelRow, this.ge.gqLevelCol)].toCharArray(), 120, pixelY + (36 - GameCanvas.resFonts[1].getFontHeight()) / 2, 17);
        GameCanvas cfr_ignored_2 = this.ge.gc;
        pixelY += (this.ge.gc.resImages[23].getHeight() - GameCanvas.resFonts[1].getFontHeight()) / 2;
        GameCanvas cfr_ignored_3 = this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(0);
        for (int i = 0; i < 4; ++i) {
            this.ge.gc.resetClip(_g);
            pixelY += this.ge.gc.resImages[23].getHeight() + 3;
            if (i < this.ge.gqLevelNumber) {
                _g.setColor(0xFFFFFF);
                GameCanvas cfr_ignored_4 = this.ge.gc;
                GameCanvas cfr_ignored_5 = this.ge.gc;
                _g.fillRect(pixelX + this.ge.gc.resImages[23].getWidth() + 10, pixelY, GameCanvas.resFonts[2].getLineWidth(this.ge.lang[97].toCharArray()) + 4, GameCanvas.resFonts[2].getFontHeight() + 2);
                GameCanvas cfr_ignored_6 = this.ge.gc;
                GameCanvas cfr_ignored_7 = this.ge.gc;
                _g.fillRect(pixelX + 3 * (this.ge.gc.resImages[23].getWidth() + 10), pixelY, GameCanvas.resFonts[2].getLineWidth(this.ge.lang[83].toCharArray()) + 4, GameCanvas.resFonts[2].getFontHeight() + 2);
                _g.drawImage(this.ge.gc.resImages[23], pixelX, pixelY, 20);
                int square = 1;
                if (boardSize == 15) {
                    square = 2;
                }
                if (boardSize == 10) {
                    square = 3;
                }
                if (boardSize == 5) {
                    square = 6;
                }
                for (int row = 0; row < boardSize; ++row) {
                    for (int col = 0; col < boardSize; ++col) {
                        byte color = this.ge.gqDataColor[i][row * boardSize + col];
                        if (color == 0) continue;
                        _g.setColor(this.ge.palettes[this.ge.gqDataPalette[i]][color]);
                        _g.fillRect(pixelX + 4 + col * square, pixelY + 4 + row * square, square, square);
                    }
                }
                _g.setClip(pixelX + 2 * (this.ge.gc.resImages[23].getWidth() + 10) + 15, pixelY + 2, iconSize, iconSize);
                _g.drawImage(this.ge.gc.resImages[20], pixelX + 2 * (this.ge.gc.resImages[23].getWidth() + 10) + 15, pixelY + 2 - iconSize * this.ge.gqItemUsed[i], 20);
                GameCanvas cfr_ignored_8 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[97].toCharArray(), pixelX + this.ge.gc.resImages[23].getWidth() + 10 + 2, pixelY - 1, 20);
                GameCanvas cfr_ignored_9 = this.ge.gc;
                GameCanvas cfr_ignored_10 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, SSFunctions.getTimeText(this.ge.gqTimeLeft[i]).toCharArray(), pixelX + this.ge.gc.resImages[23].getWidth() + 10 + 2, pixelY + GameCanvas.resFonts[2].getFontHeight() + 4, 20);
                GameCanvas cfr_ignored_11 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[83].toCharArray(), pixelX + 3 * (this.ge.gc.resImages[23].getWidth() + 10) + 2, pixelY - 1, 20);
                GameCanvas cfr_ignored_12 = this.ge.gc;
                GameCanvas cfr_ignored_13 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, (i + 1 + "/4").toCharArray(), pixelX + 3 * (this.ge.gc.resImages[23].getWidth() + 10) + 2, pixelY + GameCanvas.resFonts[2].getFontHeight() + 4, 20);
                continue;
            }
            _g.drawImage(this.ge.gc.resImages[24], pixelX, pixelY, 20);
            GameCanvas cfr_ignored_14 = this.ge.gc;
            GameCanvas cfr_ignored_15 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[96].toCharArray(), pixelX + this.ge.gc.resImages[23].getWidth() + 10 + 2, pixelY + GameCanvas.resFonts[2].getFontHeight() + 4, 20);
        }
        if (this.ge.gqLevelNumber == 0) {
            GameCanvas cfr_ignored_16 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[28].toCharArray(), 2, 318, 68, 120);
        }
        GameCanvas cfr_ignored_17 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[6].toCharArray(), 238, 318, 72, 120);
    }

    public void paintFailed(Graphics _g) {
        this.ge.gc.resetClip(_g);
        this.ge.gc.paintBackground(_g);
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        GameCanvas cfr_ignored_0 = this.ge.gc;
        int frameWidth = Math.min(20 * GameCanvas.resFonts[1].getFontHeight(), 20 * this.boardFramesAux);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        int frameHeight = Math.min(5 * GameCanvas.resFonts[1].getFontHeight(), 5 * this.boardFramesAux);
        this.ge.gc.paintItem(_g, (240 - frameWidth) / 2, (320 - frameHeight) / 2, frameWidth, frameHeight);
        int pixelX = 120;
        GameCanvas cfr_ignored_2 = this.ge.gc;
        int pixelY = (320 - frameHeight) / 2 + GameCanvas.resFonts[1].getFontHeight();
        if (this.boardFramesAux > 20) {
            GameCanvas cfr_ignored_3 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[85].toCharArray(), pixelX, pixelY, 17);
        }
        GameCanvas cfr_ignored_4 = this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(0);
        if (this.boardFramesAux > 25) {
            GameCanvas cfr_ignored_5 = this.ge.gc;
            pixelY += 2 * GameCanvas.resFonts[1].getFontHeight();
            if (this.boardFramesAux % 14 < 7) {
                GameCanvas cfr_ignored_6 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[47].toCharArray(), pixelX, pixelY, 3);
            }
            this.ge.pressedAnyKey = true;
        }
        this.ge.gc.resAnimations[1].drawAnimation(_g, 6, System.currentTimeMillis(), 35, 273, true);
        GameCanvas cfr_ignored_7 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[6].toCharArray(), 238, 318, 72);
    }

    public void paintMenuInGame(Graphics _g) {
        int i;
        this.ge.gc.resetClip(_g);
        this.paintBackground(_g);
        for (i = 0; i < panelCols.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX + (panelMaxIndex + i) * (cellSize + cellSpacing), boardY, cellSize, this.getPanelSize());
        }
        for (i = 0; i < panelRows.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX, boardY + (panelMaxIndex + i) * (cellSize + cellSpacing), this.getPanelSize(), cellSize);
        }
        this.paintBoardCells(_g);
        this.paintScoreboard(_g, this.ge.auxString);
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        int itemTextOffsetX = 10;
        int itemTextOffsetY = 6;
        int pixelX = (240 - this.ge.gc.resAnimations[3].getFrameWidth(0)) / 2;
        int pixelY = (320 - 6 * (this.ge.gc.resAnimations[3].getFrameHeight(0) + 2)) / 2 - 10;
        int item_on_off = 1;
        if (this.itemSelected == 0) {
            item_on_off = 0;
        }
        this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, System.currentTimeMillis() - this.itemAnimateTime[0], pixelX, pixelY, false);
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[51].toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        pixelY += this.ge.gc.resAnimations[3].getFrameHeight(0) + 2;
        item_on_off = 1;
        if (this.itemSelected == 1) {
            item_on_off = 0;
        }
        this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, System.currentTimeMillis() - this.itemAnimateTime[1], pixelX, pixelY, false);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[14].toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        pixelY += this.ge.gc.resAnimations[3].getFrameHeight(0) + 2;
        item_on_off = 1;
        if (this.itemSelected == 2) {
            item_on_off = 0;
        }
        this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, System.currentTimeMillis() - this.itemAnimateTime[2], pixelX, pixelY, false);
        if (this.ge.configSound) {
            GameCanvas cfr_ignored_2 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, (this.ge.lang[38] + " " + this.ge.lang[42]).toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        } else {
            GameCanvas cfr_ignored_3 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, (this.ge.lang[38] + " " + this.ge.lang[43]).toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        }
        pixelY += this.ge.gc.resAnimations[3].getFrameHeight(0) + 2;
        item_on_off = 1;
        if (this.itemSelected == 3) {
            item_on_off = 0;
        }
        this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, System.currentTimeMillis() - this.itemAnimateTime[3], pixelX, pixelY, false);
        if (this.ge.configVibrate) {
            GameCanvas cfr_ignored_4 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, (this.ge.lang[40] + " " + this.ge.lang[42]).toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        } else {
            GameCanvas cfr_ignored_5 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, (this.ge.lang[40] + " " + this.ge.lang[43]).toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        }
        pixelY += this.ge.gc.resAnimations[3].getFrameHeight(0) + 2;
        item_on_off = 1;
        if (this.itemSelected == 4) {
            item_on_off = 0;
        }
        this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, System.currentTimeMillis() - this.itemAnimateTime[4], pixelX, pixelY, false);
        GameCanvas cfr_ignored_6 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[18].toCharArray(), pixelX + itemTextOffsetX, pixelY + itemTextOffsetY, 20);
        this.ge.gc.resAnimations[1].drawAnimation(_g, 2, System.currentTimeMillis(), 35, 273, true);
        GameCanvas cfr_ignored_7 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[5].toCharArray(), 238, 318, 72, 120);
    }

    public void paintUseItem(Graphics _g) {
        int i;
        this.paintBackground(_g);
        for (i = 0; i < panelCols.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX + (panelMaxIndex + i) * (cellSize + cellSpacing), boardY, cellSize, this.getPanelSize());
        }
        for (i = 0; i < panelRows.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX, boardY + (panelMaxIndex + i) * (cellSize + cellSpacing), this.getPanelSize(), cellSize);
        }
        this.paintBoardCells(_g);
        this.paintScoreboard(_g, this.ge.clock.getTimeString(3));
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        int frameWidth = 205;
        GameCanvas cfr_ignored_0 = this.ge.gc;
        int frameHeight = 7 * GameCanvas.resFonts[1].getFontHeight();
        int paperX = (240 - frameWidth) / 2;
        int paperY = (320 - frameHeight) / 2;
        this.ge.gc.paintItem(_g, paperX, paperY, frameWidth, frameHeight);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[86].toCharArray(), 120, paperY + 6, 17);
        GameCanvas cfr_ignored_2 = this.ge.gc;
        int iconSize = 20;
        paperX = (240 - 6 * (iconSize + 4)) / 2;
        _g.setColor(0xFF0000);
        _g.setClip(paperX + this.itemSelected * (iconSize + 4) - 2, paperY += GameCanvas.resFonts[1].getFontHeight() + 12, iconSize + 4, iconSize + 4);
        _g.fillRect(paperX + this.itemSelected * (iconSize + 4) - 2, paperY, iconSize + 4, iconSize + 4);
        paperY += 2;
        for (int i2 = 0; i2 <= 5; ++i2) {
            _g.setClip(paperX + i2 * (iconSize + 4), paperY, iconSize, iconSize);
            _g.drawImage(this.ge.gc.resImages[20], paperX + i2 * (iconSize + 4), paperY - i2 * iconSize, 20);
        }
        paperY += iconSize + 4;
        GameCanvas cfr_ignored_3 = this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(0);
        GameCanvas cfr_ignored_4 = this.ge.gc;
        GameCanvas.resFonts[2].drawString(_g, this.ge.gqItemDescription[this.itemSelected].toCharArray(), 120, paperY, 17);
        GameCanvas cfr_ignored_5 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[5].toCharArray(), 0, 318, 68, 120);
    }

    public void paintPressAnyKey(Graphics _g) {
        int i;
        this.ge.gc.resetClip(_g);
        this.paintBackground(_g);
        for (i = 0; i < panelCols.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX + (panelMaxIndex + i) * (cellSize + cellSpacing), boardY, cellSize, this.getPanelSize());
        }
        for (i = 0; i < panelRows.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX, boardY + (panelMaxIndex + i) * (cellSize + cellSpacing), this.getPanelSize(), cellSize);
        }
        this.paintBoardCells(_g);
        this.paintScoreboard(_g, this.ge.clock.getTimeString(3));
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        GameCanvas cfr_ignored_0 = this.ge.gc;
        int frameWidth = Math.min(20 * GameCanvas.resFonts[1].getFontHeight(), 20 * this.boardFramesAux);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        int frameHeight = Math.min(5 * GameCanvas.resFonts[1].getFontHeight(), 5 * this.boardFramesAux);
        this.ge.gc.paintItem(_g, (240 - frameWidth) / 2, (320 - frameHeight) / 2, frameWidth, frameHeight);
        int pixelX = 120;
        GameCanvas cfr_ignored_2 = this.ge.gc;
        int pixelY = (320 - frameHeight) / 2 + GameCanvas.resFonts[1].getFontHeight();
        if (this.boardFramesAux > 20) {
            GameCanvas cfr_ignored_3 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[46].toCharArray(), pixelX, pixelY, 17);
        }
        GameCanvas cfr_ignored_4 = this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(0);
        if (this.boardFramesAux > 25) {
            GameCanvas cfr_ignored_5 = this.ge.gc;
            pixelY += 2 * GameCanvas.resFonts[1].getFontHeight();
            if (this.boardFramesAux % 14 < 7) {
                GameCanvas cfr_ignored_6 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[47].toCharArray(), pixelX, pixelY, 3);
            }
        }
        this.ge.gc.resAnimations[1].drawAnimation(_g, 4, System.currentTimeMillis(), 35, 273, true);
        GameCanvas cfr_ignored_7 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[6].toCharArray(), 238, 318, 72);
    }

    public void paintInGameHelp(Graphics _g) {
        int i;
        this.ge.gc.resetClip(_g);
        this.paintBackground(_g);
        for (i = 0; i < panelCols.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX + (panelMaxIndex + i) * (cellSize + cellSpacing), boardY, cellSize, this.getPanelSize());
        }
        for (i = 0; i < panelRows.length; ++i) {
            this.ge.gc.resetClip(_g);
            _g.setColor(skinPanelColors[this.skin][i % 2]);
            _g.fillRect(boardX, boardY + (panelMaxIndex + i) * (cellSize + cellSpacing), this.getPanelSize(), cellSize);
        }
        this.paintBoardCells(_g);
        this.paintScoreboard(_g, this.ge.auxString);
        this.ge.gc.paintAlpha(_g, 0, 0, 240, 320);
        if (this.ge.gameType == 0) {
            _g.drawImage(this.ge.gc.resImages[7], 0, 0, 20);
        } else if (this.ge.gameType == 1) {
            _g.drawImage(this.ge.gc.resImages[14], 0, 0, 20);
        }
        int textWidth = this.ge.gc.resAnimations[3].getFrameWidth(0);
        int textHeight = 4 * (this.ge.gc.resAnimations[3].getFrameHeight(0) + 2);
        int pixelX = (240 - textWidth) / 2;
        int pixelY = (320 - textHeight) / 2;
        _g.setClip(0, 0, 240, 320);
        this.ge.gc.paintItem(_g, pixelX, pixelY, textWidth, textHeight);
        this.ge.gc.resetClip(_g);
        _g.setColor(16163641);
        GameCanvas cfr_ignored_0 = this.ge.gc;
        _g.fillRect(pixelX + 6, pixelY + 6, textWidth - 13, GameCanvas.resFonts[1].getFontHeight() + 2);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[14].toCharArray(), 120, pixelY + 6, 17);
        GameCanvas cfr_ignored_2 = this.ge.gc;
        this.auxInt = GameCanvas.resFonts[2].drawString(_g, this.ge.lang[44].toCharArray(), pixelX + 6, pixelY + 19, textWidth - 12, textHeight - 32, 20, this.auxInt, 8, 16163641);
        this.ge.gc.resAnimations[1].drawAnimation(_g, 2, System.currentTimeMillis(), 35, 273, true);
        GameCanvas cfr_ignored_3 = this.ge.gc;
        GameCanvas.resFonts[1].drawString(_g, this.ge.lang[28].toCharArray(), 238, 318, 72);
    }

    public void drawNumber(Graphics _g, int _n, int _type, int _x, int _y, int _c) {
        int insertX = 0;
        int insertY = 0;
        insertX = _x + (_c - numbersWidth) / 2;
        insertY = _y + (_c - numbersHeight) / 2;
        _g.setClip(insertX, insertY, numbersWidth, numbersHeight);
        _g.drawImage(numbersImg, insertX - _n * numbersWidth, insertY - _type * numbersHeight, 20);
    }

    private void paintAnimations(Graphics _g) {
        for (int i = 0; i < bonusType.length; ++i) {
            if (bonusType[i] >= 0) {
                if (this.bonusDuration[i] <= 0L) continue;
                this.ge.gc.resAnimations[7].drawAnimation(_g, bonusType[i], System.currentTimeMillis(), bonusX[i], bonusY[i], true);
                int n = i;
                bonusY[n] = bonusY[n] - 1;
                int n2 = i;
                this.bonusDuration[n2] = this.bonusDuration[n2] - 1L;
                continue;
            }
            this.auxLong = System.currentTimeMillis() - bonusTimestamp[i];
            if (this.auxLong > this.bonusDuration[i]) {
                BoardManager.bonusTimestamp[i] = 0L;
                continue;
            }
            this.auxInt = 5;
            if (bonusType[i] == -1) {
                this.auxInt = 6;
            }
            this.ge.gc.resAnimations[this.auxInt].drawAnimation(_g, 0, System.currentTimeMillis() - bonusTimestamp[i], bonusX[i], bonusY[i], false);
        }
    }

    public void drawAnimation(int _type, int _x, int _y, long _timestamp) {
        BoardManager.bonusType[BoardManager.bonusIndex] = Math.min(_type, 18);
        BoardManager.bonusX[BoardManager.bonusIndex] = _x;
        BoardManager.bonusY[BoardManager.bonusIndex] = _y;
        BoardManager.bonusTimestamp[BoardManager.bonusIndex] = _timestamp;
        switch (_type) {
            case -2: {
                this.bonusDuration[BoardManager.bonusIndex] = 420L;
                break;
            }
            case -1: {
                this.bonusDuration[BoardManager.bonusIndex] = 360L;
                break;
            }
            default: {
                this.bonusDuration[BoardManager.bonusIndex] = 20L;
                if (!this.ge.configIsLowPerformance) break;
                this.bonusDuration[BoardManager.bonusIndex] = 8L;
            }
        }
        bonusIndex = (bonusIndex + 1) % 32;
    }

    public void optimizeBoard() {
        System.out.println("optimizeBoard()");
        switch (boardSize) {
            case 5: {
                minCellSize = 15;
                maxCellSize = 20;
                cellSizeSolution = 20;
                numbersImg = this.ge.gc.resManager.getImage("15x15px.png");
                numbersWidth = 15;
                numbersHeight = 15;
                zoomEnabled = false;
                this.setPointerCell((boardSize + 1) / 2, (boardSize + 1) / 2);
                break;
            }
            case 10: {
                minCellSize = 15;
                maxCellSize = 20;
                cellSizeSolution = 10;
                numbersImg = this.ge.gc.resManager.getImage("15x15px.png");
                numbersWidth = 15;
                numbersHeight = 15;
                zoomEnabled = false;
                this.setPointerCell((boardSize + 1) / 2, (boardSize + 1) / 2);
                break;
            }
            case 15: {
                minCellSize = 10;
                maxCellSize = 15;
                cellSizeSolution = 8;
                numbersImg = this.ge.gc.resManager.getImage("10x10px.png");
                numbersWidth = 10;
                numbersHeight = 10;
                zoomEnabled = true;
                this.setPointerCell(5, 5);
                break;
            }
            case 20: {
                minCellSize = 10;
                maxCellSize = 15;
                cellSizeSolution = 6;
                numbersImg = this.ge.gc.resManager.getImage("10x10px.png");
                numbersWidth = 10;
                numbersHeight = 10;
                zoomEnabled = true;
                this.setPointerCell(5, 5);
                if (miniMapSize <= this.getPanelSize() + boardMargin) break;
                miniMapSize = 40;
            }
        }
        cellSize = minCellSize;
        cellSizeFinal = minCellSize;
        zoomState = 0;
        boardMargin = minCellSize / 3;
        this.setCellSize(minCellSize);
        boardXfinal = boardX = (240 - this.getBoardSize()) / 2;
        boardXfixed = boardX;
        boardYfinal = boardY = (320 - this.getBoardSize()) / 2;
        boardYfixed = boardY;
        scrollSpeed = 6;
        if (this.ge.configIsLowPerformance) {
            scrollSpeed = 2;
        }
        scroll = false;
        if (this.getBoardSize() > 240 - 2 * boardMargin) {
            scroll = true;
        }
        if (this.getBoardSize() > 320 - 2 * boardMargin) {
            scroll = true;
        }
    }

    public boolean loadLevel(String fileName) {
        int i;
        System.out.println("Loading level " + fileName);
        this.boardFileName = fileName;
        this.levelData = null;
        BoardManager boardManager = this;
        boardManager.ge.garbageCollector();
        this.levelData = this.ge.gc.resManager.getResource(fileName);
        boardSize = Level.getSize(this.levelData);
        boardPalette = Level.getPalette(this.levelData);
        dataInput = null;
        dataBW = null;
        dataColor = null;
        BoardManager boardManager2 = this;
        boardManager2.ge.garbageCollector();
        dataInput = new byte[boardSize * boardSize];
        dataBW = new byte[boardSize * boardSize];
        dataColor = new byte[boardSize * boardSize];
        dataBW = Level.getBWArray(this.levelData);
        dataColor = Level.getColorArray(this.levelData);
        panelRows = new int[boardSize][];
        panelCols = new int[boardSize][];
        for (i = 0; i < boardSize; ++i) {
            this.patternHorizontal = null;
            this.patternVertical = null;
            BoardManager boardManager3 = this;
            boardManager3.ge.garbageCollector();
            this.patternHorizontal = new byte[boardSize];
            this.patternVertical = new byte[boardSize];
            for (int j = 0; j < boardSize; ++j) {
                this.patternHorizontal[j] = dataBW[i * boardSize + j];
                this.patternVertical[j] = dataBW[j * boardSize + i];
            }
            BoardManager.panelRows[i] = this.getPattern(this.patternHorizontal);
            BoardManager.panelCols[i] = this.getPattern(this.patternVertical);
        }
        panelRowsFill = new boolean[boardSize][];
        panelColsFill = new boolean[boardSize][];
        for (i = 0; i < boardSize; ++i) {
            BoardManager.panelRowsFill[i] = new boolean[panelRows[i].length];
            BoardManager.panelColsFill[i] = new boolean[panelCols[i].length];
        }
        panelRowsMaxIndex = 0;
        panelColsMaxIndex = 0;
        for (i = 0; i < boardSize; ++i) {
            if (panelRows[i].length > panelRowsMaxIndex) {
                panelRowsMaxIndex = panelRows[i].length;
            }
            if (panelCols[i].length <= panelColsMaxIndex) continue;
            panelColsMaxIndex = panelCols[i].length;
        }
        panelMaxIndex = Math.max(5, Math.max(panelRowsMaxIndex, panelColsMaxIndex));
        System.out.println("   loadLevel(" + fileName + ")");
        return true;
    }

    public int[] getPattern(byte[] _data) {
        int i;
        int dataLenght = _data.length;
        int index = 0;
        this.output = null;
        this.output = new int[dataLenght];
        for (i = 0; i < dataLenght; ++i) {
            if (_data[i] == 0) {
                ++index;
                continue;
            }
            int n = index;
            this.output[n] = this.output[n] + 1;
        }
        this.outputAux = null;
        this.outputAux = new int[index + 1];
        index = 0;
        for (i = 0; i < this.output.length; ++i) {
            if (this.output[i] <= 0) continue;
            this.outputAux[index] = this.output[i];
            ++index;
        }
        this.output = null;
        if (index == 0) {
            this.output = new int[1];
            this.output[0] = 0;
        } else {
            this.output = new int[index];
            System.arraycopy(this.outputAux, 0, this.output, 0, index);
        }
        return this.output;
    }

    public int[] getPatternInput(byte[] _data) {
        int i;
        int dataLenght = _data.length;
        int index = 0;
        this.output = null;
        this.output = new int[dataLenght];
        for (i = 0; i < dataLenght; ++i) {
            if (_data[i] == 1) {
                int n = index;
                this.output[n] = this.output[n] + 1;
                continue;
            }
            ++index;
        }
        this.outputAux = null;
        this.outputAux = new int[index + 1];
        index = 0;
        for (i = 0; i < this.output.length; ++i) {
            if (this.output[i] <= 0) continue;
            this.outputAux[index] = this.output[i];
            ++index;
        }
        this.output = null;
        if (index == 0) {
            this.output = new int[1];
            this.output[0] = 0;
        } else {
            this.output = new int[index];
            System.arraycopy(this.outputAux, 0, this.output, 0, index);
        }
        return this.output;
    }

    public void checkPatterns(int _row, int _col) {
        block17: {
            int i;
            int bigOneIndexInput;
            int bigOneIndex;
            block18: {
                block16: {
                    this.patternHorizontal = null;
                    this.patternVertical = null;
                    BoardManager boardManager = this;
                    boardManager.ge.garbageCollector();
                    this.patternHorizontal = new byte[boardSize];
                    this.patternVertical = new byte[boardSize];
                    for (int i2 = 0; i2 < boardSize; ++i2) {
                        this.patternHorizontal[i2] = dataInput[_row * boardSize + i2];
                        this.patternVertical[i2] = dataInput[i2 * boardSize + _col];
                    }
                    this.inputPatternH = null;
                    this.inputPatternV = null;
                    BoardManager boardManager2 = this;
                    boardManager2.ge.garbageCollector();
                    this.inputPatternH = this.getPatternInput(this.patternHorizontal);
                    this.inputPatternV = this.getPatternInput(this.patternVertical);
                    bigOneIndex = -1;
                    bigOneIndexInput = -1;
                    for (i = 0; i < panelRowsFill[_row].length; ++i) {
                        BoardManager.panelRowsFill[_row][i] = false;
                    }
                    if (this.inputPatternH.length == panelRows[_row].length) {
                        for (i = 0; i < this.inputPatternH.length; ++i) {
                            if (this.inputPatternH[i] != panelRows[_row][i]) continue;
                            BoardManager.panelRowsFill[_row][i] = true;
                        }
                    } else if (this.inputPatternH.length == 1) {
                        bigOneIndex = this.getUniqueBigOne(panelRows[_row]);
                        if (bigOneIndex != -1 && panelRows[_row][bigOneIndex] == this.inputPatternH[0]) {
                            BoardManager.panelRowsFill[_row][bigOneIndex] = true;
                        }
                    } else if (this.inputPatternH.length < panelRows[_row].length && (bigOneIndex = this.getUniqueBigOne(panelRows[_row])) != -1 && (bigOneIndexInput = this.getUniqueBigOne(this.inputPatternH)) != -1 && panelRows[_row][bigOneIndex] == this.inputPatternH[bigOneIndexInput]) {
                        BoardManager.panelRowsFill[_row][bigOneIndex] = true;
                        for (i = 1; i < this.inputPatternH.length - bigOneIndexInput; ++i) {
                            if (panelRows[_row][bigOneIndex + i] != this.inputPatternH[bigOneIndexInput + i]) continue;
                            BoardManager.panelRowsFill[_row][bigOneIndex + i] = true;
                        }
                        for (i = 1; i <= bigOneIndexInput; ++i) {
                            if (panelRows[_row][bigOneIndex - i] != this.inputPatternH[bigOneIndexInput - i]) continue;
                            BoardManager.panelRowsFill[_row][bigOneIndex - i] = true;
                        }
                    }
                    for (i = 0; i < panelColsFill[_col].length; ++i) {
                        BoardManager.panelColsFill[_col][i] = false;
                    }
                    if (this.inputPatternV.length != panelCols[_col].length) break block16;
                    for (i = 0; i < this.inputPatternV.length; ++i) {
                        if (this.inputPatternV[i] != panelCols[_col][i]) continue;
                        BoardManager.panelColsFill[_col][i] = true;
                    }
                    break block17;
                }
                if (this.inputPatternV.length != 1) break block18;
                bigOneIndex = this.getUniqueBigOne(panelCols[_col]);
                if (bigOneIndex == -1 || panelCols[_col][bigOneIndex] != this.inputPatternV[0]) break block17;
                BoardManager.panelColsFill[_col][bigOneIndex] = true;
                break block17;
            }
            if (this.inputPatternV.length < panelCols[_col].length && (bigOneIndex = this.getUniqueBigOne(panelCols[_col])) != -1 && (bigOneIndexInput = this.getUniqueBigOne(this.inputPatternV)) != -1 && panelCols[_col][bigOneIndex] == this.inputPatternV[bigOneIndexInput]) {
                BoardManager.panelColsFill[_col][bigOneIndex] = true;
                for (i = 1; i < this.inputPatternV.length - bigOneIndexInput; ++i) {
                    if (panelCols[_col][bigOneIndex + i] != this.inputPatternV[bigOneIndexInput + i]) continue;
                    BoardManager.panelColsFill[_col][bigOneIndex + i] = true;
                }
                for (i = 1; i <= bigOneIndexInput; ++i) {
                    if (panelCols[_col][bigOneIndex - i] != this.inputPatternV[bigOneIndexInput - i]) continue;
                    BoardManager.panelColsFill[_col][bigOneIndex - i] = true;
                }
            }
        }
    }

    private int getUniqueBigOne(int[] v) {
        int maxIndex = SSMath.maxValueIndex(v);
        for (int i = 0; i < v.length; ++i) {
            if (i == maxIndex || v[i] < v[maxIndex]) continue;
            return -1;
        }
        return maxIndex;
    }

    public void saveState(int _gameType) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            StringBuffer sb = new StringBuffer();
            String recordStoreName = "";
            switch (_gameType) {
                case 0: {
                    recordStoreName = "Game_Classic_Continue";
                    break;
                }
                case 1: {
                    recordStoreName = "Game_Quest_Continue";
                    sb.append(this.ge.gqLevelRow);
                    sb.append("#");
                    sb.append(this.ge.gqLevelCol);
                    sb.append("#");
                    sb.append(this.ge.gqLevelNumber);
                    sb.append("#");
                    for (int i = 0; i <= 3; ++i) {
                        sb.append(this.ge.gqOrder[i]);
                        sb.append("#");
                        sb.append(this.ge.gqItemUsed[i]);
                        sb.append("#");
                        sb.append(this.ge.gqTimeLeft[i]);
                        sb.append("#");
                        sb.append(this.ge.gqPointsLevel[i]);
                        sb.append("#");
                    }
                    break;
                }
                case 2: {
                    recordStoreName = "Game_Daily_Continue";
                }
            }
            dos.writeUTF(sb.toString());
            SSFunctions.store(recordStoreName, baos);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String parseRecord(String s) {
        if (s == null) {
            return "0";
        }
        String sParser = "";
        while (s.charAt(this.loadIndex) != '#') {
            sParser = sParser + s.charAt(this.loadIndex);
            ++this.loadIndex;
        }
        ++this.loadIndex;
        return sParser;
    }

    public boolean loadState(String recordStoreName) {
        boolean output = false;
        try {
            DataInputStream dis = SSFunctions.load(recordStoreName);
            if (dis == null) {
                System.out.println("** loadState() -> Invalid RMS **");
                return false;
            }
            String s = dis.readUTF();
            dis.close();
            this.loadIndex = 0;
            if (recordStoreName.startsWith("Game_Quest")) {
                System.out.println("** loadState(Game_Quest_Continue) **");
                int gqLevelRowSaved = Integer.parseInt(this.parseRecord(s));
                int gqLevelColSaved = Integer.parseInt(this.parseRecord(s));
                if (gqLevelRowSaved == this.ge.gqLevelRow && gqLevelColSaved == this.ge.gqLevelCol) {
                    output = true;
                    this.ge.gqLevelNumber = Integer.parseInt(this.parseRecord(s));
                    for (int i = 0; i <= 3; ++i) {
                        this.ge.gqOrder[i] = Integer.parseInt(this.parseRecord(s));
                        this.ge.gqItemUsed[i] = Integer.parseInt(this.parseRecord(s));
                        this.ge.gqTimeLeft[i] = Long.parseLong(this.parseRecord(s));
                        this.ge.gqPointsLevel[i] = Integer.parseInt(this.parseRecord(s));
                        if (i >= this.ge.gqLevelNumber) continue;
                        byte[] levelData = this.ge.gc.resManager.getResource("q" + this.ge.gqLevelRow + this.ge.gqLevelCol + this.ge.gqOrder[i] + ".pcs");
                        this.ge.gqDataColor[i] = Level.getColorArray(levelData);
                        this.ge.gqDataPalette[i] = Level.getPalette(levelData);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }
}

