/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import com.inode.pictorama.Level;
import com.inode.utils.SSFunctions;
import javax.microedition.lcdui.Graphics;

public class MenuClassic {
    public GameEngine ge;
    public static final int STATE_MENU_FIXED = 0;
    public static final int STATE_CHANGING_LEVEL = 1;
    public static final int STATE_TRANSITION_IN = 2;
    public static final int STATE_TRANSITION_OUT = 3;
    public int menuState = 0;
    public static final int STATE_ITEM_OFF = 1;
    public static final int STATE_ITEM_ON = 0;
    public int LEVEL_PREVIEW_SIZE = 60;
    public static final int LEVEL_PREVIEW_BORDER = 6;
    public int menuFrames = 0;
    public long nowTime = System.currentTimeMillis();
    public int itemSelected = 0;
    public long[] itemAnimateTime = null;
    public int[] itemPosXfixed = null;
    public int[] itemPosYfixed = null;
    public int[] itemPosX = null;
    public int[] itemPosY = null;
    public int[] itemPosXfinal = null;
    public int[] itemPosYfinal = null;
    public boolean[] itemBounce = null;
    public int levelSelected = 0;
    public int levelSelectedNext = 0;
    public int levelHighest = 0;
    public byte[][] levelDataColor = null;
    public int[] levelPalette = null;
    public int[] levelSize = null;
    public int speedX = 3;

    public MenuClassic(GameEngine _ge) {
        this.ge = _ge;
        System.out.println("MenuClassic()");
        this.ge.auxString = "MenuClassic()";
        this.ge.loadGame("Game_Classic");
        this.levelDataColor = new byte[90][];
        this.levelPalette = new int[90];
        this.levelSize = new int[90];
        this.initLevels();
        this.itemAnimateTime = new long[8];
        this.itemPosXfixed = new int[8];
        this.itemPosYfixed = new int[8];
        this.itemPosX = new int[8];
        this.itemPosY = new int[8];
        this.itemPosXfinal = new int[8];
        this.itemPosYfinal = new int[8];
        this.itemPosXfixed[5] = 0;
        this.itemPosYfixed[5] = 0;
        this.itemPosXfixed[2] = (240 - this.LEVEL_PREVIEW_SIZE - 12) / 2;
        this.itemPosYfixed[2] = 71;
        this.itemPosXfixed[6] = 20;
        GameCanvas cfr_ignored_0 = this.ge.gc;
        this.itemPosYfixed[6] = this.itemPosYfixed[2] + this.LEVEL_PREVIEW_SIZE + 6 * GameCanvas.resFonts[1].getFontHeight();
        this.itemPosXfixed[0] = this.itemPosXfixed[2] - 10 * this.LEVEL_PREVIEW_SIZE / 3;
        this.itemPosYfixed[0] = this.itemPosYfixed[2];
        this.itemPosXfixed[1] = this.itemPosXfixed[2] - 5 * this.LEVEL_PREVIEW_SIZE / 3 - 1;
        this.itemPosYfixed[1] = this.itemPosYfixed[2];
        this.itemPosXfixed[3] = this.itemPosXfixed[2] + 5 * this.LEVEL_PREVIEW_SIZE / 3 + 1;
        this.itemPosYfixed[3] = this.itemPosYfixed[2];
        this.itemPosXfixed[4] = this.itemPosXfixed[2] + 10 * this.LEVEL_PREVIEW_SIZE / 3;
        this.itemPosYfixed[4] = this.itemPosYfixed[2];
    }

    public void initLevels() {
        this.levelHighest = Math.min(this.ge.gcHighLevelCompleted, 89);
        this.levelSelected = this.ge.gcLastLevelPlayed;
        for (int i = 0; i <= this.levelHighest; ++i) {
            this.setLevelDataColor(i, this.ge.gc.resManager.getResource("c" + i + ".pcs"));
            this.ge.repaint();
            this.ge.serviceRepaints();
        }
    }

    public void unload() {
        this.itemAnimateTime = null;
        this.itemPosXfixed = null;
        this.itemPosYfixed = null;
        this.itemPosX = null;
        this.itemPosY = null;
        this.itemPosXfinal = null;
        this.itemPosYfinal = null;
        this.itemBounce = null;
        for (int i = 0; i < this.levelDataColor.length; ++i) {
            this.levelDataColor[i] = null;
        }
        this.levelPalette = null;
        this.levelSize = null;
    }

    public void runTransitionIn() {
        this.menuFrames = 0;
        this.menuState = 2;
        for (int i = 0; i <= 6; ++i) {
            this.itemPosX[i] = this.itemPosXfixed[i];
            this.itemPosXfinal[i] = this.itemPosXfixed[i];
            this.itemPosY[i] = this.itemPosYfixed[i];
            this.itemPosYfinal[i] = this.itemPosYfixed[i];
        }
        this.itemPosY[5] = -31;
        this.itemPosX[1] = -this.LEVEL_PREVIEW_SIZE;
        this.itemPosY[2] = -120;
        this.itemPosX[3] = 240;
        this.itemPosY[6] = 320;
        this.itemPosY[7] = 320;
    }

    public void runTransitionOut() {
        this.menuFrames = 0;
        this.menuState = 3;
        this.itemPosYfinal[5] = -31;
        this.itemPosXfinal[1] = -2 * this.LEVEL_PREVIEW_SIZE;
        this.itemPosXfinal[2] = this.itemPosXfixed[2];
        this.itemPosYfinal[2] = -2 * this.LEVEL_PREVIEW_SIZE;
        this.itemPosXfinal[3] = 240 + 2 * this.LEVEL_PREVIEW_SIZE;
        this.itemPosYfinal[6] = 320;
    }

    public int setLevelSelected(int _levelNumber) {
        int levelSelectedPrevious = this.levelSelected;
        this.levelSelectedNext = _levelNumber;
        if (_levelNumber < 0) {
            this.levelSelectedNext = 0;
        }
        if (_levelNumber >= 90) {
            this.levelSelectedNext = 89;
        }
        if (this.levelSelectedNext < levelSelectedPrevious) {
            this.itemPosXfinal[0] = this.itemPosXfixed[1];
            this.itemPosXfinal[1] = this.itemPosXfixed[2];
            this.itemPosXfinal[2] = this.itemPosXfixed[3];
            this.itemPosXfinal[3] = this.itemPosXfixed[4];
            this.itemPosXfinal[4] = this.itemPosXfixed[4];
            this.menuState = 1;
        } else if (this.levelSelectedNext > levelSelectedPrevious) {
            this.itemPosXfinal[0] = this.itemPosXfixed[0];
            this.itemPosXfinal[1] = this.itemPosXfixed[0];
            this.itemPosXfinal[2] = this.itemPosXfixed[1];
            this.itemPosXfinal[3] = this.itemPosXfixed[2];
            this.itemPosXfinal[4] = this.itemPosXfixed[3];
            this.menuState = 1;
        }
        return this.levelSelectedNext;
    }

    public int setItemSelected(int _item) {
        this.itemAnimateTime[6] = System.currentTimeMillis();
        this.itemAnimateTime[7] = System.currentTimeMillis();
        this.itemSelected = (this.itemSelected + 1) % 2;
        return this.itemSelected;
    }

    public void setLevelDataColor(int _levelNumber, byte[] _data) {
        this.levelDataColor[_levelNumber] = Level.getColorArray(_data);
        this.levelPalette[_levelNumber] = Level.getPalette(_data);
        this.levelSize[_levelNumber] = Level.getSize(_data);
    }

    public void paint(Graphics _g) {
        switch (this.menuState) {
            case 0: {
                this.paintFixed(_g);
                break;
            }
            case 1: {
                this.paintChangingLevel(_g);
                break;
            }
            case 2: 
            case 3: {
                this.paintTransition(_g);
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics _g) {
        this.ge.gc.resetClip(_g);
        _g.setColor(0xFF0000);
        int item_on_off = 1;
        this.nowTime = System.currentTimeMillis();
        _g.drawImage(this.ge.gc.resImages[7], this.itemPosX[5], this.itemPosY[5], 20);
        if (this.itemSelected == 0) {
            item_on_off = 0;
        }
        this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, this.nowTime - this.itemAnimateTime[6], this.itemPosX[6], this.itemPosY[6], false);
        if (this.levelSelected <= this.ge.gcHighLevelCompleted) {
            this.ge.menu.menuFont.drawString(_g, (this.ge.lang[32] + " " + (this.levelSelected + 1)).toCharArray(), this.itemPosX[6] + this.ge.menu.itemTextOffsetX, this.itemPosY[6] + this.ge.menu.itemTextOffsetY, 20);
        } else {
            this.ge.menu.menuFont.drawString(_g, (this.ge.lang[83] + " " + (this.levelSelected + 1)).toCharArray(), this.itemPosX[6] + this.ge.menu.itemTextOffsetX, this.itemPosY[6] + this.ge.menu.itemTextOffsetY, 20);
        }
        if (this.menuState == 1) {
            if (this.levelSelected - 2 >= 0) {
                this.paintLevel(_g, this.levelSelected - 2, this.itemPosX[0], this.itemPosY[0]);
            }
            if (this.levelSelected + 2 < 90) {
                this.paintLevel(_g, this.levelSelected + 2, this.itemPosX[4], this.itemPosY[4]);
            }
        }
        if (this.levelSelected - 1 >= 0) {
            this.paintLevel(_g, this.levelSelected - 1, this.itemPosX[1], this.itemPosY[1]);
        }
        if (this.levelSelected + 1 < 90) {
            this.paintLevel(_g, this.levelSelected + 1, this.itemPosX[3], this.itemPosY[3]);
        }
        this.paintLevel(_g, this.levelSelected, this.itemPosX[2], this.itemPosY[2]);
        if (this.menuState == 0 || this.menuState == 1) {
            GameCanvas cfr_ignored_0 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[30].toCharArray(), 120, this.itemPosY[5] + this.ge.gc.resImages[7].getHeight() + 16, 17);
        }
        if (this.menuState == 0 && this.itemSelected == 0) {
            this.ge.gc.resetClip(_g);
            if (this.levelSelected > 0) {
                _g.drawImage(this.ge.gc.resImages[11], (240 - this.LEVEL_PREVIEW_SIZE) / 2 - 6, this.itemPosY[2] + this.LEVEL_PREVIEW_SIZE / 2, 24);
            }
            if (this.levelSelected < 89) {
                _g.drawImage(this.ge.gc.resImages[12], (240 + this.LEVEL_PREVIEW_SIZE) / 2 + 6, this.itemPosY[2] + this.LEVEL_PREVIEW_SIZE / 2, 20);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void paintLevel(Graphics _g, int _levelNumber, int _x, int _y) {
        if (_x < -this.LEVEL_PREVIEW_SIZE - 20 || _x > 240) {
            return;
        }
        frameWidth = this.LEVEL_PREVIEW_SIZE + 12;
        this.ge.gc;
        frameHeight = this.LEVEL_PREVIEW_SIZE + 12 + 4 * GameCanvas.resFonts[1].getFontHeight();
        _g.setClip(_x, _y, frameWidth, frameHeight);
        _g.setColor(0xFFFFFF);
        _g.fillRoundRect(_x, _y, frameWidth, frameHeight, 10, 10);
        _g.setColor(0);
        _g.fillRoundRect(_x + 3, _y + 3, frameWidth - 6, frameHeight - 6, 10, 10);
        if (_levelNumber < this.levelHighest) ** GOTO lbl-1000
        if (this.ge.gcHighLevelCompleted >= 90) lbl-1000:
        // 2 sources

        {
            this.ge.gc.resAnimations[9].drawAnimation(_g, 0, System.currentTimeMillis(), _x + 6, _y + 6, true);
            square = 3;
            if (this.levelSize[_levelNumber] == 5) {
                square = 4;
            }
            palette = this.levelPalette[_levelNumber];
            _g.setClip(_x + 6 + (this.LEVEL_PREVIEW_SIZE - square * this.levelSize[_levelNumber]) / 2, _y + 6 + (this.LEVEL_PREVIEW_SIZE - square * this.levelSize[_levelNumber]) / 2, square * this.levelSize[_levelNumber], square * this.levelSize[_levelNumber]);
            for (row = 0; row < this.levelSize[_levelNumber]; ++row) {
                for (col = 0; col < this.levelSize[_levelNumber]; ++col) {
                    color = this.levelDataColor[_levelNumber][row * this.levelSize[_levelNumber] + col];
                    if (color == 0) continue;
                    _g.setColor(this.ge.palettes[palette][color]);
                    _g.fillRect(_x + 6 + (this.LEVEL_PREVIEW_SIZE - square * this.levelSize[_levelNumber]) / 2 + col * square, _y + 6 + (this.LEVEL_PREVIEW_SIZE - square * this.levelSize[_levelNumber]) / 2 + row * square, square, square);
                }
            }
        } else if (_levelNumber == this.levelHighest) {
            _g.setClip(_x + 6, _y + 6, this.LEVEL_PREVIEW_SIZE, this.LEVEL_PREVIEW_SIZE);
            _g.drawImage(this.ge.gc.resImages[9], _x + 6, _y + 6, 20);
            _g.drawImage(this.ge.gc.resImages[10], _x + 6 + this.LEVEL_PREVIEW_SIZE / 2, _y + 6 + this.LEVEL_PREVIEW_SIZE / 2, 3);
        } else {
            _g.setClip(_x + 6, _y + 6, this.LEVEL_PREVIEW_SIZE, this.LEVEL_PREVIEW_SIZE);
            _g.drawImage(this.ge.gc.resImages[8], _x + 6, _y + 6, 20);
        }
        posY = _y + 9 + this.LEVEL_PREVIEW_SIZE;
        if (_levelNumber > this.levelHighest) {
            this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, "???".toCharArray(), _x + frameWidth / 2, posY, 17);
        } else {
            this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, (this.levelSize[_levelNumber] + "x" + this.levelSize[_levelNumber]).toCharArray(), _x + frameWidth / 2, posY, 17);
        }
        this.ge.gc;
        this.ge.gc;
        posY += GameCanvas.resFonts[1].getFontHeight() + GameCanvas.resFonts[2].getLineSpacing();
        this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(2);
        this.ge.gc;
        GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[31] + ":").toCharArray(), _x + frameWidth / 2, posY, 17);
        this.ge.gc;
        this.ge.gc;
        posY += GameCanvas.resFonts[2].getFontHeight() + GameCanvas.resFonts[2].getLineSpacing();
        this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(1);
        if (this.ge.gcHighScoresTime[_levelNumber] > 0L) {
            this.ge.gc;
            GameCanvas.resFonts[2].drawString(_g, SSFunctions.getTimeText(this.ge.gcHighScoresTime[_levelNumber]).toCharArray(), _x + frameWidth / 2, posY, 17);
        } else {
            this.ge.gc;
            GameCanvas.resFonts[2].drawString(_g, "--:--".toCharArray(), _x + frameWidth / 2, posY, 17);
        }
    }

    private void paintTransition(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        for (int i = 0; i < this.itemPosY.length; ++i) {
            diffX = this.itemPosXfinal[i] - this.itemPosX[i];
            if (diffX != 0) {
                isComplete = false;
                step = Math.max(this.ge.menu.minStep, Math.abs(diffX / this.ge.menu.speedX));
                if (Math.abs(diffX) < step) {
                    this.itemPosX[i] = this.itemPosXfinal[i];
                } else if (diffX > 0) {
                    int n = i;
                    this.itemPosX[n] = this.itemPosX[n] + step;
                    if (this.itemPosX[i] < 240) {
                        isOnScreen = true;
                    }
                } else if (diffX < 0) {
                    int n = i;
                    this.itemPosX[n] = this.itemPosX[n] - step;
                    if (this.itemPosX[i] > -200) {
                        isOnScreen = true;
                    }
                }
            }
            if ((diffY = this.itemPosYfinal[i] - this.itemPosY[i]) == 0) continue;
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[i] = this.itemPosYfinal[i];
                continue;
            }
            if (diffY > 0) {
                int n = i;
                this.itemPosY[n] = this.itemPosY[n] + step;
                if (this.itemPosY[i] >= 320) continue;
                isOnScreen = true;
                continue;
            }
            if (diffY >= 0) continue;
            int n = i;
            this.itemPosY[n] = this.itemPosY[n] - step;
            if (this.itemPosY[i] <= -26) continue;
            isOnScreen = true;
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.menuState = 0;
        }
    }

    private void paintChangingLevel(Graphics _g) {
        int i;
        boolean isComplete = true;
        boolean isOnScreen = false;
        int step = 1;
        int diffX = 0;
        boolean diffY = false;
        for (i = 0; i <= 4; ++i) {
            diffX = this.itemPosXfinal[i] - this.itemPosX[i];
            if (diffX == 0) continue;
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffX / this.speedX));
            if (Math.abs(diffX) < step) {
                this.itemPosX[i] = this.itemPosXfinal[i];
                continue;
            }
            if (diffX > 0) {
                int n = i;
                this.itemPosX[n] = this.itemPosX[n] + step;
                if (this.itemPosX[i] >= 240) continue;
                isOnScreen = true;
                continue;
            }
            if (diffX >= 0) continue;
            int n = i;
            this.itemPosX[n] = this.itemPosX[n] - step;
            if (this.itemPosX[i] <= -200) continue;
            isOnScreen = true;
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.menuState = 0;
            this.levelSelected = this.levelSelectedNext;
            for (i = 0; i <= 4; ++i) {
                this.itemPosX[i] = this.itemPosXfixed[i];
            }
        }
    }
}

