/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import java.util.Calendar;
import java.util.Date;

public class Clock {
    public static final int TYPE_REALTIME = 0;
    public static final int TYPE_CRONO = 1;
    public static final int TYPE_COUNTDOWN = 2;
    public static final int FORMAT_HHMMSSD = 0;
    public static final int FORMAT_HHMMSS = 1;
    public static final int FORMAT_HHMM = 2;
    public static final int FORMAT_MMSSD = 3;
    public static final int FORMAT_MMSS = 4;
    public static final int FORMAT_SSD = 5;
    public static final int FORMAT_SS = 6;
    public int clockType = 0;
    public long startTimestamp = 0L;
    public long stopTimestamp = 0L;
    public long initTime = 0L;
    public long nowTime = 0L;
    public Calendar calendario = null;
    public static StringBuffer output = new StringBuffer(16);

    public Clock(int _type) {
        this.clockType = _type;
        this.calendario = Calendar.getInstance();
    }

    public void setTime(long _milliseconds) {
        switch (this.clockType) {
            case 0: {
                this.calendario.setTime(new Date(_milliseconds));
                break;
            }
            case 1: {
                this.initTime = _milliseconds;
                this.nowTime = _milliseconds;
                break;
            }
            case 2: {
                this.initTime = _milliseconds;
                this.nowTime = _milliseconds;
            }
        }
    }

    public void addTime(long _milliseconds) {
        switch (this.clockType) {
            case 0: {
                this.calendario.setTime(new Date(_milliseconds));
                break;
            }
            case 1: {
                this.initTime += _milliseconds;
                this.nowTime += _milliseconds;
                break;
            }
            case 2: {
                this.initTime += _milliseconds;
                this.nowTime += _milliseconds;
            }
        }
    }

    public void start() {
        this.startTimestamp = System.currentTimeMillis();
    }

    public long stop() {
        this.stopTimestamp = System.currentTimeMillis();
        switch (this.clockType) {
            case 0: {
                break;
            }
            case 1: {
                this.nowTime += this.stopTimestamp - this.startTimestamp;
                break;
            }
            case 2: {
                this.nowTime -= this.stopTimestamp - this.startTimestamp;
                if (this.nowTime >= 0L) break;
                this.nowTime = 0L;
            }
        }
        return this.getMilliseconds();
    }

    public void reset() {
        this.nowTime = this.initTime;
    }

    public long getMilliseconds() {
        long output = 0L;
        long now = System.currentTimeMillis();
        switch (this.clockType) {
            case 0: {
                output = System.currentTimeMillis();
                break;
            }
            case 1: {
                output = this.nowTime + (now - this.startTimestamp);
                break;
            }
            case 2: {
                output = this.nowTime - (now - this.startTimestamp);
                if (output >= 0L) break;
                output = 0L;
            }
        }
        return output;
    }

    public int get(int _field) {
        long time = this.getMilliseconds();
        this.calendario.setTime(new Date(time));
        return this.calendario.get(_field);
    }

    public int get(int _field, long time) {
        this.calendario.setTime(new Date(time));
        return this.calendario.get(_field);
    }

    public String getTimeString(int _format) {
        output.setLength(0);
        switch (_format) {
            case 0: {
                output.append(this.get(11));
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(12));
                } else {
                    output.append(this.get(12));
                }
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(13));
                } else {
                    output.append(this.get(13));
                }
                output.append(":");
                output.append(this.get(14) / 100);
                break;
            }
            case 1: {
                output.append(this.get(11));
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(12));
                } else {
                    output.append(this.get(12));
                }
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(13));
                    break;
                }
                output.append(this.get(13));
                break;
            }
            case 2: {
                output.append(this.get(11));
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(12));
                    break;
                }
                output.append(this.get(12));
                break;
            }
            case 3: {
                if (this.getMilliseconds() >= 3600000L) {
                    output.append("59:59:9");
                    break;
                }
                output.append(Math.min(59, this.get(12)));
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(13));
                } else {
                    output.append(Math.min(59, this.get(13)));
                }
                output.append(":");
                output.append(this.get(14) / 100);
                break;
            }
            case 4: {
                output.append(Math.min(59, this.get(12)));
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(13));
                    break;
                }
                output.append(Math.min(59, this.get(13)));
                break;
            }
            case 5: {
                output.append(this.get(13));
                output.append(":");
                output.append(this.get(14) / 100);
                break;
            }
            case 6: {
                output.append(this.get(13));
            }
        }
        return output.toString();
    }

    public String getTimeString(int _format, long time) {
        output.setLength(0);
        switch (_format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (time >= 3600000L) {
                    output.append("59:59:9");
                    break;
                }
                output.append(Math.min(59, this.get(12, time)));
                output.append(":");
                if (this.get(13) < 10) {
                    output.append("0");
                    output.append(this.get(13, time));
                } else {
                    output.append(Math.min(59, this.get(13, time)));
                }
                output.append(":");
                output.append(this.get(14, time) / 100);
                break;
            }
        }
        return output.toString();
    }
}

